/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.view.visual;

import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.InteractionElement;
import edu.berkeley.guir.damask.component.Content;
import edu.berkeley.guir.damask.component.Control;
import edu.berkeley.guir.damask.component.Trigger;
import edu.berkeley.guir.damask.connection.Connection;
import edu.berkeley.guir.damask.connection.ConnectionDest;
import edu.berkeley.guir.damask.connection.ConnectionSource;
import edu.berkeley.guir.damask.connection.OrgConnection;
import edu.berkeley.guir.damask.dialog.Page;
import edu.berkeley.guir.damask.dialog.PageRegion;
import edu.berkeley.guir.damask.dialog.TemplateDialog;
import edu.berkeley.guir.damask.event.ConnectionEvent;
import edu.berkeley.guir.damask.event.ConnectionListener;
import edu.berkeley.guir.damask.event.ControlEvent;
import edu.berkeley.guir.damask.event.ControlListener;
import edu.berkeley.guir.damask.event.InteractionElementEvent;
import edu.berkeley.guir.damask.event.InteractionElementListener;
import edu.berkeley.guir.damask.view.DamaskAppUtils;
import edu.berkeley.guir.damask.view.DamaskLayer;
import edu.berkeley.guir.damask.view.InteractionElementView;
import edu.berkeley.guir.damask.view.visual.component.Button;
import edu.berkeley.guir.damask.view.visual.component.ControlView;
import edu.berkeley.guir.damask.view.visual.component.Hyperlink;
import edu.berkeley.guir.damask.view.visual.component.Label;
import edu.berkeley.guir.damask.view.visual.dialog.PageView;
import edu.berkeley.guir.lib.awt.geom.GeomLib;
import edu.berkeley.guir.lib.awt.geom.Polygon2D;
import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PPaintContext;
import java.awt.Color;
import java.awt.Paint;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Arrow
extends InteractionElementView {
    private static final Paint ORG_COLOR;
    private static final Paint NAV_COLOR;
    private final Map visible = new HashMap();
    private final ConnectionHandler connectionHandler = new ConnectionHandler();
    private final EndpointViewHandler endpointViewHandler = new EndpointViewHandler();
    private final ControlHandler controlHandler = new ControlHandler();
    private final PageRegionViewHandler pageRegionViewHandler = new PageRegionViewHandler();
    private final CameraHandler cameraHandler = new CameraHandler();
    private InteractionElementView sourceView;
    private PageView sourcePageView;
    private InteractionElementView destView;
    private PageView destPageView;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.damask.view.visual.Arrow");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        ORG_COLOR = Color.GRAY;
        NAV_COLOR = new Color(0, 153, 255);
    }

    public Arrow(Connection connection) {
        super(connection);
        if (connection instanceof OrgConnection) {
            this.setStrokePaint(ORG_COLOR);
        } else {
            this.setStrokePaint(NAV_COLOR);
        }
        connection.addConnectionListener(this.connectionHandler);
        connection.addInteractionElementListener(this.connectionHandler);
    }

    protected void initAfterAddToParent() {
        super.initAfterAddToParent();
        this.updateSourceView();
        this.updateDestView();
        this.updateShape();
        this.deviceTypeLayerChanged();
    }

    public void dispose() {
        super.dispose();
        Connection connection = (Connection)this.getModel();
        connection.removeConnectionListener(this.connectionHandler);
        connection.removeInteractionElementListener(this.connectionHandler);
        this.stopListeningToSourceView();
        this.stopListeningToDestView();
    }

    public DeviceType getDeviceType() {
        DamaskLayer layer = this.getLayer();
        if (layer != null) {
            return layer.getDeviceType();
        }
        return null;
    }

    public InteractionElementView getSourceView() {
        return this.sourceView;
    }

    public InteractionElementView getDestView() {
        return this.destView;
    }

    protected void paint(PPaintContext paintContext) {
        ConnectionSource source = this.sourceView == null ? null : (ConnectionSource)this.sourceView.getModel();
        ConnectionDest dest = this.destView == null ? null : (ConnectionDest)this.destView.getModel();
        boolean dontShow = false;
        if (source instanceof Trigger) {
            Label label = this.sourceView instanceof Hyperlink ? ((Hyperlink)this.sourceView).getContent() : ((Button)this.sourceView).getContent();
            dontShow |= label.isEmpty() && label.getDisplayMode() == Content.TEXT;
        }
        if (!(dontShow |= source.getPage(this.getDeviceType()) == dest.getPage(this.getDeviceType()))) {
            super.paint(paintContext);
            DamaskAppUtils.drawArrowheads(this, paintContext);
        }
    }

    protected void updateShape() {
        Connection model = (Connection)this.getModel();
        this.setVisible(true);
        GeneralPath newShape = model.getShape(this.getDeviceType());
        Polygon2D newPoly = GeomLib.pathIteratorToPolygon2D(newShape.getPathIterator(null));
        if (((ConnectionSource)this.sourceView.getModel()).getDialog() instanceof TemplateDialog) {
            PBounds sourceGlobalBds = this.sourceView.getBounds();
            this.sourceView.localToGlobal(sourceGlobalBds);
            this.setPathTo(new Line2D.Double(sourceGlobalBds.getCenterX(), sourceGlobalBds.getCenterY(), newPoly.xpoints[newPoly.npoints - 1], newPoly.ypoints[newPoly.npoints - 1]));
        } else {
            this.setPathTo(newShape);
        }
        this.setTransform(model.getTransform(this.getDeviceType()));
    }

    protected void updateSourceView() {
        DeviceType deviceType = this.getDeviceType();
        this.stopListeningToSourceView();
        DamaskLayer layer = this.getLayer();
        ConnectionSource newSource = ((Connection)this.getModel()).getConnectionSource(deviceType);
        if (newSource != null) {
            Page newSourcePage;
            List possibleViews = this.getLayer().getViews(newSource);
            this.sourceView = null;
            Iterator i = possibleViews.iterator();
            while (i.hasNext()) {
                InteractionElementView possibleView = (InteractionElementView)i.next();
                if (possibleView instanceof PageView) {
                    if (!$assertionsDisabled && possibleViews.size() != 1) {
                        throw new AssertionError();
                    }
                    this.sourceView = possibleView;
                    break;
                }
                ControlView possibleControlView = (ControlView)possibleView;
                if (possibleControlView.getPageView().getModel() != newSource.getPage(deviceType)) continue;
                this.sourceView = possibleView;
                break;
            }
            this.sourceView.addPropertyChangeListener(this.endpointViewHandler);
            if (newSource instanceof Control) {
                ((Control)newSource).addControlListener(this.controlHandler);
            }
            if ((newSourcePage = newSource.getPage(deviceType)) != null && newSourcePage != newSource) {
                this.sourcePageView = (PageView)layer.getView(newSourcePage);
                this.sourcePageView.addPropertyChangeListener(this.endpointViewHandler);
            } else {
                this.sourcePageView = null;
            }
            if (newSourcePage != null && newSourcePage.isTemplate()) {
                Iterator i2 = layer.getCamerasReference().iterator();
                while (i2.hasNext()) {
                    PCamera camera = (PCamera)i2.next();
                    camera.addPropertyChangeListener("bounds", this.cameraHandler);
                    camera.addPropertyChangeListener("viewTransform", this.cameraHandler);
                }
            }
        }
    }

    private void stopListeningToSourceView() {
        if (this.sourceView != null) {
            DamaskLayer layer = this.getLayer();
            this.sourceView.removePropertyChangeListener(this.endpointViewHandler);
            InteractionElement source = this.sourceView.getModel();
            if (source instanceof Control) {
                ((Control)source).removeControlListener(this.controlHandler);
            }
            if (this.sourcePageView != null) {
                this.sourcePageView.removePropertyChangeListener(this.endpointViewHandler);
                if (((Page)this.sourcePageView.getModel()).isTemplate()) {
                    Iterator i = layer.getCamerasReference().iterator();
                    while (i.hasNext()) {
                        PCamera camera = (PCamera)i.next();
                        camera.removePropertyChangeListener("bounds", this.cameraHandler);
                        camera.removePropertyChangeListener("viewTransform", this.cameraHandler);
                    }
                }
            }
        }
    }

    protected void updateDestView() {
        DeviceType deviceType = this.getDeviceType();
        this.stopListeningToDestView();
        ConnectionDest newDest = ((Connection)this.getModel()).getConnectionDest(deviceType);
        if (newDest != null) {
            Page newDestPage;
            this.destView = this.getLayer().getView(newDest);
            this.destView.addPropertyChangeListener(this.endpointViewHandler);
            if (newDest instanceof Control) {
                ((Control)newDest).addControlListener(this.controlHandler);
            }
            if ((newDestPage = newDest.getPage(deviceType)) != null && newDestPage != newDest) {
                this.destPageView = (PageView)this.getLayer().getView(newDestPage);
                this.destPageView.addPropertyChangeListener(this.endpointViewHandler);
            }
        }
    }

    private void stopListeningToDestView() {
        if (this.destView != null) {
            this.destView.removePropertyChangeListener(this.endpointViewHandler);
            InteractionElement dest = this.destView.getModel();
            if (dest instanceof Control) {
                ((Control)dest).removeControlListener(this.controlHandler);
            }
            if (this.destPageView != null) {
                this.destPageView.removePropertyChangeListener(this.endpointViewHandler);
            }
        }
    }

    public void reanchor() {
        Connection connection = (Connection)this.getModel();
        DeviceType deviceType = this.getDeviceType();
        InteractionElementView sourceView = this.getSourceView();
        InteractionElementView destView = this.getDestView();
        if (sourceView == null || destView == null) {
            this.setVisible(false);
            return;
        }
        this.setVisible(true);
        PBounds sourceGlobalBds = sourceView.getBounds();
        sourceView.localToGlobal(sourceGlobalBds);
        double fracX = connection.getSourceXAsWidthFraction(deviceType);
        if (fracX < 0.0 || fracX > 1.0) {
            fracX = 0.5;
        }
        double startPointX = fracX * sourceGlobalBds.getWidth() + sourceGlobalBds.getX();
        double fracY = connection.getSourceYAsHeightFraction(deviceType);
        if (fracY < 0.0 || fracY > 1.0) {
            fracY = 0.5;
        }
        double startPointY = fracY * sourceGlobalBds.getHeight() + sourceGlobalBds.getY();
        PBounds destGlobalBds = destView.getBounds();
        destView.localToGlobal(destGlobalBds);
        double endPointX = connection.getDestXAsWidthFraction(deviceType) * destGlobalBds.getWidth() + destGlobalBds.getX();
        double endPointY = connection.getDestYAsHeightFraction(deviceType) * destGlobalBds.getHeight() + destGlobalBds.getY();
        this.setPathTo(new Line2D.Double(startPointX, startPointY, endPointX, endPointY));
    }

    public boolean isVisibleToCamera(PCamera camera) {
        Boolean result = (Boolean)this.visible.get(camera);
        if (result == null) {
            return true;
        }
        return result;
    }

    public void setVisibleToCamera(PCamera camera, boolean isVisible) {
        this.visible.put(camera, isVisible);
    }

    public void fullPaint(PPaintContext paintContext) {
        if (this.isVisibleToCamera(paintContext.getCamera())) {
            super.fullPaint(paintContext);
        }
    }

    public void deviceTypeLayerChanged() {
        Connection connection = (Connection)this.getModel();
        DamaskLayer.DeviceTypeLayer deviceTypeLayer = this.getLayer().getDeviceTypeLayer();
        if (connection.isForAllDeviceTypes() && deviceTypeLayer == DamaskLayer.DeviceTypeLayer.ALL || !connection.isForAllDeviceTypes() && connection.isVisibleToDeviceType(this.getDeviceType()) && deviceTypeLayer == DamaskLayer.DeviceTypeLayer.DEVICE) {
            DamaskAppUtils.setInternalColorAlpha(this, 255);
        } else {
            DamaskAppUtils.setInternalColorAlpha(this, 80);
        }
    }

    private class ConnectionHandler
    implements InteractionElementListener,
    ConnectionListener {
        ConnectionHandler() {
        }

        public void elementBoundsUpdated(InteractionElementEvent e) {
            if (e.getDeviceType() == Arrow.this.getDeviceType()) {
                Arrow.this.updateShape();
            }
        }

        public void elementTransformUpdated(InteractionElementEvent e) {
            if (e.getDeviceType() == Arrow.this.getDeviceType()) {
                Arrow.this.updateShape();
            }
        }

        public void elementBorderUpdated(InteractionElementEvent e) {
        }

        public void sourceChanged(ConnectionEvent e) {
            if (e.getDeviceType() == Arrow.this.getDeviceType()) {
                Arrow.this.updateSourceView();
                Arrow.this.updateShape();
            }
        }

        public void destChanged(ConnectionEvent e) {
            if (e.getDeviceType() == Arrow.this.getDeviceType()) {
                Arrow.this.updateDestView();
                Arrow.this.updateShape();
            }
        }

        public void shapeChanged(ConnectionEvent e) {
            if (e.getDeviceType() == Arrow.this.getDeviceType()) {
                Arrow.this.updateShape();
            }
        }

        public void userEventChanged(ConnectionEvent e) {
        }

        public void conditionChanged(ConnectionEvent e) {
        }
    }

    private class EndpointViewHandler
    implements PropertyChangeListener {
        EndpointViewHandler() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("bounds") || evt.getPropertyName().equals("transform")) {
                Arrow.this.reanchor();
            } else if (evt.getPropertyName().equals("parent")) {
                Arrow.this.reanchor();
            }
        }
    }

    private class CameraHandler
    implements PropertyChangeListener {
        CameraHandler() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            Arrow.this.reanchor();
        }
    }

    private class ControlHandler
    implements ControlListener {
        ControlHandler() {
        }

        public void controlStateChanged(ControlEvent e) {
        }

        public void controlSignificanceChanged(ControlEvent e) {
        }

        public void pageRegionChanged(ControlEvent e) {
            DeviceType deviceType = Arrow.this.getDeviceType();
            if (e.getDeviceType() == deviceType) {
                Connection connection = (Connection)Arrow.this.getModel();
                Control control = e.getControl();
                PageRegion pageRegion = control.getPageRegion(deviceType);
                if (control == connection.getConnectionSource(deviceType)) {
                    if (pageRegion == null) {
                        Arrow.this.stopListeningToSourceView();
                    } else {
                        Arrow.this.getLayer().getView(pageRegion).addPropertyChangeListener("children", Arrow.this.pageRegionViewHandler);
                    }
                } else if (control == connection.getConnectionDest(deviceType)) {
                    if (pageRegion == null) {
                        Arrow.this.stopListeningToDestView();
                    } else {
                        Arrow.this.getLayer().getView(pageRegion).addPropertyChangeListener("children", Arrow.this.pageRegionViewHandler);
                    }
                }
            }
        }
    }

    private class PageRegionViewHandler
    implements PropertyChangeListener {
        PageRegionViewHandler() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            ((PNode)e.getSource()).removePropertyChangeListener("children", Arrow.this.pageRegionViewHandler);
            Arrow.this.updateSourceView();
            Arrow.this.updateDestView();
        }
    }
}

