/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.view.pattern;

import edu.berkeley.guir.damask.view.DamaskAppExceptionHandler;
import edu.berkeley.guir.damask.view.pattern.PatternBrowser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Text;
import org.jdom.input.SAXBuilder;

public class PatternsSearcher {
    private URL patternsListURL;
    private File xmlfile;
    private Document doc;
    private Element root;
    private String patternID;
    private String collectionID;
    private List imagelinks = new LinkedList();
    private List cpattlinks = new LinkedList();
    private List rpattlinks = new LinkedList();
    private String name;
    private String problem = "";
    private String context = "";
    private String solution = "";
    private String diagram = "";
    private String illustration = "";
    private String relatedpatterns = "";
    private String credits = "";
    private static final Logger logger;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.damask.view.pattern.PatternsSearcher");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getName());
    }

    public PatternsSearcher(URL patternsListURL) {
        this.patternsListURL = patternsListURL;
    }

    public void setPatternsList(URL patternsListURL) {
        this.clearAll();
        this.patternsListURL = patternsListURL;
    }

    public List searchPatterns(String keyString) {
        ArrayList results = new ArrayList();
        if ((keyString = keyString.trim()).length() == 0) {
            return results;
        }
        ArrayList<String> keyStrings = new ArrayList<String>();
        boolean insideQuote = false;
        StringBuffer sb = new StringBuffer();
        int i = 0;
        int n = keyString.length();
        while (i < n) {
            char c = keyString.charAt(i);
            if (insideQuote) {
                if (c == '\"') {
                    insideQuote = false;
                    keyStrings.add(sb.toString());
                    sb = new StringBuffer();
                } else {
                    sb.append(c);
                }
            } else if (c == '\"') {
                insideQuote = true;
            } else if (Character.isWhitespace(c)) {
                if (sb.length() != 0) {
                    keyStrings.add(sb.toString());
                    sb = new StringBuffer();
                }
            } else {
                sb.append(c);
            }
            ++i;
        }
        if (sb.length() != 0) {
            keyStrings.add(sb.toString());
        }
        try {
            String fileline;
            BufferedReader buffreader = new BufferedReader(new InputStreamReader(this.patternsListURL.openStream()));
            while ((fileline = buffreader.readLine()) != null) {
                SAXBuilder builder = new SAXBuilder();
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("edu.berkeley.guir.damask.pattern.Pattern");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                this.doc = builder.build(clazz.getResource(fileline));
                this.root = this.doc.getRootElement();
                this.fillAttributes(this.root);
                this.searchForString(keyStrings, results);
                this.clearAll();
            }
        }
        catch (FileNotFoundException fnfe) {
            DamaskAppExceptionHandler.log(fnfe);
        }
        catch (JDOMException e) {
            logger.severe(this.xmlfile + " is not well-formed.");
            DamaskAppExceptionHandler.log(e);
        }
        catch (IOException e) {
            DamaskAppExceptionHandler.log(e);
        }
        return results;
    }

    private void clearAll() {
        this.imagelinks.clear();
        this.cpattlinks.clear();
        this.rpattlinks.clear();
        this.problem = "";
        this.context = "";
        this.solution = "";
        this.diagram = "";
        this.illustration = "";
        this.relatedpatterns = "";
        this.credits = "";
    }

    private void fillAttributes(Element element) {
        String elementName = element.getName();
        if (elementName.equals("name")) {
            this.name = element.getText();
        } else if (elementName.equals("pattern")) {
            this.patternID = element.getAttributeValue("patternID");
            this.collectionID = element.getAttributeValue("collectionID");
        } else if (elementName.equals("illustration")) {
            List illuList = element.getContent();
            this.illustration = String.valueOf(this.listToString(illuList, this.illustration).trim()) + "\n";
        } else if (elementName.equals("problem")) {
            List probList = element.getContent();
            this.problem = String.valueOf(this.listToString(probList, this.problem).trim()) + "\n";
        } else if (elementName.equals("context")) {
            List contList = element.getContent();
            this.context = String.valueOf(this.listToString(contList, this.context).trim()) + "\n";
        } else if (elementName.equals("solution")) {
            List soluList = element.getContent();
            this.solution = String.valueOf(this.listToString(soluList, this.solution).trim()) + "\n";
        } else if (elementName.equals("diagram")) {
            List diagList = element.getContent();
            this.diagram = String.valueOf(this.listToString(diagList, this.diagram).trim()) + "\n";
        } else if (elementName.equals("related-patterns")) {
            List pattList = element.getContent();
            this.relatedpatterns = String.valueOf(this.listToString(pattList, this.relatedpatterns).trim()) + "\n";
        } else if (elementName.equals("credits")) {
            List credList = element.getContent();
            this.credits = String.valueOf(this.listToString(credList, this.credits).trim()) + "\n";
        }
        List children = element.getChildren();
        Iterator iterator = children.iterator();
        while (iterator.hasNext()) {
            Element child = (Element)iterator.next();
            this.fillAttributes(child);
        }
    }

    private String listToString(List l, String s) {
        Iterator iterator = l.iterator();
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            if (obj instanceof Text) {
                s = String.valueOf(s) + ((Text)obj).getText();
                continue;
            }
            if (!(obj instanceof Element)) continue;
            s = String.valueOf(s) + ((Element)obj).getText();
        }
        return s;
    }

    private String getSearchResultString(String sectionName) {
        return "<a href=\"" + PatternBrowser.createPatternLinkURLString(this.collectionID, this.patternID) + "\">" + this.name + "</a> - " + sectionName;
    }

    private void searchForString(List keyStrings, String section, String sectionName, List results) {
        String sectionLowerCase = section.toLowerCase();
        boolean found = true;
        Iterator i = keyStrings.iterator();
        while (i.hasNext()) {
            String keyString = (String)i.next();
            String keyStringLowerCase = keyString.toLowerCase();
            if (sectionLowerCase.indexOf(keyStringLowerCase) >= 0) continue;
            found = false;
        }
        if (found) {
            results.add(this.getSearchResultString(sectionName));
        }
    }

    private void searchForString(List keyStrings, List results) {
        this.searchForString(keyStrings, this.name, "Name", results);
        this.searchForString(keyStrings, this.illustration, "Illustration", results);
        this.searchForString(keyStrings, this.context, "Background", results);
        this.searchForString(keyStrings, this.problem, "Problem", results);
        this.searchForString(keyStrings, this.solution, "Solution", results);
        this.searchForString(keyStrings, this.diagram, "Solution", results);
        this.searchForString(keyStrings, this.relatedpatterns, "Related Patterns", results);
        this.searchForString(keyStrings, this.credits, "Credits", results);
    }
}

