/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.view.pattern;

import edu.berkeley.guir.damask.io.DamaskReader;
import edu.berkeley.guir.damask.pattern.Pattern;
import edu.berkeley.guir.damask.pattern.PatternLibrary;
import edu.berkeley.guir.damask.view.DamaskAppExceptionHandler;
import edu.berkeley.guir.damask.view.pattern.PatternBrowser;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.Text;
import org.jdom.input.SAXBuilder;

public class PatternParser {
    private static final Namespace HTML_NAMESPACE = Namespace.getNamespace("html", "http://www.w3.org/1999/xhtml");
    private static final Namespace DEFAULT_NAMESPACE = Namespace.getNamespace("", "http://www.hcipatterns.org");
    static /* synthetic */ Class class$0;

    private PatternParser() {
    }

    public static Pattern parse(URL patternURL) {
        Pattern pattern = new Pattern();
        PatternParser.parseInto(patternURL, pattern);
        return pattern;
    }

    public static void parseInto(URL patternURL, Pattern pattern) {
        SAXBuilder builder = new SAXBuilder();
        try {
            Document doc = builder.build(patternURL);
            Element root = doc.getRootElement();
            PatternParser.fillInPattern(root, pattern);
        }
        catch (JDOMException e) {
            DamaskAppExceptionHandler.log(e);
        }
        catch (IOException e) {
            DamaskAppExceptionHandler.log(e);
        }
    }

    public static String[] getPatternIDs(URL patternURL) {
        SAXBuilder builder = new SAXBuilder();
        try {
            Document doc = builder.build(patternURL);
            Element root = doc.getRootElement();
            String[] result = new String[]{root.getAttributeValue("collectionID"), root.getAttributeValue("patternID")};
            return result;
        }
        catch (JDOMException e) {
            DamaskAppExceptionHandler.log(e);
        }
        catch (IOException e) {
            DamaskAppExceptionHandler.log(e);
        }
        return new String[0];
    }

    public static String getPatternName(URL patternURL) {
        SAXBuilder builder = new SAXBuilder();
        try {
            Document doc = builder.build(patternURL);
            Element root = doc.getRootElement();
            return root.getChildText("name", DEFAULT_NAMESPACE);
        }
        catch (JDOMException e) {
            DamaskAppExceptionHandler.log(e);
        }
        catch (IOException e) {
            DamaskAppExceptionHandler.log(e);
        }
        return null;
    }

    private static void fillInPattern(Element root, Pattern pattern) {
        pattern.setID(root.getAttributeValue("patternID"));
        pattern.setCollectionID(root.getAttributeValue("collectionID"));
        pattern.setName(root.getChildText("name", DEFAULT_NAMESPACE));
        Element element = root.getChild("illustration", DEFAULT_NAMESPACE);
        pattern.setIllustrationText(PatternParser.convertDOMElementToHTML(element, null));
        pattern.setIllustrationURL(PatternParser.getFirstImageURL(element));
        pattern.setProblem(PatternParser.convertDOMElementToHTML(root.getChild("problem", DEFAULT_NAMESPACE), null));
        ArrayList inPatterns = new ArrayList();
        pattern.setBackground(PatternParser.convertDOMElementToHTML(root.getChild("context", DEFAULT_NAMESPACE), inPatterns));
        Iterator i = inPatterns.iterator();
        while (i.hasNext()) {
            Pattern inPattern = (Pattern)i.next();
            pattern.addInRef(inPattern);
        }
        pattern.setSolutionText(PatternParser.convertDOMElementToHTML(root.getChild("solution", DEFAULT_NAMESPACE), null));
        element = root.getChild("diagram", DEFAULT_NAMESPACE);
        pattern.setSolutionImageText(PatternParser.convertDOMElementToHTML(element, null));
        pattern.setSolutionImageURL(PatternParser.getFirstImageURL(element));
        Element implementation = root.getChild("implementation", DEFAULT_NAMESPACE);
        if (implementation != null) {
            Element anchor = implementation.getChild("a", HTML_NAMESPACE);
            String dmkBaseFileName = anchor.getAttributeValue("href");
            try {
                URL patternSolutionURL;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("edu.berkeley.guir.damask.pattern.Pattern");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((patternSolutionURL = clazz.getResource(dmkBaseFileName)) != null) {
                    pattern.setSolution(DamaskReader.open(patternSolutionURL, pattern));
                }
            }
            catch (JAXBException e1) {
                DamaskAppExceptionHandler.log(e1);
            }
        }
        ArrayList outPatterns = new ArrayList();
        pattern.setRelatedPatternsText(PatternParser.convertDOMElementToHTML(root.getChild("related-patterns", DEFAULT_NAMESPACE), outPatterns));
        i = outPatterns.iterator();
        while (i.hasNext()) {
            Pattern outPattern = (Pattern)i.next();
            pattern.addOutRef(outPattern);
        }
        pattern.setCredits(PatternParser.convertDOMElementToHTML(root.getChild("management", DEFAULT_NAMESPACE).getChild("credits", DEFAULT_NAMESPACE), null));
    }

    private static URL getFirstImageURL(Element element) {
        if (element.getName().equals("img")) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("edu.berkeley.guir.damask.pattern.Pattern");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz.getResource(element.getAttributeValue("src"));
        }
        URL url = null;
        Iterator i = element.getChildren().iterator();
        while (i.hasNext()) {
            Element child = (Element)i.next();
            url = PatternParser.getFirstImageURL(child);
            if (url != null) break;
        }
        return url;
    }

    private static String convertDOMElementToHTML(Element element, List patternLinks) {
        StringBuffer sb = new StringBuffer();
        Iterator i = element.getContent().iterator();
        while (i.hasNext()) {
            Object obj = i.next();
            if (obj instanceof Text) {
                sb.append(((Text)obj).getText());
                continue;
            }
            if (!(obj instanceof Element)) continue;
            Element elem = (Element)obj;
            String tag = elem.getName();
            if (tag.equals("a")) {
                sb.append("<a class=\"val\" href=\"" + elem.getAttributeValue("href") + "\">");
                sb.append(String.valueOf(elem.getText()) + "</a>");
                continue;
            }
            if (tag.equals("pattern-link")) {
                String patternName = elem.getText();
                String patternID = elem.getAttributeValue("patternID");
                String collectionID = elem.getAttributeValue("collectionID");
                sb.append("<a class=\"val\" href=\"" + PatternBrowser.createPatternLinkURLString(collectionID, patternID) + "\">" + patternName + "</a>");
                if (patternLinks == null) continue;
                patternLinks.add(PatternLibrary.getPattern(collectionID, patternID));
                continue;
            }
            sb.append(PatternParser.convertDOMElementToHTML(elem, patternLinks));
        }
        return sb.toString().trim();
    }
}

