/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.view.pattern;

import edu.berkeley.guir.damask.DamaskUtils;
import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.pattern.PatternInstance;
import edu.berkeley.guir.damask.pattern.PatternInstanceMember;
import edu.berkeley.guir.damask.view.DamaskLayer;
import edu.berkeley.guir.damask.view.InteractionElementView;
import edu.berkeley.guir.lib.collection.WeakHashSet;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PBounds;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class PatternInstanceView
extends InteractionElementView {
    private static final Color BOUNDARY_COLOR = Color.BLUE;
    private static final Color TEXT_COLOR = new Color(0, 0, 255, 127);
    private static final float TEXT_SIZE = 18.0f;
    private static final Stroke BOUNDARY_STROKE = new BasicStroke(1.0f, 0, 0, 1.0f, new float[]{2.0f, 2.0f}, 0.0f);
    private final MemberViewBoundsTransformHandler boundsTransformHandler = new MemberViewBoundsTransformHandler();
    private final MemberViewParentHandler parentHandler = new MemberViewParentHandler();
    private final Set memberViews = new HashSet();
    private final Map ancestors = new HashMap();
    private final Map descendants = new HashMap();
    private final PText patternName;
    private static boolean autoReshape = true;
    private static WeakHashSet instances = new WeakHashSet();

    public PatternInstanceView(PatternInstance patternInstance) {
        super(patternInstance);
        this.setStrokePaint(BOUNDARY_COLOR);
        this.setStroke(BOUNDARY_STROKE);
        this.patternName = new PText(patternInstance.getPattern().getName());
        this.patternName.setPaint(TEXT_COLOR);
        this.patternName.setFont(this.patternName.getFont().deriveFont(18.0f));
        this.addChild(this.patternName);
        instances.add(this);
        this.setPickable(false);
    }

    protected void initAfterAddToParent() {
        super.initAfterAddToParent();
        DamaskLayer layer = this.getLayer();
        Iterator i = ((PatternInstance)this.getModel()).getMembers(this.getDeviceType()).iterator();
        while (i.hasNext()) {
            PatternInstanceMember member = (PatternInstanceMember)i.next();
            InteractionElementView memberView = layer.getView(member);
            if (memberView == null) continue;
            this.addMemberView(memberView);
        }
        if (autoReshape) {
            this.reshape();
        }
    }

    public void dispose() {
        Iterator i = new HashSet(this.memberViews).iterator();
        while (i.hasNext()) {
            InteractionElementView memberView = (InteractionElementView)i.next();
            this.removeMemberView(memberView);
        }
    }

    private void startListeningToAncestors(InteractionElementView memberView) {
        PNode parent = memberView.getParent();
        while (parent != null && !(parent instanceof PLayer)) {
            Set ancestorsOfMemberView = (Set)DamaskUtils.defaultGet(this.ancestors, memberView, new HashSet());
            ancestorsOfMemberView.add(parent);
            Set memberViewOfParent = (Set)DamaskUtils.defaultGet(this.descendants, parent, new HashSet());
            if (memberViewOfParent.isEmpty()) {
                parent.addPropertyChangeListener("bounds", this.boundsTransformHandler);
                parent.addPropertyChangeListener("transform", this.boundsTransformHandler);
            }
            memberViewOfParent.add(memberView);
            parent = parent.getParent();
        }
    }

    private void stopListeningToAncestors(InteractionElementView memberView) {
        Set ancestorsOfMemberView = (Set)this.ancestors.get(memberView);
        if (ancestorsOfMemberView != null) {
            Iterator i = ancestorsOfMemberView.iterator();
            while (i.hasNext()) {
                PNode ancestor = (PNode)i.next();
                Set descendantsForAncestor = (Set)this.descendants.get(ancestor);
                descendantsForAncestor.remove(memberView);
                if (!descendantsForAncestor.isEmpty()) continue;
                this.descendants.remove(ancestor);
                ancestor.removePropertyChangeListener("bounds", this.boundsTransformHandler);
                ancestor.removePropertyChangeListener("transform", this.boundsTransformHandler);
            }
            ancestorsOfMemberView.clear();
        }
    }

    public DeviceType getDeviceType() {
        DamaskLayer layer = this.getLayer();
        if (layer != null) {
            return layer.getDeviceType();
        }
        return null;
    }

    public void addMemberView(InteractionElementView memberView) {
        this.memberViews.add(memberView);
        memberView.addPropertyChangeListener("parent", this.parentHandler);
        memberView.addPropertyChangeListener("bounds", this.boundsTransformHandler);
        memberView.addPropertyChangeListener("transform", this.boundsTransformHandler);
        this.startListeningToAncestors(memberView);
    }

    public void removeMemberView(InteractionElementView memberView) {
        this.memberViews.remove(memberView);
        memberView.removePropertyChangeListener("parent", this.parentHandler);
        memberView.removePropertyChangeListener("bounds", this.boundsTransformHandler);
        memberView.removePropertyChangeListener("transform", this.boundsTransformHandler);
        this.stopListeningToAncestors(memberView);
    }

    public static void setAutoReshape(boolean flag) {
        autoReshape = flag;
    }

    public static void reshapeAll() {
        Iterator i = instances.iterator();
        while (i.hasNext()) {
            PatternInstanceView view = (PatternInstanceView)i.next();
            view.reshape();
        }
    }

    protected void reshape() {
        RectangularShape shape = null;
        Iterator i = this.memberViews.iterator();
        while (i.hasNext()) {
            InteractionElementView memberView = (InteractionElementView)i.next();
            if (!memberView.getVisible()) continue;
            PBounds memberGlobalBounds = memberView.getBounds();
            memberView.localToGlobal(memberGlobalBounds);
            if (((RectangularShape)memberGlobalBounds).isEmpty()) continue;
            if (shape == null) {
                shape = memberGlobalBounds;
                continue;
            }
            ((Rectangle2D)shape).add(memberGlobalBounds);
        }
        if (shape != null) {
            this.setPathTo(shape);
            this.patternName.setBounds(shape.getX(), shape.getY(), this.patternName.getWidth(), this.patternName.getHeight());
        }
    }

    public class MemberViewBoundsTransformHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {
            if (autoReshape) {
                PatternInstanceView.this.reshape();
            }
        }
    }

    public class MemberViewParentHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {
            InteractionElementView memberView = (InteractionElementView)evt.getSource();
            PatternInstanceView.this.stopListeningToAncestors(memberView);
            PatternInstanceView.this.startListeningToAncestors(memberView);
            if (autoReshape) {
                PatternInstanceView.this.reshape();
            }
        }
    }
}

