/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.view.pattern;

import edu.berkeley.guir.damask.Damask;
import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.dialog.Page;
import edu.berkeley.guir.damask.pattern.Pattern;
import edu.berkeley.guir.damask.pattern.PatternLibrary;
import edu.berkeley.guir.damask.pattern.PatternSolution;
import edu.berkeley.guir.damask.view.DamaskAppExceptionHandler;
import edu.berkeley.guir.damask.view.DamaskAppUtils;
import edu.berkeley.guir.damask.view.DamaskCanvas;
import edu.berkeley.guir.damask.view.DamaskDocument;
import edu.berkeley.guir.damask.view.DamaskFrame;
import edu.berkeley.guir.damask.view.DamaskRunFrame;
import edu.berkeley.guir.damask.view.DamaskToolbar;
import edu.berkeley.guir.damask.view.pattern.BrowserLauncher;
import edu.berkeley.guir.damask.view.pattern.LinkListener;
import edu.berkeley.guir.damask.view.pattern.PatternParser;
import edu.berkeley.guir.damask.view.pattern.PatternsSearcher;
import edu.berkeley.guir.damask.view.visual.DamaskPhoneRunFrame;
import edu.berkeley.guir.damask.view.voice.VoicePreview;
import edu.umd.cs.piccolox.swing.PScrollPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.Scrollable;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;

public class PatternBrowser
extends JFrame {
    private static final String ILLUSTRATION = "Illustration";
    private static final String CONTEXT = "Background";
    private static final String PROBLEM = "Problem";
    private static final String SOLUTION = "Solution";
    private static final String CONSIDER = "Consider These Other Patterns";
    private static final String RELATED = "Related Patterns";
    private static final String CREDITS = "Credits";
    private static final int DEFAULT_WIDTH = 1000;
    private static final int DEFAULT_HEIGHT = 500;
    private static final int SECTION_PADDING = 8;
    private static final int COMPONENT_PADDING = 5;
    private static final int MIN_SEARCH_RESULTS_HEIGHT = 100;
    private static final int MIN_PATTERN_DISPLAY_WIDTH = 300;
    private static final Icon SHOW_ICON;
    private static final Icon HIDE_ICON;
    private static final Logger logger;
    public static final DataFlavor PATTERN_SOLUTION_FLAVOR;
    private static final Map groupColors;
    private static final Map groupNames;
    private Pattern currentPattern = null;
    private final PatternsSearcher scanner;
    private final JButton backButton;
    private final JButton forwardButton;
    private final JTextField searchTextField;
    private final JButton showHideSearchResultsButton;
    private final JSplitPane contentSplitPane;
    private final JSplitPane mainSplitPane;
    private final JLabel searchResultsLabel;
    private final JEditorPane searchResultsPane;
    private final JLabel showAllLabel;
    private final JEditorPane showAllPane;
    private final JButton showHidePatternIndexButton;
    private final JScrollPane patternScrollPane;
    private final JLabel nameLabel = new JLabel();
    private Map infoPanels = new HashMap();
    private Stack backStack = new Stack();
    private Stack forwardStack = new Stack();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.damask.view.DamaskApp");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        SHOW_ICON = new ImageIcon(toolkit.getImage(clazz.getResource("images/pattern/show.png")));
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("edu.berkeley.guir.damask.view.DamaskApp");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        HIDE_ICON = new ImageIcon(toolkit.getImage(clazz2.getResource("images/pattern/hide.png")));
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("edu.berkeley.guir.damask.view.pattern.PatternBrowser");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz3.getName());
        PATTERN_SOLUTION_FLAVOR = new DataFlavor("application/x-java-jvm-local-objectref;class=edu.berkeley.guir.damask.pattern.PatternSolution", "Damask-based pattern solution");
        groupColors = new HashMap();
        groupColors.put("A", "#2E1263");
        groupColors.put("B", "#005E9D");
        groupColors.put("C", "#007E98");
        groupColors.put("D", "#D5847D");
        groupColors.put("E", "#881344");
        groupColors.put("F", "#657376");
        groupColors.put("G", "#9EACAA");
        groupColors.put("H", "#9E481A");
        groupColors.put("I", "#A56E08");
        groupColors.put("J", "#FCAF17");
        groupColors.put("K", "#AA9900");
        groupColors.put("L", "#7A8F1B");
        groupNames = new HashMap();
        groupNames.put("A", "Site Genres");
        groupNames.put("B", "Creating a Navigation Framework");
        groupNames.put("C", "Creating a Powerful Homepage");
        groupNames.put("D", "Writing and Managing Content");
        groupNames.put("E", "Building Trust and Credibility");
        groupNames.put("F", "Basic E-Commerce");
        groupNames.put("G", "Advanced E-Commerce");
        groupNames.put("H", "Helping Customers Complete Tasks");
        groupNames.put("I", "Designing Effective Page Layouts");
        groupNames.put("J", "Making Site Search Fast and Relevant");
        groupNames.put("K", "Making Navigation Easy");
        groupNames.put("L", "Speeding Up Your Site");
    }

    public PatternBrowser(String initialCollectionId, String initialPatternId) {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("edu.berkeley.guir.damask.pattern.Pattern");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.scanner = new PatternsSearcher(clazz.getResource("PatternList.txt"));
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        ShowHideSearchResultsAction searchResultsAction = new ShowHideSearchResultsAction();
        ShowHidePatternIndexAction patternDisplayAction = new ShowHidePatternIndexAction();
        JPanel toolBarsArea = new JPanel();
        toolBarsArea.setLayout(new BorderLayout());
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        this.backButton = DamaskAppUtils.createBackButton(new BackAction());
        toolbar.add(this.backButton);
        this.backButton.setEnabled(false);
        this.forwardButton = DamaskAppUtils.createForwardButton(new ForwardAction());
        toolbar.add(this.forwardButton);
        this.forwardButton.setEnabled(false);
        toolBarsArea.add((Component)toolbar, "North");
        JPanel searchBar = new JPanel();
        searchBar.setLayout(new BoxLayout(searchBar, 2));
        this.showHidePatternIndexButton = new JButton(patternDisplayAction);
        this.showHidePatternIndexButton.setBorder(new EmptyBorder(5, 5, 5, 5));
        searchBar.add(this.showHidePatternIndexButton);
        JLabel searchLabel = new JLabel("Look for:");
        searchLabel.setBorder(new EmptyBorder(5, 5, 5, 5));
        searchBar.add(searchLabel);
        this.searchTextField = new JTextField();
        this.searchTextField.setBorder(new EmptyBorder(5, 5, 5, 5));
        searchBar.add(this.searchTextField);
        searchBar.add(Box.createHorizontalStrut(5));
        JButton searchButton = new JButton(new SearchAction());
        searchButton.setBorder(new EmptyBorder(5, 5, 5, 5));
        searchBar.add(searchButton);
        this.showHideSearchResultsButton = new JButton(searchResultsAction);
        this.showHideSearchResultsButton.setBorder(new EmptyBorder(5, 5, 5, 5));
        searchBar.add(this.showHideSearchResultsButton);
        toolBarsArea.add((Component)searchBar, "Center");
        contentPane.add((Component)toolBarsArea, "North");
        JPanel searchResultsPanel = new JPanel();
        searchResultsPanel.setLayout(new BoxLayout(searchResultsPanel, 3));
        searchResultsPanel.setMinimumSize(new Dimension(0, 0));
        this.searchResultsLabel = new JLabel("Search Results");
        this.searchResultsLabel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.searchResultsLabel.setAlignmentX(0.0f);
        searchResultsPanel.add(this.searchResultsLabel);
        this.searchResultsPane = new JEditorPane();
        this.searchResultsPane.setContentType("text/html");
        this.searchResultsPane.addHyperlinkListener(new LinkListener(this.searchResultsPane, this));
        this.searchResultsPane.setEditable(false);
        JScrollPane searchResultsScrollPane = new JScrollPane(this.searchResultsPane);
        searchResultsScrollPane.setAlignmentX(0.0f);
        searchResultsPanel.add(searchResultsScrollPane);
        FlexWidthPanel patternPanel = new FlexWidthPanel();
        patternPanel.setLayout(new BoxLayout(patternPanel, 3));
        this.nameLabel.setFont(this.nameLabel.getFont().deriveFont(1, 14.0f));
        this.nameLabel.setBackground(Color.WHITE);
        JPanel namePanel = new JPanel();
        namePanel.setBackground(Color.WHITE);
        namePanel.setLayout(new BorderLayout());
        namePanel.add((Component)this.nameLabel, "West");
        namePanel.setBorder(new EmptyBorder(8, 8, 8, 8));
        patternPanel.add(namePanel);
        this.createInfoPanel(patternPanel, ILLUSTRATION);
        this.createInfoPanel(patternPanel, CONTEXT);
        this.createInfoPanel(patternPanel, PROBLEM);
        this.createInfoPanel(patternPanel, SOLUTION);
        this.createInfoPanel(patternPanel, CONSIDER);
        this.createInfoPanel(patternPanel, RELATED);
        this.createInfoPanel(patternPanel, CREDITS);
        this.patternScrollPane = new JScrollPane(patternPanel);
        this.patternScrollPane.setWheelScrollingEnabled(true);
        this.patternScrollPane.setPreferredSize(new Dimension(1000, 500));
        this.contentSplitPane = new JSplitPane(0, true, searchResultsPanel, this.patternScrollPane);
        this.contentSplitPane.addPropertyChangeListener("dividerLocation", searchResultsAction);
        JPanel showAllPanel = new JPanel();
        showAllPanel.setLayout(new BoxLayout(showAllPanel, 3));
        showAllPanel.setMinimumSize(new Dimension(0, 0));
        this.showAllLabel = new JLabel("Pattern Index");
        this.showAllLabel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.showAllLabel.setAlignmentX(0.0f);
        showAllPanel.add(this.showAllLabel);
        this.showAllPane = new JEditorPane();
        this.showAllPane.setContentType("text/html");
        this.showAllPane.addHyperlinkListener(new LinkListener(this.showAllPane, this));
        this.showAllPane.setEditable(false);
        StringBuffer sb = new StringBuffer();
        sb.append("<html>");
        sb.append("<head>");
        sb.append("<style>");
        sb.append("a.val { color: #ffffff; } ");
        sb.append("td { font-family: sans-serif; } ");
        sb.append("</style>");
        sb.append("</head><body>");
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("edu.berkeley.guir.damask.pattern.Pattern");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        sb.append(PatternBrowser.createPatternsIndex(clazz2.getResource("PatternList.txt")));
        sb.append("</body></html>");
        this.showAllPane.setText(sb.toString());
        JScrollPane showAllScrollPane = new JScrollPane(this.showAllPane);
        showAllScrollPane.setAlignmentX(0.0f);
        showAllPanel.add(showAllScrollPane);
        this.mainSplitPane = new JSplitPane(1, true, showAllPanel, this.contentSplitPane);
        this.mainSplitPane.addPropertyChangeListener("dividerLocation", patternDisplayAction);
        this.mainSplitPane.setDividerLocation(300);
        contentPane.add(this.mainSplitPane);
        this.displayPattern(PatternLibrary.getPattern(initialCollectionId, initialPatternId));
        this.addComponentListener(new ComponentHandler());
        this.setSize(1000, 500);
        this.validate();
    }

    public void scrollToTop() {
        JScrollBar verticalBar = this.patternScrollPane.getVerticalScrollBar();
        verticalBar.setValue(verticalBar.getMinimum());
        this.patternScrollPane.getViewport().setViewPosition(new Point(0, 0));
    }

    private void createInfoPanel(JPanel panel, String name) {
        InfoPanel infoPanel = new InfoPanel(name);
        this.infoPanels.put(name, infoPanel);
        panel.add(infoPanel);
    }

    private InfoPanel getInfoPanel(String name) {
        return (InfoPanel)this.infoPanels.get(name);
    }

    private void displayCurrentPattern() {
        this.fillPatternInfoPane();
        this.setTitle(String.valueOf(this.currentPattern.getName()) + " - Damask - Pattern Browser");
        this.backButton.setEnabled(this.canGoBack());
        this.forwardButton.setEnabled(this.canGoForward());
        JScrollBar verticalBar = this.patternScrollPane.getVerticalScrollBar();
        verticalBar.setValue(verticalBar.getMinimum());
    }

    public void displayPattern(Pattern pattern) {
        Cursor oldCursor = this.getCursor();
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (this.currentPattern != null) {
            this.backStack.push(this.currentPattern);
        }
        this.forwardStack.clear();
        this.currentPattern = pattern;
        this.displayCurrentPattern();
        this.setCursor(oldCursor);
    }

    public Pattern getCurrentPattern() {
        return this.currentPattern;
    }

    public void goBack() {
        this.forwardStack.push(this.currentPattern);
        this.currentPattern = (Pattern)this.backStack.pop();
        this.displayCurrentPattern();
    }

    public boolean canGoBack() {
        return !this.backStack.isEmpty();
    }

    public void goForward() {
        this.backStack.push(this.currentPattern);
        this.currentPattern = (Pattern)this.forwardStack.pop();
        this.displayCurrentPattern();
    }

    public boolean canGoForward() {
        return !this.forwardStack.isEmpty();
    }

    public void launchURL(URL url) {
        try {
            BrowserLauncher.openURL(url.toString());
        }
        catch (IOException ioe) {
            DamaskAppExceptionHandler.log(ioe);
        }
    }

    private void fillPatternInfoPane() {
        InfoPanel infoPanel = this.getInfoPanel(ILLUSTRATION);
        infoPanel.clear();
        infoPanel.addImagePanel(this.currentPattern.getIllustrationURL());
        infoPanel.addHtmlPanel(this.currentPattern.getIllustrationText());
        infoPanel = this.getInfoPanel(CONTEXT);
        infoPanel.clear();
        infoPanel.addHtmlPanel(this.currentPattern.getBackground());
        infoPanel = this.getInfoPanel(PROBLEM);
        infoPanel.clear();
        infoPanel.addHtmlPanel(this.currentPattern.getProblem());
        infoPanel = this.getInfoPanel(SOLUTION);
        infoPanel.clear();
        infoPanel.addHtmlPanel(this.currentPattern.getSolutionText());
        infoPanel.addImagePanel(this.currentPattern.getSolutionImageURL());
        infoPanel.addHtmlPanel(this.currentPattern.getSolutionImageText());
        if (!this.currentPattern.getSolution().getDialogs().isEmpty()) {
            infoPanel.addSolutionPanel(this.currentPattern);
        }
        infoPanel = this.getInfoPanel(CONSIDER);
        infoPanel.clear();
        infoPanel.addHtmlPanel(this.currentPattern.getRelatedPatternsText());
        infoPanel = this.getInfoPanel(RELATED);
        infoPanel.clear();
        infoPanel.addHtmlPanel(this.createRelatedPatternsDiagrams(this.currentPattern), Color.WHITE, Color.LIGHT_GRAY);
        infoPanel = this.getInfoPanel(CREDITS);
        infoPanel.clear();
        infoPanel.addHtmlPanel(this.currentPattern.getCredits());
        this.nameLabel.setText(this.currentPattern.getName());
    }

    private static Map getCategorizedPatterns(Collection patterns) {
        TreeMap<String, TreeSet<Pattern>> result = new TreeMap<String, TreeSet<Pattern>>();
        Iterator i = patterns.iterator();
        while (i.hasNext()) {
            Pattern pattern = (Pattern)i.next();
            String group = pattern.getGroup();
            TreeSet<Pattern> patternsInGroup = (TreeSet<Pattern>)result.get(group);
            if (patternsInGroup == null) {
                patternsInGroup = new TreeSet<Pattern>(new Comparator(){

                    public int compare(Object o1, Object o2) {
                        int index2;
                        int index1 = ((Pattern)o1).getIndexInGroup();
                        if (index1 < (index2 = ((Pattern)o2).getIndexInGroup())) {
                            return -1;
                        }
                        if (index1 == index2) {
                            return 0;
                        }
                        return 1;
                    }
                });
                result.put(group, patternsInGroup);
            }
            patternsInGroup.add(pattern);
        }
        return result;
    }

    public static String createPatternLinkURLString(Pattern pattern) {
        return PatternBrowser.createPatternLinkURLString(pattern.getCollectionID(), pattern.getID());
    }

    public static String createPatternLinkURLString(String collectionID, String patternID) {
        return "http://damask/" + collectionID + "/" + patternID;
    }

    public static Pattern getPatternFromURL(URL url) {
        if (url.getProtocol().equals("http") && url.getHost().equals("damask")) {
            String[] pathParts = url.getPath().split("/");
            return PatternLibrary.getPattern(pathParts[1], pathParts[2]);
        }
        return null;
    }

    private String createRelatedPatternsDiagram(Collection patterns) {
        StringBuffer sb = new StringBuffer();
        sb.append("<table border=\"0\"><tr>");
        Map groupedPatterns = PatternBrowser.getCategorizedPatterns(patterns);
        Iterator i = groupedPatterns.keySet().iterator();
        while (i.hasNext()) {
            String group = (String)i.next();
            sb.append("<td bgcolor=\"" + groupColors.get(group) + "\" align=\"center\" valign=\"top\">");
            sb.append("<table border=\"0\" cellpadding=\"10\">");
            Iterator j = ((Set)groupedPatterns.get(group)).iterator();
            while (j.hasNext()) {
                Pattern pattern = (Pattern)j.next();
                sb.append("<tr><td><a class=\"val\" href=\"" + PatternBrowser.createPatternLinkURLString(pattern) + "\">" + pattern.getName() + "</a></td></tr>");
            }
            sb.append("</table></td>");
        }
        sb.append("</tr></table>");
        return sb.toString();
    }

    private String createRelatedPatternsDiagrams(Pattern pattern) {
        Collection inPatterns = pattern.getInRefs();
        Collection outPatterns = pattern.getOutRefs();
        StringBuffer sb = new StringBuffer();
        sb.append("<center>");
        if (inPatterns.size() > 0) {
            sb.append("<p>This pattern is <b>used by</b>:");
            sb.append(this.createRelatedPatternsDiagram(inPatterns));
            sb.append("<br>");
        }
        if (outPatterns.size() > 0) {
            sb.append("<p>This pattern <b>uses</b>:");
            sb.append(this.createRelatedPatternsDiagram(outPatterns));
        }
        sb.append("</center>");
        return sb.toString();
    }

    private static String createPatternsIndex(URL patternsListURL) {
        StringBuffer sb = new StringBuffer();
        try {
            String patternline;
            HashSet<Pattern> allPatterns = new HashSet<Pattern>();
            BufferedReader indexReader = new BufferedReader(new InputStreamReader(patternsListURL.openStream()));
            while ((patternline = indexReader.readLine()) != null) {
                Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("edu.berkeley.guir.damask.pattern.Pattern");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                String[] ids = PatternParser.getPatternIDs(clazz.getResource(patternline));
                Pattern pattern = PatternLibrary.getPattern(ids[0], ids[1]);
                allPatterns.add(pattern);
            }
            Map groupedPatterns = PatternBrowser.getCategorizedPatterns(allPatterns);
            sb.append("<table border=\"0\" cellpadding=\"5\" width=\"100%\">");
            Iterator i = groupedPatterns.keySet().iterator();
            while (i.hasNext()) {
                String group = (String)i.next();
                sb.append("<tr bgcolor=\"" + groupColors.get(group) + "\" align=\"left\" valign=\"top\">");
                sb.append("<td colspan=\"2\"><font color=\"#ffffff\"><b>" + groupNames.get(group) + " (" + group + ") </b></font></td></tr>");
                Iterator j = ((Set)groupedPatterns.get(group)).iterator();
                while (j.hasNext()) {
                    Pattern pattern = (Pattern)j.next();
                    sb.append("<tr bgcolor=\"" + groupColors.get(group) + "\" align=\"left\" valign=\"top\">");
                    sb.append("<td>&nbsp;&nbsp;&nbsp;</td><td><a class=\"val\" href=\"" + PatternBrowser.createPatternLinkURLString(pattern) + "\">" + pattern.getName() + "</a></td></tr>");
                }
            }
            sb.append("</table>");
        }
        catch (FileNotFoundException fnfe) {
            DamaskAppExceptionHandler.log(fnfe);
        }
        catch (IOException ioe) {
            DamaskAppExceptionHandler.log(ioe);
        }
        return sb.toString();
    }

    private class ComponentHandler
    extends ComponentAdapter {
        ComponentHandler() {
        }

        public void componentShown(ComponentEvent event) {
            logger.info("Pattern browser visible");
            Iterator i = DamaskFrame.getAllDamaskFrames().iterator();
            while (i.hasNext()) {
                DamaskFrame frame = (DamaskFrame)i.next();
                frame.onPatternBrowserVisibleChanged(true);
            }
        }

        public void componentHidden(ComponentEvent event) {
            logger.info("Pattern browser not visible");
            Iterator i = DamaskFrame.getAllDamaskFrames().iterator();
            while (i.hasNext()) {
                DamaskFrame frame = (DamaskFrame)i.next();
                frame.onPatternBrowserVisibleChanged(false);
            }
        }
    }

    private class BackAction
    extends AbstractAction {
        public BackAction() {
            super("Back");
            this.putValue("ShortDescription", "Go back");
            this.putValue("MnemonicKey", new Integer(37));
        }

        public void actionPerformed(ActionEvent e) {
            PatternBrowser.this.goBack();
        }
    }

    private class ForwardAction
    extends AbstractAction {
        public ForwardAction() {
            super("Forward");
            this.putValue("ShortDescription", "Go forward");
            this.putValue("MnemonicKey", new Integer(39));
        }

        public void actionPerformed(ActionEvent e) {
            PatternBrowser.this.goForward();
        }
    }

    private class SearchAction
    extends AbstractAction {
        public SearchAction() {
            super("Search");
            this.putValue("ShortDescription", "Search the pattern library");
            this.putValue("MnemonicKey", new Integer(83));
        }

        public void actionPerformed(ActionEvent event) {
            String searchKeyWords = PatternBrowser.this.searchTextField.getText();
            List searchResults = PatternBrowser.this.scanner.searchPatterns(searchKeyWords);
            PatternBrowser.this.searchResultsLabel.setText("Search Results - " + searchKeyWords + " - " + searchResults.size() + " matches found");
            StringBuffer searchResultsBuffer = new StringBuffer();
            Iterator i = searchResults.iterator();
            while (i.hasNext()) {
                String result = (String)i.next();
                searchResultsBuffer.append(result);
                if (!i.hasNext()) continue;
                searchResultsBuffer.append("<br>");
            }
            PatternBrowser.this.searchResultsPane.setText(searchResultsBuffer.toString());
            PatternBrowser.this.searchResultsPane.setCaretPosition(0);
            if (PatternBrowser.this.contentSplitPane.getDividerLocation() < 100) {
                PatternBrowser.this.contentSplitPane.setDividerLocation(100);
            }
        }
    }

    private class ShowHideSearchResultsAction
    extends AbstractAction
    implements PropertyChangeListener {
        private int lastDividerLocation;
        private boolean listenToDividerLocation;

        public ShowHideSearchResultsAction() {
            super("Show Results");
            this.lastDividerLocation = 100;
            this.listenToDividerLocation = true;
            this.setExpanded(false);
            this.putValue("MnemonicKey", new Integer(82));
        }

        private void setExpanded(boolean expanded) {
            if (expanded) {
                this.putValue("Name", "Hide Results");
                this.putValue("SmallIcon", HIDE_ICON);
                this.putValue("ShortDescription", "Hide the search results");
            } else {
                this.putValue("Name", "Show Results");
                this.putValue("SmallIcon", SHOW_ICON);
                this.putValue("ShortDescription", "Show the search results");
            }
        }

        public void actionPerformed(ActionEvent event) {
            if (PatternBrowser.this.contentSplitPane.getDividerLocation() <= 1) {
                PatternBrowser.this.contentSplitPane.setDividerLocation(Math.max(this.lastDividerLocation, 100));
                this.setExpanded(true);
            } else {
                this.listenToDividerLocation = false;
                this.lastDividerLocation = PatternBrowser.this.contentSplitPane.getDividerLocation();
                PatternBrowser.this.contentSplitPane.setDividerLocation(0);
                this.setExpanded(false);
                this.listenToDividerLocation = true;
            }
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (this.listenToDividerLocation) {
                if (PatternBrowser.this.contentSplitPane.getDividerLocation() <= 1) {
                    this.setExpanded(false);
                } else {
                    this.setExpanded(true);
                }
            }
        }
    }

    private static class FlexWidthPanel
    extends JPanel
    implements Scrollable {
        private static JTextArea textArea = new JTextArea();

        FlexWidthPanel() {
        }

        public Dimension getPreferredScrollableViewportSize() {
            return textArea.getPreferredScrollableViewportSize();
        }

        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return textArea.getScrollableUnitIncrement(visibleRect, orientation, direction);
        }

        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            return textArea.getScrollableBlockIncrement(visibleRect, orientation, direction);
        }

        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        public boolean getScrollableTracksViewportHeight() {
            return false;
        }
    }

    private class ShowHidePatternIndexAction
    extends AbstractAction
    implements PropertyChangeListener {
        private int lastDividerLocation;
        private boolean listenToDividerLocation;

        public ShowHidePatternIndexAction() {
            super("Show Pattern Index");
            this.lastDividerLocation = 300;
            this.listenToDividerLocation = true;
            this.putValue("ShortDescription", "Show the pattern index");
            this.putValue("MnemonicKey", new Integer(73));
        }

        public void actionPerformed(ActionEvent event) {
            if (PatternBrowser.this.mainSplitPane.getDividerLocation() <= 1) {
                PatternBrowser.this.mainSplitPane.setDividerLocation(Math.max(this.lastDividerLocation, 300));
                this.putValue("Name", "Hide Pattern Index");
                this.putValue("ShortDescription", "Hide the pattern index");
            } else {
                this.listenToDividerLocation = false;
                this.lastDividerLocation = PatternBrowser.this.mainSplitPane.getDividerLocation();
                PatternBrowser.this.mainSplitPane.setDividerLocation(0);
                this.putValue("Name", "Show Pattern Index");
                this.putValue("ShortDescription", "Show the pattern index");
                this.listenToDividerLocation = true;
            }
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (this.listenToDividerLocation) {
                if (PatternBrowser.this.mainSplitPane.getDividerLocation() <= 1) {
                    this.putValue("Name", "Show Pattern Index");
                    this.putValue("ShortDescription", "Show the pattern index");
                } else {
                    this.putValue("Name", "Hide Pattern Index");
                    this.putValue("ShortDescription", "Hide the pattern index");
                }
            }
        }
    }

    private class InfoPanel
    extends JPanel {
        private static final int INTERNAL_PADDING = 5;
        private final JPanel contentPanel = new JPanel();
        private final JButton expanderButton;

        public InfoPanel(String name) {
            this.setLayout(new BoxLayout(this, 3));
            this.expanderButton = new JButton(HIDE_ICON);
            this.expanderButton.setToolTipText("Hides this panel");
            this.expanderButton.addActionListener(new ActionListener(this){
                final /* synthetic */ InfoPanel this$1;
                {
                    this.this$1 = infoPanel;
                }

                public void actionPerformed(ActionEvent event) {
                    InfoPanel.access$0(this.this$1);
                }
            });
            JLabel titleLabel = new JLabel(name);
            titleLabel.setFont(titleLabel.getFont().deriveFont(1));
            JPanel titlePanel = new JPanel();
            titlePanel.setLayout(new BorderLayout());
            titlePanel.setBorder(new EmptyBorder(5, 5, 5, 5));
            titlePanel.add((Component)titleLabel, "West");
            titlePanel.add((Component)this.expanderButton, "East");
            titlePanel.setCursor(Cursor.getPredefinedCursor(12));
            titlePanel.addMouseListener(new MouseAdapter(this){
                final /* synthetic */ InfoPanel this$1;
                {
                    this.this$1 = infoPanel;
                }

                public void mouseClicked(MouseEvent event) {
                    InfoPanel.access$0(this.this$1);
                }
            });
            this.add(titlePanel);
            this.contentPanel.setLayout(new BoxLayout(this.contentPanel, 3));
            this.add(this.contentPanel);
            this.setBorder(new CompoundBorder(new LineBorder(Color.WHITE, 8), new LineBorder(Color.BLACK, 1)));
        }

        private void toggleExpanded() {
            if (this.contentPanel.isVisible()) {
                this.contentPanel.setVisible(false);
                this.expanderButton.setIcon(SHOW_ICON);
                this.expanderButton.setToolTipText("Shows this panel");
            } else {
                this.contentPanel.setVisible(true);
                this.expanderButton.setIcon(HIDE_ICON);
                this.expanderButton.setToolTipText("Hides this panel");
            }
        }

        public void addHtmlPanel(String content) {
            JEditorPane editorPane = new JEditorPane("text/html", "<html><body><br>" + content + "<br></body></html>");
            editorPane.setEditable(false);
            editorPane.addHyperlinkListener(new LinkListener(editorPane, PatternBrowser.this));
            editorPane.setBorder(new EmptyBorder(5, 5, 5, 5));
            this.contentPanel.add(editorPane);
        }

        public void addHtmlPanel(String content, Color linkColor, Color visitedLinkColor) {
            StringBuffer sb = new StringBuffer();
            sb.append("<html>");
            sb.append("<head>");
            if (linkColor != null || visitedLinkColor != null) {
                sb.append("<style>");
                if (linkColor != null) {
                    sb.append("a.val { color: #" + Integer.toHexString(linkColor.getRGB() & 0xFFFFFF) + "; } ");
                }
                if (visitedLinkColor != null) {
                    sb.append("a.val:visited { color: #" + Integer.toHexString(visitedLinkColor.getRGB() & 0xFFFFFF) + "; }");
                }
                sb.append("</style>");
            }
            sb.append("</head><body>");
            sb.append(content);
            sb.append("</body></html>");
            JEditorPane editorPane = new JEditorPane("text/html", sb.toString());
            editorPane.setEditable(false);
            editorPane.addHyperlinkListener(new LinkListener(editorPane, PatternBrowser.this));
            editorPane.setBorder(new EmptyBorder(5, 5, 5, 5));
            this.contentPanel.add(editorPane);
        }

        public void addImagePanel(URL url) {
            this.addImagePanel(Toolkit.getDefaultToolkit().getImage(url), new JPanel());
        }

        private void addImagePanel(Image image, JPanel panel) {
            panel.setLayout(new BorderLayout());
            panel.setBackground(Color.WHITE);
            JLabel imageLabel = new JLabel(new ImageIcon(image));
            panel.add((Component)imageLabel, "West");
            panel.setBorder(new EmptyBorder(5, 5, 5, 5));
            this.contentPanel.add(panel);
        }

        public void addSolutionPanel(Pattern pattern) {
            this.contentPanel.add(new DmkSolutionPanel(pattern));
        }

        public void clear() {
            this.contentPanel.removeAll();
        }

        static /* synthetic */ void access$0(InfoPanel infoPanel) {
            infoPanel.toggleExpanded();
        }
    }

    private class DmkSolutionPanel
    extends JPanel {
        private static final int INTERNAL_PADDING = 5;
        private final PatternSolution solution;
        private final DragSource dragSource;
        private final DragGestureListener dgListener;
        private final DragSourceListener dsListener;
        static /* synthetic */ Class class$0;

        public DmkSolutionPanel(Pattern pattern) {
            this.setLayout(new BoxLayout(this, 3));
            this.solution = pattern.getSolution();
            DamaskDocument doc = new DamaskDocument(this.solution, -1);
            DamaskDocument.DamaskCanvasGroup canvasGroup = doc.createCanvasGroup();
            this.dragSource = DragSource.getDefaultDragSource();
            this.dgListener = new DragGestureHandler();
            this.dsListener = new DragSourceHandler();
            this.dragSource.createDefaultDragGestureRecognizer(this, 3, this.dgListener);
            Iterator i = Damask.getSupportedDeviceTypes().iterator();
            while (i.hasNext()) {
                DeviceType aDeviceType = (DeviceType)i.next();
                if (this.solution.getDialogs(aDeviceType).isEmpty()) continue;
                JPanel devicePanel = new JPanel();
                devicePanel.setLayout(new BorderLayout());
                JPanel devicePanelTop = new JPanel();
                devicePanelTop.setLayout(new BoxLayout(devicePanelTop, 3));
                JPanel devicePanelTopBottom = new JPanel();
                devicePanelTopBottom.setLayout(new FlowLayout(3));
                JButton runButton = new JButton("Run");
                runButton.setIcon(DamaskToolbar.getToolbarIcon("run.png"));
                runButton.addActionListener(new ActionListener(this, aDeviceType, pattern){
                    final /* synthetic */ DmkSolutionPanel this$1;
                    private final /* synthetic */ DeviceType val$aDeviceType;
                    private final /* synthetic */ Pattern val$pattern;
                    {
                        this.this$1 = dmkSolutionPanel;
                        this.val$aDeviceType = deviceType;
                        this.val$pattern = pattern;
                    }

                    public void actionPerformed(ActionEvent e) {
                        JFrame runFrame;
                        Page homePage = DmkSolutionPanel.access$0(this.this$1).getHomePage(this.val$aDeviceType);
                        if (this.val$aDeviceType == DeviceType.VOICE) {
                            VoicePreview voicePreview = new VoicePreview(null, this.val$pattern.getName(), homePage.getDialog());
                            voicePreview.go();
                        } else {
                            runFrame = this.val$aDeviceType == DeviceType.SMARTPHONE ? new DamaskPhoneRunFrame(this.val$pattern.getName(), homePage) : new DamaskRunFrame(this.val$pattern.getName(), homePage);
                            runFrame.setVisible(true);
                        }
                        runFrame = this.val$aDeviceType == DeviceType.SMARTPHONE ? new DamaskPhoneRunFrame(this.val$pattern.getName(), homePage) : (this.val$aDeviceType == DeviceType.DESKTOP ? new DamaskRunFrame(this.val$pattern.getName(), homePage) : null);
                        if (runFrame != null) {
                            runFrame.setVisible(true);
                        }
                    }
                });
                devicePanelTopBottom.add(new JLabel(aDeviceType.toString()));
                devicePanelTopBottom.add(runButton);
                JLabel dragLabel = new JLabel("<html><b>Drag this label and drop into the main window to add to your design.</b></html>");
                dragLabel.setAlignmentX(0.0f);
                devicePanelTopBottom.setAlignmentX(0.0f);
                devicePanelTop.add(dragLabel);
                devicePanelTop.add(devicePanelTopBottom);
                devicePanel.add((Component)devicePanelTop, "North");
                DamaskCanvas canvas = canvasGroup.getCanvas(aDeviceType);
                canvas.setZoomCenteredAtUpperLeft(true);
                canvas.setModeByName("Pan");
                PScrollPane scrollPane = new PScrollPane(canvas);
                scrollPane.setMinimumSize(new Dimension(800, 800));
                devicePanel.add((Component)scrollPane, "Center");
                this.dragSource.createDefaultDragGestureRecognizer(scrollPane, 3, this.dgListener);
                devicePanel.setBorder(new EmptyBorder(0, 0, 5, 0));
                JToolBar sliderBar = new JToolBar();
                sliderBar.setFloatable(false);
                sliderBar.setLayout(new BorderLayout());
                JSlider slider = new JSlider(1, 1, 13, 7);
                slider.setInverted(true);
                sliderBar.add((Component)slider, "Center");
                slider.setModel(canvas.getSliderModel());
                if (aDeviceType != DeviceType.SMARTPHONE) {
                    slider.setValue(3);
                }
                JButton zoomOutButton = new JButton(this.getRadarIcon("zoom_out.png"));
                zoomOutButton.addActionListener(new ActionListener(this, slider){
                    final /* synthetic */ DmkSolutionPanel this$1;
                    private final /* synthetic */ JSlider val$slider;
                    {
                        this.this$1 = dmkSolutionPanel;
                        this.val$slider = jSlider;
                    }

                    public void actionPerformed(ActionEvent e) {
                        this.val$slider.setValue(this.val$slider.getValue() - 1);
                    }
                });
                sliderBar.add((Component)zoomOutButton, "North");
                JButton zoomInButton = new JButton(this.getRadarIcon("zoom_in.png"));
                zoomInButton.addActionListener(new ActionListener(this, slider){
                    final /* synthetic */ DmkSolutionPanel this$1;
                    private final /* synthetic */ JSlider val$slider;
                    {
                        this.this$1 = dmkSolutionPanel;
                        this.val$slider = jSlider;
                    }

                    public void actionPerformed(ActionEvent e) {
                        this.val$slider.setValue(this.val$slider.getValue() + 1);
                    }
                });
                sliderBar.add((Component)zoomInButton, "South");
                devicePanel.add((Component)sliderBar, "West");
                devicePanel.setMinimumSize(new Dimension(800, 400));
                this.add(devicePanel);
                JLabel spacer = new JLabel("    ");
                spacer.setBackground(Color.WHITE);
                this.add(spacer);
            }
            this.setMinimumSize(new Dimension(800, 800));
            this.setPreferredSize(new Dimension(800, 1400));
            this.setMaximumSize(new Dimension(800, 1400));
            this.setBorder(new EmptyBorder(5, 5, 5, 5));
        }

        protected ImageIcon getRadarIcon(String fileName) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("edu.berkeley.guir.damask.view.DamaskApp");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Image image = toolkit.createImage(clazz.getResource("images/radar/" + fileName));
            return new ImageIcon(image);
        }

        private class DragGestureHandler
        implements DragGestureListener {
            DragGestureHandler() {
            }

            public void dragGestureRecognized(DragGestureEvent dge) {
                try {
                    DmkSolutionTransferable transferable = new DmkSolutionTransferable(DmkSolutionPanel.this.solution);
                    dge.startDrag(DragSource.DefaultCopyNoDrop, transferable, DmkSolutionPanel.this.dsListener);
                }
                catch (InvalidDnDOperationException idoe) {
                    DamaskAppExceptionHandler.log(idoe);
                }
            }
        }

        private class DragSourceHandler
        implements DragSourceListener {
            DragSourceHandler() {
            }

            public void dragEnter(DragSourceDragEvent dsde) {
                DragSourceContext context = dsde.getDragSourceContext();
                int myAction = dsde.getDropAction();
                if (myAction != 0) {
                    context.setCursor(DragSource.DefaultCopyDrop);
                } else {
                    context.setCursor(DragSource.DefaultCopyNoDrop);
                }
            }

            public void dragOver(DragSourceDragEvent dsde) {
            }

            public void dropActionChanged(DragSourceDragEvent dsde) {
            }

            public void dragDropEnd(DragSourceDropEvent dsde) {
            }

            public void dragExit(DragSourceEvent dse) {
            }
        }
    }

    private class DmkSolutionTransferable
    implements Transferable,
    ClipboardOwner {
        private DataFlavor[] flavors = new DataFlavor[]{PATTERN_SOLUTION_FLAVOR};
        private final PatternSolution solution;

        public DmkSolutionTransferable(PatternSolution solution) {
            this.solution = solution;
        }

        public DataFlavor[] getTransferDataFlavors() {
            return this.flavors;
        }

        public boolean isDataFlavorSupported(DataFlavor flavor) {
            int i = 0;
            int n = this.flavors.length;
            while (i < n) {
                if (this.flavors[i].match(flavor)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
            if (PATTERN_SOLUTION_FLAVOR.match(flavor)) {
                return this.solution;
            }
            throw new UnsupportedFlavorException(flavor);
        }

        public void lostOwnership(Clipboard clipboard, Transferable contents) {
        }
    }
}

