/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.view.pattern;

import edu.berkeley.guir.damask.pattern.Pattern;
import edu.berkeley.guir.damask.view.pattern.PatternBrowser;
import java.net.URL;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class LinkListener
implements HyperlinkListener {
    private static final Logger logger;
    private final JEditorPane editorPane;
    private final JLabel status;
    private final PatternBrowser browser;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.damask.view.pattern.LinkListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getName());
    }

    public LinkListener(JEditorPane editorPane, JLabel status, PatternBrowser browser) {
        this.editorPane = editorPane;
        this.status = status;
        this.browser = browser;
    }

    public LinkListener(JEditorPane editorPane, PatternBrowser browser) {
        this(editorPane, null, browser);
    }

    public void hyperlinkUpdate(HyperlinkEvent he) {
        URL link;
        HyperlinkEvent.EventType type = he.getEventType();
        if (type == HyperlinkEvent.EventType.ENTERED) {
            if (this.status != null) {
                this.status.setText(he.getURL().toString());
            }
        } else if (type == HyperlinkEvent.EventType.EXITED) {
            if (this.status != null) {
                this.status.setText("");
            }
        } else if (type == HyperlinkEvent.EventType.ACTIVATED && (link = he.getURL()).getProtocol().equals("http")) {
            Pattern possiblePattern = PatternBrowser.getPatternFromURL(link);
            if (possiblePattern != null) {
                this.browser.displayPattern(possiblePattern);
                logger.info("displaying pattern " + possiblePattern);
            } else {
                this.browser.launchURL(link);
                logger.info("launching external browser " + link);
            }
        }
    }
}

