/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.view.nodes;

import edu.berkeley.guir.damask.view.DamaskAppExceptionHandler;
import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PAffineTransform;
import edu.umd.cs.piccolo.util.PBounds;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public final class StickyTransformManager {
    private StickyTransformManager() {
    }

    public static void setupSticky(PNode node, PCamera camera) {
        new StickyTransformHandler(node, camera);
    }

    public static void setupStickyZ(PNode node, PCamera camera, Point2D stickyPoint) {
        new StickyZTransformHandler(node, camera, stickyPoint, 1.0);
    }

    public static void setupStickyZ(PNode node, PCamera camera, Point2D stickyPoint, double scale) {
        new StickyZTransformHandler(node, camera, stickyPoint, scale);
    }

    private static class StickyTransformHandler
    implements PropertyChangeListener {
        private final PNode node;
        private final PCamera constraintCamera;

        StickyTransformHandler(PNode node, PCamera constraintCamera) {
            this.node = node;
            this.constraintCamera = constraintCamera;
            constraintCamera.addPropertyChangeListener("viewTransform", this);
            this.applyStickyConstraint();
        }

        public void propertyChange(PropertyChangeEvent cameraViewTransformChanged) {
            this.applyStickyConstraint();
        }

        private void applyStickyConstraint() {
            try {
                PAffineTransform frame = null;
                frame = this.node.getParent() != null ? this.node.getParent().getLocalToGlobalTransform(null) : new PAffineTransform();
                AffineTransform t = frame.createInverse();
                t.concatenate(this.constraintCamera.getViewTransformReference().createInverse());
                t.concatenate(frame);
                this.node.setTransform(t);
            }
            catch (NoninvertibleTransformException e) {
                DamaskAppExceptionHandler.log(e);
            }
        }
    }

    private static class StickyZTransformHandler
    implements PropertyChangeListener {
        private final PNode node;
        private final PCamera constraintCamera;
        private final double stickyPointX;
        private final double stickyPointY;
        private final double scale;

        StickyZTransformHandler(PNode node, PCamera constraintCamera, Point2D stickyPoint, double scale) {
            this.node = node;
            this.constraintCamera = constraintCamera;
            this.stickyPointX = stickyPoint.getX();
            this.stickyPointY = stickyPoint.getY();
            this.scale = scale;
            constraintCamera.addPropertyChangeListener("viewTransform", this);
            this.applyStickyZConstraint();
        }

        public void propertyChange(PropertyChangeEvent cameraViewTransformChanged) {
            this.applyStickyZConstraint();
        }

        public void applyStickyZConstraint() {
            PAffineTransform t = new PAffineTransform();
            double s = this.scale / this.constraintCamera.getViewScale();
            PBounds b = this.node.getFullBoundsReference();
            t.scaleAboutPoint(s, b.getX() + this.stickyPointX * b.getWidth(), b.getY() + this.stickyPointY * b.getHeight());
            this.node.setTransform(t);
        }
    }
}

