/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.view.nodes;

import edu.berkeley.guir.damask.view.nodes.SizingBorder;
import edu.berkeley.guir.damask.view.nodes.StickyTransformManager;
import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PAffineTransform;
import edu.umd.cs.piccolox.util.PBoundsLocator;
import java.awt.Point;

public class StickySizingBorder
extends SizingBorder {
    protected PCamera constraintCamera;
    protected PAffineTransform lastCameraTransform;

    public StickySizingBorder(PBoundsLocator aLocator, PCamera constraintCamera) {
        super(aLocator);
        this.constraintCamera = constraintCamera;
        this.relocateHandle();
    }

    public static void addStickySizingBorderTo(PBoundsLocator locator, PCamera camera) {
        StickySizingBorder border = new StickySizingBorder(locator, camera);
        locator.getNode().addChild(border);
        StickyTransformManager.setupStickyZ(border, camera, new Point(0, 0));
        border.relocateHandle();
    }

    public static void addStickySizingBordersTo(PNode aNode, PCamera camera) {
        StickySizingBorder[] borders = new StickySizingBorder[]{new StickySizingBorder(PBoundsLocator.createEastLocator(aNode), camera), new StickySizingBorder(PBoundsLocator.createWestLocator(aNode), camera), new StickySizingBorder(PBoundsLocator.createNorthLocator(aNode), camera), new StickySizingBorder(PBoundsLocator.createSouthLocator(aNode), camera), new StickySizingBorder(PBoundsLocator.createNorthEastLocator(aNode), camera), new StickySizingBorder(PBoundsLocator.createNorthWestLocator(aNode), camera), new StickySizingBorder(PBoundsLocator.createSouthEastLocator(aNode), camera), new StickySizingBorder(PBoundsLocator.createSouthWestLocator(aNode), camera)};
        int i = 0;
        int n = borders.length;
        while (i < n) {
            StickySizingBorder border = borders[i];
            aNode.addChild(border);
            StickyTransformManager.setupStickyZ(border, camera, new Point(0, 0));
            border.relocateHandle();
            ++i;
        }
    }

    protected double getNodeRenderedWidth() {
        PNode node = ((PBoundsLocator)this.getLocator()).getNode();
        if (this.constraintCamera == null) {
            return node.getWidth();
        }
        double s = this.constraintCamera.getViewScale();
        return node.getWidth() * s;
    }

    protected double getNodeRenderedHeight() {
        PNode node = ((PBoundsLocator)this.getLocator()).getNode();
        if (this.constraintCamera == null) {
            return node.getHeight();
        }
        double s = this.constraintCamera.getViewScale();
        return node.getHeight() * s;
    }
}

