/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.view.nodes;

import edu.berkeley.guir.damask.view.nodes.BoundsHandle;
import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolox.util.PBoundsLocator;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Iterator;

public class SizingBorder
extends BoundsHandle {
    public static final int CORNER_SIZE = 20;
    public static final int BORDER_SIZE = 5;
    public static final Color BORDER_COLOR = Color.LIGHT_GRAY;

    public SizingBorder(PBoundsLocator aLocator) {
        super(aLocator);
        this.setPaint(BORDER_COLOR);
        this.setStrokePaint(Color.BLACK);
        this.relocateHandle();
    }

    public static void addSizingBordersTo(PNode aNode) {
        aNode.addChild(new SizingBorder(PBoundsLocator.createEastLocator(aNode)));
        aNode.addChild(new SizingBorder(PBoundsLocator.createWestLocator(aNode)));
        aNode.addChild(new SizingBorder(PBoundsLocator.createNorthLocator(aNode)));
        aNode.addChild(new SizingBorder(PBoundsLocator.createSouthLocator(aNode)));
        aNode.addChild(new SizingBorder(PBoundsLocator.createNorthEastLocator(aNode)));
        aNode.addChild(new SizingBorder(PBoundsLocator.createNorthWestLocator(aNode)));
        aNode.addChild(new SizingBorder(PBoundsLocator.createSouthEastLocator(aNode)));
        aNode.addChild(new SizingBorder(PBoundsLocator.createSouthWestLocator(aNode)));
    }

    public static void removeSizingBordersFrom(PNode aNode) {
        ArrayList<PNode> handles = new ArrayList<PNode>();
        Iterator i = aNode.getChildrenIterator();
        while (i.hasNext()) {
            PNode each = (PNode)i.next();
            if (!(each instanceof SizingBorder)) continue;
            handles.add(each);
        }
        aNode.removeChildren(handles);
    }

    protected void resizeHandle(double nodeWidth, double nodeHeight, float cornerWidth, float cornerHeight, float borderSize) {
        switch (((PBoundsLocator)this.getLocator()).getSide()) {
            case 8: {
                this.setPathToPolyline(new float[]{0.0f, cornerWidth, cornerWidth, borderSize, borderSize, 0.0f, 0.0f}, new float[]{0.0f, 0.0f, borderSize, borderSize, cornerHeight, cornerHeight, 0.0f});
                break;
            }
            case 2: {
                this.setPathToPolyline(new float[]{0.0f, cornerWidth, cornerWidth, cornerWidth - borderSize, cornerWidth - borderSize, 0.0f, 0.0f}, new float[]{0.0f, 0.0f, cornerHeight, cornerHeight, borderSize, borderSize, 0.0f});
                break;
            }
            case 6: {
                this.setPathToPolyline(new float[]{0.0f, borderSize, borderSize, cornerWidth, cornerWidth, 0.0f, 0.0f}, new float[]{0.0f, 0.0f, cornerHeight - borderSize, cornerHeight - borderSize, cornerHeight, cornerHeight, 0.0f});
                break;
            }
            case 4: {
                this.setPathToPolyline(new float[]{0.0f, 0.0f, cornerWidth - borderSize, cornerWidth - borderSize, cornerWidth, cornerWidth, 0.0f}, new float[]{cornerHeight, cornerHeight - borderSize, cornerHeight - borderSize, 0.0f, 0.0f, cornerHeight, cornerHeight});
                break;
            }
            case 3: 
            case 7: {
                this.setPathToRectangle(0.0f, 0.0f, borderSize, (float)(nodeHeight - (double)cornerWidth + 3.0));
                break;
            }
            case 1: 
            case 5: {
                this.setPathToRectangle(0.0f, 0.0f, (float)(nodeWidth - (double)cornerHeight + 3.0), borderSize);
            }
        }
    }

    protected double getNodeRenderedWidth() {
        return ((PBoundsLocator)this.getLocator()).getNode().getWidth();
    }

    protected double getNodeRenderedHeight() {
        return ((PBoundsLocator)this.getLocator()).getNode().getHeight();
    }

    public void relocateHandle() {
        double nodeWidth = this.getNodeRenderedWidth();
        double nodeHeight = this.getNodeRenderedHeight();
        float cornerWidth = 20.0f;
        float cornerHeight = 20.0f;
        if (40.0 > nodeWidth + 10.0) {
            cornerWidth = ((float)nodeWidth + 10.0f) / 2.0f;
            nodeWidth = 0.0;
        }
        if (40.0 > nodeHeight + 10.0) {
            cornerHeight = ((float)nodeHeight + 10.0f) / 2.0f;
            nodeHeight = 0.0;
        }
        this.resizeHandle(nodeWidth, nodeHeight, cornerWidth, cornerHeight, 5.0f);
        PBoundsLocator locator = (PBoundsLocator)this.getLocator();
        PBounds b = this.getBoundsReference();
        double width = b.getWidth();
        double height = b.getHeight();
        Point2D aPoint = locator.locatePoint(null);
        PNode located = locator.getNode();
        PNode parent = this.getParent();
        located.localToGlobal(aPoint);
        this.globalToLocal(aPoint);
        if (parent != located && parent instanceof PCamera) {
            ((PCamera)parent).viewToLocal(aPoint);
        }
        double newCenterX = aPoint.getX();
        double newCenterY = aPoint.getY();
        if (newCenterX != b.getCenterX() || newCenterY != b.getCenterY()) {
            switch (locator.getSide()) {
                case 8: {
                    this.setBounds(newCenterX - 5.0, newCenterY - 5.0, width, height);
                    break;
                }
                case 2: {
                    this.setBounds(newCenterX - (double)cornerWidth + 5.0 - 1.0, newCenterY - 5.0, width, height);
                    break;
                }
                case 6: {
                    this.setBounds(newCenterX - 5.0, newCenterY - (double)cornerHeight + 5.0 - 1.0, width, height);
                    break;
                }
                case 4: {
                    this.setBounds(newCenterX - (double)cornerWidth + 5.0 - 1.0, newCenterY - (double)cornerHeight + 5.0 - 1.0, width, height);
                    break;
                }
                case 1: {
                    this.setBounds(newCenterX - width / 2.0, newCenterY - 5.0, width, height);
                    break;
                }
                case 5: {
                    this.setBounds(newCenterX - width / 2.0, newCenterY - 1.0, width, height);
                    break;
                }
                case 7: {
                    this.setBounds(newCenterX - 5.0, newCenterY - height / 2.0, width, height);
                    break;
                }
                case 3: {
                    this.setBounds(newCenterX - 1.0, newCenterY - height / 2.0, width, height);
                }
            }
        }
    }
}

