/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.view.nodes;

import edu.berkeley.guir.damask.view.DamaskCanvas;
import edu.berkeley.guir.damask.view.nodes.BoundsHandle;
import edu.berkeley.guir.damask.view.nodes.StickyTransformManager;
import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PComponent;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PPaintContext;
import edu.umd.cs.piccolox.util.PBoundsLocator;
import java.awt.Color;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Iterator;

public class SizeGrip
extends BoundsHandle {
    private static final int WIDTH = 20;
    private static final int HEIGHT = 20;
    private static final Color BACKGROUND_COLOR = new Color(153, 153, 204);
    private static final Color HIGHLIGHT_COLOR = new Color(204, 204, 255);
    private static final Color SHADOW_COLOR = new Color(102, 102, 153);
    private PPath[] dimpleHighlights = new PPath[6];
    private PPath[] dimpleShadows = new PPath[6];

    protected SizeGrip(PNode node) {
        super(PBoundsLocator.createSouthEastLocator(node));
        this.setPaint(BACKGROUND_COLOR);
        this.setStrokePaint(BACKGROUND_COLOR);
        this.setPathToPolyline(new float[]{20.0f, 20.0f, 0.0f, 20.0f}, new float[]{0.0f, 20.0f, 20.0f, 0.0f});
        int i = 0;
        int n = this.dimpleHighlights.length;
        while (i < n) {
            this.dimpleHighlights[i] = this.addDimpleHighlight();
            ++i;
        }
        i = 0;
        n = this.dimpleShadows.length;
        while (i < n) {
            this.dimpleShadows[i] = this.addDimpleShadow();
            ++i;
        }
        this.moveDimples(new Point(20, 20));
    }

    public static void addTo(PNode node, PCamera camera) {
        SizeGrip grip = new SizeGrip(node);
        node.addChild(grip);
        StickyTransformManager.setupStickyZ(grip, camera, new Point(20, 20));
        grip.relocateHandle();
    }

    public static void removeFrom(PNode node) {
        ArrayList<PNode> handles = new ArrayList<PNode>();
        Iterator i = node.getChildrenIterator();
        while (i.hasNext()) {
            PNode each = (PNode)i.next();
            if (!(each instanceof SizeGrip)) continue;
            handles.add(each);
        }
        node.removeChildren(handles);
    }

    private PPath addDimpleHighlight() {
        PPath highlight = PPath.createRectangle(0.0f, 0.0f, 2.0f, 2.0f);
        highlight.setStrokePaint(HIGHLIGHT_COLOR);
        this.addChild(highlight);
        return highlight;
    }

    private PPath addDimpleShadow() {
        PPath shadow = PPath.createRectangle(0.0f, 0.0f, 2.0f, 2.0f);
        shadow.setStrokePaint(SHADOW_COLOR);
        this.addChild(shadow);
        return shadow;
    }

    private void moveDimples(Point2D pt) {
        double x = pt.getX();
        double y = pt.getY();
        this.moveDimple(0, x - 4.0, y - 4.0);
        this.moveDimple(1, x - 4.0, y - 8.0);
        this.moveDimple(2, x - 4.0, y - 12.0);
        this.moveDimple(3, x - 8.0, y - 4.0);
        this.moveDimple(4, x - 8.0, y - 8.0);
        this.moveDimple(5, x - 12.0, y - 4.0);
    }

    private void moveDimple(int n, double x, double y) {
        Point2D.Double pt = new Point2D.Double(x, y);
        this.localToGlobal(pt);
        this.dimpleShadows[n].globalToLocal(pt);
        this.dimpleShadows[n].setBounds(((Point2D)pt).getX(), ((Point2D)pt).getY(), 2.0, 2.0);
        pt = new Point2D.Double(x, y);
        this.localToGlobal(pt);
        this.dimpleHighlights[n].globalToLocal(pt);
        this.dimpleHighlights[n].setBounds(((Point2D)pt).getX() + 1.0, ((Point2D)pt).getY() + 1.0, 2.0, 2.0);
    }

    public void relocateHandle() {
        PBoundsLocator locator = (PBoundsLocator)this.getLocator();
        PBounds b = this.getBoundsReference();
        double width = b.getWidth();
        double height = b.getHeight();
        Point2D aPoint = locator.locatePoint(null);
        PNode located = locator.getNode();
        PNode parent = this.getParent();
        located.localToGlobal(aPoint);
        this.globalToLocal(aPoint);
        if (parent != located && parent instanceof PCamera) {
            ((PCamera)parent).viewToLocal(aPoint);
        }
        this.setBounds(aPoint.getX() - width + 1.0, aPoint.getY() - height + 1.0, width, height);
        this.moveDimples(aPoint);
    }

    public void startHandleDrag(Point2D localPt, PInputEvent event) {
        super.startHandleDrag(localPt, event);
        PComponent eventComponent = event.getComponent();
        if (eventComponent instanceof DamaskCanvas) {
            ((DamaskCanvas)eventComponent).setWindowBoundsChanging(true);
        }
    }

    public void endHandleDrag(Point2D localPt, PInputEvent event) {
        super.endHandleDrag(localPt, event);
        PComponent eventComponent = event.getComponent();
        if (eventComponent instanceof DamaskCanvas) {
            ((DamaskCanvas)eventComponent).setWindowBoundsChanging(false);
        }
    }

    public void paint(PPaintContext aPaintContext) {
        PCamera camera = aPaintContext.getCamera();
        if (camera != null && camera.getComponent() instanceof DamaskCanvas) {
            boolean childrenVisible;
            if (camera.getViewScale() >= DamaskCanvas.scaleFactor(2)) {
                super.paint(aPaintContext);
                childrenVisible = true;
            } else {
                childrenVisible = false;
            }
            Iterator i = this.getChildrenIterator();
            while (i.hasNext()) {
                PNode child = (PNode)i.next();
                child.setVisible(childrenVisible);
            }
        }
    }
}

