/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.view.nodes;

import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.Direction;
import edu.berkeley.guir.damask.InteractionElement;
import edu.berkeley.guir.damask.command.ModifyGraphMacroCommand;
import edu.berkeley.guir.damask.command.SetBoundsCommand;
import edu.berkeley.guir.damask.command.SetTextSizeCommand;
import edu.berkeley.guir.damask.command.SetTransformCommand;
import edu.berkeley.guir.damask.component.ComponentGroup;
import edu.berkeley.guir.damask.component.Content;
import edu.berkeley.guir.damask.dialog.PageRegion;
import edu.berkeley.guir.damask.view.DamaskAppUtils;
import edu.berkeley.guir.damask.view.DamaskCanvas;
import edu.berkeley.guir.damask.view.InteractionElementView;
import edu.berkeley.guir.damask.view.nodes.BoundsHandle;
import edu.berkeley.guir.damask.view.nodes.DamaskPPath;
import edu.berkeley.guir.damask.view.visual.component.Label;
import edu.berkeley.guir.damask.view.visual.component.Panel;
import edu.berkeley.guir.damask.view.visual.dialog.PageRegionView;
import edu.berkeley.guir.lib.satin.command.MacroCommand;
import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PAffineTransform;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PDimension;
import edu.umd.cs.piccolox.handles.PBoundsHandle;
import edu.umd.cs.piccolox.util.PBoundsLocator;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ResizableHandle
extends BoundsHandle {
    private Map origPaths = new HashMap();
    private Map origTextBounds = new HashMap();
    private Map origTextSize = new HashMap();
    private Map origBoundsPct = new HashMap();
    private List objectsToResize = new ArrayList();
    static /* synthetic */ Class class$0;

    public ResizableHandle(PBoundsLocator aLocator) {
        super(aLocator);
    }

    public static void addHandlesTo(PNode aNode) {
        ResizableHandle.addHandlesTo(aNode, null, false, false);
    }

    public static void addStickyHandlesTo(PNode aNode, PCamera camera) {
        ResizableHandle.addHandlesTo(aNode, camera, true, false);
    }

    public static void addStickyZHandlesTo(PNode aNode, PCamera camera) {
        ResizableHandle.addHandlesTo(aNode, camera, false, true);
    }

    public static void addHandlesTo(PNode aNode, PCamera camera, boolean useSticky, boolean useStickyZ) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.damask.view.nodes.ResizableHandle");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        BoundsHandle.addHandlesTo(aNode, camera, useSticky, useStickyZ, clazz);
    }

    public static void removeHandlesFrom(PNode aNode) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.damask.view.nodes.ResizableHandle");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        BoundsHandle.removeHandlesFrom(aNode, clazz);
    }

    public static void removeStickyHandlesFrom(PNode aNode, PCamera camera) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.damask.view.nodes.ResizableHandle");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        BoundsHandle.removeStickyHandlesFrom(aNode, camera, clazz);
    }

    private void storeOrigBoundsPct(PNode node, PNode ancestor) {
        PNode path;
        PBounds nodeGlobalBds = node.getBounds();
        node.localToGlobal(nodeGlobalBds);
        if (node instanceof PPath) {
            path = (PPath)node;
            this.origPaths.put(path, new GeneralPath(((PPath)path).getPathReference()));
        } else if (node instanceof DamaskPPath) {
            path = (DamaskPPath)node;
            this.origPaths.put(path, new GeneralPath(((DamaskPPath)path).getPathReference()));
        } else if (node instanceof PText) {
            this.origTextBounds.put(node, node.getBounds());
            this.origTextSize.put(node, new Integer(((PText)node).getFont().getSize()));
        }
        PBounds ancestorGlobalBds = ancestor.getBounds();
        ancestor.localToGlobal(ancestorGlobalBds);
        this.origBoundsPct.put(node, new Rectangle2D.Double((nodeGlobalBds.getX() - ancestorGlobalBds.getX()) / ancestorGlobalBds.getWidth(), (nodeGlobalBds.getY() - ancestorGlobalBds.getY()) / ancestorGlobalBds.getHeight(), nodeGlobalBds.getWidth() / ancestorGlobalBds.getWidth(), nodeGlobalBds.getHeight() / ancestorGlobalBds.getHeight()));
        Iterator i = node.getChildrenIterator();
        while (i.hasNext()) {
            PNode child = (PNode)i.next();
            this.storeOrigBoundsPct(child, ancestor);
        }
    }

    public void startHandleDrag(Point2D aLocalPoint, PInputEvent aEvent) {
        PNode node;
        Iterator i;
        super.startHandleDrag(aLocalPoint, aEvent);
        this.objectsToResize.clear();
        if (aEvent.getComponent() instanceof DamaskCanvas) {
            i = ((DamaskCanvas)aEvent.getComponent()).getSelectedObjects().iterator();
            while (i.hasNext()) {
                node = (PNode)i.next();
                if (node instanceof InteractionElementView && !((InteractionElementView)node).isResizable()) continue;
                this.objectsToResize.add(node);
            }
        } else {
            this.objectsToResize.add(((PBoundsLocator)this.getLocator()).getNode());
        }
        i = this.objectsToResize.iterator();
        while (i.hasNext()) {
            node = (PNode)i.next();
            this.storeOrigBoundsPct(node, node);
        }
    }

    public void dragHandle(PDimension aLocalDimension, PInputEvent aEvent) {
        PBoundsLocator l = (PBoundsLocator)this.getLocator();
        PNode node = l.getNode();
        PNode parent = this.getParent();
        if (parent != node && parent instanceof PCamera) {
            ((PCamera)parent).localToView(aLocalDimension);
        }
        this.localToGlobal(aLocalDimension);
        node.globalToLocal(aLocalDimension);
        Iterator i = this.objectsToResize.iterator();
        while (i.hasNext()) {
            boolean toStretchObject;
            PNode n = (PNode)i.next();
            double dx = aLocalDimension.getWidth();
            double dy = aLocalDimension.getHeight();
            PBounds b = n.getBounds();
            boolean bl = toStretchObject = !(n instanceof InteractionElementView) || ((InteractionElementView)n).isStretchedWhenResized();
            if (toStretchObject && n.getClientProperty("Resize anchor") == Direction.CENTER) {
                switch (l.getSide()) {
                    case 1: {
                        b.setRect(b.x, b.y + dy / 2.0, b.width, b.height - dy);
                        break;
                    }
                    case 5: {
                        b.setRect(b.x, b.y - dy / 2.0, b.width, b.height + dy);
                        break;
                    }
                    case 3: {
                        b.setRect(b.x - dx / 2.0, b.y, b.width + dx, b.height);
                        break;
                    }
                    case 7: {
                        b.setRect(b.x + dx / 2.0, b.y, b.width - dx, b.height);
                        break;
                    }
                    case 8: {
                        b.setRect(b.x + dx / 2.0, b.y + dy / 2.0, b.width - dx, b.height - dy);
                        break;
                    }
                    case 6: {
                        b.setRect(b.x + dx / 2.0, b.y - dy / 2.0, b.width - dx, b.height + dy);
                        break;
                    }
                    case 2: {
                        b.setRect(b.x - dx / 2.0, b.y + dy / 2.0, b.width + dx, b.height - dy);
                        break;
                    }
                    case 4: {
                        b.setRect(b.x - dx / 2.0, b.y - dy / 2.0, b.width + dx, b.height + dy);
                    }
                }
            } else {
                switch (l.getSide()) {
                    case 1: {
                        b.setRect(b.x, b.y + dy, b.width, b.height - dy);
                        break;
                    }
                    case 5: {
                        b.setRect(b.x, b.y, b.width, b.height + dy);
                        break;
                    }
                    case 3: {
                        b.setRect(b.x, b.y, b.width + dx, b.height);
                        break;
                    }
                    case 7: {
                        b.setRect(b.x + dx, b.y, b.width - dx, b.height);
                        break;
                    }
                    case 8: {
                        b.setRect(b.x + dx, b.y + dy, b.width - dx, b.height - dy);
                        break;
                    }
                    case 6: {
                        b.setRect(b.x + dx, b.y, b.width - dx, b.height + dy);
                        break;
                    }
                    case 2: {
                        b.setRect(b.x, b.y + dy, b.width + dx, b.height - dy);
                        break;
                    }
                    case 4: {
                        b.setRect(b.x, b.y, b.width + dx, b.height + dy);
                    }
                }
            }
            boolean flipX = false;
            boolean flipY = false;
            if (b.width < 0.0) {
                flipX = true;
                b.width = -b.width;
                b.x -= b.width;
            }
            if (b.height < 0.0) {
                flipY = true;
                b.height = -b.height;
                b.y -= b.height;
            }
            if (flipX || flipY) {
                this.flipSiblingBoundsHandles(flipX, flipY);
            }
            PBounds origBounds = n.getBounds();
            AffineTransform translation = AffineTransform.getTranslateInstance(b.getX() - origBounds.getX(), b.getY() - origBounds.getY());
            translation.concatenate(n.getTransform());
            n.setTransform(translation);
            n.setBounds(origBounds.getX(), origBounds.getY(), b.getWidth(), b.getHeight());
            if (toStretchObject) {
                PBounds nodeGlobalBds = n.getBounds();
                n.localToGlobal(nodeGlobalBds);
                Iterator j = n.getChildrenIterator();
                while (j.hasNext()) {
                    PNode child = (PNode)j.next();
                    if (child instanceof PBoundsHandle) continue;
                    this.stretch(child, nodeGlobalBds);
                }
                continue;
            }
            if (n.getClientProperty("Resize children anchor") != Direction.CENTER) continue;
            double dw = b.width - origBounds.width;
            double dh = b.height - origBounds.height;
            Iterator j = n.getChildrenIterator();
            while (j.hasNext()) {
                PNode child = (PNode)j.next();
                child.translate(dw / 2.0, dh / 2.0);
            }
        }
    }

    private void stretch(PNode node, PBounds ancestorGlobalBds) {
        Point2D newOrigin;
        PNode path;
        Rectangle2D nodeBdsPct = (Rectangle2D)this.origBoundsPct.get(node);
        if (node instanceof PPath) {
            path = (PPath)node;
            ((PPath)path).setPathTo((Shape)this.origPaths.get(path));
        } else if (node instanceof DamaskPPath) {
            path = (DamaskPPath)node;
            ((DamaskPPath)path).setPathTo((Shape)this.origPaths.get(path));
        }
        PBounds oldBounds = node.getBounds();
        PDimension newSize = new PDimension(nodeBdsPct.getWidth() * ancestorGlobalBds.getWidth(), nodeBdsPct.getHeight() * ancestorGlobalBds.getHeight());
        node.globalToLocal(newSize);
        if (node instanceof PText && node.getParent() instanceof Label) {
            newOrigin = oldBounds.getOrigin();
        } else {
            newOrigin = new Point2D.Double(ancestorGlobalBds.getX() + nodeBdsPct.getX() * ancestorGlobalBds.getWidth(), ancestorGlobalBds.getY() + nodeBdsPct.getY() * ancestorGlobalBds.getHeight());
            node.globalToLocal(newOrigin);
        }
        PBounds newBounds = new PBounds();
        newBounds.setOrigin(newOrigin.getX(), newOrigin.getY());
        newBounds.setSize(newSize.getWidth(), newSize.getHeight());
        AffineTransform translation = AffineTransform.getTranslateInstance(newBounds.getX() - oldBounds.getX(), newBounds.getY() - oldBounds.getY());
        translation.concatenate(node.getTransform());
        node.setTransform(translation);
        node.setBounds(oldBounds.getX(), oldBounds.getY(), newBounds.getWidth(), newBounds.getHeight());
        if (node instanceof PText) {
            PText text = (PText)node;
            Rectangle2D origBounds = (Rectangle2D)this.origTextBounds.get(text);
            double fracSize = Math.min(newBounds.getWidth() / origBounds.getWidth(), newBounds.getHeight() / origBounds.getHeight());
            DamaskAppUtils.setFontSize(text, (int)((double)((Integer)this.origTextSize.get(text)).intValue() * fracSize));
        }
        Iterator i = node.getChildrenIterator();
        while (i.hasNext()) {
            PNode child = (PNode)i.next();
            if (child instanceof PBoundsHandle) continue;
            this.stretch(child, ancestorGlobalBds);
        }
    }

    protected void addStretchCommand(InteractionElementView view, DeviceType deviceType, MacroCommand command) {
        PBounds viewBounds = view.getBounds();
        InteractionElement model = view.getModel();
        if (view instanceof Panel) {
            ComponentGroup componentGroup = (ComponentGroup)model;
            PageRegion currentRegion = (PageRegion)((PageRegionView)((Panel)view).getParent()).getModel();
            command.addCommand(new SetBoundsCommand(componentGroup, currentRegion, (Rectangle2D)viewBounds));
            command.addCommand(new SetTransformCommand(componentGroup, currentRegion, (AffineTransform)view.getTransform()));
        } else {
            if (view instanceof Label && ((Label)view).getDisplayMode() == Content.TEXT) {
                Label label = (Label)view;
                command.addCommand(new SetTextSizeCommand((Content)label.getModel(), deviceType, label.getText().getFont().getSize()));
            } else {
                command.addCommand(new SetBoundsCommand(model, deviceType, (Rectangle2D)viewBounds));
            }
            command.addCommand(new SetTransformCommand(model, deviceType, (AffineTransform)view.getTransform()));
        }
        Iterator i = view.getChildrenIterator();
        while (i.hasNext()) {
            PNode child = (PNode)i.next();
            if (!(child instanceof InteractionElementView)) continue;
            this.addStretchCommand((InteractionElementView)child, deviceType, command);
        }
    }

    protected void addResizeCommand(InteractionElementView view, DeviceType deviceType, MacroCommand cmd) {
        PAffineTransform newTransform;
        AffineTransform oldTransform;
        PBounds newBounds;
        Rectangle2D oldBounds = view.getModel().getBounds(deviceType);
        if (!oldBounds.equals(newBounds = view.getBounds())) {
            cmd.addCommand(new SetBoundsCommand(view.getModel(), deviceType, (Rectangle2D)newBounds));
        }
        if (!(oldTransform = view.getModel().getTransform(deviceType)).equals(newTransform = view.getTransform())) {
            cmd.addCommand(new SetTransformCommand(view.getModel(), deviceType, (AffineTransform)newTransform));
        }
        if (view.getClientProperty("Resize children anchor") == Direction.CENTER) {
            Iterator i = view.getChildrenIterator();
            while (i.hasNext()) {
                PAffineTransform newChildTransform;
                InteractionElementView child;
                AffineTransform oldChildTransform;
                PNode childNode = (PNode)i.next();
                if (!(childNode instanceof InteractionElementView) || (oldChildTransform = (child = (InteractionElementView)childNode).getModel().getTransform(deviceType)).equals(newChildTransform = child.getTransform())) continue;
                cmd.addCommand(new SetTransformCommand(child.getModel(), deviceType, (AffineTransform)newChildTransform));
            }
        }
    }

    public void endHandleDrag(Point2D aLocalPoint, PInputEvent aEvent) {
        super.endHandleDrag(aLocalPoint, aEvent);
        if (aEvent.getComponent() instanceof DamaskCanvas) {
            DamaskCanvas canvas = (DamaskCanvas)aEvent.getComponent();
            ModifyGraphMacroCommand command = new ModifyGraphMacroCommand();
            Iterator i = canvas.getSelectedObjects().iterator();
            while (i.hasNext()) {
                InteractionElementView view = (InteractionElementView)i.next();
                if (view.isStretchedWhenResized()) {
                    this.addStretchCommand(view, canvas.getDeviceType(), command);
                    continue;
                }
                this.addResizeCommand(view, canvas.getDeviceType(), command);
            }
            canvas.getDocument().getCommandQueue().doCommand(canvas, command);
        }
        this.origPaths.clear();
        this.origTextBounds.clear();
        this.origTextSize.clear();
        this.origBoundsPct.clear();
    }
}

