/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.view.nodes;

import edu.berkeley.guir.damask.Direction;
import edu.berkeley.guir.damask.command.SetInsetCommand;
import edu.berkeley.guir.damask.dialog.PageRegion;
import edu.berkeley.guir.damask.view.DamaskAppUtils;
import edu.berkeley.guir.damask.view.DamaskCanvas;
import edu.berkeley.guir.damask.view.nodes.StickySizingBorder;
import edu.berkeley.guir.damask.view.nodes.StickyTransformManager;
import edu.berkeley.guir.damask.view.visual.dialog.PageRegionView;
import edu.berkeley.guir.damask.view.visual.dialog.PageViewContents;
import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PDimension;
import edu.umd.cs.piccolox.util.PBoundsLocator;
import java.awt.Color;
import java.awt.Point;
import java.awt.geom.Point2D;

public class PageRegionViewSizingBorder
extends StickySizingBorder {
    private static final int OTHER_SIZE = 50;
    private PageRegionView changingRegionView;

    public PageRegionViewSizingBorder(PBoundsLocator aLocator, PCamera constraintCamera) {
        super(aLocator, constraintCamera);
        this.setPaint(Color.LIGHT_GRAY);
        this.setStrokePaint(DamaskAppUtils.NO_COLOR);
    }

    public static void addPageRegionViewSizingBorderTo(PBoundsLocator locator, PCamera camera) {
        PageRegionViewSizingBorder border = new PageRegionViewSizingBorder(locator, camera);
        locator.getNode().addChild(border);
        StickyTransformManager.setupStickyZ(border, camera, new Point(0, 0));
        border.relocateHandle();
    }

    public void startHandleDrag(Point2D aLocalPoint, PInputEvent aEvent) {
        super.startHandleDrag(aLocalPoint, aEvent);
        this.changingRegionView = null;
    }

    public void dragHandle(PDimension aLocalDimension, PInputEvent aEvent) {
        PBoundsLocator l = (PBoundsLocator)this.getLocator();
        PageRegionView n = (PageRegionView)l.getNode();
        PageViewContents contents = (PageViewContents)n.getParent();
        PageRegionView centerRegion = contents.getRegionView(Direction.CENTER);
        PageRegionView northRegion = contents.getRegionView(Direction.NORTH);
        PageRegionView southRegion = contents.getRegionView(Direction.SOUTH);
        PageRegionView eastRegion = contents.getRegionView(Direction.EAST);
        PageRegionView westRegion = contents.getRegionView(Direction.WEST);
        PNode parent = this.getParent();
        if (parent != n && parent instanceof PCamera) {
            ((PCamera)parent).localToView(aLocalDimension);
        }
        this.localToGlobal(aLocalDimension);
        n.globalToLocal(aLocalDimension);
        int dx = (int)aLocalDimension.getWidth();
        int dy = (int)aLocalDimension.getHeight();
        int locatorSide = l.getSide();
        if ((n == westRegion || n == centerRegion || n == eastRegion) && locatorSide == 5 || n == southRegion) {
            this.changingRegionView = southRegion;
            southRegion.setInset(Math.max(0, southRegion.getInset() - dy));
        } else if ((n == westRegion || n == centerRegion || n == eastRegion) && locatorSide == 1 || n == northRegion) {
            this.changingRegionView = northRegion;
            northRegion.setInset(Math.max(0, northRegion.getInset() + dy));
        } else if (n == westRegion && locatorSide == 3 || n == centerRegion && locatorSide == 7) {
            this.changingRegionView = westRegion;
            westRegion.setInset(Math.max(0, westRegion.getInset() + dx));
        } else if (n == eastRegion && locatorSide == 7 || n == centerRegion && locatorSide == 3) {
            this.changingRegionView = eastRegion;
            eastRegion.setInset(Math.max(0, eastRegion.getInset() - dx));
        }
        if (this.changingRegionView != null) {
            this.changingRegionView.getParent().signalBoundsChanged();
        }
    }

    public void relocateHandle() {
        double nodeWidth = 50.0;
        double nodeHeight = 50.0;
        float cornerWidth = 0.0f;
        float cornerHeight = 0.0f;
        if (40.0 > nodeWidth + 10.0) {
            cornerWidth = ((float)nodeWidth + 10.0f) / 2.0f;
            nodeWidth = 0.0;
        }
        if (40.0 > nodeHeight + 10.0) {
            cornerHeight = ((float)nodeHeight + 10.0f) / 2.0f;
            nodeHeight = 0.0;
        }
        this.resizeHandle(nodeWidth, nodeHeight, cornerWidth, cornerHeight, 5.0f);
        PBoundsLocator locator = (PBoundsLocator)this.getLocator();
        PBounds b = this.getBoundsReference();
        double width = b.getWidth();
        double height = b.getHeight();
        Point2D aPoint = locator.locatePoint(null);
        PNode located = locator.getNode();
        PNode parent = this.getParent();
        located.localToGlobal(aPoint);
        this.globalToLocal(aPoint);
        if (parent != located && parent instanceof PCamera) {
            ((PCamera)parent).viewToLocal(aPoint);
        }
        double newCenterX = aPoint.getX();
        double newCenterY = aPoint.getY();
        if (newCenterX != b.getCenterX() || newCenterY != b.getCenterY()) {
            switch (locator.getSide()) {
                case 1: {
                    this.setBounds(newCenterX - width / 2.0, newCenterY, width, height);
                    break;
                }
                case 5: {
                    this.setBounds(newCenterX - width / 2.0, newCenterY - 5.0, width, height);
                    break;
                }
                case 7: {
                    this.setBounds(newCenterX, newCenterY - height / 2.0, width, height);
                    break;
                }
                case 3: {
                    this.setBounds(newCenterX - 5.0, newCenterY - height / 2.0, width, height);
                }
            }
        }
    }

    public void endHandleDrag(Point2D localPt, PInputEvent event) {
        super.endHandleDrag(localPt, event);
        if (this.changingRegionView != null) {
            DamaskCanvas canvas = (DamaskCanvas)event.getComponent();
            canvas.getDocument().getCommandQueue().doCommand(canvas, new SetInsetCommand((PageRegion)this.changingRegionView.getModel(), this.changingRegionView.getInset()));
        }
    }
}

