/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.view.nodes;

import edu.berkeley.guir.damask.view.DamaskAppUtils;
import edu.berkeley.guir.damask.view.DamaskCanvas;
import edu.berkeley.guir.damask.view.nodes.StickyTransformManager;
import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PComponent;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PDragSequenceEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.TexturePaint;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.imageio.ImageIO;

public class DragBar
extends PPath {
    private final PCamera constraintCamera;
    private final PNode node;
    private int height;
    private static final int CORNER_RADIUS = 5;
    private static final Color BORDER_COLOR = Color.LIGHT_GRAY.darker();
    static /* synthetic */ Class class$0;

    public DragBar(PNode node, PCamera constraintCamera) {
        this.constraintCamera = constraintCamera;
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("edu.berkeley.guir.damask.view.DamaskApp");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            BufferedImage image = ImageIO.read(clazz.getResource("images/page/drag_bar.gif"));
            this.height = image.getHeight();
            this.setPaint(new TexturePaint(image, new Rectangle2D.Double(0.0, 0.0, image.getWidth(), image.getHeight())));
        }
        catch (IOException e) {
            this.setPaint(new Color(204, 204, 204));
            this.height = 12;
        }
        this.node = node;
        this.setPathBounds(0.0f, 0.0f, (float)node.getWidth(), this.height);
        this.setStrokePaint(BORDER_COLOR);
        MouseEventHandler handler = new MouseEventHandler();
        handler.getEventFilter().setMarksAcceptedEventsAsHandled(true);
        this.addInputEventListener(handler);
    }

    public static void addTo(PNode node, PCamera camera) {
        DragBar dragBar = new DragBar(node, camera);
        node.addChild(dragBar);
        StickyTransformManager.setupStickyZ(dragBar, camera, new Point2D.Double(0.0, dragBar.getHeight()));
    }

    public static void removeFrom(PNode node) {
        ArrayList<PNode> handles = new ArrayList<PNode>();
        Iterator i = node.getChildrenIterator();
        while (i.hasNext()) {
            PNode each = (PNode)i.next();
            if (!(each instanceof DragBar)) continue;
            handles.add(each);
        }
        node.removeChildren(handles);
    }

    public void setPathBounds(float x, float y, float w, float h) {
        this.setPathTo(DamaskAppUtils.createHalfRoundRectangle(x, y, w, h, 5.0f, 5.0f));
    }

    public PNode getNode() {
        return this.node;
    }

    public int getIntHeight() {
        return this.height;
    }

    public PCamera getConstraintCamera() {
        return this.constraintCamera;
    }

    private class MouseEventHandler
    extends PDragSequenceEventHandler {
        MouseEventHandler() {
        }

        public void mouseEntered(PInputEvent event) {
            event.pushCursor(Cursor.getPredefinedCursor(13));
        }

        public void startDrag(PInputEvent event) {
            super.startDrag(event);
            PComponent eventComponent = event.getComponent();
            if (eventComponent instanceof DamaskCanvas) {
                ((DamaskCanvas)eventComponent).setWindowBoundsChanging(true);
            }
        }

        public void drag(PInputEvent event) {
            super.drag(event);
            PDimension d = event.getCanvasDelta();
            event.getTopCamera().localToView(d);
            PDimension gDist = new PDimension();
            gDist.setSize(d);
            DragBar.this.node.getParent().globalToLocal(d);
            DragBar.this.node.offset(d.getWidth(), d.getHeight());
        }

        public void endDrag(PInputEvent event) {
            super.endDrag(event);
            PComponent eventComponent = event.getComponent();
            if (eventComponent instanceof DamaskCanvas) {
                ((DamaskCanvas)eventComponent).setWindowBoundsChanging(false);
            }
        }

        public void mouseExited(PInputEvent event) {
            event.popCursor();
        }
    }
}

