/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.view.nodes;

import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.component.Content;
import edu.berkeley.guir.damask.view.DamaskAppUtils;
import edu.berkeley.guir.damask.view.DamaskCanvas;
import edu.berkeley.guir.damask.view.DamaskLayer;
import edu.berkeley.guir.damask.view.nodes.DamaskWindow;
import edu.berkeley.guir.damask.view.nodes.StickyTransformManager;
import edu.berkeley.guir.damask.view.visual.component.Label;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.Dimension;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class DamaskWindowTitle
extends PPath {
    public static final int DEFAULT_FONT_SIZE = 18;
    private static final int EMPTY_LABEL_WIDTH = 120;
    private Label titleLabel;
    private final int height;
    private PropertyChangeListener layerDetector = new LayerDetector();

    public DamaskWindowTitle() {
        this(18);
        this.addInputEventListener(new BasicInputEventHandler());
    }

    public DamaskWindowTitle(final int textSize) {
        this.height = (int)DamaskAppUtils.getRenderedTextBounds("Page", textSize).getHeight();
        this.addPropertyChangeListener("parent", this.layerDetector);
        this.addPropertyChangeListener("parent", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (DamaskWindowTitle.this.getParent() instanceof DamaskWindow) {
                    Content titleContent = ((DamaskWindow)DamaskWindowTitle.this.getParent()).getTitleContent();
                    titleContent.setTextSize(((DamaskWindow)DamaskWindowTitle.this.getParent()).getDeviceType(), textSize);
                    DamaskWindowTitle.this.titleLabel = new Label(titleContent);
                    DamaskWindowTitle.this.titleLabel.setEmptySize(new Dimension(120, DamaskWindowTitle.this.height));
                    DamaskWindowTitle.this.titleLabel.setMovable(false);
                    DamaskWindowTitle.this.titleLabel.setUseStickyZHandles(false);
                    DamaskWindowTitle.this.addChild(DamaskWindowTitle.this.titleLabel);
                }
            }
        });
    }

    public DamaskWindow getWindow() {
        if (this.getParent() instanceof DamaskWindow) {
            return (DamaskWindow)this.getParent();
        }
        return null;
    }

    public DeviceType getDeviceType() {
        if (this.getParent() instanceof DamaskWindow) {
            return ((DamaskWindow)this.getParent()).getDeviceType();
        }
        return null;
    }

    public int getPixelHeight() {
        return this.height;
    }

    public Label getLabel() {
        return this.titleLabel;
    }

    protected void setupStickyZ(final PLayer layer) {
        final double scale = layer instanceof DamaskLayer ? ((DamaskLayer)layer).getPageTitleScale() : 1.0;
        if (layer.getCameraCount() > 0) {
            StickyTransformManager.setupStickyZ(this, layer.getCamera(0), new Point(0, 0), scale);
        } else {
            layer.addPropertyChangeListener("cameras", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    if (layer.getCameraCount() > 0) {
                        StickyTransformManager.setupStickyZ(DamaskWindowTitle.this, layer.getCamera(0), new Point(0, 0), scale);
                    }
                }
            });
        }
    }

    private class LayerDetector
    implements PropertyChangeListener {
        LayerDetector() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            PNode node = (PNode)evt.getSource();
            PNode parent = node.getParent();
            if (parent != null) {
                node.removePropertyChangeListener("parent", this);
                PNode n = parent;
                while (n.getParent() != null && !(n instanceof PLayer)) {
                    n = n.getParent();
                }
                if (n instanceof PLayer) {
                    DamaskWindowTitle.this.setupStickyZ((PLayer)n);
                } else {
                    n.addPropertyChangeListener("parent", this);
                }
            }
        }
    }

    private class BasicInputEventHandler
    extends PBasicInputEventHandler {
        BasicInputEventHandler() {
        }

        public void mousePressed(PInputEvent event) {
            if (event.getComponent() instanceof DamaskCanvas) {
                ((DamaskCanvas)event.getComponent()).attachHandles((DamaskWindow)DamaskWindowTitle.this.getParent(), event.getCamera());
            }
        }
    }
}

