/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.view.nodes;

import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.InteractionElement;
import edu.berkeley.guir.damask.component.Content;
import edu.berkeley.guir.damask.dialog.Dialog;
import edu.berkeley.guir.damask.dialog.Page;
import edu.berkeley.guir.damask.event.InteractionElementEvent;
import edu.berkeley.guir.damask.event.InteractionElementListener;
import edu.berkeley.guir.damask.view.DamaskAppUtils;
import edu.berkeley.guir.damask.view.DamaskCanvas;
import edu.berkeley.guir.damask.view.DamaskLayer;
import edu.berkeley.guir.damask.view.InteractionElementView;
import edu.berkeley.guir.damask.view.nodes.DamaskWindowTitle;
import edu.berkeley.guir.damask.view.nodes.DragBar;
import edu.berkeley.guir.damask.view.visual.VisualCanvas;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;

public abstract class DamaskWindow
extends InteractionElementView {
    private static final Paint BORDER_COLOR = Color.LIGHT_GRAY.darker();
    private static final Image HOME_PAGE_IMAGE;
    private DamaskWindowTitle titleBar;
    private Color origTitleBarTextColor;
    private PPath contents = null;
    private DragBar dragBar;
    private final PImage homeIcon = new PImage(HOME_PAGE_IMAGE, false);
    private boolean listenToTransformChanges = true;
    private final boolean grayOutTemplateElements;
    private boolean inRunMode = false;
    private boolean isHome = false;
    private ElementHandler elementHandler = new ElementHandler();
    static /* synthetic */ Class class$0;

    static {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.damask.view.DamaskApp");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        HOME_PAGE_IMAGE = toolkit.createImage(clazz.getResource("images/page/home.png"));
    }

    protected DamaskWindow(InteractionElement model) {
        this(model, true);
    }

    protected DamaskWindow(InteractionElement model, boolean grayOutTemplateElements) {
        super(model, false);
        model.addInteractionElementListener(this.elementHandler);
        this.setStrokePaint(null);
        this.grayOutTemplateElements = grayOutTemplateElements;
    }

    protected void initAfterAddToParent() {
        super.initAfterAddToParent();
        this.contents = this.createContents();
        this.contents.setPaint(this.getContentsPaint());
        this.addChild(this.contents);
        this.titleBar = new DamaskWindowTitle();
        this.titleBar.setPaint(this.getTitleColor());
        this.titleBar.setStrokePaint(BORDER_COLOR);
        this.addChild(this.titleBar);
        this.origTitleBarTextColor = this.titleBar.getLabel().getLabelColor();
        this.homeIcon.setPickable(false);
        this.addInputEventListener(new BasicInputEventHandler());
        this.deviceTypeLayerChanged();
    }

    protected abstract PPath createContents();

    protected abstract Content getTitleContent();

    public void dispose() {
        super.dispose();
        this.getModel().removeInteractionElementListener(this.elementHandler);
    }

    public void setListenToTransformChanges(boolean flag) {
        this.listenToTransformChanges = flag;
    }

    protected boolean isTemplateElementsGrayedOut() {
        return this.grayOutTemplateElements;
    }

    protected abstract Paint getDeviceSpecificContentsPaintInAllLayer();

    protected abstract Paint getContentsPaint();

    protected abstract Color getTitleColor();

    private Paint getAllDevicesTitlePaintInDeviceLayer() {
        Color titlePaint = this.getTitleColor();
        return new GradientPaint(0.0f, 0.0f, titlePaint, 20.0f, 20.0f, DamaskAppUtils.createDarkerColor(titlePaint, 0.85), true);
    }

    protected abstract Dialog getDialogModel();

    protected void deviceTypeLayerChanged() {
        DeviceType dialogDeviceType = this.getDialogModel().getDeviceType();
        DamaskLayer layer = this.getLayer();
        if (layer == null) {
            return;
        }
        DamaskLayer.DeviceTypeLayer deviceTypeLayer = layer.getDeviceTypeLayer();
        if (dialogDeviceType == layer.getDeviceType() && deviceTypeLayer == DamaskLayer.DeviceTypeLayer.ALL) {
            this.contents.setPaint(this.getDeviceSpecificContentsPaintInAllLayer());
            this.titleBar.getLabel().setLabelColor(DamaskAppUtils.createTransparentColor(this.origTitleBarTextColor, 50));
            this.titleBar.setStrokePaint(Color.LIGHT_GRAY);
            this.titleBar.setPaint(this.getTitleColor());
        } else if (dialogDeviceType == DeviceType.ALL && deviceTypeLayer == DamaskLayer.DeviceTypeLayer.DEVICE) {
            this.contents.setPaint(this.getContentsPaint());
            this.titleBar.getLabel().setLabelColor(this.origTitleBarTextColor);
            this.titleBar.setStrokePaint(BORDER_COLOR);
            this.titleBar.setPaint(this.getAllDevicesTitlePaintInDeviceLayer());
        } else {
            this.contents.setPaint(this.getContentsPaint());
            this.titleBar.getLabel().setLabelColor(this.origTitleBarTextColor);
            this.titleBar.setStrokePaint(Color.LIGHT_GRAY);
            this.titleBar.setStrokePaint(BORDER_COLOR);
            this.titleBar.setPaint(this.getTitleColor());
        }
    }

    public PPath getContents() {
        return this.contents;
    }

    public DamaskWindowTitle getTitleBar() {
        return this.titleBar;
    }

    public void addChild(int index, PNode child) {
        super.addChild(index, child);
        if (child instanceof DragBar) {
            this.dragBar = (DragBar)child;
        }
    }

    public PNode removeChild(int index) {
        PNode child = super.removeChild(index);
        if (child == this.dragBar) {
            this.dragBar = null;
        }
        return child;
    }

    protected void layoutChildren() {
        double titleBarHeightInLocalCoords = (double)this.titleBar.getPixelHeight() * this.titleBar.getTransform().getScaleY();
        if (this.dragBar != null) {
            PDimension pageWidthDim = new PDimension(this.getWidth(), 0.0);
            this.localToGlobal(pageWidthDim);
            this.dragBar.globalToLocal(pageWidthDim);
            PDimension barHeightDim = new PDimension(0.0, this.dragBar.getIntHeight());
            this.dragBar.localToGlobal(barHeightDim);
            this.globalToLocal(barHeightDim);
            this.dragBar.setPathBounds(0.0f, 0.0f, (float)pageWidthDim.getWidth(), this.dragBar.getIntHeight());
            this.dragBar.setOffset(0.0, -titleBarHeightInLocalCoords - barHeightDim.getHeight());
        }
        this.titleBar.setPathTo(new Rectangle2D.Double(0.0, 0.0, this.getWidth() / this.titleBar.getTransform().getScaleX(), this.titleBar.getPixelHeight()));
        this.titleBar.setOffset(0.0, -titleBarHeightInLocalCoords);
        PBounds titleBarBounds = this.titleBar.getBounds();
        PBounds homeIconBounds = this.homeIcon.getFullBounds();
        this.homeIcon.setOffset(titleBarBounds.getMaxX() - ((RectangularShape)homeIconBounds).getWidth() - 5.0, titleBarBounds.getMinY() + 5.0);
        this.contents.setPathTo(new Rectangle2D.Double(0.0, 0.0, this.getWidth(), this.getHeight()));
    }

    public DeviceType getDeviceType() {
        return ((Page)this.getModel()).getDeviceType();
    }

    public boolean isInRunMode() {
        return this.inRunMode;
    }

    public void setInRunMode(boolean flag) {
        this.inRunMode = flag;
    }

    public boolean isHome() {
        return this.isHome;
    }

    public void setHome(boolean flag) {
        this.isHome = flag;
        if (this.isHome) {
            this.titleBar.addChild(this.homeIcon);
        } else {
            this.homeIcon.removeFromParent();
        }
    }

    private final class ElementHandler
    implements InteractionElementListener {
        static final /* synthetic */ boolean $assertionsDisabled;
        static /* synthetic */ Class class$0;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("edu.berkeley.guir.damask.view.nodes.DamaskWindow$ElementHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        ElementHandler() {
        }

        public void elementBoundsUpdated(InteractionElementEvent e) {
            if (!$assertionsDisabled && e.getSource() != DamaskWindow.this.getModel()) {
                throw new AssertionError((Object)("Got event from " + e.getSource() + " which does not match " + DamaskWindow.this.getModel()));
            }
            Rectangle2D bounds = DamaskWindow.this.getModel().getBounds(DamaskWindow.this.getDeviceType());
            DamaskWindow.this.setPathTo(bounds);
        }

        public void elementTransformUpdated(InteractionElementEvent e) {
            if (!$assertionsDisabled && e.getSource() != DamaskWindow.this.getModel()) {
                throw new AssertionError((Object)("Got event from " + e.getSource() + " which does not match " + DamaskWindow.this.getModel()));
            }
            if (DamaskWindow.this.listenToTransformChanges) {
                AffineTransform transform = DamaskWindow.this.getModel().getTransform(DamaskWindow.this.getDeviceType());
                DamaskWindow.this.setTransform(transform);
            }
        }

        public void elementBorderUpdated(InteractionElementEvent e) {
        }
    }

    private class BasicInputEventHandler
    extends PBasicInputEventHandler {
        BasicInputEventHandler() {
        }

        public void mouseEntered(PInputEvent event) {
            DamaskCanvas canvas;
            if (event.getComponent() instanceof DamaskCanvas && !(canvas = (DamaskCanvas)event.getComponent()).isWindowBoundsChanging() && event.getModifiers() == 0) {
                canvas.setInsideNode(event.getPickedNode());
            }
        }

        public void mouseExited(PInputEvent event) {
            if (event.getComponent() instanceof DamaskCanvas) {
                DamaskCanvas canvas = (DamaskCanvas)event.getComponent();
                if (event.getModifiers() == 0) {
                    canvas.setInsideNode(null);
                }
            }
        }

        public void mousePressed(PInputEvent event) {
            VisualCanvas canvas;
            if (event.getComponent() instanceof VisualCanvas && !(canvas = (VisualCanvas)event.getComponent()).isWindowBoundsChanging() && event.getModifiers() == 0) {
                this.updateHandles(event);
            }
        }

        private void updateHandles(PInputEvent event) {
            if (event.getComponent() instanceof DamaskCanvas) {
                ((DamaskCanvas)event.getComponent()).attachHandles(DamaskWindow.this, event.getCamera());
            }
        }
    }
}

