/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.view.nodes;

import edu.berkeley.guir.damask.view.DamaskAppExceptionHandler;
import edu.berkeley.guir.damask.view.nodes.StickyTransformManager;
import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.util.PPickPath;
import edu.umd.cs.piccolox.handles.PBoundsHandle;
import edu.umd.cs.piccolox.util.PBoundsLocator;
import java.awt.geom.Point2D;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;

public class BoundsHandle
extends PBoundsHandle {
    private PBasicInputEventHandler handleCursorHandler;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public static void addHandlesTo(PNode aNode) {
        BoundsHandle.addHandlesTo(aNode, null, false, false);
    }

    public static void addStickyHandlesTo(PNode aNode, PCamera camera) {
        BoundsHandle.addHandlesTo(aNode, camera, true, false);
    }

    public static void addStickyZHandlesTo(PNode aNode, PCamera camera) {
        BoundsHandle.addHandlesTo(aNode, camera, false, true);
    }

    public static void addHandlesTo(PNode aNode, PCamera camera, boolean useSticky, boolean useStickyZ) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.damask.view.nodes.BoundsHandle");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        BoundsHandle.addHandlesTo(aNode, camera, useSticky, useStickyZ, clazz);
    }

    protected static void addHandlesTo(PNode aNode, PCamera camera, boolean useSticky, boolean useStickyZ, Class handleClass) {
        try {
            Class[] classArray = new Class[1];
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("edu.umd.cs.piccolox.util.PBoundsLocator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            Constructor handleConstructor = handleClass.getConstructor(classArray);
            PBoundsLocator[] locators = BoundsHandle.createLocators(aNode);
            BoundsHandle[] handles = new BoundsHandle[locators.length];
            int i = 0;
            int n = handles.length;
            while (i < n) {
                handles[i] = (BoundsHandle)handleConstructor.newInstance(locators[i]);
                ++i;
            }
            if (useStickyZ) {
                i = 0;
                n = handles.length;
                while (i < n) {
                    BoundsHandle handle = handles[i];
                    aNode.addChild(handle);
                    StickyTransformManager.setupStickyZ(handle, camera, new Point2D.Double(0.5, 0.5));
                    handle.relocateHandle();
                    ++i;
                }
            } else if (useSticky) {
                i = 0;
                n = handles.length;
                while (i < n) {
                    BoundsHandle handle = handles[i];
                    camera.addChild(handle);
                    ++i;
                }
            } else {
                i = 0;
                n = handles.length;
                while (i < n) {
                    BoundsHandle handle = handles[i];
                    aNode.addChild(handle);
                    ++i;
                }
            }
        }
        catch (SecurityException e) {
            DamaskAppExceptionHandler.log(e);
        }
        catch (NoSuchMethodException e) {
            DamaskAppExceptionHandler.log(e);
        }
        catch (IllegalArgumentException e) {
            DamaskAppExceptionHandler.log(e);
        }
        catch (InstantiationException e) {
            DamaskAppExceptionHandler.log(e);
        }
        catch (IllegalAccessException e) {
            DamaskAppExceptionHandler.log(e);
        }
        catch (InvocationTargetException e) {
            DamaskAppExceptionHandler.log(e);
        }
    }

    public static PBoundsLocator[] createLocators(PNode aNode) {
        return new PBoundsLocator[]{PBoundsLocator.createEastLocator(aNode), PBoundsLocator.createWestLocator(aNode), PBoundsLocator.createNorthLocator(aNode), PBoundsLocator.createSouthLocator(aNode), PBoundsLocator.createNorthEastLocator(aNode), PBoundsLocator.createNorthWestLocator(aNode), PBoundsLocator.createSouthEastLocator(aNode), PBoundsLocator.createSouthWestLocator(aNode)};
    }

    public static void removeHandlesFrom(PNode aNode) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.damask.view.nodes.BoundsHandle");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        BoundsHandle.removeHandlesFrom(aNode, clazz);
    }

    protected static void removeHandlesFrom(PNode aNode, Class handleClass) {
        ArrayList<PNode> handles = new ArrayList<PNode>();
        Iterator i = aNode.getChildrenIterator();
        while (i.hasNext()) {
            PNode each = (PNode)i.next();
            if (!handleClass.isInstance(each)) continue;
            handles.add(each);
        }
        aNode.removeChildren(handles);
    }

    public static void removeStickyHandlesFrom(PNode aNode, PCamera camera) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.damask.view.nodes.BoundsHandle");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        BoundsHandle.removeStickyHandlesFrom(aNode, camera, clazz);
    }

    protected static void removeStickyHandlesFrom(PNode aNode, PCamera camera, Class handleClass) {
        HashSet<PBoundsHandle> handlesToRemove = new HashSet<PBoundsHandle>();
        Iterator i = camera.getChildrenIterator();
        while (i.hasNext()) {
            PBoundsHandle handle;
            PBoundsLocator l;
            PNode n;
            PNode child = (PNode)i.next();
            if (!handleClass.isInstance(child) || (n = (l = (PBoundsLocator)(handle = (PBoundsHandle)child).getLocator()).getNode()) != aNode) continue;
            handlesToRemove.add(handle);
        }
        camera.removeChildren(handlesToRemove);
    }

    public BoundsHandle(PBoundsLocator aLocator) {
        super(aLocator);
    }

    protected void installHandleEventHandlers() {
        super.installHandleEventHandlers();
        this.handleCursorHandler = new PBasicInputEventHandler(){
            boolean cursorPushed = false;

            public void mouseEntered(PInputEvent aEvent) {
                if (!this.cursorPushed) {
                    aEvent.pushCursor(BoundsHandle.this.getCursorFor(((PBoundsLocator)BoundsHandle.this.getLocator()).getSide()));
                    this.cursorPushed = true;
                }
            }

            public void mouseExited(PInputEvent aEvent) {
                PPickPath focus = aEvent.getInputManager().getMouseFocus();
                if (this.cursorPushed && (focus == null || focus.getPickedNode() != BoundsHandle.this)) {
                    aEvent.popCursor();
                    this.cursorPushed = false;
                }
            }
        };
        this.addInputEventListener(this.handleCursorHandler);
    }
}

