/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.view.examples;

import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolox.PFrame;
import java.awt.geom.Point2D;

public class TooltipExample
extends PFrame {
    public void initialize() {
        PPath n1 = PPath.createEllipse(0.0f, 0.0f, 100.0f, 100.0f);
        PPath n2 = PPath.createRectangle(300.0f, 200.0f, 100.0f, 100.0f);
        n1.addClientProperty("tooltip", "node 1");
        n2.addClientProperty("tooltip", "node 2");
        this.getCanvas().getLayer().addChild(n1);
        this.getCanvas().getLayer().addChild(n2);
        final PCamera camera = this.getCanvas().getCamera();
        final PText tooltipNode = new PText();
        tooltipNode.setPickable(false);
        camera.addChild(tooltipNode);
        camera.addInputEventListener(new PBasicInputEventHandler(){

            public void mouseMoved(PInputEvent event) {
                this.updateToolTip(event);
            }

            public void mouseDragged(PInputEvent event) {
                this.updateToolTip(event);
            }

            public void updateToolTip(PInputEvent event) {
                PNode n = event.getInputManager().getMouseOver().getPickedNode();
                String tooltipString = (String)n.getClientProperty("tooltip");
                Point2D p = event.getCanvasPosition();
                event.getPath().canvasToLocal(p, (PNode)camera);
                tooltipNode.setText(tooltipString);
                tooltipNode.setOffset(p.getX() + 8.0, p.getY() - 8.0);
            }
        });
    }

    public static void main(String[] argv) {
        new TooltipExample();
    }
}

