/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.view.examples;

import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PAffineTransform;
import edu.umd.cs.piccolo.util.PBounds;
import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class PStickyNode
extends PNode
implements PropertyChangeListener {
    public static final int STICKY = 1;
    public static final int STICKYZ = 2;
    protected PCamera constraintCamera;
    protected PAffineTransform lastCameraTransform;
    protected int constraintType = 1;
    protected double stickyPointX = 0.5;
    protected double stickyPointY = 0.5;

    public PStickyNode(PCamera constraintCamera) {
        this.setBounds(0.0, 0.0, 100.0, 80.0);
        this.setPaint(Color.BLUE);
        this.setConstraintCamera(constraintCamera);
    }

    public PCamera getConstraintCamera() {
        return this.constraintCamera;
    }

    public void setConstraintCamera(PCamera camera) {
        if (this.constraintCamera != null) {
            this.constraintCamera.removePropertyChangeListener("viewTransform", this);
        }
        this.constraintCamera = camera;
        if (this.constraintCamera != null) {
            this.constraintCamera.addPropertyChangeListener("viewTransform", this);
        }
    }

    public void propertyChange(PropertyChangeEvent cameraViewTransformChanged) {
        if (this.constraintType == 1) {
            this.applyStickyConstraint();
        } else {
            this.applyStickyZConstraint();
        }
    }

    private void applyStickyConstraint() {
        if (this.constraintCamera == null) {
            return;
        }
        try {
            PAffineTransform frame = null;
            frame = this.getParent() != null ? this.getParent().getLocalToGlobalTransform(null) : new PAffineTransform();
            AffineTransform t = frame.createInverse();
            t.concatenate(this.constraintCamera.getViewTransformReference().createInverse());
            t.concatenate(frame);
            this.setTransform(t);
        }
        catch (NoninvertibleTransformException e) {
            e.printStackTrace();
        }
    }

    private void applyStickyZConstraint() {
        if (this.constraintCamera == null) {
            return;
        }
        PAffineTransform t = new PAffineTransform();
        double s = 1.0 / this.constraintCamera.getViewScale();
        PBounds b = this.getFullBoundsReference();
        t.scaleAboutPoint(s, b.getX() + this.stickyPointX * b.getWidth(), b.getY() + this.stickyPointY * b.getHeight());
        this.setTransform(t);
    }
}

