/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.view.examples;

import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PDimension;
import edu.umd.cs.piccolox.PFrame;
import java.awt.Color;
import java.awt.geom.Dimension2D;

public class NodeEventExample
extends PFrame {
    public NodeEventExample() {
    }

    public NodeEventExample(PCanvas aCanvas) {
        super(false, aCanvas);
    }

    public void initialize() {
        PLayer layer = this.getCanvas().getLayer();
        final PNode aNode = new PNode();
        aNode.addInputEventListener(new PBasicInputEventHandler(){

            public void mousePressed(PInputEvent aEvent) {
                aNode.setPaint(Color.orange);
                this.printEventCoords(aEvent);
                aEvent.setHandled(true);
            }

            public void mouseDragged(PInputEvent aEvent) {
                PDimension delta = aEvent.getDeltaRelativeTo(aNode);
                aNode.translate(((Dimension2D)delta).getWidth(), ((Dimension2D)delta).getHeight());
                this.printEventCoords(aEvent);
                aEvent.setHandled(true);
            }

            public void mouseReleased(PInputEvent aEvent) {
                aNode.setPaint(Color.green);
                this.printEventCoords(aEvent);
                aEvent.setHandled(true);
            }

            public void printEventCoords(PInputEvent aEvent) {
                System.out.println("Canvas Location: " + aEvent.getCanvasPosition());
                System.out.println("Local Location: " + aEvent.getPositionRelativeTo(aNode));
                System.out.println("Canvas Delta: " + aEvent.getCanvasDelta());
                System.out.println("Local Delta: " + aEvent.getDeltaRelativeTo(aNode));
            }
        });
        aNode.setBounds(0.0, 0.0, 200.0, 200.0);
        aNode.setPaint(Color.green);
        layer.addChild(PPath.createRectangle(0.0f, 0.0f, 100.0f, 80.0f));
        layer.addChild(aNode);
    }

    public static void main(String[] args) {
        new NodeEventExample();
    }
}

