/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.view.examples;

import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.PRoot;
import edu.umd.cs.piccolo.event.PDragSequenceEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.event.PInputEventFilter;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PPaintContext;
import edu.umd.cs.piccolox.PFrame;
import edu.umd.cs.piccolox.handles.PBoundsHandle;
import edu.umd.cs.piccolox.nodes.PLens;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;

public class LensExample
extends PFrame {
    public LensExample() {
    }

    public LensExample(PCanvas aCanvas) {
        super(false, aCanvas);
    }

    public void initialize() {
        PRoot root = this.getCanvas().getRoot();
        PCamera camera = this.getCanvas().getCamera();
        PLayer mainLayer = this.getCanvas().getLayer();
        PLayer sharedLayer = new PLayer();
        PLayer lensOnlyLayer = new PLayer();
        root.addChild(lensOnlyLayer);
        root.addChild(sharedLayer);
        camera.addLayer(0, sharedLayer);
        final PLens lens = new PLens();
        lens.setBounds(10.0, 10.0, 100.0, 130.0);
        lens.addLayer(0, lensOnlyLayer);
        lens.addLayer(1, sharedLayer);
        mainLayer.addChild(lens);
        PBoundsHandle.addBoundsHandlesTo(lens);
        PDragSequenceEventHandler squiggleEventHandler = new PDragSequenceEventHandler(){
            protected PPath squiggle;

            public void startDrag(PInputEvent e) {
                super.startDrag(e);
                Point2D p = e.getPosition();
                this.squiggle = new PPath();
                this.squiggle.moveTo((float)p.getX(), (float)p.getY());
                e.getCamera().getLayer(0).addChild(this.squiggle);
            }

            public void drag(PInputEvent e) {
                super.drag(e);
                this.updateSquiggle(e);
            }

            public void endDrag(PInputEvent e) {
                super.endDrag(e);
                this.updateSquiggle(e);
                this.squiggle = null;
            }

            public void updateSquiggle(PInputEvent aEvent) {
                Point2D p = aEvent.getPosition();
                this.squiggle.lineTo((float)p.getX(), (float)p.getY());
            }
        };
        lens.getCamera().addInputEventListener(squiggleEventHandler);
        camera.addInputEventListener(squiggleEventHandler);
        squiggleEventHandler.setEventFilter(new PInputEventFilter(16));
        squiggleEventHandler.getEventFilter().setMarksAcceptedEventsAsHandled(true);
        this.getCanvas().removeInputEventListener(this.getCanvas().getPanEventHandler());
        PNode sharedNode = new PNode(){

            protected void paint(PPaintContext paintContext) {
                if (paintContext.getCamera() == lens.getCamera()) {
                    Graphics2D g2 = paintContext.getGraphics();
                    g2.setPaint(Color.RED);
                    g2.fill(this.getBoundsReference());
                } else {
                    super.paint(paintContext);
                }
            }
        };
        sharedNode.setPaint(Color.GREEN);
        sharedNode.setBounds(0.0, 0.0, 100.0, 200.0);
        sharedNode.translate(200.0, 200.0);
        sharedLayer.addChild(sharedNode);
        PText label = new PText("Move the lens (by dragging title bar) over the green rectangle, and it will appear red. press and drag the mouse on the canvas and it will draw squiggles. press and drag the mouse over the lens and drag squiggles that are only visible through the lens.");
        label.setConstrainWidthToTextWidth(false);
        label.setBounds(200.0, 100.0, 200.0, 200.0);
        sharedLayer.addChild(label);
    }

    public static void main(String[] args) {
        new LensExample();
    }
}

