/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.view.event;

import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.InteractionElement;
import edu.berkeley.guir.damask.command.ChangePageRegionCommand;
import edu.berkeley.guir.damask.command.ModifyGraphMacroCommand;
import edu.berkeley.guir.damask.command.SetTransformCommand;
import edu.berkeley.guir.damask.component.Component;
import edu.berkeley.guir.damask.component.ComponentGroup;
import edu.berkeley.guir.damask.component.Control;
import edu.berkeley.guir.damask.component.Select;
import edu.berkeley.guir.damask.dialog.PageRegion;
import edu.berkeley.guir.damask.view.DamaskAppExceptionHandler;
import edu.berkeley.guir.damask.view.DamaskAppUtils;
import edu.berkeley.guir.damask.view.DamaskCanvas;
import edu.berkeley.guir.damask.view.DamaskLayer;
import edu.berkeley.guir.damask.view.InteractionElementView;
import edu.berkeley.guir.damask.view.nodes.NonResizableHandle;
import edu.berkeley.guir.damask.view.nodes.ResizableHandle;
import edu.berkeley.guir.damask.view.visual.component.CheckBox;
import edu.berkeley.guir.damask.view.visual.component.ComponentView;
import edu.berkeley.guir.damask.view.visual.component.Panel;
import edu.berkeley.guir.damask.view.visual.component.RadioButton;
import edu.berkeley.guir.damask.view.visual.dialog.PageRegionView;
import edu.berkeley.guir.damask.view.voice.component.Prompt;
import edu.berkeley.guir.damask.view.voice.component.Response;
import edu.berkeley.guir.damask.view.voice.dialog.Conversation;
import edu.berkeley.guir.damask.view.voice.dialog.Form;
import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PDragSequenceEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PAffineTransform;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PDimension;
import edu.umd.cs.piccolo.util.PNodeFilter;
import edu.umd.cs.piccolox.handles.PBoundsHandle;
import edu.umd.cs.piccolox.handles.PHandle;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SelectionEventHandler
extends PDragSequenceEventHandler {
    private static final int DASH_WIDTH = 5;
    private static final int NUM_STROKES = 10;
    private final Set selection = new HashSet();
    private final ArrayList selectableParents;
    private PPath marquee = null;
    private PNode marqueeParent = null;
    private Point2D presspt = null;
    private Point2D canvasPressPt = null;
    private float strokeNum = 0.0f;
    private final Stroke[] strokes = new Stroke[10];
    private final Set allItems = new HashSet();
    private final List unselectList = new ArrayList();
    private final Set marqueeSet = new HashSet();
    private PNode pressNode = null;
    private boolean deleteKeyActive = false;
    private PNode selectedObjectInOtherLayer = null;
    private final Map origTransforms = new HashMap();
    private final Map origRegionViews = new HashMap();
    private final Map nodesToDrag = new HashMap();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public SelectionEventHandler(PNode marqueeParent, PNode selectableParent) {
        this.marqueeParent = marqueeParent;
        this.selectableParents = new ArrayList();
        this.selectableParents.add(selectableParent);
        this.init();
    }

    public SelectionEventHandler(PNode marqueeParent, ArrayList selectableParents) {
        this.marqueeParent = marqueeParent;
        this.selectableParents = selectableParents;
        this.init();
    }

    protected void init() {
        float[] dash = new float[]{5.0f, 5.0f};
        int i = 0;
        while (i < 10) {
            this.strokes[i] = new BasicStroke(1.0f, 0, 0, 1.0f, dash, i);
            ++i;
        }
    }

    protected void select(Collection items, PCamera camera) {
        Iterator itemIt = items.iterator();
        while (itemIt.hasNext()) {
            PNode node = (PNode)itemIt.next();
            this.select(node, camera);
        }
    }

    public void select(Collection items, DamaskCanvas canvas) {
        this.select(items, canvas.getCamera());
        canvas.fireSelectionChanged();
    }

    protected void select(PNode node, PCamera camera) {
        if (this.isSelected(node)) {
            return;
        }
        this.selection.add(node);
        this.decorateSelectedNode(node, camera);
        if (node instanceof Panel) {
            this.selectPanelChildren((Panel)node, camera);
        }
    }

    public void select(PNode node, DamaskCanvas canvas) {
        this.select(node, canvas.getCamera());
        canvas.fireSelectionChanged();
    }

    private void selectPanelChildren(Panel panel, PCamera camera) {
        ComponentGroup group = (ComponentGroup)panel.getModel();
        Iterator i = panel.getPageRegionView().getChildrenIterator();
        while (i.hasNext()) {
            ComponentView componentView;
            Component component;
            PNode child = (PNode)i.next();
            if (!(child instanceof ComponentView) || (component = (Component)(componentView = (ComponentView)child).getModel()).getGroup() != group) continue;
            if (component instanceof Select) {
                Iterator j = child.getChildrenIterator();
                while (j.hasNext()) {
                    PNode grandchild = (PNode)j.next();
                    if (!(grandchild instanceof RadioButton) && !(grandchild instanceof CheckBox)) continue;
                    this.select(grandchild, camera);
                }
                continue;
            }
            this.select((PNode)componentView, camera);
        }
    }

    protected void decorateSelectedNode(PNode node, PCamera camera) {
        if (node instanceof InteractionElementView) {
            InteractionElementView elementView = (InteractionElementView)node;
            if (!elementView.isResizable()) {
                NonResizableHandle.addHandlesTo(node, camera, false, elementView.getUseStickyZHandles());
            } else {
                ResizableHandle.addHandlesTo(node, camera, false, elementView.getUseStickyZHandles());
            }
        } else if (node instanceof Response.TextGroup) {
            NonResizableHandle.addHandlesTo(node, camera, false, true);
        } else {
            ResizableHandle.addHandlesTo(node, camera, false, true);
        }
    }

    protected void unselect(Collection items) {
        Iterator itemIt = items.iterator();
        while (itemIt.hasNext()) {
            PNode node = (PNode)itemIt.next();
            this.unselect(node);
        }
    }

    public void unselect(Collection items, DamaskCanvas canvas) {
        this.unselect(items);
        canvas.fireSelectionChanged();
    }

    protected void unselect(PNode node) {
        if (!this.isSelected(node)) {
            return;
        }
        PBoundsHandle.removeBoundsHandlesFrom(node);
        this.selection.remove(node);
    }

    public void unselect(PNode node, DamaskCanvas canvas) {
        this.unselect(node);
        canvas.fireSelectionChanged();
    }

    protected void unselectAll() {
        Iterator it = new HashSet(this.selection).iterator();
        while (it.hasNext()) {
            PNode node = (PNode)it.next();
            this.unselect(node);
        }
    }

    public void unselectAll(DamaskCanvas canvas) {
        this.unselectAll();
        canvas.fireSelectionChanged();
    }

    public boolean isSelected(PNode node) {
        return node != null && this.selection.contains(node);
    }

    public Collection getSelection() {
        return new HashSet(this.selection);
    }

    protected boolean isSelectable(PNode node) {
        boolean selectable = false;
        if (node instanceof PHandle || node instanceof Response.HotSpot) {
            return false;
        }
        Iterator parentsIt = this.selectableParents.iterator();
        block0: while (parentsIt.hasNext()) {
            PNode parent = (PNode)parentsIt.next();
            if (parent.getChildrenReference().contains(node)) {
                if (node instanceof InteractionElementView) {
                    selectable = ((InteractionElementView)node).isSelectable();
                    break;
                }
                selectable = true;
                break;
            }
            if (!(parent instanceof PCamera)) continue;
            int i = 0;
            while (i < ((PCamera)parent).getLayerCount()) {
                PLayer layer = ((PCamera)parent).getLayer(i);
                if (layer.getChildrenReference().contains(node)) {
                    selectable = true;
                    continue block0;
                }
                ++i;
            }
        }
        return selectable;
    }

    public void addSelectableParent(PNode node) {
        this.selectableParents.add(node);
    }

    public void removeSelectableParent(PNode node) {
        this.selectableParents.remove(node);
    }

    public void setSelectableParent(PNode node) {
        this.selectableParents.clear();
        this.selectableParents.add(node);
    }

    public void setSelectableParents(Collection c) {
        this.selectableParents.clear();
        this.selectableParents.addAll(c);
    }

    public Collection getSelectableParents() {
        return (ArrayList)this.selectableParents.clone();
    }

    protected void startDrag(PInputEvent e) {
        super.startDrag(e);
        this.initializeSelection(e);
        if (this.isMarqueeSelection(e)) {
            this.initializeMarquee(e);
            if (!this.isOptionSelection(e)) {
                this.startMarqueeSelection(e);
            } else {
                this.startOptionMarqueeSelection(e);
            }
        } else if (!this.isOptionSelection(e)) {
            this.startStandardSelection(e);
        } else {
            this.startStandardOptionSelection(e);
        }
    }

    protected void drag(PInputEvent e) {
        super.drag(e);
        if (this.isMarqueeSelection(e)) {
            this.updateMarquee(e);
            if (!this.isOptionSelection(e)) {
                this.computeMarqueeSelection(e);
            } else {
                this.computeOptionMarqueeSelection(e);
            }
        } else {
            this.dragStandardSelection(e);
        }
    }

    protected void endDrag(PInputEvent e) {
        super.endDrag(e);
        DamaskCanvas canvas = (DamaskCanvas)e.getComponent();
        if (this.isMarqueeSelection(e)) {
            this.endMarqueeSelection(e);
        } else if (this.selectedObjectInOtherLayer != null) {
            DamaskLayer layer = ((InteractionElementView)this.pressNode).getLayer();
            if (DamaskAppUtils.askToChangeLayers(layer, canvas)) {
                this.select(this.selectedObjectInOtherLayer, e.getCamera());
            }
        } else {
            DeviceType deviceType = canvas.getDeviceType();
            ModifyGraphMacroCommand cmd = new ModifyGraphMacroCommand();
            Iterator selectionIt = this.selection.iterator();
            while (selectionIt.hasNext()) {
                PNode node = (PNode)selectionIt.next();
                PNode moveNode = this.getNodeToMove(node);
                if (!(moveNode instanceof ComponentView)) continue;
                PNode dragNode = this.getNodeToDrag(moveNode);
                dragNode.removeFromParent();
                moveNode.setVisible(true);
                moveNode.setTransform((AffineTransform)this.origTransforms.get(moveNode));
            }
            Point2D ptCameraCoords = e.getPositionRelativeTo(e.getCamera());
            PNode endNode = e.getCamera().pick(ptCameraCoords.getX(), ptCameraCoords.getY(), 1.0).getPickedNode();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("edu.berkeley.guir.damask.view.visual.dialog.PageRegionView");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            PageRegionView regionView = (PageRegionView)DamaskAppUtils.getAncestor(endNode, clazz);
            DamaskLayer layer = (DamaskLayer)canvas.getLayer();
            layer.clearTrackedNewAdditions();
            layer.startTrackingNewAdditions();
            Iterator selectionIt2 = this.selection.iterator();
            while (selectionIt2.hasNext()) {
                PNode newParent;
                InteractionElementView view;
                InteractionElement model;
                PNode node = (PNode)selectionIt2.next();
                PNode moveNode = this.getNodeToMove(node);
                PNode dragNode = this.getNodeToDrag(moveNode);
                if (!(moveNode instanceof InteractionElementView) || (model = (view = (InteractionElementView)moveNode).getModel()) == null) continue;
                boolean simpleTransformChange = true;
                if (moveNode instanceof ComponentView) {
                    newParent = regionView;
                    PageRegionView origRegionView = (PageRegionView)this.origRegionViews.get(moveNode);
                    if (regionView == null || ((PageRegion)regionView.getModel()).getPage().getDialog() != ((PageRegion)origRegionView.getModel()).getPage().getDialog()) {
                        simpleTransformChange = false;
                    } else if (regionView == origRegionView) {
                        simpleTransformChange = true;
                    } else {
                        simpleTransformChange = false;
                        AffineTransform oldTransform = (AffineTransform)this.origTransforms.get(moveNode);
                        PAffineTransform newTransform = dragNode.getLocalToGlobalTransform(null);
                        newTransform.preConcatenate(regionView.getGlobalToLocalTransform(null));
                        AffineTransform deltaTransform = null;
                        try {
                            deltaTransform = oldTransform.createInverse();
                        }
                        catch (NoninvertibleTransformException e1) {
                            DamaskAppExceptionHandler.log(e1);
                        }
                        deltaTransform.preConcatenate(newTransform);
                        Component componentToMove = moveNode instanceof RadioButton || moveNode instanceof CheckBox ? ((Select.Item)view.getModel()).getParent() : (Component)model;
                        cmd.addCommand(new ChangePageRegionCommand(componentToMove, (PageRegion)origRegionView.getModel(), (PageRegion)regionView.getModel()));
                        if (model instanceof ComponentGroup) {
                            cmd.addCommand(new SetTransformCommand((ComponentGroup)model, (PageRegion)regionView.getModel(), (AffineTransform)newTransform));
                        } else {
                            Iterator j;
                            ArrayList<Component> controlsToMove = new ArrayList<Component>();
                            if (moveNode instanceof RadioButton || moveNode instanceof CheckBox) {
                                j = ((Select)componentToMove).getItems().iterator();
                                while (j.hasNext()) {
                                    Select.Item item = (Select.Item)j.next();
                                    controlsToMove.add(item);
                                }
                            } else {
                                controlsToMove.add(componentToMove);
                            }
                            j = controlsToMove.iterator();
                            while (j.hasNext()) {
                                Control control = (Control)j.next();
                                AffineTransform newTransformForControl = control.getTransform(canvas.getDeviceType());
                                newTransformForControl.preConcatenate(deltaTransform);
                                cmd.addCommand(new SetTransformCommand(control, canvas.getDeviceType(), newTransformForControl));
                            }
                        }
                    }
                } else {
                    newParent = moveNode.getParent();
                }
                if (!simpleTransformChange) continue;
                AffineTransform oldTransform = (AffineTransform)this.origTransforms.get(view);
                PAffineTransform newTransform = dragNode.getLocalToGlobalTransform(null);
                newTransform.preConcatenate(newParent.getGlobalToLocalTransform(null));
                if (oldTransform.equals(newTransform)) continue;
                if (model instanceof ComponentGroup) {
                    PageRegion region;
                    ComponentGroup group = (ComponentGroup)model;
                    if (newParent instanceof PageRegionView) {
                        region = (PageRegion)regionView.getModel();
                    } else {
                        Class<?> clazz2 = class$1;
                        if (clazz2 == null) {
                            try {
                                clazz2 = Class.forName("edu.berkeley.guir.damask.view.voice.dialog.Conversation");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        region = ((Conversation)DamaskAppUtils.getAncestor(moveNode, clazz2)).getRegionModel();
                    }
                    cmd.addCommand(new SetTransformCommand(group, region, (AffineTransform)newTransform));
                    continue;
                }
                cmd.addCommand(new SetTransformCommand(model, deviceType, (AffineTransform)newTransform));
            }
            if (!cmd.isEmpty()) {
                canvas.getDocument().getCommandQueue().doCommand(canvas, cmd);
            }
            layer.stopTrackingNewAdditions();
            List newAdds = layer.getTrackedNewAdditions();
            if (!newAdds.isEmpty()) {
                this.unselectAll(canvas);
                Iterator j = newAdds.iterator();
                while (j.hasNext()) {
                    WeakReference ref = (WeakReference)j.next();
                    this.select((PNode)((InteractionElementView)ref.get()), canvas);
                }
            }
            this.endStandardSelection(e);
        }
        canvas.fireSelectionChanged();
    }

    protected boolean isOptionSelection(PInputEvent pie) {
        return pie.isShiftDown();
    }

    protected boolean isMarqueeSelection(PInputEvent pie) {
        return this.pressNode == null || this.pressNode instanceof PageRegionView || this.pressNode instanceof Form.Contents;
    }

    protected void initializeSelection(PInputEvent pie) {
        this.canvasPressPt = pie.getCanvasPosition();
        this.presspt = pie.getPosition();
        this.pressNode = DamaskAppUtils.getSelectablePickedNode(pie, this.selectableParents);
        if (this.pressNode == null) {
            this.pressNode = pie.getPath().getPickedNode();
            if (this.pressNode instanceof PCamera) {
                this.pressNode = null;
            }
        }
        this.selectedObjectInOtherLayer = null;
    }

    protected void initializeMarquee(PInputEvent e) {
        this.marquee = PPath.createRectangle((float)this.presspt.getX(), (float)this.presspt.getY(), 0.0f, 0.0f);
        this.marquee.setPaint(null);
        this.marquee.setStrokePaint(Color.black);
        this.marquee.setStroke(this.strokes[0]);
        this.marqueeParent.addChild(this.marquee);
        this.marqueeSet.clear();
    }

    protected void startOptionMarqueeSelection(PInputEvent e) {
    }

    protected void startMarqueeSelection(PInputEvent e) {
        this.unselectAll();
    }

    protected void startStandardSelection(PInputEvent pie) {
        if (!this.isSelected(this.pressNode)) {
            this.unselectAll();
            if (this.isSelectable(this.pressNode)) {
                this.select(this.pressNode, pie.getCamera());
            } else if (this.pressNode instanceof InteractionElementView && ((InteractionElementView)this.pressNode).getModel() instanceof Control && this.pressNode.getParent() instanceof InteractionElementView) {
                this.selectedObjectInOtherLayer = this.pressNode;
            }
        }
        this.origTransforms.clear();
        this.origRegionViews.clear();
        this.nodesToDrag.clear();
        Iterator i = this.selection.iterator();
        while (i.hasNext()) {
            PNode selectNode = (PNode)i.next();
            this.trackNode(selectNode, pie);
        }
    }

    private void trackNode(PNode selectNode, PInputEvent pie) {
        PNode moveNode = this.getNodeToMove(selectNode);
        this.origTransforms.put(moveNode, moveNode.getTransform());
        if (moveNode instanceof ComponentView) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("edu.berkeley.guir.damask.view.visual.dialog.PageRegionView");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.origRegionViews.put(moveNode, DamaskAppUtils.getAncestor(moveNode, clazz));
            PAffineTransform globalTransform = moveNode.getLocalToGlobalTransform(null);
            PNode nodeToDrag = DamaskAppUtils.getPureCopy(moveNode);
            this.nodesToDrag.put(moveNode, nodeToDrag);
            moveNode.setVisible(false);
            PLayer layer = ((PCanvas)pie.getComponent()).getLayer();
            nodeToDrag.setTransform(globalTransform);
            layer.addChild(nodeToDrag);
        }
    }

    protected void startStandardOptionSelection(PInputEvent pie) {
        if (this.isSelectable(this.pressNode)) {
            if (this.isSelected(this.pressNode)) {
                this.unselect(this.pressNode);
            } else {
                this.select(this.pressNode, pie.getCamera());
                this.trackNode(this.pressNode, pie);
            }
        }
    }

    protected void updateMarquee(PInputEvent pie) {
        PBounds b = new PBounds();
        if (this.marqueeParent instanceof PCamera) {
            b.add(this.canvasPressPt);
            b.add(pie.getCanvasPosition());
        } else {
            b.add(this.presspt);
            b.add(pie.getPosition());
        }
        this.marquee.setPathToRectangle((float)b.x, (float)b.y, (float)b.width, (float)b.height);
        b.reset();
        b.add(this.presspt);
        b.add(pie.getPosition());
        this.allItems.clear();
        PNodeFilter filter = this.createNodeFilter(b);
        Iterator parentsIt = this.selectableParents.iterator();
        while (parentsIt.hasNext()) {
            Collection items;
            PNode parent = (PNode)parentsIt.next();
            if (parent instanceof PCamera) {
                items = new ArrayList();
                int i = 0;
                while (i < ((PCamera)parent).getLayerCount()) {
                    ((PCamera)parent).getLayer(i).getAllNodes(filter, items);
                    ++i;
                }
            } else {
                items = parent.getAllNodes(filter, null);
            }
            Iterator itemsIt = items.iterator();
            while (itemsIt.hasNext()) {
                this.allItems.add(itemsIt.next());
            }
        }
    }

    protected void computeMarqueeSelection(PInputEvent pie) {
        PNode node;
        this.unselectList.clear();
        Iterator selectionIt = this.selection.iterator();
        while (selectionIt.hasNext()) {
            node = (PNode)selectionIt.next();
            if (this.allItems.contains(node)) continue;
            this.unselectList.add(node);
        }
        this.unselect(this.unselectList);
        selectionIt = this.allItems.iterator();
        while (selectionIt.hasNext()) {
            node = (PNode)selectionIt.next();
            if (this.selection.contains(node) || this.marqueeSet.contains(node)) continue;
            this.marqueeSet.add(node);
        }
        this.select((Collection)this.allItems, pie.getCamera());
    }

    protected void computeOptionMarqueeSelection(PInputEvent pie) {
        PNode node;
        this.unselectList.clear();
        Iterator selectionIt = this.selection.iterator();
        while (selectionIt.hasNext()) {
            node = (PNode)selectionIt.next();
            if (this.allItems.contains(node) || !this.marqueeSet.contains(node)) continue;
            this.marqueeSet.remove(node);
            this.unselectList.add(node);
        }
        this.unselect(this.unselectList);
        selectionIt = this.allItems.iterator();
        while (selectionIt.hasNext()) {
            node = (PNode)selectionIt.next();
            if (this.selection.contains(node) || this.marqueeSet.contains(node)) continue;
            this.marqueeSet.add(node);
        }
        this.select((Collection)this.allItems, pie.getCamera());
    }

    protected PNodeFilter createNodeFilter(PBounds bounds) {
        return new BoundsFilter(bounds);
    }

    protected PBounds getMarqueeBounds() {
        if (this.marquee != null) {
            return this.marquee.getBounds();
        }
        return new PBounds();
    }

    protected void dragStandardSelection(PInputEvent e) {
        PDimension d = e.getCanvasDelta();
        e.getTopCamera().localToView(d);
        PDimension gDist = new PDimension();
        Iterator selectionIt = this.selection.iterator();
        while (selectionIt.hasNext()) {
            PNode node = (PNode)selectionIt.next();
            PNode moveNode = this.getNodeToMove(node);
            boolean move = true;
            if (moveNode instanceof InteractionElementView) {
                move = ((InteractionElementView)node).isMovable();
            }
            if (!move) continue;
            gDist.setSize(d);
            PNode dragNode = this.getNodeToDrag(moveNode);
            dragNode.getParent().globalToLocal(gDist);
            dragNode.offset(gDist.getWidth(), gDist.getHeight());
            if (dragNode == moveNode) continue;
            gDist.setSize(d);
            moveNode.getParent().globalToLocal(gDist);
            moveNode.offset(gDist.getWidth(), gDist.getHeight());
        }
    }

    private PNode getNodeToMove(PNode node) {
        PNode moveNode;
        if (node instanceof Prompt || node instanceof Response) {
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("edu.berkeley.guir.damask.view.voice.component.VoiceControl");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            moveNode = DamaskAppUtils.getAncestor(node, clazz);
        } else {
            moveNode = node;
        }
        return moveNode;
    }

    private PNode getNodeToDrag(PNode node) {
        PNode dragNode = (PNode)this.nodesToDrag.get(node);
        if (dragNode == null) {
            return node;
        }
        return dragNode;
    }

    protected void endMarqueeSelection(PInputEvent e) {
        this.marquee.removeFromParent();
        this.marquee = null;
        this.selectedObjectInOtherLayer = null;
    }

    protected void endStandardSelection(PInputEvent e) {
        this.pressNode = null;
        this.selectedObjectInOtherLayer = null;
    }

    protected void dragActivityStep(PInputEvent aEvent) {
        if (this.marquee != null) {
            float origStrokeNum = this.strokeNum;
            this.strokeNum = (this.strokeNum + 0.5f) % 10.0f;
            if ((int)this.strokeNum != (int)origStrokeNum) {
                this.marquee.setStroke(this.strokes[(int)this.strokeNum]);
            }
        }
    }

    public void keyPressed(PInputEvent e) {
        switch (e.getKeyCode()) {
            case 127: {
                if (!this.deleteKeyActive) break;
                Iterator selectionIt = this.selection.iterator();
                while (selectionIt.hasNext()) {
                    PNode node = (PNode)selectionIt.next();
                    node.removeFromParent();
                }
                this.selection.clear();
            }
        }
    }

    public boolean getSupportDeleteKey() {
        return this.deleteKeyActive;
    }

    public boolean isDeleteKeyActive() {
        return this.deleteKeyActive;
    }

    public void setDeleteKeyActive(boolean deleteKeyActive) {
        this.deleteKeyActive = deleteKeyActive;
    }

    protected class BoundsFilter
    implements PNodeFilter {
        PBounds localBounds = new PBounds();
        PBounds bounds;

        protected BoundsFilter(PBounds bounds) {
            this.bounds = bounds;
        }

        public boolean accept(PNode node) {
            this.localBounds.setRect(this.bounds);
            node.globalToLocal(this.localBounds);
            boolean result = true;
            if (node instanceof InteractionElementView) {
                result = ((InteractionElementView)node).isSelectable();
            }
            return result && node.getPickable() && node.intersects(this.localBounds) && !(node instanceof PHandle) && !(node instanceof Response.HotSpot) && node != SelectionEventHandler.this.marquee && !SelectionEventHandler.this.selectableParents.contains(node) && !this.isCameraLayer(node);
        }

        public boolean acceptChildrenOf(PNode node) {
            return SelectionEventHandler.this.selectableParents.contains(node) || this.isCameraLayer(node);
        }

        public boolean isCameraLayer(PNode node) {
            if (node instanceof PLayer) {
                Iterator i = SelectionEventHandler.this.selectableParents.iterator();
                while (i.hasNext()) {
                    PNode parent = (PNode)i.next();
                    if (!(parent instanceof PCamera) || ((PCamera)parent).indexOfLayer((PLayer)node) == -1) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

