/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.view.event;

import edu.berkeley.guir.damask.command.ModifyGraphMacroCommand;
import edu.berkeley.guir.damask.command.SplitComponentIntoDeviceSpecificVersionsCommand;
import edu.berkeley.guir.damask.component.Component;
import edu.berkeley.guir.damask.view.DamaskAppUtils;
import edu.berkeley.guir.damask.view.DamaskCanvas;
import edu.berkeley.guir.damask.view.visual.component.ComponentView;
import edu.berkeley.guir.damask.view.visual.component.RadioButton;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PDragSequenceEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import java.util.HashSet;
import java.util.Iterator;

public class PushToSingleDeviceTypeEventHandler
extends PDragSequenceEventHandler {
    public PushToSingleDeviceTypeEventHandler() {
        this.getEventFilter().setAndMask(16);
    }

    public void startDrag(PInputEvent e) {
        super.startDrag(e);
        this.push(e);
    }

    public void drag(PInputEvent e) {
        super.drag(e);
        this.push(e);
    }

    private void push(PInputEvent e) {
        DamaskCanvas currentCanvas = (DamaskCanvas)e.getComponent();
        HashSet pickedNodes = new HashSet(DamaskAppUtils.getPickedNodes(currentCanvas, e.getPosition()));
        HashSet<PNode> nodesToAdd = new HashSet<PNode>();
        HashSet<PNode> nodesToRemove = new HashSet<PNode>();
        Iterator i = pickedNodes.iterator();
        while (i.hasNext()) {
            PNode node = (PNode)i.next();
            if (!(node instanceof RadioButton)) continue;
            nodesToAdd.add(node.getParent());
            nodesToRemove.add(node);
        }
        pickedNodes.addAll(nodesToAdd);
        pickedNodes.removeAll(nodesToRemove);
        ModifyGraphMacroCommand cmd = new ModifyGraphMacroCommand();
        Iterator i2 = pickedNodes.iterator();
        while (i2.hasNext()) {
            PNode node = (PNode)i2.next();
            if (!(node instanceof ComponentView)) continue;
            Component component = (Component)((ComponentView)node).getModel();
            cmd.addCommand(new SplitComponentIntoDeviceSpecificVersionsCommand(component, currentCanvas.getDeviceType()));
        }
        currentCanvas.getDocument().getCommandQueue().doCommand(currentCanvas, cmd);
    }
}

