/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.view.event;

import edu.berkeley.guir.damask.view.DamaskAppUtils;
import edu.berkeley.guir.damask.view.DamaskCanvas;
import edu.berkeley.guir.damask.view.event.SelectionEventHandler;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import java.awt.geom.Point2D;
import javax.swing.JPopupMenu;

public class PopupMenuEventHandler
extends PBasicInputEventHandler {
    private final DamaskCanvas canvas;

    public PopupMenuEventHandler(DamaskCanvas canvas) {
        this.canvas = canvas;
    }

    public void mousePressed(PInputEvent e) {
        this.maybeShowPopup(e);
    }

    public void mouseReleased(PInputEvent e) {
        this.maybeShowPopup(e);
    }

    protected void maybeShowPopup(PInputEvent e) {
        if (e.isPopupTrigger()) {
            boolean isPickedNodeSelectable;
            SelectionEventHandler selectionEventHandler = this.canvas.getSelectionEventHandler();
            PNode pickedNode = DamaskAppUtils.getSelectablePickedNode(e, selectionEventHandler.getSelectableParents());
            if (pickedNode != null) {
                if (!this.canvas.getSelectedObjects().contains(pickedNode)) {
                    selectionEventHandler.unselectAll(this.canvas);
                    selectionEventHandler.select(pickedNode, this.canvas);
                }
                isPickedNodeSelectable = true;
            } else {
                pickedNode = e.getPath().getPickedNode();
                isPickedNodeSelectable = false;
            }
            Point2D pt = e.getCanvasPosition();
            JPopupMenu popupMenu = this.canvas.getPopupMenu(pickedNode, isPickedNodeSelectable);
            if (popupMenu != null) {
                popupMenu.show(this.canvas, (int)pt.getX(), (int)pt.getY());
            }
        }
    }
}

