/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.view.event;

import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.event.PDragSequenceEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import java.awt.geom.Point2D;

public class PanningHandEventHandler
extends PDragSequenceEventHandler {
    private Point2D lastPosition;

    public PanningHandEventHandler() {
        this.getEventFilter().setAndMask(16);
    }

    public void startDrag(PInputEvent e) {
        super.startDrag(e);
        this.lastPosition = e.getCanvasPosition();
    }

    public void drag(PInputEvent e) {
        super.drag(e);
        Point2D position = e.getCanvasPosition();
        PCamera camera = e.getTopCamera();
        double cameraScale = camera.getViewScale();
        double dx = position.getX() - this.lastPosition.getX();
        double dy = position.getY() - this.lastPosition.getY();
        camera.translateView(dx / cameraScale, dy / cameraScale);
        this.lastPosition = position;
    }
}

