/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.view.appevent;

import edu.berkeley.guir.damask.view.appevent.RunCanvasEvent;
import edu.berkeley.guir.damask.view.appevent.RunCanvasListener;
import edu.berkeley.guir.damask.view.visual.DamaskRunCanvas;
import java.util.Iterator;
import java.util.Vector;

public class RunCanvasEventSource {
    private Vector eventListeners = new Vector();

    public synchronized void addRunCanvasListener(RunCanvasListener listener) {
        if (!this.eventListeners.contains(listener)) {
            this.eventListeners.add(listener);
        }
    }

    public synchronized void removeRunCanvasListener(RunCanvasListener listener) {
        this.eventListeners.remove(listener);
    }

    public void fireLoadCompleted(DamaskRunCanvas canvas) {
        Vector el;
        RunCanvasEventSource runCanvasEventSource = this;
        synchronized (runCanvasEventSource) {
            el = (Vector)this.eventListeners.clone();
        }
        if (el.isEmpty()) {
            return;
        }
        RunCanvasEvent event = new RunCanvasEvent(canvas, RunCanvasEvent.LOAD_COMPLETED);
        Iterator i = el.iterator();
        while (i.hasNext()) {
            RunCanvasListener listener = (RunCanvasListener)i.next();
            listener.loadCompleted(event);
        }
    }
}

