/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.view.appevent;

import edu.berkeley.guir.damask.view.DamaskDocument;
import edu.berkeley.guir.damask.view.appevent.DocumentEvent;
import edu.berkeley.guir.damask.view.appevent.DocumentListener;
import java.util.Iterator;
import java.util.Vector;

public class DocumentEventSource {
    private Vector eventListeners = new Vector();

    public synchronized void addDocumentListener(DocumentListener listener) {
        if (!this.eventListeners.contains(listener)) {
            this.eventListeners.add(listener);
        }
    }

    public synchronized void removeDocumentListener(DocumentListener listener) {
        this.eventListeners.remove(listener);
    }

    public void fireDocumentModified(DamaskDocument doc) {
        Vector el;
        DocumentEventSource documentEventSource = this;
        synchronized (documentEventSource) {
            el = (Vector)this.eventListeners.clone();
        }
        if (el.isEmpty()) {
            return;
        }
        DocumentEvent event = new DocumentEvent(doc, DocumentEvent.DOCUMENT_MODIFIED);
        Iterator i = el.iterator();
        while (i.hasNext()) {
            DocumentListener listener = (DocumentListener)i.next();
            listener.documentModified(event);
        }
    }

    public void fireDocumentCleaned(DamaskDocument doc) {
        Vector el;
        DocumentEventSource documentEventSource = this;
        synchronized (documentEventSource) {
            el = (Vector)this.eventListeners.clone();
        }
        if (el.isEmpty()) {
            return;
        }
        DocumentEvent event = new DocumentEvent(doc, DocumentEvent.DOCUMENT_CLEANED);
        Iterator i = el.iterator();
        while (i.hasNext()) {
            DocumentListener listener = (DocumentListener)i.next();
            listener.documentCleaned(event);
        }
    }

    public void fireDocumentRenamed(DamaskDocument doc) {
        Vector el;
        DocumentEventSource documentEventSource = this;
        synchronized (documentEventSource) {
            el = (Vector)this.eventListeners.clone();
        }
        if (el.isEmpty()) {
            return;
        }
        DocumentEvent event = new DocumentEvent(doc, DocumentEvent.DOCUMENT_RENAMED);
        Iterator i = el.iterator();
        while (i.hasNext()) {
            DocumentListener listener = (DocumentListener)i.next();
            listener.documentRenamed(event);
        }
    }

    public void fireDocumentClosed(DamaskDocument doc) {
        Vector el;
        DocumentEventSource documentEventSource = this;
        synchronized (documentEventSource) {
            el = (Vector)this.eventListeners.clone();
        }
        if (el.isEmpty()) {
            return;
        }
        DocumentEvent event = new DocumentEvent(doc, DocumentEvent.DOCUMENT_CLOSED);
        Iterator i = el.iterator();
        while (i.hasNext()) {
            DocumentListener listener = (DocumentListener)i.next();
            listener.documentClosed(event);
        }
    }

    public void fireDocumentBusyStarted(DamaskDocument doc) {
        Vector el;
        DocumentEventSource documentEventSource = this;
        synchronized (documentEventSource) {
            el = (Vector)this.eventListeners.clone();
        }
        if (el.isEmpty()) {
            return;
        }
        DocumentEvent event = new DocumentEvent(doc, DocumentEvent.DOCUMENT_BUSY_STARTED);
        Iterator i = el.iterator();
        while (i.hasNext()) {
            DocumentListener listener = (DocumentListener)i.next();
            listener.documentBusyStarted(event);
        }
    }

    public void fireDocumentBusyStopped(DamaskDocument doc) {
        Vector el;
        DocumentEventSource documentEventSource = this;
        synchronized (documentEventSource) {
            el = (Vector)this.eventListeners.clone();
        }
        if (el.isEmpty()) {
            return;
        }
        DocumentEvent event = new DocumentEvent(doc, DocumentEvent.DOCUMENT_BUSY_STOPPED);
        Iterator i = el.iterator();
        while (i.hasNext()) {
            DocumentListener listener = (DocumentListener)i.next();
            listener.documentBusyStopped(event);
        }
    }

    public void fireCanvasGroupAdded(DamaskDocument doc) {
        Vector el;
        DocumentEventSource documentEventSource = this;
        synchronized (documentEventSource) {
            el = (Vector)this.eventListeners.clone();
        }
        if (el.isEmpty()) {
            return;
        }
        DocumentEvent event = new DocumentEvent(doc, DocumentEvent.CANVAS_GROUP_ADDED);
        Iterator i = el.iterator();
        while (i.hasNext()) {
            DocumentListener listener = (DocumentListener)i.next();
            listener.canvasGroupAdded(event);
        }
    }

    public void fireCanvasGroupRemoved(DamaskDocument doc) {
        Vector el;
        DocumentEventSource documentEventSource = this;
        synchronized (documentEventSource) {
            el = (Vector)this.eventListeners.clone();
        }
        if (el.isEmpty()) {
            return;
        }
        DocumentEvent event = new DocumentEvent(doc, DocumentEvent.CANVAS_GROUP_REMOVED);
        Iterator i = el.iterator();
        while (i.hasNext()) {
            DocumentListener listener = (DocumentListener)i.next();
            listener.canvasGroupRemoved(event);
        }
    }
}

