/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.view.appevent;

import edu.berkeley.guir.damask.view.appevent.CommandEvent;
import edu.berkeley.guir.damask.view.appevent.CommandListener;
import edu.berkeley.guir.lib.satin.command.Command;
import edu.berkeley.guir.lib.satin.command.CommandQueue;
import edu.umd.cs.piccolo.PCanvas;
import java.awt.geom.AffineTransform;
import java.util.Iterator;
import java.util.Vector;

public class CommandEventSource {
    private Vector eventListeners = new Vector();

    public synchronized void addCommandListener(CommandListener listener) {
        if (!this.eventListeners.contains(listener)) {
            this.eventListeners.add(listener);
        }
    }

    public synchronized void removeCommandListener(CommandListener listener) {
        this.eventListeners.remove(listener);
    }

    public void fireCommandExecuted(CommandQueue commandQueue, Command command, PCanvas canvas, AffineTransform canvasTransform) {
        Vector el;
        CommandEventSource commandEventSource = this;
        synchronized (commandEventSource) {
            el = (Vector)this.eventListeners.clone();
        }
        if (el.isEmpty()) {
            return;
        }
        CommandEvent event = new CommandEvent(commandQueue, CommandEvent.COMMAND_EXECUTED, command, canvas, canvasTransform);
        Iterator i = el.iterator();
        while (i.hasNext()) {
            CommandListener listener = (CommandListener)i.next();
            listener.commandExecuted(event);
        }
    }

    public void fireCommandUndone(CommandQueue commandQueue, Command command, PCanvas canvas, AffineTransform canvasTransform) {
        Vector el;
        CommandEventSource commandEventSource = this;
        synchronized (commandEventSource) {
            el = (Vector)this.eventListeners.clone();
        }
        if (el.isEmpty()) {
            return;
        }
        CommandEvent event = new CommandEvent(commandQueue, CommandEvent.COMMAND_UNDONE, command, canvas, canvasTransform);
        Iterator i = el.iterator();
        while (i.hasNext()) {
            CommandListener listener = (CommandListener)i.next();
            listener.commandUndone(event);
        }
    }

    public void fireCommandRedone(CommandQueue commandQueue, Command command, PCanvas canvas, AffineTransform canvasTransform) {
        Vector el;
        CommandEventSource commandEventSource = this;
        synchronized (commandEventSource) {
            el = (Vector)this.eventListeners.clone();
        }
        if (el.isEmpty()) {
            return;
        }
        CommandEvent event = new CommandEvent(commandQueue, CommandEvent.COMMAND_REDONE, command, canvas, canvasTransform);
        Iterator i = el.iterator();
        while (i.hasNext()) {
            CommandListener listener = (CommandListener)i.next();
            listener.commandRedone(event);
        }
    }
}

