/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.view.appevent;

import edu.berkeley.guir.damask.view.DamaskCanvas;
import edu.berkeley.guir.damask.view.appevent.CanvasEvent;
import edu.berkeley.guir.damask.view.appevent.CanvasListener;
import java.util.Iterator;
import java.util.Vector;

public class CanvasEventSource {
    private Vector eventListeners = new Vector();

    public synchronized void addCanvasListener(CanvasListener listener) {
        if (!this.eventListeners.contains(listener)) {
            this.eventListeners.add(listener);
        }
    }

    public synchronized void removeCanvasListener(CanvasListener listener) {
        this.eventListeners.remove(listener);
    }

    public void fireSelectionChanged(DamaskCanvas canvas) {
        Vector el;
        CanvasEventSource canvasEventSource = this;
        synchronized (canvasEventSource) {
            el = (Vector)this.eventListeners.clone();
        }
        if (el.isEmpty()) {
            return;
        }
        CanvasEvent event = new CanvasEvent(canvas, CanvasEvent.SELECTION_CHANGED);
        Iterator i = el.iterator();
        while (i.hasNext()) {
            CanvasListener listener = (CanvasListener)i.next();
            listener.selectionChanged(event);
        }
    }

    public void fireSelectedPageChanged(DamaskCanvas canvas) {
        Vector el;
        CanvasEventSource canvasEventSource = this;
        synchronized (canvasEventSource) {
            el = (Vector)this.eventListeners.clone();
        }
        if (el.isEmpty()) {
            return;
        }
        CanvasEvent event = new CanvasEvent(canvas, CanvasEvent.SELECTED_PAGE_CHANGED);
        Iterator i = el.iterator();
        while (i.hasNext()) {
            CanvasListener listener = (CanvasListener)i.next();
            listener.selectedPageChanged(event);
        }
    }
}

