/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.view.appevent;

import edu.berkeley.guir.damask.view.DamaskApp;
import edu.berkeley.guir.damask.view.appevent.AppEvent;
import edu.berkeley.guir.damask.view.appevent.AppListener;
import java.util.Iterator;
import java.util.Vector;

public class AppEventSource {
    private Vector eventListeners = new Vector();

    public synchronized void addAppListener(AppListener listener) {
        if (!this.eventListeners.contains(listener)) {
            this.eventListeners.add(listener);
        }
    }

    public synchronized void removeAppListener(AppListener listener) {
        this.eventListeners.remove(listener);
    }

    public void fireCurrentFrameChanged(DamaskApp source) {
        Vector el;
        AppEventSource appEventSource = this;
        synchronized (appEventSource) {
            el = (Vector)this.eventListeners.clone();
        }
        if (el.isEmpty()) {
            return;
        }
        AppEvent event = new AppEvent(source, AppEvent.CURRENT_FRAME_CHANGED);
        Iterator i = el.iterator();
        while (i.hasNext()) {
            AppListener listener = (AppListener)i.next();
            listener.currentFrameChanged(event);
        }
    }
}

