/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.view.appdialogs;

import edu.berkeley.guir.damask.view.DamaskAppUtils;
import edu.berkeley.guir.lib.io.FileLib;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriter;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ImageWriterSpi;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;

public class FileDialogUtils {
    private static final JFileChooser fileChooser;
    private static FileDialog fileDialog;
    private static final FileFilterCreator[] damaskFilterCreators;
    private static final FileFilterCreator[] voiceXMLFilterCreators;
    private static final FileFilterCreator[] imageOpenFilterCreators;
    private static final FileFilterCreator[] imageSaveFilterCreators;

    static {
        String ext;
        int m;
        int j;
        String[] spiExts;
        Set<String> exts;
        String description;
        String type;
        fileChooser = new JFileChooser();
        damaskFilterCreators = new FileFilterCreator[]{new FileFilterCreator("Damask Documents", "dmk")};
        voiceXMLFilterCreators = new FileFilterCreator[]{new FileFilterCreator("VoiceXML", "vxml")};
        HashMap<String, String> descriptions = new HashMap<String, String>();
        descriptions.put("image/gif", "GIF Files");
        descriptions.put("image/jpeg", "JPEG Files");
        descriptions.put("image/png", "PNG Files");
        descriptions.put("image/x-png", "PNG Files");
        descriptions.put("image/bmp", "Microsoft Windows Bitmap Files");
        descriptions.put("image/vnd.wap.wbmp", "Wireless Bitmap Files");
        TreeMap<String, Set<Object>> imageExts = new TreeMap<String, Set<Object>>();
        HashSet<String> handledExts = new HashSet<String>();
        String[] types = ImageIO.getReaderMIMETypes();
        int i = 0;
        int n = types.length;
        while (i < n) {
            type = types[i];
            description = (String)descriptions.get(type);
            if (description == null) {
                description = type;
            }
            if ((exts = (TreeSet)imageExts.get(description)) == null) {
                exts = new TreeSet();
                imageExts.put(description, exts);
            }
            Iterator<ImageReader> readers = ImageIO.getImageReadersByMIMEType(type);
            while (readers.hasNext()) {
                ImageReader reader = readers.next();
                ImageReaderSpi readerSpi = reader.getOriginatingProvider();
                spiExts = readerSpi.getFileSuffixes();
                j = 0;
                m = spiExts.length;
                while (j < m) {
                    ext = spiExts[j].toLowerCase();
                    if (!handledExts.contains(ext)) {
                        handledExts.add(ext);
                        exts.add(ext);
                    }
                    ++j;
                }
            }
            ++i;
        }
        imageOpenFilterCreators = new FileFilterCreator[imageExts.size() + 1];
        TreeSet<String> allImageExts = new TreeSet<String>();
        int index = 0;
        Iterator i2 = imageExts.keySet().iterator();
        while (i2.hasNext()) {
            description = (String)i2.next();
            exts = (Set)imageExts.get(description);
            if (!exts.isEmpty()) {
                allImageExts.addAll(exts);
                FileDialogUtils.imageOpenFilterCreators[index + 1] = new FileFilterCreator(description, exts);
            }
            ++index;
        }
        FileDialogUtils.imageOpenFilterCreators[0] = new FileFilterCreator("Image Files", allImageExts);
        imageExts = new TreeMap();
        handledExts = new HashSet();
        types = ImageIO.getWriterMIMETypes();
        i = 0;
        n = types.length;
        while (i < n) {
            type = types[i];
            description = (String)descriptions.get(type);
            if (description == null) {
                description = type;
            }
            if ((exts = (Set)imageExts.get(description)) == null) {
                exts = new TreeSet();
                imageExts.put(description, exts);
            }
            Iterator<ImageWriter> writers = ImageIO.getImageWritersByMIMEType(type);
            while (writers.hasNext()) {
                ImageWriter writer = writers.next();
                ImageWriterSpi writerSpi = writer.getOriginatingProvider();
                spiExts = writerSpi.getFileSuffixes();
                j = 0;
                m = spiExts.length;
                while (j < m) {
                    ext = spiExts[j].toLowerCase();
                    if (!handledExts.contains(ext)) {
                        handledExts.add(ext);
                        exts.add(ext);
                    }
                    ++j;
                }
            }
            ++i;
        }
        imageSaveFilterCreators = new FileFilterCreator[imageExts.size()];
        int index2 = 0;
        Iterator i3 = imageExts.keySet().iterator();
        while (i3.hasNext()) {
            String description2 = (String)i3.next();
            Set exts2 = (Set)imageExts.get(description2);
            if (!exts2.isEmpty()) {
                FileDialogUtils.imageSaveFilterCreators[index2] = new FileFilterCreator(description2, exts2);
            }
            ++index2;
        }
    }

    private FileDialogUtils() {
    }

    private static File getSelectedFileWithFilterExtension(JFileChooser fileChooser) {
        File tempFile = fileChooser.getSelectedFile();
        FileFilter chosenFileFilter = fileChooser.getFileFilter();
        if (chosenFileFilter instanceof StandardFileFilter) {
            StandardFileFilter chosenStandardFileFilter = (StandardFileFilter)chosenFileFilter;
            String[] exts = chosenStandardFileFilter.getExtensions();
            if (exts.length == 1) {
                return new File(FileLib.addFileNameExtension(tempFile, exts[0]));
            }
            return tempFile;
        }
        return tempFile;
    }

    public static File showDamaskOpenDialog(Component parentComponent) {
        return FileDialogUtils.showOpenDialog(parentComponent, damaskFilterCreators);
    }

    public static File showImageOpenDialog(Component parentComponent) {
        return FileDialogUtils.showOpenDialog(parentComponent, imageOpenFilterCreators);
    }

    public static File showOpenDialog(Component parentComponent, FileFilterCreator[] fileFilterCreators) {
        int result;
        if (DamaskAppUtils.isMac()) {
            Frame frame = parentComponent instanceof Frame ? (Frame)parentComponent : (Frame)SwingUtilities.windowForComponent(parentComponent);
            fileDialog = new FileDialog(frame, "Open", 0);
            if (fileFilterCreators.length > 0) {
                fileDialog.setFilenameFilter(fileFilterCreators[0].getFilenameFilter());
            }
            fileDialog.setVisible(true);
            if (fileDialog.getFile() == null) {
                return null;
            }
            String newFileNameStr = String.valueOf(fileDialog.getDirectory()) + File.separator + fileDialog.getFile();
            String[] fileExts = fileFilterCreators[0].getExtensions();
            if (fileExts.length == 1) {
                newFileNameStr = FileLib.addFileNameExtension(newFileNameStr, fileExts[0]);
            }
            return new File(newFileNameStr);
        }
        fileChooser.setSelectedFile(null);
        fileChooser.setAcceptAllFileFilterUsed(true);
        fileChooser.resetChoosableFileFilters();
        int i = 0;
        int n = fileFilterCreators.length;
        while (i < n) {
            fileChooser.addChoosableFileFilter(fileFilterCreators[i].getFileFilter());
            ++i;
        }
        if (fileFilterCreators.length > 0) {
            fileChooser.setFileFilter(fileFilterCreators[0].getFileFilter());
        }
        while ((result = fileChooser.showOpenDialog(parentComponent)) == 0) {
            File selectedFile = FileDialogUtils.getSelectedFileWithFilterExtension(fileChooser);
            if (selectedFile.exists()) {
                return selectedFile;
            }
            JOptionPane.showMessageDialog(parentComponent, selectedFile + " does not exist.\n\n" + "Please verify the correct file name was given.", "Damask", 2);
        }
        return null;
    }

    public static File showDamaskSaveDialog(Component parentComponent) {
        return FileDialogUtils.showSaveDialog(parentComponent, damaskFilterCreators);
    }

    public static File showExportVoiceXMLDialog(Component parentComponent) {
        return FileDialogUtils.showSaveDialog(parentComponent, voiceXMLFilterCreators);
    }

    public static File showImageSaveDialog(Component parentComponent) {
        return FileDialogUtils.showSaveDialog(parentComponent, imageSaveFilterCreators);
    }

    public static File showSaveDialog(Component parentComponent, FileFilterCreator[] fileFilterCreators) {
        int result;
        if (DamaskAppUtils.isMac()) {
            Frame frame = parentComponent instanceof Frame ? (Frame)parentComponent : (Frame)SwingUtilities.windowForComponent(parentComponent);
            fileDialog = new FileDialog(frame, "Save", 1);
            if (fileFilterCreators.length > 0) {
                fileDialog.setFilenameFilter(fileFilterCreators[0].getFilenameFilter());
            }
            fileDialog.setVisible(true);
            if (fileDialog.getFile() == null) {
                return null;
            }
            String newFileNameStr = String.valueOf(fileDialog.getDirectory()) + File.separator + fileDialog.getFile();
            String[] fileExts = fileFilterCreators[0].getExtensions();
            if (fileExts.length == 1) {
                newFileNameStr = FileLib.addFileNameExtension(newFileNameStr, fileExts[0]);
            }
            return new File(newFileNameStr);
        }
        fileChooser.setSelectedFile(null);
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.resetChoosableFileFilters();
        int i = 0;
        int n = fileFilterCreators.length;
        while (i < n) {
            fileChooser.addChoosableFileFilter(fileFilterCreators[i].getFileFilter());
            ++i;
        }
        if (fileFilterCreators.length > 0) {
            fileChooser.setFileFilter(fileFilterCreators[0].getFileFilter());
        }
        while ((result = fileChooser.showSaveDialog(parentComponent)) == 0) {
            File file = FileDialogUtils.getSelectedFileWithFilterExtension(fileChooser);
            if (file.exists()) {
                int overwriteResult = FileDialogUtils.promptToOverwrite(parentComponent, file);
                if (overwriteResult != 0) continue;
                return file;
            }
            return file;
        }
        return null;
    }

    public static int promptToSave(Component parentComponent, String fileName) {
        return JOptionPane.showConfirmDialog(parentComponent, "Do you want to save the changes to " + fileName + "?", "Damask", 1, 2);
    }

    private static int promptToOverwrite(Component parentComponent, File file) {
        Object[] options = new String[2];
        if (DamaskAppUtils.isMac()) {
            options[0] = "Cancel";
            options[1] = "Replace";
        } else {
            options[0] = "Yes";
            options[1] = "No";
        }
        return JOptionPane.showOptionDialog(parentComponent, String.valueOf(file.getName()) + " already exists.\nDo you want to replace it?", "Damask", 0, 2, null, options, options[1]);
    }

    public static class FileFilterCreator {
        private final String description;
        private final String[] extensions;
        private final FileFilter fileFilter;
        private final FilenameFilter filenameFilter;

        public FileFilterCreator(String description, String extension) {
            this(description, new String[]{extension});
        }

        public FileFilterCreator(String description, Collection extensions) {
            this(description, extensions.toArray(new String[extensions.size()]));
        }

        public FileFilterCreator(String description, String[] extensions) {
            this.description = description;
            this.extensions = new String[extensions.length];
            System.arraycopy(extensions, 0, this.extensions, 0, extensions.length);
            this.fileFilter = new StandardFileFilter(description, extensions);
            this.filenameFilter = new StandardFilenameFilter(extensions);
        }

        public String getDescription() {
            return this.description;
        }

        public String[] getExtensions() {
            String[] result = new String[this.extensions.length];
            System.arraycopy(this.extensions, 0, result, 0, this.extensions.length);
            return result;
        }

        public FileFilter getFileFilter() {
            return this.fileFilter;
        }

        public FilenameFilter getFilenameFilter() {
            return this.filenameFilter;
        }

        public String toString() {
            return String.valueOf(super.toString()) + "(" + this.getDescription() + " " + Arrays.asList(this.getExtensions()).toString() + ")";
        }
    }

    private static class StandardFileFilter
    extends FileFilter {
        private final String description;
        private final String[] extensions;
        private final String fullDescription;

        public StandardFileFilter(String description, String[] extensions) {
            this.description = description;
            this.extensions = new String[extensions.length];
            System.arraycopy(extensions, 0, this.extensions, 0, extensions.length);
            StringBuffer fullDescBuffer = new StringBuffer(description);
            fullDescBuffer.append(" (");
            int i = 0;
            int n = extensions.length;
            while (i < n) {
                fullDescBuffer.append("*.");
                fullDescBuffer.append(extensions[i]);
                if (i != n - 1) {
                    fullDescBuffer.append(", ");
                }
                ++i;
            }
            fullDescBuffer.append(")");
            this.fullDescription = fullDescBuffer.toString();
        }

        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            int i = 0;
            int n = this.extensions.length;
            while (i < n) {
                if (FileLib.getFileNameExtension(f.getAbsolutePath()).equalsIgnoreCase(this.extensions[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public String getDescription() {
            return this.fullDescription;
        }

        public String[] getExtensions() {
            String[] result = new String[this.extensions.length];
            System.arraycopy(this.extensions, 0, result, 0, this.extensions.length);
            return result;
        }
    }

    private static class StandardFilenameFilter
    implements FilenameFilter {
        private final String[] extensions;

        public StandardFilenameFilter(String[] extensions) {
            this.extensions = new String[extensions.length];
            System.arraycopy(extensions, 0, this.extensions, 0, extensions.length);
        }

        public boolean accept(File dir, String name) {
            String nameLowerCase = name.toLowerCase();
            int i = 0;
            int n = this.extensions.length;
            while (i < n) {
                String extensionLowerCase = this.extensions[i].toLowerCase();
                if (nameLowerCase.endsWith("." + extensionLowerCase)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }
}

