/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.view.appdialogs;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class EditListDialog
extends JDialog {
    private static final int DEFAULT_WIDTH = 420;
    private static final int DEFAULT_HEIGHT = 200;
    private JTextArea textArea;
    private JOptionPane optionPane;
    private boolean isOK;

    public EditListDialog(String[] listItems) {
        this.commonInitializations(listItems);
    }

    public EditListDialog(Frame frame, String[] listItems, int x, int y) {
        super(frame, true);
        this.commonInitializations(listItems);
        this.setSizeAndPosition(x, y);
    }

    private void setSizeAndPosition(int x, int y) {
        int xbox = x - 210;
        int ybox = y - 200;
        if (xbox < 0) {
            xbox = 0;
        }
        if (ybox < 0) {
            ybox = 0;
        }
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        if (xbox + 420 > screenDim.width) {
            xbox -= xbox + 420 - screenDim.width;
        }
        if (ybox + 200 > screenDim.height) {
            ybox -= ybox + 200 - screenDim.height;
        }
        this.setBounds(xbox, ybox, 420, 200);
    }

    private void commonInitializations(String[] items) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < items.length) {
            sb.append(items[i]);
            sb.append('\n');
            ++i;
        }
        this.textArea = new JTextArea(sb.toString());
        this.setTitle("Edit List");
        this.setResizable(false);
        this.textArea.setRows(5);
        this.textArea.setColumns(4);
        this.textArea.setLineWrap(false);
        this.textArea.setWrapStyleWord(false);
        JScrollPane areaScrollPane = new JScrollPane(this.textArea);
        areaScrollPane.setVerticalScrollBarPolicy(22);
        areaScrollPane.setPreferredSize(new Dimension(250, 70));
        Object[] array = new Object[]{"Enter the items in the list (one per line):", areaScrollPane};
        this.optionPane = new JOptionPane(array, -1, 2, null, null, null);
        this.setContentPane(this.optionPane);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                EditListDialog.this.optionPane.setValue(new Integer(-1));
            }
        });
        this.optionPane.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                String prop = e.getPropertyName();
                if (EditListDialog.this.isVisible() && e.getSource() == EditListDialog.this.optionPane && (prop.equals("value") || prop.equals("inputValue"))) {
                    Object value = EditListDialog.this.optionPane.getValue();
                    if (value == JOptionPane.UNINITIALIZED_VALUE) {
                        return;
                    }
                    EditListDialog.this.optionPane.setValue(JOptionPane.UNINITIALIZED_VALUE);
                    if (value instanceof Integer && (Integer)value == 0) {
                        EditListDialog.this.isOK = true;
                        EditListDialog.this.setVisible(false);
                    } else {
                        EditListDialog.this.isOK = false;
                        EditListDialog.this.setVisible(false);
                    }
                }
            }
        });
    }

    public String[] getValues() {
        return this.textArea.getText().split("\n");
    }

    public boolean wasOKPressed() {
        return this.isOK;
    }
}

