/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.view;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoundedRangeModel;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.KeyStroke;

public class ZoomSlider
extends JSlider {
    private static final KeyStroke CTRL_EQUALS = KeyStroke.getKeyStroke(61, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false);
    private static final KeyStroke CTRL_ADD = KeyStroke.getKeyStroke(107, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false);
    private static final KeyStroke CTRL_HYPHEN = KeyStroke.getKeyStroke(45, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false);
    private static final KeyStroke CTRL_SUBTRACT = KeyStroke.getKeyStroke(109, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false);
    private static final String ZOOM_IN_ACTION = "zoom in";
    private static final String ZOOM_OUT_ACTION = "zoom out";
    private final Action zoomInAction = new ZoomInAction();
    private final Action zoomOutAction = new ZoomOutAction();
    static /* synthetic */ Class class$0;

    public ZoomSlider(BoundedRangeModel sliderModel) {
        super(1);
        this.setModel(sliderModel);
        this.setSnapToTicks(true);
        this.setPaintTicks(true);
        this.setMajorTickSpacing(1);
        this.setInverted(true);
        this.getActionMap().put(ZOOM_IN_ACTION, this.zoomInAction);
        this.getActionMap().put(ZOOM_OUT_ACTION, this.zoomOutAction);
        this.getInputMap(2).put(CTRL_EQUALS, ZOOM_IN_ACTION);
        this.getInputMap(2).put(CTRL_ADD, ZOOM_IN_ACTION);
        this.getInputMap(2).put(CTRL_HYPHEN, ZOOM_OUT_ACTION);
        this.getInputMap(2).put(CTRL_SUBTRACT, ZOOM_OUT_ACTION);
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        ((Dictionary)labelTable).put(new Integer(1), this.getSliderLabel("Site Map", "site_map.gif"));
        ((Dictionary)labelTable).put(new Integer(7), this.getSliderLabel("Page", "page.gif"));
        ((Dictionary)labelTable).put(new Integer(13), this.getSliderLabel("Detail", "detail.gif"));
        this.setLabelTable(labelTable);
        this.setPaintLabels(true);
    }

    protected JLabel getSliderLabel(String text, String fileName) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.damask.view.DamaskApp");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Image image = toolkit.createImage(clazz.getResource("images/slider/" + fileName));
        JLabel label = new JLabel(text);
        label.setIcon(new ImageIcon(image));
        label.setHorizontalTextPosition(0);
        label.setVerticalTextPosition(3);
        return label;
    }

    private class ZoomInAction
    extends AbstractAction {
        ZoomInAction() {
        }

        public void actionPerformed(ActionEvent e) {
            ZoomSlider.this.setValue(ZoomSlider.this.getValue() + 1);
        }
    }

    private class ZoomOutAction
    extends AbstractAction {
        ZoomOutAction() {
        }

        public void actionPerformed(ActionEvent e) {
            ZoomSlider.this.setValue(ZoomSlider.this.getValue() - 1);
        }
    }
}

