/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.view;

import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.view.DamaskApp;
import edu.berkeley.guir.damask.view.DamaskCanvas;
import edu.berkeley.guir.damask.view.DamaskDocument;
import edu.berkeley.guir.damask.view.DamaskFrame;
import edu.berkeley.guir.damask.view.appevent.AppEvent;
import edu.berkeley.guir.damask.view.appevent.AppListener;
import edu.berkeley.guir.damask.view.appevent.CanvasEvent;
import edu.berkeley.guir.damask.view.appevent.CanvasListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Toolbox
extends JToolBar {
    private DamaskFrame frame;
    private DamaskFrame currentFrame = null;
    private DamaskCanvas currentCanvas = null;
    private final ButtonGroup toolsButtonGroup = new ButtonGroup();
    private final CanvasListener canvasHandler = new CanvasHandler();
    private final ChangeListener canvasChangeHandler = new CanvasChangeHandler();
    private JToggleButton pointerButton;
    private OutputModality currentModality;
    private final Map outputSpecificTools = new HashMap();
    private final Map currentTool = new HashMap();
    private static final int FIRST_OUTPUT_SPECIFIC_TOOL_INDEX = 3;
    static /* synthetic */ Class class$0;

    public Toolbox() {
        super(1);
        this.setFloatable(false);
    }

    private JToggleButton createToolButton(Action action) {
        JToggleButton newButton = new JToggleButton(action);
        newButton.setText("");
        newButton.setDisabledIcon((Icon)action.getValue("Disabled icon"));
        newButton.setMaximumSize(new Dimension(Integer.MAX_VALUE, newButton.getMaximumSize().height));
        newButton.setHorizontalAlignment(2);
        return newButton;
    }

    private void addButton(JToggleButton newButton) {
        this.addButton(newButton, this.getComponentCount());
    }

    private void addButton(JToggleButton newButton, int index) {
        this.add((Component)newButton, index);
        this.toolsButtonGroup.add(newButton);
    }

    private void addButtons(List newButtons) {
        Iterator i = newButtons.iterator();
        while (i.hasNext()) {
            JToggleButton newButton = (JToggleButton)i.next();
            if (newButton == null) {
                this.addSeparator();
                continue;
            }
            this.addButton(newButton);
        }
    }

    private void addButtons(List newButtons, int index) {
        Iterator i = newButtons.iterator();
        while (i.hasNext()) {
            JToggleButton newButton = (JToggleButton)i.next();
            if (newButton == null) {
                this.addSeparator(index);
            } else {
                this.addButton(newButton, index);
            }
            ++index;
        }
    }

    private void addSeparator(int index) {
        JToolBar.Separator s = new JToolBar.Separator(null);
        if (this.getOrientation() == 1) {
            s.setOrientation(0);
        } else {
            s.setOrientation(1);
        }
        this.add((Component)s, index);
    }

    public void initialize() {
        ArrayList<JToggleButton> visualButtons = new ArrayList<JToggleButton>();
        this.outputSpecificTools.put(OutputModality.VISUAL, visualButtons);
        JToggleButton pageButton = this.createToolButton(new ToolAction("Page/Pencil", this.getToolboxIcon("pencil.gif"), 80, "Page/Pencil"));
        visualButtons.add(pageButton);
        visualButtons.add(this.createToolButton(new ToolAction("Eraser", this.getToolboxIcon("eraser.gif"), 69, "Eraser")));
        visualButtons.add(this.createToolButton(new ToolAction("Text", this.getToolboxIcon("text.gif"), 84, "Text")));
        visualButtons.add(null);
        visualButtons.add(this.createToolButton(new ToolAction("Button", this.getToolboxIcon("button.gif"), 66, "Button")));
        visualButtons.add(this.createToolButton(new ToolAction("Check Box", this.getToolboxIcon("check_box.gif"), 67, "Check Box")));
        visualButtons.add(this.createToolButton(new ToolAction("Radio Button", this.getToolboxIcon("radio_button.gif"), 82, "Radio Button")));
        visualButtons.add(this.createToolButton(new ToolAction("List Box", this.getToolboxIcon("list_box.gif"), 76, "List Box")));
        visualButtons.add(this.createToolButton(new ToolAction("Drop-Down Box", this.getToolboxIcon("combo_box.gif"), 79, "Drop-Down Box")));
        visualButtons.add(this.createToolButton(new ToolAction("Text Box", this.getToolboxIcon("text_box.gif"), 69, "Text Box")));
        visualButtons.add(this.createToolButton(new ToolAction("Panel", this.getToolboxIcon("panel.gif"), 78, "Group")));
        visualButtons.add(null);
        visualButtons.add(this.createToolButton(new ToolAction("Split", this.getToolboxIcon("split.gif"), 83, "Split Page")));
        visualButtons.add(this.createToolButton(new ToolAction("Merge", this.getToolboxIcon("merge.gif"), 83, "Merge Pages")));
        visualButtons.add(null);
        visualButtons.add(this.createToolButton(new ToolAction("Change Control State", this.getToolboxIcon("change_state.gif"), 83, "Change Control State")));
        ArrayList<JToggleButton> voiceButtons = new ArrayList<JToggleButton>();
        this.outputSpecificTools.put(OutputModality.VOICE, voiceButtons);
        JToggleButton voiceDrawButton = this.createToolButton(new ToolAction("Draw", this.getToolboxIcon("pencil.gif"), 80, "Draw"));
        voiceButtons.add(voiceDrawButton);
        voiceButtons.add(this.createToolButton(new ToolAction("Eraser", this.getToolboxIcon("eraser.gif"), 69, "Eraser")));
        this.addSeparator();
        this.pointerButton = this.createToolButton(new ToolAction("Select/Move", this.getToolboxIcon("pointer.gif"), 86, "Select/Move"));
        this.addButton(this.pointerButton);
        this.addButton(this.createToolButton(new ToolAction("Pan", this.getToolboxIcon("hand.gif"), 65, "Pan")));
        this.addSeparator();
        this.currentModality = OutputModality.VISUAL;
        this.addButtons(visualButtons);
        Component root = SwingUtilities.getRoot(this);
        if (root instanceof DamaskFrame) {
            this.frame = (DamaskFrame)root;
            this.setCurrentFrame(this.frame);
        } else {
            this.frame = null;
            DamaskApp.addAppListener(new AppHandler());
        }
        this.currentTool.put(OutputModality.VISUAL, pageButton);
        this.currentTool.put(OutputModality.VOICE, voiceDrawButton);
        pageButton.doClick();
    }

    protected ImageIcon getToolboxIcon(String fileName) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.damask.view.DamaskApp");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Image image = toolkit.createImage(clazz.getResource("images/toolbox/" + fileName));
        return new ImageIcon(image);
    }

    private Collection getCanvases() {
        HashSet<DamaskCanvas> canvases;
        if (this.frame == null) {
            canvases = new HashSet<DamaskCanvas>();
            List docs = DamaskApp.getDocuments();
            Iterator i = docs.iterator();
            while (i.hasNext()) {
                DamaskDocument doc = (DamaskDocument)i.next();
                Iterator j = doc.getCanvasGroups().iterator();
                while (j.hasNext()) {
                    DamaskDocument.DamaskCanvasGroup group = (DamaskDocument.DamaskCanvasGroup)j.next();
                    Iterator k = group.getCanvases().iterator();
                    while (k.hasNext()) {
                        DamaskCanvas canvas = (DamaskCanvas)k.next();
                        canvases.add(canvas);
                    }
                }
            }
        } else {
            DamaskDocument.DamaskCanvasGroup group = this.frame.getCanvasGroup();
            canvases = new HashSet(group.getCanvases());
        }
        return canvases;
    }

    private DamaskFrame getCurrentFrame() {
        return this.currentFrame;
    }

    private void setCurrentFrame(DamaskFrame currentFrame) {
        if (currentFrame != null) {
            currentFrame.removeCanvasChangeListener(this.canvasChangeHandler);
        }
        this.currentFrame = currentFrame;
        if (currentFrame != null) {
            this.setCurrentCanvas(currentFrame.getCurrentCanvas());
            currentFrame.addCanvasChangeListener(this.canvasChangeHandler);
        }
    }

    private void setCurrentCanvas(DamaskCanvas canvas) {
        if (this.currentCanvas != null) {
            this.currentCanvas.removeCanvasListener(this.canvasHandler);
        }
        this.currentCanvas = canvas;
        if (this.currentCanvas != null) {
            this.currentCanvas.addCanvasListener(this.canvasHandler);
            this.updateDeviceTypeSpecificTools();
        }
    }

    private void updateDeviceTypeSpecificTools() {
        if (this.currentModality == OutputModality.VISUAL && this.currentCanvas.getDeviceType().isVisual()) {
            return;
        }
        if (this.currentModality == OutputModality.VOICE && this.currentCanvas.getDeviceType() == DeviceType.VOICE) {
            return;
        }
        int i = 0;
        int n = this.getComponentCount();
        while (i < n) {
            JToggleButton tool;
            Component toolBarComponent = this.getComponentAtIndex(i);
            if (toolBarComponent instanceof JToggleButton && this.toolsButtonGroup.isSelected((tool = (JToggleButton)toolBarComponent).getModel())) {
                this.currentTool.put(this.currentModality, tool);
                break;
            }
            ++i;
        }
        while (3 < this.getComponentCount()) {
            this.remove(3);
        }
        this.currentModality = this.currentCanvas.getDeviceType().isVisual() ? OutputModality.VISUAL : OutputModality.VOICE;
        List newButtons = (List)this.outputSpecificTools.get(this.currentModality);
        if (!newButtons.isEmpty()) {
            this.addSeparator(3);
            this.addButtons(newButtons, 4);
        }
        this.repaint();
        ((JToggleButton)this.currentTool.get(this.currentModality)).doClick();
    }

    public static class OutputModality {
        private String name;
        public static final OutputModality VISUAL = new OutputModality("Visual");
        public static final OutputModality VOICE = new OutputModality("Voice");

        private OutputModality(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    private class ToolAction
    extends AbstractAction {
        private String eventModeName;

        public ToolAction(String text, ImageIcon icon, int mnemonic, String appModeName) {
            super(text, icon);
            this.putValue("ShortDescription", text);
            this.putValue("MnemonicKey", new Integer(mnemonic));
            this.eventModeName = appModeName;
        }

        public void actionPerformed(ActionEvent e) {
            Iterator i = Toolbox.this.getCanvases().iterator();
            while (i.hasNext()) {
                DamaskCanvas canvas = (DamaskCanvas)i.next();
                canvas.setModeByName(this.eventModeName);
            }
        }
    }

    private class AppHandler
    implements AppListener {
        AppHandler() {
        }

        public void currentFrameChanged(AppEvent e) {
            Toolbox.this.setCurrentFrame(DamaskApp.getCurrentFrame());
        }
    }

    private class CanvasChangeHandler
    implements ChangeListener {
        CanvasChangeHandler() {
        }

        public void stateChanged(ChangeEvent e) {
            Toolbox.this.setCurrentCanvas(Toolbox.this.getCurrentFrame().getCurrentCanvas());
        }
    }

    private class CanvasHandler
    implements CanvasListener {
        static final /* synthetic */ boolean $assertionsDisabled;
        static /* synthetic */ Class class$0;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("edu.berkeley.guir.damask.view.Toolbox$CanvasHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        CanvasHandler() {
        }

        public void selectionChanged(CanvasEvent e) {
            if (!$assertionsDisabled && e.getCanvas() != Toolbox.this.currentCanvas) {
                throw new AssertionError((Object)("should be receiving events from " + Toolbox.this.currentCanvas + ", not " + e.getCanvas()));
            }
        }

        public void selectedPageChanged(CanvasEvent e) {
        }
    }
}

