/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.view;

import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.InteractionElement;
import edu.berkeley.guir.damask.InteractionGraph;
import edu.berkeley.guir.damask.command.AddTemplateCommand;
import edu.berkeley.guir.damask.command.ApplyTemplateToPageCommand;
import edu.berkeley.guir.damask.command.RemoveTemplateCommand;
import edu.berkeley.guir.damask.command.UnapplyTemplateToPageCommand;
import edu.berkeley.guir.damask.component.Content;
import edu.berkeley.guir.damask.connection.Connection;
import edu.berkeley.guir.damask.dialog.Dialog;
import edu.berkeley.guir.damask.dialog.Page;
import edu.berkeley.guir.damask.dialog.TemplateDialog;
import edu.berkeley.guir.damask.event.ElementContainerEvent;
import edu.berkeley.guir.damask.event.ElementContainerListener;
import edu.berkeley.guir.damask.view.DamaskAppUtils;
import edu.berkeley.guir.damask.view.DamaskCanvas;
import edu.berkeley.guir.damask.view.DamaskLayer;
import edu.berkeley.guir.damask.view.InteractionElementView;
import edu.berkeley.guir.damask.view.appevent.CanvasEvent;
import edu.berkeley.guir.damask.view.appevent.CanvasListener;
import edu.berkeley.guir.damask.view.nodes.DamaskWindowTitle;
import edu.berkeley.guir.damask.view.nodes.StickyTransformManager;
import edu.berkeley.guir.damask.view.visual.Arrow;
import edu.berkeley.guir.damask.view.visual.VisualLayer;
import edu.berkeley.guir.damask.view.visual.dialog.DialogView;
import edu.berkeley.guir.damask.view.visual.dialog.PageView;
import edu.berkeley.guir.damask.view.voice.dialog.Form;
import edu.berkeley.guir.lib.satin.command.UndoableCommand;
import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PComponent;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PAffineTransform;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PPaintContext;
import edu.umd.cs.piccolo.util.PPickPath;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class TemplatePane
extends PPath {
    private static final int PADDING = 25;
    private static final int ANIMATION_LENGTH = 500;
    private boolean expanded = false;
    private PCamera visibleCamera = null;
    private int topDialogView = 0;
    private Page selectedPage = null;
    private static final int CHECK_BOX_SIDE_LENGTH = 15;
    private static final int REMOVE_BUTTON_SIDE_LENGTH = 20;
    private static final Color BUTTON_COLOR = new Color(233, 233, 233);
    private static final Color PRESSED_BUTTON_COLOR = Color.LIGHT_GRAY;
    private PPath addTemplateButton;
    private PPath upButton;
    private PPath downButton;
    private PNode focus = null;
    private final CanvasListener canvasListener = new CanvasHandler();
    private final TemplateWell templateWell = new TemplateWell();
    private final Map checkBoxToDialog = new HashMap();
    private final Map dialogViewToCheckBox = new HashMap();
    private final Map removeButtonToDialog = new HashMap();
    private final Map dialogViewToRemoveButton = new HashMap();
    static /* synthetic */ Class class$0;

    public TemplatePane() {
        this.setPathToRectangle(0.0f, 0.0f, 1.0f, 1.0f);
        this.setPaint(Color.WHITE);
        ContentsEventHandler contentsHandler = new ContentsEventHandler();
        this.addInputEventListener(contentsHandler);
        this.addPropertyChangeListener("parent", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (TemplatePane.this.getParent() != null) {
                    TemplatePane.this.initAfterAddToParent();
                } else {
                    TemplatePane.this.removeAllChildren();
                }
            }
        });
        this.templateWell.setStrokePaint(null);
        this.addChild(this.templateWell);
    }

    protected void initAfterAddToParent() {
        DamaskLayer layer = (DamaskLayer)this.getParent();
        InteractionGraph graph = layer.getDocument().getGraph();
        Iterator i = graph.getTemplates(layer.getDeviceType()).iterator();
        while (i.hasNext()) {
            TemplateDialog templateDialog = (TemplateDialog)i.next();
            this.addTemplateToWell(layer, templateDialog);
        }
        graph.addElementContainerListener(new GraphHandler());
        this.addTemplateButton = this.createButton(new PText("Add Template"), 0.0, 0.0, 110.0, 25.0, layer);
        this.addTemplateButton.addInputEventListener(new AddTemplateButtonEventHandler());
        this.addChild(this.addTemplateButton);
        PPath upArrow = new PPath();
        upArrow.moveTo(5.0f, 0.0f);
        upArrow.lineTo(10.0f, 5.0f);
        upArrow.lineTo(0.0f, 5.0f);
        upArrow.closePath();
        upArrow.setPaint(Color.BLACK);
        this.upButton = this.createButton(upArrow, 0.0, 0.0, 20.0, 20.0, layer);
        this.upButton.addInputEventListener(new UpButtonEventHandler());
        this.addChild(this.upButton);
        PPath downArrow = new PPath();
        downArrow.moveTo(5.0f, 5.0f);
        downArrow.lineTo(10.0f, 0.0f);
        downArrow.lineTo(0.0f, 0.0f);
        downArrow.closePath();
        downArrow.setPaint(Color.BLACK);
        this.downButton = this.createButton(downArrow, 0.0, 0.0, 20.0, 20.0, layer);
        this.downButton.addInputEventListener(new DownButtonEventHandler());
        this.addChild(this.downButton);
    }

    private PPath createButton(PNode buttonLabel, double x, double y, double width, double height, DamaskLayer layer) {
        PPath newButton = new PPath(new Rectangle2D.Double(x, y, width, height));
        newButton.setPaint(new Color(233, 233, 233));
        buttonLabel.setOffset((width - buttonLabel.getWidth()) / 2.0, (height - buttonLabel.getHeight()) / 2.0);
        newButton.addChild(buttonLabel);
        buttonLabel.setPickable(false);
        this.setupStickyZ(layer, newButton);
        newButton.addInputEventListener(new ButtonEventHandler());
        return newButton;
    }

    private void setupStickyZ(final DamaskLayer layer, final PNode node) {
        if (layer.getCameraCount() > 0) {
            StickyTransformManager.setupStickyZ(node, layer.getCamera(0), new Point(0, 0), 1.0);
        } else {
            layer.addPropertyChangeListener("cameras", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    if (layer.getCameraCount() > 0) {
                        StickyTransformManager.setupStickyZ(node, layer.getCamera(0), new Point(0, 0), 1.0);
                    }
                }
            });
        }
    }

    protected Image getTemplateImage(String fileName) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.damask.view.DamaskApp");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return toolkit.createImage(clazz.getResource("images/template/" + fileName));
    }

    private void addTemplateToWell(DamaskLayer layer, TemplateDialog dialog) {
        InteractionElementView dialogView = layer instanceof VisualLayer ? new DialogView(dialog) : new Form(dialog);
        CheckBox checkBox = new CheckBox(new Rectangle2D.Double(0.0, 0.0, 15.0, 15.0));
        checkBox.setPaint(DamaskAppUtils.NO_COLOR);
        checkBox.addInputEventListener(new CheckBoxEventHandler());
        this.setupStickyZ(layer, checkBox);
        this.checkBoxToDialog.put(checkBox, dialog);
        this.dialogViewToCheckBox.put(dialogView, checkBox);
        this.templateWell.addChild(checkBox);
        PPath removeButton = this.createButton(new PImage(this.getTemplateImage("delete.png"), false), 0.0, 0.0, 20.0, 20.0, layer);
        removeButton.addInputEventListener(new RemoveTemplateButtonEventHandler());
        this.removeButtonToDialog.put(removeButton, dialog);
        this.dialogViewToRemoveButton.put(dialogView, removeButton);
        if (layer.getDocument().getGraph().getDefaultTemplate() != dialog) {
            this.templateWell.addChild(removeButton);
        }
        this.templateWell.addChild(dialogView);
    }

    private void updateCheckBoxes() {
        if (this.selectedPage == null || this.selectedPage.isTemplate()) {
            Iterator i = this.checkBoxToDialog.keySet().iterator();
            while (i.hasNext()) {
                CheckBox checkBox = (CheckBox)i.next();
                checkBox.setState(false);
                checkBox.setEnabled(false);
            }
        } else {
            Iterator i = this.checkBoxToDialog.keySet().iterator();
            while (i.hasNext()) {
                CheckBox checkBox = (CheckBox)i.next();
                Dialog dialog = (Dialog)this.checkBoxToDialog.get(checkBox);
                Page pageTemplate = dialog.getFirstPage(((DamaskLayer)this.getParent()).getDeviceType());
                checkBox.setState(this.selectedPage.getTemplates().contains(pageTemplate));
                checkBox.setEnabled(true);
            }
        }
    }

    public List getViewsOfTemplateDialogs() {
        ArrayList dialogViews = new ArrayList();
        Iterator i = this.templateWell.getChildrenIterator();
        while (i.hasNext()) {
            Object child = i.next();
            if (!(child instanceof DialogView) && !(child instanceof Form)) continue;
            dialogViews.add(child);
        }
        return dialogViews;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setExpanded(PCamera camera, boolean expanded, boolean animate) {
        this.expanded = expanded;
        this.templateWell.paintClipped = !expanded;
        this.reposition(camera, animate);
    }

    private double getWidthWhenExpanded() {
        double removeButtonWidth;
        double templateViewWidth;
        List templateViews = this.getViewsOfTemplateDialogs();
        if (templateViews.isEmpty()) {
            templateViewWidth = 0.0;
            removeButtonWidth = 0.0;
        } else {
            DeviceType canvasDeviceType;
            InteractionElementView firstDialogView = (InteractionElementView)templateViews.get(0);
            if (this.visibleCamera != null) {
                DamaskCanvas canvas = (DamaskCanvas)this.visibleCamera.getComponent();
                canvasDeviceType = canvas.getDeviceType();
            } else {
                canvasDeviceType = null;
            }
            templateViewWidth = canvasDeviceType == DeviceType.VOICE ? firstDialogView.localToParent(firstDialogView.getBounds()).getWidth() : firstDialogView.getFullBounds().getWidth();
            removeButtonWidth = ((PPath)this.dialogViewToRemoveButton.get(firstDialogView)).getFullBounds().getWidth();
        }
        return Math.max(Math.max(25.0 + removeButtonWidth + 25.0 + templateViewWidth + 25.0 + this.upButton.getFullBounds().getWidth() + 25.0, 25.0 + removeButtonWidth + 25.0 + templateViewWidth + 25.0 + this.upButton.getFullBounds().getWidth() + 25.0), 25.0 + this.addTemplateButton.getFullBounds().getWidth() + 25.0);
    }

    public double getVisibleWidth() {
        if (this.expanded) {
            return this.getWidthWhenExpanded();
        }
        return 0.0;
    }

    public boolean isVisibleToCamera(PCamera camera) {
        return camera == this.visibleCamera;
    }

    public void setVisibleToCamera(PCamera camera) {
        if (this.visibleCamera != null) {
            DamaskCanvas oldCanvas = (DamaskCanvas)this.visibleCamera.getComponent();
            this.setArrowsVisibleToCamera(this.visibleCamera, false);
            oldCanvas.removeCanvasListener(this.canvasListener);
            oldCanvas.repaint();
        }
        this.visibleCamera = camera;
        if (this.visibleCamera != null) {
            DamaskCanvas canvas = (DamaskCanvas)this.visibleCamera.getComponent();
            this.setArrowsVisibleToCamera(this.visibleCamera, true);
            canvas.addCanvasListener(this.canvasListener);
            canvas.repaint();
            this.selectedPage = canvas.getSelectedPage();
            this.updateCheckBoxes();
        }
    }

    private void setArrowsVisibleToCamera(PCamera camera, boolean flag) {
        DamaskLayer layer = (DamaskLayer)this.getParent();
        DeviceType deviceType = layer.getDeviceType();
        Iterator i = layer.getChildrenIterator();
        while (i.hasNext()) {
            Arrow arrow;
            Page sourcePage;
            PNode child = (PNode)i.next();
            if (!(child instanceof Arrow) || !(sourcePage = ((Connection)(arrow = (Arrow)child).getModel()).getConnectionSource(deviceType).getPage(deviceType)).isTemplate()) continue;
            arrow.setVisibleToCamera(camera, flag);
        }
    }

    public void fullPaint(PPaintContext paintContext) {
        if (this.isVisibleToCamera(paintContext.getCamera())) {
            super.fullPaint(paintContext);
        }
    }

    public void reposition(PCamera camera, boolean animate) {
        DamaskLayer layer = (DamaskLayer)this.getParent();
        DeviceType deviceType = layer.getDeviceType();
        if (this.expanded) {
            this.setVisible(false);
            this.repositionHelper(camera, false);
            Iterator i = layer.getChildrenIterator();
            while (i.hasNext()) {
                Page sourcePage;
                PNode child = (PNode)i.next();
                if (!(child instanceof Arrow) || !(sourcePage = ((Connection)((Arrow)child).getModel()).getConnectionSource(deviceType).getPage(deviceType)).isTemplate()) continue;
                ((Arrow)child).reanchor();
            }
            this.expanded = false;
            this.repositionHelper(camera, false);
            this.expanded = true;
            this.setVisible(true);
        }
        this.setArrowsVisibleToCamera(camera, this.expanded);
        this.repositionHelper(camera, animate);
    }

    private void repositionHelper(PCamera camera, boolean animate) {
        PBounds cameraBounds = camera.getBounds();
        camera.localToView(cameraBounds);
        PAffineTransform transform = this.getTransform();
        transform.setOffset(cameraBounds.getMaxX() - this.getVisibleWidth(), cameraBounds.getMinY());
        if (animate) {
            this.animateToTransform(transform, 500L);
        } else {
            this.setTransform(transform);
        }
        this.globalToLocal(cameraBounds);
        this.setPathTo(new Rectangle2D.Double(0.0, 0.0, this.getWidthWhenExpanded(), ((RectangularShape)cameraBounds).getHeight()));
        this.repositionDialogViews();
    }

    private void repositionDialogViews() {
        PPath removeButton;
        PPath checkBox;
        double yOffset;
        DamaskWindowTitle titleBar;
        InteractionElementView dialogView;
        List dialogViews = this.getViewsOfTemplateDialogs();
        int y = 0;
        ListIterator i = dialogViews.listIterator(this.topDialogView);
        while (i.hasNext()) {
            dialogView = (InteractionElementView)i.next();
            if (dialogView instanceof DialogView) {
                titleBar = ((PageView)((DialogView)dialogView).getChild(0)).getTitleBar();
                ((DialogView)dialogView).setContentsSelectable(true);
            } else {
                titleBar = ((Form)dialogView).getTitleBar();
                ((Form)dialogView).setContentsSelectable(true);
            }
            yOffset = (double)titleBar.getPixelHeight() * titleBar.getTransform().getScaleY();
            if (y == 0) {
                y = (int)((double)y + yOffset);
            }
            checkBox = (PPath)this.dialogViewToCheckBox.get(dialogView);
            checkBox.setOffset(0.0, (double)y - yOffset);
            removeButton = (PPath)this.dialogViewToRemoveButton.get(dialogView);
            removeButton.setOffset(0.0, checkBox.getFullBounds().getY() + checkBox.getFullBounds().getHeight() + 50.0);
            dialogView.setOffset(removeButton.getFullBounds().getWidth() + 25.0, y);
            y = (int)((double)y + (dialogView.getFullBounds().getHeight() + 25.0));
        }
        if (this.topDialogView > 0) {
            y = 0;
            i = dialogViews.listIterator(this.topDialogView);
            while (i.hasPrevious()) {
                dialogView = (InteractionElementView)i.previous();
                if (dialogView instanceof DialogView) {
                    titleBar = ((PageView)((DialogView)dialogView).getChild(0)).getTitleBar();
                    ((DialogView)dialogView).setContentsSelectable(true);
                } else {
                    titleBar = ((Form)dialogView).getTitleBar();
                    ((Form)dialogView).setContentsSelectable(true);
                }
                yOffset = (double)titleBar.getPixelHeight() * titleBar.getTransform().getScaleY();
                y = (int)((double)y - (25.0 + dialogView.getFullBounds().getHeight() + yOffset));
                checkBox = (PPath)this.dialogViewToCheckBox.get(dialogView);
                checkBox.setOffset(0.0, (double)y - yOffset);
                removeButton = (PPath)this.dialogViewToRemoveButton.get(dialogView);
                removeButton.setOffset(0.0, checkBox.getFullBounds().getHeight() + 50.0);
                dialogView.setOffset(removeButton.getFullBounds().getWidth() + 25.0, y);
            }
        }
    }

    protected void layoutChildren() {
        this.addTemplateButton.setOffset(25.0, 25.0);
        PBounds addTemplateButtonFullBounds = this.addTemplateButton.getFullBounds();
        Rectangle2D templatePaneBounds = this.getPathReference().getBounds2D();
        this.upButton.setOffset(templatePaneBounds.getWidth() - 25.0 - this.upButton.getFullBounds().getWidth(), addTemplateButtonFullBounds.getY() + addTemplateButtonFullBounds.getHeight() + 25.0);
        this.downButton.setOffset(templatePaneBounds.getWidth() - 25.0 - this.upButton.getFullBounds().getWidth(), templatePaneBounds.getHeight() - this.downButton.getFullBounds().getHeight() - 25.0);
        this.templateWell.setPathTo(new Rectangle2D.Double(0.0, 0.0, templatePaneBounds.getWidth() - 75.0 - this.upButton.getFullBounds().getWidth(), templatePaneBounds.getHeight() - addTemplateButtonFullBounds.getY() - addTemplateButtonFullBounds.getHeight() - 50.0));
        this.templateWell.setOffset(25.0, addTemplateButtonFullBounds.getY() + addTemplateButtonFullBounds.getHeight() + 25.0);
        this.repositionDialogViews();
    }

    private static class TemplateWell
    extends PPath {
        public boolean paintClipped = true;

        TemplateWell() {
        }

        protected void clipPaint(PPaintContext paintContext) {
            Paint p = this.getPaint();
            if (p != null) {
                Graphics2D g2 = paintContext.getGraphics();
                g2.setPaint(p);
                g2.fill(this.getPathReference());
            }
            paintContext.pushClip(this.getPathReference());
        }

        protected void clipPaintAfterChildren(PPaintContext paintContext) {
            paintContext.popClip(this.getPathReference());
            if (this.getStroke() != null && this.getStrokePaint() != null) {
                Graphics2D g2 = paintContext.getGraphics();
                g2.setPaint(this.getStrokePaint());
                g2.setStroke(this.getStroke());
                g2.draw(this.getPathReference());
            }
        }

        public boolean clipFullPick(PPickPath pickPath) {
            if (this.getPickable() && this.fullIntersects(pickPath.getPickBounds())) {
                pickPath.pushNode(this);
                pickPath.pushTransform(this.getTransformReference(false));
                if (this.pick(pickPath)) {
                    return true;
                }
                if (this.getChildrenPickable() && this.getPathReference().intersects(pickPath.getPickBounds())) {
                    int count = this.getChildrenCount();
                    int i = count - 1;
                    while (i >= 0) {
                        PNode each = this.getChild(i);
                        if (each.fullPick(pickPath)) {
                            return true;
                        }
                        --i;
                    }
                }
                if (this.pickAfterChildren(pickPath)) {
                    return true;
                }
                pickPath.popTransform(this.getTransformReference(false));
                pickPath.popNode(this);
            }
            return false;
        }

        protected void paint(PPaintContext paintContext) {
            if (this.paintClipped) {
                this.clipPaint(paintContext);
            } else {
                super.paint(paintContext);
            }
        }

        protected void paintAfterChildren(PPaintContext paintContext) {
            if (this.paintClipped) {
                this.clipPaintAfterChildren(paintContext);
            } else {
                super.paintAfterChildren(paintContext);
            }
        }

        public boolean fullPick(PPickPath pickPath) {
            if (this.paintClipped) {
                return this.clipFullPick(pickPath);
            }
            return super.fullPick(pickPath);
        }
    }

    private class GraphHandler
    implements ElementContainerListener {
        static final /* synthetic */ boolean $assertionsDisabled;
        static /* synthetic */ Class class$0;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("edu.berkeley.guir.damask.view.TemplatePane$GraphHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        GraphHandler() {
        }

        public void elementAdded(ElementContainerEvent e) {
            DamaskLayer layer = (DamaskLayer)TemplatePane.this.getParent();
            InteractionGraph graph = layer.getDocument().getGraph();
            Object container = e.getSource();
            InteractionElement element = e.getElement();
            if (!$assertionsDisabled && !graph.equals(container)) {
                throw new AssertionError((Object)("ERROR: event source " + container + " is not " + graph));
            }
            if (element instanceof TemplateDialog) {
                TemplateDialog dialog = (TemplateDialog)element;
                TemplatePane.this.addTemplateToWell(layer, dialog);
                TemplatePane.this.repositionDialogViews();
            }
        }

        public void elementRemoved(ElementContainerEvent e) {
            DamaskLayer layer = (DamaskLayer)TemplatePane.this.getParent();
            InteractionGraph graph = layer.getDocument().getGraph();
            Object container = e.getSource();
            InteractionElement element = e.getElement();
            if (!$assertionsDisabled && !graph.equals(container)) {
                throw new AssertionError((Object)("ERROR: event source " + container + " is not " + graph));
            }
            if (element instanceof TemplateDialog) {
                TemplateDialog dialog = (TemplateDialog)element;
                ArrayList<InteractionElementView> templateDialogsToRemove = new ArrayList<InteractionElementView>();
                Iterator i = TemplatePane.this.templateWell.getChildrenIterator();
                while (i.hasNext()) {
                    InteractionElementView dialogView;
                    PNode child = (PNode)i.next();
                    if (!(child instanceof InteractionElementView) || (dialogView = (InteractionElementView)child).getModel() != dialog) continue;
                    templateDialogsToRemove.add(dialogView);
                }
                i = templateDialogsToRemove.iterator();
                while (i.hasNext()) {
                    InteractionElementView dialogView = (InteractionElementView)i.next();
                    TemplatePane.this.templateWell.removeChild(dialogView);
                    CheckBox checkBox = (CheckBox)TemplatePane.this.dialogViewToCheckBox.get(dialogView);
                    PPath removeButton = (PPath)TemplatePane.this.dialogViewToRemoveButton.get(dialogView);
                    int removeButtonIndex = TemplatePane.this.templateWell.indexOfChild(removeButton);
                    if (removeButtonIndex != -1) {
                        TemplatePane.this.templateWell.removeChild(removeButtonIndex);
                    }
                    TemplatePane.this.templateWell.removeChild(checkBox);
                    TemplatePane.this.dialogViewToCheckBox.remove(dialogView);
                    TemplatePane.this.checkBoxToDialog.remove(checkBox);
                    TemplatePane.this.dialogViewToRemoveButton.remove(dialogView);
                    TemplatePane.this.removeButtonToDialog.remove(removeButton);
                }
                TemplatePane.this.repositionDialogViews();
            }
        }
    }

    private class ContentsEventHandler
    extends PBasicInputEventHandler {
        ContentsEventHandler() {
        }

        private DamaskCanvas getCanvas(PInputEvent event) {
            PComponent component = event.getComponent();
            if (component instanceof DamaskCanvas) {
                return (DamaskCanvas)component;
            }
            return null;
        }

        public void mouseEntered(PInputEvent event) {
            DamaskCanvas canvas = this.getCanvas(event);
            if (canvas != null && canvas.getInsideNode() == null) {
                canvas.setCursor(null);
            }
        }

        public void mousePressed(PInputEvent event) {
        }

        public void mouseReleased(PInputEvent event) {
        }

        public void mouseExited(PInputEvent event) {
            DamaskCanvas canvas = this.getCanvas(event);
            if (canvas != null) {
                canvas.setProperCursor();
            }
        }
    }

    private class ButtonEventHandler
    extends PBasicInputEventHandler {
        ButtonEventHandler() {
        }

        public void mousePressed(PInputEvent event) {
            PNode button = event.getPickedNode();
            button.setPaint(PRESSED_BUTTON_COLOR);
            TemplatePane.this.focus = button;
        }

        public void mouseReleased(PInputEvent event) {
            PNode button = event.getPickedNode();
            if (TemplatePane.this.focus == button) {
                button.setPaint(BUTTON_COLOR);
                TemplatePane.this.focus = null;
            }
        }

        public void mouseEntered(PInputEvent event) {
            PNode button = event.getPickedNode();
            if (TemplatePane.this.focus == button) {
                button.setPaint(PRESSED_BUTTON_COLOR);
            }
        }

        public void mouseExited(PInputEvent event) {
            PNode button = event.getPickedNode();
            if (TemplatePane.this.focus == button) {
                button.setPaint(BUTTON_COLOR);
            }
        }
    }

    private class UpButtonEventHandler
    extends PBasicInputEventHandler {
        UpButtonEventHandler() {
        }

        public void mouseReleased(PInputEvent event) {
            if (TemplatePane.this.topDialogView > 0) {
                TemplatePane templatePane = TemplatePane.this;
                templatePane.topDialogView = templatePane.topDialogView - 1;
                TemplatePane.this.repositionDialogViews();
            }
        }
    }

    private class DownButtonEventHandler
    extends PBasicInputEventHandler {
        DownButtonEventHandler() {
        }

        public void mouseReleased(PInputEvent event) {
            if (TemplatePane.this.topDialogView < TemplatePane.this.getViewsOfTemplateDialogs().size() - 1) {
                TemplatePane templatePane = TemplatePane.this;
                templatePane.topDialogView = templatePane.topDialogView + 1;
                TemplatePane.this.repositionDialogViews();
            }
        }
    }

    private class AddTemplateButtonEventHandler
    extends PBasicInputEventHandler {
        AddTemplateButtonEventHandler() {
        }

        public void mouseReleased(PInputEvent event) {
            DamaskCanvas canvas = (DamaskCanvas)event.getComponent();
            InteractionGraph graph = canvas.getDocument().getGraph();
            TemplateDialog newTemplate = new TemplateDialog(DeviceType.ALL, new Content(DeviceType.ALL, "Template " + (graph.getTemplates().size() + 1)));
            canvas.getDocument().getCommandQueue().doCommand(canvas, new AddTemplateCommand(graph, newTemplate));
        }
    }

    private class RemoveTemplateButtonEventHandler
    extends PBasicInputEventHandler {
        RemoveTemplateButtonEventHandler() {
        }

        public void mouseReleased(PInputEvent event) {
            PPath removeButton = (PPath)event.getPickedNode();
            DamaskCanvas canvas = (DamaskCanvas)event.getComponent();
            canvas.getDocument().getCommandQueue().doCommand(canvas, new RemoveTemplateCommand((TemplateDialog)TemplatePane.this.removeButtonToDialog.get(removeButton)));
        }
    }

    private static class CheckBox
    extends PPath {
        private boolean state = false;
        private boolean enabled = true;
        private final PPath checkMark = new PPath();

        public CheckBox() {
            this.init();
        }

        public CheckBox(Shape aShape) {
            super(aShape);
            this.init();
        }

        public CheckBox(Shape aShape, Stroke aStroke) {
            super(aShape, aStroke);
            this.init();
        }

        private void init() {
            this.setStrokePaint(Color.BLACK);
            this.checkMark.moveTo(3.0f, 7.5f);
            this.checkMark.lineTo(6.0f, 12.0f);
            this.checkMark.lineTo(12.0f, 3.0f);
            this.checkMark.setStrokePaint(Color.BLACK);
            this.checkMark.setPickable(false);
        }

        public void setState(boolean state) {
            this.state = state;
            if (state) {
                this.addChild(this.checkMark);
            } else {
                this.removeAllChildren();
            }
        }

        public boolean getState() {
            return this.state;
        }

        public void setEnabled(boolean flag) {
            this.enabled = flag;
            if (this.enabled) {
                this.setStrokePaint(Color.BLACK);
                this.checkMark.setStrokePaint(Color.BLACK);
            } else {
                this.setStrokePaint(Color.LIGHT_GRAY);
                this.checkMark.setStrokePaint(Color.LIGHT_GRAY);
            }
        }

        public boolean isEnabled() {
            return this.enabled;
        }
    }

    private class CheckBoxEventHandler
    extends PBasicInputEventHandler {
        CheckBoxEventHandler() {
        }

        public void mousePressed(PInputEvent event) {
            CheckBox checkBox = (CheckBox)event.getPickedNode();
            if (checkBox.isEnabled()) {
                checkBox.setPaint(Color.LIGHT_GRAY);
                TemplatePane.this.focus = checkBox;
            }
        }

        public void mouseReleased(PInputEvent event) {
            CheckBox checkBox = (CheckBox)event.getPickedNode();
            if (TemplatePane.this.focus == checkBox) {
                checkBox.setPaint(DamaskAppUtils.NO_COLOR);
                boolean newState = !checkBox.getState();
                checkBox.setState(newState);
                if (TemplatePane.this.selectedPage != null) {
                    DamaskCanvas canvas = (DamaskCanvas)event.getComponent();
                    Page pageTemplate = ((Dialog)TemplatePane.this.checkBoxToDialog.get(checkBox)).getFirstPage(((DamaskLayer)TemplatePane.this.getParent()).getDeviceType());
                    UndoableCommand command = newState ? new ApplyTemplateToPageCommand(TemplatePane.this.selectedPage, pageTemplate) : new UnapplyTemplateToPageCommand(TemplatePane.this.selectedPage, pageTemplate);
                    canvas.getDocument().getCommandQueue().doCommand(canvas, command);
                }
            }
            TemplatePane.this.focus = null;
        }

        public void mouseEntered(PInputEvent event) {
            PNode checkBox = event.getPickedNode();
            if (TemplatePane.this.focus == checkBox) {
                checkBox.setPaint(Color.LIGHT_GRAY);
            }
        }

        public void mouseExited(PInputEvent event) {
            PNode checkBox = event.getPickedNode();
            if (TemplatePane.this.focus == checkBox) {
                checkBox.setPaint(DamaskAppUtils.NO_COLOR);
            }
        }
    }

    private class CanvasHandler
    implements CanvasListener {
        static final /* synthetic */ boolean $assertionsDisabled;
        static /* synthetic */ Class class$0;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("edu.berkeley.guir.damask.view.TemplatePane$CanvasHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        CanvasHandler() {
        }

        public void selectionChanged(CanvasEvent e) {
        }

        public void selectedPageChanged(CanvasEvent e) {
            if (!$assertionsDisabled && e.getCanvas() != TemplatePane.this.visibleCamera.getComponent()) {
                throw new AssertionError((Object)"Not listening to the correct canvas");
            }
            TemplatePane.this.selectedPage = e.getCanvas().getSelectedPage();
            TemplatePane.this.updateCheckBoxes();
        }
    }
}

