/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.view;

import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.InteractionElement;
import edu.berkeley.guir.damask.event.InteractionElementEvent;
import edu.berkeley.guir.damask.event.InteractionElementListener;
import edu.berkeley.guir.damask.view.DamaskCamera;
import edu.berkeley.guir.damask.view.DamaskLayer;
import edu.berkeley.guir.damask.view.nodes.DamaskPPath;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PAffineTransform;
import edu.umd.cs.piccolo.util.PPaintContext;
import edu.umd.cs.piccolo.util.PPickPath;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;

public abstract class InteractionElementView
extends DamaskPPath {
    private final InteractionElement model;
    private boolean selectable = true;
    private boolean movable = true;
    private boolean resizable = true;
    private boolean stretchedWhenResized = true;
    private boolean useStickyZHandles = true;
    private final InteractionElementListener elementHandler = new ElementHandler();
    private final PropertyChangeListener parentChildrenChangeHandler = new ParentChildrenChangeHandler();

    protected InteractionElementView(InteractionElement model) {
        this(model, true);
    }

    protected InteractionElementView(InteractionElement model, boolean useDefaultElementListener) {
        this.model = model;
        if (useDefaultElementListener && model != null) {
            model.addInteractionElementListener(this.elementHandler);
        }
        this.addPropertyChangeListener("parent", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (InteractionElementView.this.getParent() != null) {
                    InteractionElementView.this.getParent().addPropertyChangeListener("children", InteractionElementView.this.parentChildrenChangeHandler);
                }
            }
        });
    }

    protected void initAfterAddToParent() {
        InteractionElement model = this.getModel();
        if (model != null) {
            DeviceType deviceType = this.getDeviceType();
            Rectangle2D bounds = model.getBounds(deviceType);
            if (bounds != null) {
                this.setBounds(bounds);
                this.setPathTo(bounds);
            }
            this.setTransform(model.getTransform(deviceType));
        }
        this.getParent().removePropertyChangeListener("children", this.parentChildrenChangeHandler);
    }

    public void dispose() {
        Iterator i = this.getChildrenIterator();
        while (i.hasNext()) {
            PNode child = (PNode)i.next();
            if (!(child instanceof InteractionElementView)) continue;
            ((InteractionElementView)child).dispose();
        }
        if (this.model != null) {
            this.model.removeInteractionElementListener(this.elementHandler);
        }
    }

    public final DamaskLayer getLayer() {
        PNode ancestor = this;
        while (ancestor != null) {
            if ((ancestor = ancestor.getParent()) instanceof DamaskLayer) {
                return (DamaskLayer)ancestor;
            }
            if (!(ancestor instanceof DamaskCamera)) continue;
            return (DamaskLayer)((DamaskCamera)ancestor).getLayer(0);
        }
        return null;
    }

    public InteractionElement getModel() {
        return this.model;
    }

    public boolean isSelectable() {
        return this.selectable;
    }

    public void setSelectable(boolean flag) {
        this.selectable = flag;
    }

    public boolean isResizable() {
        return this.resizable;
    }

    public void setResizable(boolean flag) {
        this.resizable = flag;
    }

    public boolean isStretchedWhenResized() {
        return this.stretchedWhenResized;
    }

    public void setStretchedWhenResized(boolean flag) {
        this.stretchedWhenResized = flag;
    }

    public boolean isMovable() {
        return this.movable;
    }

    public void setMovable(boolean flag) {
        this.movable = flag;
    }

    public boolean getUseStickyZHandles() {
        return this.useStickyZHandles;
    }

    public void setUseStickyZHandles(boolean flag) {
        this.useStickyZHandles = flag;
    }

    public abstract DeviceType getDeviceType();

    protected void clipPaint(PPaintContext paintContext) {
        Paint p = this.getPaint();
        if (p != null) {
            Graphics2D g2 = paintContext.getGraphics();
            g2.setPaint(p);
            g2.fill(this.getPathReference());
        }
        paintContext.pushClip(this.getPathReference());
    }

    protected void clipPaintAfterChildren(PPaintContext paintContext) {
        paintContext.popClip(this.getPathReference());
        if (this.getStroke() != null && this.getStrokePaint() != null) {
            Graphics2D g2 = paintContext.getGraphics();
            g2.setPaint(this.getStrokePaint());
            g2.setStroke(this.getStroke());
            g2.draw(this.getPathReference());
        }
    }

    public boolean clipFullPick(PPickPath pickPath) {
        if (this.getPickable() && this.fullIntersects(pickPath.getPickBounds())) {
            pickPath.pushNode(this);
            pickPath.pushTransform(this.getTransformReference(false));
            if (this.pick(pickPath)) {
                return true;
            }
            if (this.getChildrenPickable() && this.getPathReference().intersects(pickPath.getPickBounds())) {
                int count = this.getChildrenCount();
                int i = count - 1;
                while (i >= 0) {
                    PNode each = this.getChild(i);
                    if (each.fullPick(pickPath)) {
                        return true;
                    }
                    --i;
                }
            }
            if (this.pickAfterChildren(pickPath)) {
                return true;
            }
            pickPath.popTransform(this.getTransformReference(false));
            pickPath.popNode(this);
        }
        return false;
    }

    public InteractionElementListener getElementHandler() {
        return this.elementHandler;
    }

    private class ElementHandler
    implements InteractionElementListener {
        ElementHandler() {
        }

        public void elementBoundsUpdated(InteractionElementEvent e) {
            if (e.getDeviceType() == InteractionElementView.this.getDeviceType()) {
                Rectangle2D bounds = e.getElement().getBounds(e.getDeviceType());
                if (bounds == null) {
                    InteractionElementView.this.resetBounds();
                } else {
                    InteractionElementView.this.setBounds(bounds);
                }
            }
        }

        public void elementTransformUpdated(InteractionElementEvent e) {
            if (e.getDeviceType() == InteractionElementView.this.getDeviceType()) {
                AffineTransform newTransform = e.getElement().getTransform(e.getDeviceType());
                PAffineTransform oldTransform = InteractionElementView.this.getTransform();
                if (!oldTransform.equals(newTransform)) {
                    InteractionElementView.this.setTransform(newTransform);
                }
            }
        }

        public void elementBorderUpdated(InteractionElementEvent e) {
        }
    }

    private class ParentChildrenChangeHandler
    implements PropertyChangeListener {
        ParentChildrenChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            InteractionElementView.this.initAfterAddToParent();
            InteractionElementView.this.getParent().removePropertyChangeListener("children", InteractionElementView.this.parentChildrenChangeHandler);
        }
    }
}

