/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.view;

import edu.berkeley.guir.damask.view.DamaskAppUtils;
import edu.berkeley.guir.damask.view.DamaskCanvas;
import edu.berkeley.guir.damask.view.DamaskFrame;
import edu.berkeley.guir.damask.view.appevent.CanvasEvent;
import edu.berkeley.guir.damask.view.appevent.CanvasListener;
import edu.berkeley.guir.damask.view.visual.VisualCanvas;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DamaskToolbar
extends JToolBar {
    private DamaskFrame currentFrame = null;
    private DamaskCanvas currentCanvas = null;
    private final CanvasListener canvasHandler = new CanvasHandler();
    private final ChangeListener canvasChangeHandler = new CanvasChangeHandler();
    private JButton cutButton = new JButton();
    private JButton copyButton = new JButton();
    private JButton pasteButton = new JButton();
    private JButton deleteButton = new JButton();
    private JButton groupButton = new JButton();
    private JButton ungroupButton = new JButton();
    private JButton changeLayerOfObjectButton = new JButton();
    private JButton runButton = new JButton();
    private JButton runFromHomeButton = new JButton();
    private OutputModality currentModality;
    private final Map outputSpecificTools = new HashMap();
    private static final int FIRST_OUTPUT_SPECIFIC_TOOL_INDEX = 16;
    private static final String PLATFORM_NAME = DamaskAppUtils.isUsingSystemLookAndFeel() ? (DamaskAppUtils.isMac() ? "mac" : (DamaskAppUtils.isWindows() ? (DamaskAppUtils.isWindowsXP() ? "win_xp" : "win") : "java")) : "java";
    static /* synthetic */ Class class$0;

    public DamaskToolbar() {
        super(0);
        this.setFloatable(false);
    }

    private void setupButton(JButton button) {
        Action action = button.getAction();
        if (action.getValue("SmallIcon") == null) {
            button.setText((String)action.getValue("Name"));
        } else {
            button.setText("");
            button.setMaximumSize(new Dimension(button.getMaximumSize().width, Integer.MAX_VALUE));
        }
        if (action != null) {
            button.setDisabledIcon((Icon)action.getValue("Disabled icon"));
        }
        button.setHorizontalAlignment(2);
    }

    private void addButton(JButton newButton) {
        this.addButton(newButton, this.getComponentCount());
    }

    private void addButton(JButton newButton, int index) {
        this.add((Component)newButton, index);
    }

    private void addButtons(List newButtons, int index) {
        Iterator i = newButtons.iterator();
        while (i.hasNext()) {
            JButton newButton = (JButton)i.next();
            if (newButton == null) {
                this.addSeparator(index);
            } else {
                this.addButton(newButton, index);
                this.setupButton(newButton);
            }
            ++index;
        }
    }

    private void addSeparator(int index) {
        JToolBar.Separator s = new JToolBar.Separator(null);
        if (this.getOrientation() == 1) {
            s.setOrientation(0);
        } else {
            s.setOrientation(1);
        }
        this.add((Component)s, index);
    }

    public void initialize() {
        ArrayList<JButton> visualButtons = new ArrayList<JButton>();
        this.outputSpecificTools.put(OutputModality.VISUAL, visualButtons);
        visualButtons.add(this.groupButton);
        visualButtons.add(this.ungroupButton);
        ArrayList voiceButtons = new ArrayList();
        this.outputSpecificTools.put(OutputModality.VOICE, voiceButtons);
        DamaskFrame frame = (DamaskFrame)SwingUtilities.getRoot(this);
        JButton newButton = new JButton(frame.getNewAction());
        this.addButton(newButton);
        this.setupButton(newButton);
        JButton openButton = new JButton(frame.getOpenAction());
        this.addButton(openButton);
        this.setupButton(openButton);
        JButton saveButton = new JButton(frame.getSaveAction());
        this.addButton(saveButton);
        this.setupButton(saveButton);
        this.addSeparator();
        this.addButton(this.cutButton);
        this.addButton(this.copyButton);
        this.addButton(this.pasteButton);
        this.addButton(this.deleteButton);
        this.addSeparator();
        JButton undoButton = new JButton(frame.getUndoAction());
        this.addButton(undoButton);
        this.setupButton(undoButton);
        JButton redoButton = new JButton(frame.getRedoAction());
        this.addButton(redoButton);
        this.setupButton(redoButton);
        this.addSeparator();
        this.addButton(this.changeLayerOfObjectButton);
        this.changeLayerOfObjectButton.setVisible(true);
        this.addSeparator();
        this.addButton(this.runFromHomeButton);
        this.addButton(this.runButton);
        this.setCurrentFrame(frame);
        this.currentModality = OutputModality.VISUAL;
    }

    public static ImageIcon getToolbarIcon(String fileName) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.damask.view.DamaskApp");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Image image = toolkit.createImage(clazz.getResource("images/toolbar/" + PLATFORM_NAME + "/normal/" + fileName));
        return new ImageIcon(image);
    }

    public static ImageIcon getToolbarDisabledIcon(String fileName) {
        URL disabledIconURL;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.damask.view.DamaskApp");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((disabledIconURL = clazz.getResource("images/toolbar/" + PLATFORM_NAME + "/disabled/" + fileName)) == null) {
            return null;
        }
        Image image = Toolkit.getDefaultToolkit().createImage(disabledIconURL);
        return new ImageIcon(image);
    }

    private DamaskFrame getCurrentFrame() {
        return this.currentFrame;
    }

    private void setCurrentFrame(DamaskFrame currentFrame) {
        if (currentFrame != null) {
            currentFrame.removeCanvasChangeListener(this.canvasChangeHandler);
        }
        this.currentFrame = currentFrame;
        if (currentFrame != null) {
            this.setCurrentCanvas(currentFrame.getCurrentCanvas());
            currentFrame.addCanvasChangeListener(this.canvasChangeHandler);
        }
    }

    private void setCurrentCanvas(DamaskCanvas canvas) {
        if (this.currentCanvas != null) {
            this.currentCanvas.removeCanvasListener(this.canvasHandler);
        }
        this.currentCanvas = canvas;
        if (this.currentCanvas != null) {
            this.currentCanvas.addCanvasListener(this.canvasHandler);
            this.updateDeviceTypeSpecificTools();
        }
    }

    private void updateDeviceTypeSpecificTools() {
        while (this.getComponentAtIndex(16) != null) {
            this.remove(16);
        }
        this.cutButton.setAction(this.currentCanvas.getCutAction());
        this.setupButton(this.cutButton);
        this.copyButton.setAction(this.currentCanvas.getCopyAction());
        this.setupButton(this.copyButton);
        this.pasteButton.setAction(this.currentCanvas.getPasteAction());
        this.setupButton(this.pasteButton);
        this.deleteButton.setAction(this.currentCanvas.getDeleteAction());
        this.setupButton(this.deleteButton);
        this.runFromHomeButton.setAction(this.currentCanvas.getRunFromHomeAction());
        this.setupButton(this.runFromHomeButton);
        this.runButton.setAction(this.currentCanvas.getRunFromSelectedPageAction());
        this.setupButton(this.runButton);
        this.changeLayerOfObjectButton.setAction(this.currentCanvas.getChangeLayerOfObjectAction());
        if (this.currentCanvas.getDeviceType().isVisual()) {
            this.currentModality = OutputModality.VISUAL;
            this.groupButton.setAction(((VisualCanvas)this.currentCanvas).getGroupStrokesAction());
            this.ungroupButton.setAction(((VisualCanvas)this.currentCanvas).getUngroupStrokesAction());
        } else {
            this.currentModality = OutputModality.VOICE;
        }
        List newButtons = (List)this.outputSpecificTools.get(this.currentModality);
        if (!newButtons.isEmpty()) {
            this.addSeparator(16);
            this.addButtons(newButtons, 17);
        }
        this.repaint();
    }

    public static class OutputModality {
        private String name;
        public static final OutputModality VISUAL = new OutputModality("Visual");
        public static final OutputModality VOICE = new OutputModality("Voice");

        private OutputModality(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    private class CanvasChangeHandler
    implements ChangeListener {
        CanvasChangeHandler() {
        }

        public void stateChanged(ChangeEvent e) {
            DamaskToolbar.this.setCurrentCanvas(DamaskToolbar.this.getCurrentFrame().getCurrentCanvas());
        }
    }

    private class CanvasHandler
    implements CanvasListener {
        static final /* synthetic */ boolean $assertionsDisabled;
        static /* synthetic */ Class class$0;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("edu.berkeley.guir.damask.view.DamaskToolbar$CanvasHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        CanvasHandler() {
        }

        public void selectionChanged(CanvasEvent e) {
            if (!$assertionsDisabled && e.getCanvas() != DamaskToolbar.this.currentCanvas) {
                throw new AssertionError((Object)("should be receiving events from " + DamaskToolbar.this.currentCanvas + ", not " + e.getCanvas()));
            }
        }

        public void selectedPageChanged(CanvasEvent e) {
        }
    }
}

