/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.view;

import edu.berkeley.guir.damask.DamaskUtils;
import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.dialog.Page;
import edu.berkeley.guir.damask.view.DamaskAppUtils;
import edu.berkeley.guir.damask.view.appevent.RunCanvasEvent;
import edu.berkeley.guir.damask.view.appevent.RunCanvasListener;
import edu.berkeley.guir.damask.view.visual.DamaskRunCanvas;
import edu.umd.cs.piccolox.swing.PScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JToolBar;

public class DamaskRunFrame
extends JFrame {
    private final DamaskRunCanvas canvas;
    private JButton backButton;
    private JButton forwardButton;
    private final PScrollPane scrollPane;
    private static final Logger logger;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.damask.view.visual.DamaskPhoneRunFrame");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getName());
    }

    public DamaskRunFrame(String documentName, Page page) {
        DeviceType deviceType = page.getDeviceType();
        this.setTitle(String.valueOf(documentName) + " [Run - " + deviceType + "] - Damask");
        this.canvas = new DamaskRunCanvas();
        this.canvas.addRunCanvasListener(new RunCanvasHandler());
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.scrollPane = new PScrollPane(this.canvas);
        this.canvas.setContainingScrollPane(this.scrollPane);
        contentPane.add((Component)this.scrollPane, "Center");
        JToolBar toolBar = new JToolBar();
        this.backButton = DamaskAppUtils.createBackButton(new BackAction());
        this.backButton.setEnabled(false);
        this.forwardButton = DamaskAppUtils.createForwardButton(new ForwardAction());
        this.forwardButton.setEnabled(false);
        toolBar.add(this.backButton);
        toolBar.add(this.forwardButton);
        toolBar.setFloatable(false);
        contentPane.add((Component)toolBar, "North");
        this.canvas.goToPage(page);
        this.setVisible(true);
        Insets insets = this.getInsets();
        this.canvas.setPreferredSize(new Dimension(deviceType.getDefaultWidth() + insets.left + insets.right, deviceType.getDefaultHeight() + (int)this.canvas.getCurrentPageView().getOffset().getY() + insets.top + insets.bottom));
        this.scrollPane.getViewport().setViewPosition(new Point(0, 0));
        this.pack();
        WindowHandler winHandler = new WindowHandler();
        this.addWindowListener(winHandler);
        this.addWindowFocusListener(winHandler);
        logger.info(this + " opened with view of " + this.canvas.getCurrentPageView().getModel());
    }

    protected void updateButtonsEnabled() {
        this.backButton.setEnabled(this.canvas.canGoBack());
        this.forwardButton.setEnabled(this.canvas.canGoForward());
    }

    public String toString() {
        return DamaskUtils.toShortString(this);
    }

    private class BackAction
    extends AbstractAction {
        public BackAction() {
            super("Back");
            this.putValue("ShortDescription", "Go back to the previous page");
            this.putValue("MnemonicKey", new Integer(37));
        }

        public void actionPerformed(ActionEvent e) {
            DamaskRunFrame.this.canvas.goBack();
            logger.info(DamaskRunFrame.this + ": back -> " + DamaskRunFrame.this.canvas.getCurrentPageView().getModel());
        }
    }

    private class ForwardAction
    extends AbstractAction {
        public ForwardAction() {
            super("Forward");
            this.putValue("ShortDescription", "Go forward to the next page");
            this.putValue("MnemonicKey", new Integer(39));
        }

        public void actionPerformed(ActionEvent e) {
            DamaskRunFrame.this.canvas.goForward();
            logger.info(DamaskRunFrame.this + ": forward -> " + DamaskRunFrame.this.canvas.getCurrentPageView().getModel());
        }
    }

    private class RunCanvasHandler
    implements RunCanvasListener {
        RunCanvasHandler() {
        }

        public void loadCompleted(RunCanvasEvent e) {
            DamaskRunFrame.this.updateButtonsEnabled();
            logger.info(DamaskRunFrame.this + " loaded with view of " + DamaskRunFrame.this.canvas.getCurrentPageView().getModel());
            DamaskRunFrame.this.scrollPane.getVerticalScrollBar().setValue(DamaskRunFrame.this.scrollPane.getVerticalScrollBar().getMinimum());
        }
    }

    private class WindowHandler
    extends WindowAdapter {
        WindowHandler() {
        }

        public void windowClosing(WindowEvent e) {
            logger.info(DamaskRunFrame.this + " closed");
        }

        public void windowGainedFocus(WindowEvent e) {
            logger.info(DamaskRunFrame.this + " gained focus");
        }

        public void windowLostFocus(WindowEvent e) {
            logger.info(DamaskRunFrame.this + " lost focus");
        }
    }
}

