/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.view;

import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.view.DamaskAppUtils;
import edu.berkeley.guir.damask.view.DamaskCamera;
import edu.berkeley.guir.damask.view.DamaskCanvas;
import edu.berkeley.guir.damask.view.DamaskFrame;
import edu.berkeley.guir.damask.view.DamaskLayer;
import edu.berkeley.guir.damask.view.appevent.DocumentEvent;
import edu.berkeley.guir.damask.view.appevent.DocumentListener;
import edu.berkeley.guir.damask.view.nodes.SizingBorder;
import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.PRoot;
import edu.umd.cs.piccolo.activities.PActivity;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PDimension;
import edu.umd.cs.piccolox.util.PBoundsLocator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DamaskRadarDialog
extends JDialog {
    private static double DEFAULT_SCALE = 0.1;
    private static double PAGE_TITLE_SCALE = 0.25;
    private static Logger logger;
    private final PCanvas radarCanvas;
    private final CanvasEventHandler radarCanvasHandler = new CanvasEventHandler();
    private final DamaskFrame mainFrame;
    private DamaskCamera mainCamera = null;
    private PropertyChangeListener mainCameraHandler = null;
    private boolean listenToMainCamera = true;
    private PPath rectangle = null;
    private RectangleHandler rectHandler = null;
    private final PanActivity panActivity = new PanActivity(-1L);
    private final int PAN_JUMP = 10;
    private boolean panActive = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.damask.view.DamaskRadarDialog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getName());
    }

    public DamaskRadarDialog(final DamaskFrame frame) {
        super((Frame)frame, "Thumbnail");
        this.radarCanvas = new PCanvas();
        this.mainFrame = frame;
        frame.getDocument().addDocumentListener(new DocumentHandler());
        this.updateTitleBar();
        this.listenToCanvas(frame.getCurrentCanvas());
        frame.addCanvasChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                DamaskRadarDialog.this.listenToCanvas(frame.getCurrentCanvas());
            }
        });
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        mainPanel.add((Component)this.radarCanvas, "Center");
        JButton topButton = new JButton(DamaskRadarDialog.getRadarIcon("top.gif"));
        JButton bottomButton = new JButton(DamaskRadarDialog.getRadarIcon("bottom.gif"));
        JButton leftButton = new JButton(DamaskRadarDialog.getRadarIcon("left.gif"));
        JButton rightButton = new JButton(DamaskRadarDialog.getRadarIcon("right.gif"));
        leftButton.setMargin(new Insets(0, 3, 0, 3));
        rightButton.setMargin(new Insets(0, 3, 0, 3));
        topButton.addMouseListener(new PanButtonMouseHandler(0.0, 1.0));
        bottomButton.addMouseListener(new PanButtonMouseHandler(0.0, -1.0));
        rightButton.addMouseListener(new PanButtonMouseHandler(-1.0, 0.0));
        leftButton.addMouseListener(new PanButtonMouseHandler(1.0, 0.0));
        mainPanel.add((Component)topButton, "North");
        mainPanel.add((Component)bottomButton, "South");
        mainPanel.add((Component)rightButton, "East");
        mainPanel.add((Component)leftButton, "West");
        JToolBar sliderBar = new JToolBar();
        sliderBar.setFloatable(false);
        sliderBar.setLayout(new BorderLayout());
        final JSlider slider = new JSlider(1, 1, 13, 7);
        slider.setInverted(true);
        sliderBar.add((Component)slider, "Center");
        slider.addChangeListener(new SliderHandler());
        JButton zoomOutButton = new JButton(DamaskRadarDialog.getRadarIcon("zoom_out.png"));
        zoomOutButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                slider.setValue(slider.getValue() - 1);
            }
        });
        sliderBar.add((Component)zoomOutButton, "North");
        JButton zoomInButton = new JButton(DamaskRadarDialog.getRadarIcon("zoom_in.png"));
        zoomInButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                slider.setValue(slider.getValue() + 1);
            }
        });
        sliderBar.add((Component)zoomInButton, "South");
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)sliderBar, "Before");
        this.getContentPane().add((Component)mainPanel, "Center");
        this.setSize(250, 250);
        this.radarCanvas.getCamera().scaleView(DEFAULT_SCALE);
        this.radarCanvas.addInputEventListener(this.radarCanvasHandler);
        WindowHandler winHandler = new WindowHandler();
        this.addWindowListener(winHandler);
        this.addWindowFocusListener(winHandler);
    }

    private void listenToCanvas(DamaskCanvas canvas) {
        if (this.mainCamera != null) {
            this.mainCamera.removePropertyChangeListener(this.mainCameraHandler);
        }
        this.mainCamera = (DamaskCamera)canvas.getCamera();
        this.mainCameraHandler = new MainCameraHandler(this.mainCamera);
        this.mainCamera.addPropertyChangeListener(this.mainCameraHandler);
        DeviceType deviceType = canvas.getDeviceType();
        PLayer layer = this.radarCanvas.getLayer();
        this.radarCanvas.getRoot().removeChild(layer);
        PCamera radarCamera = this.radarCanvas.getCamera();
        radarCamera.removeLayer(layer);
        DamaskLayer damaskLayer = DamaskLayer.create(canvas.getDocument(), deviceType, PAGE_TITLE_SCALE);
        damaskLayer.getTemplatePane().setVisibleToCamera(null);
        this.radarCanvas.getRoot().addChild(damaskLayer);
        radarCamera.addLayer(0, damaskLayer);
        this.radarCanvas.removeInputEventListener(this.radarCanvas.getPanEventHandler());
        if (this.rectangle != null) {
            radarCamera.removeChild(this.rectangle);
        }
        this.rectangle = new PPath();
        this.rectangle.setPaint(DamaskAppUtils.NO_COLOR);
        this.rectangle.setStrokePaint(Color.RED);
        radarCamera.addChild(this.rectangle);
        radarCamera.setPaint((Color)DamaskCanvas.BACKGROUND_PAINTS.get(deviceType, DamaskLayer.DeviceTypeLayer.DEVICE));
        if (this.rectHandler != null) {
            this.rectangle.removeInputEventListener(this.rectHandler);
        }
        this.rectHandler = new RectangleHandler(canvas);
        this.rectangle.addInputEventListener(this.rectHandler);
        ConstraintSizingBorder.addConstraintSizingBordersTo(this.rectangle, canvas, this);
        this.syncRectangleWithCamera(this.mainCamera);
        this.radarCanvasHandler.setMainCanvas(canvas);
    }

    private void syncRectangleWithCamera(PCamera camera) {
        PBounds bounds = camera.getViewBounds();
        this.radarCanvas.getCamera().viewToLocal(bounds);
        this.rectangle.globalToLocal(bounds);
        this.rectangle.setPathTo(bounds);
    }

    public void panCamera(double dx, double dy) {
        PCamera camera = this.radarCanvas.getCamera();
        camera.translateView(dx * 10.0 / camera.getViewScale(), dy * 10.0 / camera.getViewScale());
        this.rectangle.translate(dx * 10.0, dy * 10.0);
    }

    public void setPanning(boolean flag) {
        this.panActive = flag;
        if (this.panActive) {
            PRoot root = this.radarCanvas.getRoot();
            this.panCamera(this.panActivity.getDx(), this.panActivity.getDy());
            this.panActivity.setStartTime(root.getGlobalTime() + 500L);
            root.addActivity(this.panActivity);
        } else {
            this.panActivity.terminate();
        }
    }

    public void setVisible(boolean flag) {
        super.setVisible(flag);
        if (flag) {
            logger.info(this.mainFrame + ": Radar view visible");
        } else {
            logger.info(this.mainFrame + ": Radar view not visible");
        }
        this.mainFrame.onRadarDialogVisibleChanged(flag);
    }

    public static ImageIcon getRadarIcon(String fileName) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("edu.berkeley.guir.damask.view.DamaskApp");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Image image = toolkit.createImage(clazz.getResource("images/radar/" + fileName));
        return new ImageIcon(image);
    }

    private void updateTitleBar() {
        final String titleBarString = "Thumbnail - " + new StringBuffer(this.mainFrame.getFileNameInTitleBar());
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DamaskRadarDialog.this.setTitle(titleBarString);
            }
        });
    }

    private class PanActivity
    extends PActivity {
        private double dx;
        private double dy;

        PanActivity(long aDuration) {
            super(aDuration);
        }

        PanActivity(long aDuration, long aStepRate) {
            super(aDuration, aStepRate);
        }

        PanActivity(long aDuration, long aStepRate, long aStartTime) {
            super(aDuration, aStepRate, aStartTime);
        }

        protected void activityStep(long elapsedTime) {
            super.activityStep(elapsedTime);
            DamaskRadarDialog.this.panCamera(this.dx, this.dy);
        }

        public double getDx() {
            return this.dx;
        }

        public double getDy() {
            return this.dy;
        }

        public void setDirection(double dx, double dy) {
            this.dx = dx;
            this.dy = dy;
        }
    }

    private class PanButtonMouseHandler
    implements MouseListener {
        private double dx;
        private double dy;

        public PanButtonMouseHandler(double x, double y) {
            this.dx = x;
            this.dy = y;
        }

        public void mouseClicked(MouseEvent event) {
        }

        public void mouseEntered(MouseEvent event) {
        }

        public void mouseExited(MouseEvent event) {
        }

        public void mousePressed(MouseEvent event) {
            DamaskRadarDialog.this.panActivity.setDirection(this.dx, this.dy);
            DamaskRadarDialog.this.setPanning(true);
        }

        public void mouseReleased(MouseEvent event) {
            DamaskRadarDialog.this.setPanning(false);
        }
    }

    private class RectangleHandler
    extends PBasicInputEventHandler {
        private DamaskCanvas mainCanvas;

        public RectangleHandler(DamaskCanvas canvas) {
            this.mainCanvas = canvas;
        }

        public void mouseDragged(PInputEvent aEvent) {
            PDimension delta = aEvent.getDeltaRelativeTo(DamaskRadarDialog.this.rectangle);
            DamaskRadarDialog.this.rectangle.translate(((Dimension2D)delta).getWidth(), ((Dimension2D)delta).getHeight());
            aEvent.setHandled(true);
            double scale = DamaskRadarDialog.this.radarCanvas.getCamera().getViewScale();
            DamaskRadarDialog.this.radarCanvas.getCamera().localToGlobal(delta);
            this.mainCanvas.getCamera().translateView(((Dimension2D)delta).getWidth() / -scale, ((Dimension2D)delta).getHeight() / -scale);
            DamaskRadarDialog.this.listenToMainCamera = false;
        }

        public void mouseClicked(PInputEvent aEvent) {
            PBounds rectBounds = DamaskRadarDialog.this.rectangle.getBounds();
            Point2D mousePosition = aEvent.getPositionRelativeTo(DamaskRadarDialog.this.rectangle);
            PDimension delta = new PDimension(mousePosition.getX() - rectBounds.getCenterX(), mousePosition.getY() - rectBounds.getCenterY());
            DamaskRadarDialog.this.rectangle.translate(((Dimension2D)delta).getWidth(), ((Dimension2D)delta).getHeight());
            aEvent.setHandled(true);
            double scale = DamaskRadarDialog.this.radarCanvas.getCamera().getViewScale();
            DamaskRadarDialog.this.radarCanvas.getCamera().localToGlobal(delta);
            this.mainCanvas.getCamera().translateView(((Dimension2D)delta).getWidth() / -scale, ((Dimension2D)delta).getHeight() / -scale);
            DamaskRadarDialog.this.listenToMainCamera = false;
        }
    }

    private class CanvasEventHandler
    extends PBasicInputEventHandler {
        private DamaskCanvas mainCanvas = null;

        CanvasEventHandler() {
        }

        public void setMainCanvas(DamaskCanvas canvas) {
            this.mainCanvas = canvas;
        }

        public void mouseClicked(PInputEvent aEvent) {
            if (this.mainCanvas != null) {
                PBounds rectBounds = DamaskRadarDialog.this.rectangle.getBounds();
                Point2D mousePosition = aEvent.getPosition();
                ((PCanvas)aEvent.getComponent()).getCamera().viewToLocal(mousePosition);
                DamaskRadarDialog.this.rectangle.globalToLocal(mousePosition);
                PDimension delta = new PDimension(mousePosition.getX() - rectBounds.getCenterX(), mousePosition.getY() - rectBounds.getCenterY());
                DamaskRadarDialog.this.rectangle.translate(((Dimension2D)delta).getWidth(), ((Dimension2D)delta).getHeight());
                aEvent.setHandled(true);
                double scale = DamaskRadarDialog.this.radarCanvas.getCamera().getViewScale();
                DamaskRadarDialog.this.radarCanvas.getCamera().localToGlobal(delta);
                this.mainCanvas.getCamera().translateView(((Dimension2D)delta).getWidth() / -scale, ((Dimension2D)delta).getHeight() / -scale);
                DamaskRadarDialog.this.listenToMainCamera = false;
            }
        }
    }

    private class SliderHandler
    implements ChangeListener {
        SliderHandler() {
        }

        private double scaleFactor(int zoomLevel) {
            return DamaskCanvas.scaleFactor(zoomLevel) * DEFAULT_SCALE;
        }

        public void stateChanged(ChangeEvent e) {
            PCamera camera = DamaskRadarDialog.this.radarCanvas.getCamera();
            PBounds bounds = camera.getViewBounds();
            camera.scaleViewAboutPoint(this.scaleFactor(((JSlider)e.getSource()).getValue()) / camera.getViewScale(), bounds.getCenterX(), bounds.getCenterY());
            DamaskRadarDialog.this.syncRectangleWithCamera(DamaskRadarDialog.this.mainCamera);
        }
    }

    private class MainCameraHandler
    implements PropertyChangeListener {
        private PCamera mainCamera;
        int n = 3;

        public MainCameraHandler(PCamera p) {
            this.mainCamera = p;
        }

        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("viewTransform") || e.getPropertyName().equals("bounds") || e.getPropertyName().equals("fullBounds")) {
                if (DamaskRadarDialog.this.listenToMainCamera) {
                    DamaskRadarDialog.this.syncRectangleWithCamera(this.mainCamera);
                }
                DamaskRadarDialog.this.listenToMainCamera = true;
            }
        }
    }

    private class DocumentHandler
    implements DocumentListener {
        DocumentHandler() {
        }

        public void documentModified(DocumentEvent e) {
            if (e.getDocument() == DamaskRadarDialog.this.mainFrame.getDocument()) {
                DamaskRadarDialog.this.updateTitleBar();
            }
        }

        public void documentCleaned(DocumentEvent e) {
            if (e.getDocument() == DamaskRadarDialog.this.mainFrame.getDocument()) {
                DamaskRadarDialog.this.updateTitleBar();
            }
        }

        public void documentRenamed(DocumentEvent e) {
            if (e.getDocument() == DamaskRadarDialog.this.mainFrame.getDocument()) {
                DamaskRadarDialog.this.updateTitleBar();
            }
        }

        public void documentClosed(DocumentEvent e) {
        }

        public void documentBusyStarted(DocumentEvent e) {
        }

        public void documentBusyStopped(DocumentEvent e) {
        }

        public void canvasGroupAdded(DocumentEvent e) {
        }

        public void canvasGroupRemoved(DocumentEvent e) {
        }
    }

    private static class ConstraintSizingBorder
    extends SizingBorder {
        private final DamaskCanvas mainCanvas;
        private final DamaskRadarDialog radarDialog;
        private final PCanvas radarCanvas;

        public ConstraintSizingBorder(PBoundsLocator aLocator, DamaskCanvas mainCanvas, DamaskRadarDialog radarDialog) {
            super(aLocator);
            this.mainCanvas = mainCanvas;
            this.radarDialog = radarDialog;
            this.radarCanvas = radarDialog.radarCanvas;
            this.setPaint(DamaskAppUtils.NO_COLOR);
            this.setStrokePaint(DamaskAppUtils.NO_COLOR);
        }

        public static void addConstraintSizingBordersTo(PNode aNode, DamaskCanvas mainCanvas, DamaskRadarDialog radarDialog) {
            aNode.addChild(new ConstraintSizingBorder(PBoundsLocator.createEastLocator(aNode), mainCanvas, radarDialog));
            aNode.addChild(new ConstraintSizingBorder(PBoundsLocator.createWestLocator(aNode), mainCanvas, radarDialog));
            aNode.addChild(new ConstraintSizingBorder(PBoundsLocator.createNorthLocator(aNode), mainCanvas, radarDialog));
            aNode.addChild(new ConstraintSizingBorder(PBoundsLocator.createSouthLocator(aNode), mainCanvas, radarDialog));
            aNode.addChild(new ConstraintSizingBorder(PBoundsLocator.createNorthEastLocator(aNode), mainCanvas, radarDialog));
            aNode.addChild(new ConstraintSizingBorder(PBoundsLocator.createNorthWestLocator(aNode), mainCanvas, radarDialog));
            aNode.addChild(new ConstraintSizingBorder(PBoundsLocator.createSouthEastLocator(aNode), mainCanvas, radarDialog));
            aNode.addChild(new ConstraintSizingBorder(PBoundsLocator.createSouthWestLocator(aNode), mainCanvas, radarDialog));
        }

        public void dragHandle(PDimension aLocalDimension, PInputEvent aEvent) {
            PBoundsLocator l = (PBoundsLocator)this.getLocator();
            PPath n = (PPath)l.getNode();
            PBounds b = new PBounds(n.getPathReference().getBounds2D());
            double ratio = b.height / b.width;
            PNode parent = this.getParent();
            if (parent != n && parent instanceof PCamera) {
                ((PCamera)parent).localToView(aLocalDimension);
            }
            this.localToGlobal(aLocalDimension);
            n.globalToLocal(aLocalDimension);
            double oldHeight = b.height;
            double oldX = b.x;
            double oldY = b.y;
            double dx = aLocalDimension.getWidth();
            double dy = aLocalDimension.getHeight();
            switch (l.getSide()) {
                case 1: {
                    b.setRect(b.x + dy / (2.0 * ratio), b.y + dy, b.width - dy / ratio, b.height - dy);
                    break;
                }
                case 5: {
                    b.setRect(b.x - dy / (2.0 * ratio), b.y, b.width + dy / ratio, b.height + dy);
                    break;
                }
                case 3: {
                    b.setRect(b.x, b.y - ratio * dx / 2.0, b.width + dx, b.height + ratio * dx);
                    break;
                }
                case 7: {
                    b.setRect(b.x + dx, b.y + ratio * dx / 2.0, b.width - dx, b.height - ratio * dx);
                    break;
                }
                case 8: {
                    b.setRect(b.x + dy / ratio, b.y + dy, b.width - dy / ratio, b.height - dy);
                    break;
                }
                case 6: {
                    b.setRect(b.x + dx, b.y, b.width - dx, b.height - dx * ratio);
                    break;
                }
                case 2: {
                    b.setRect(b.x, b.y + dy, b.width - dy / ratio, b.height - dy);
                    break;
                }
                case 4: {
                    b.setRect(b.x, b.y, b.width + dy / ratio, b.height + dy);
                }
            }
            boolean flipX = false;
            boolean flipY = false;
            if (b.width < 0.0) {
                flipX = true;
                b.width = -b.width;
                b.x -= b.width;
            }
            if (b.height < 0.0) {
                flipY = true;
                b.height = -b.height;
                b.y -= b.height;
            }
            if (flipX || flipY) {
                this.flipSiblingBoundsHandles(flipX, flipY);
            }
            double deltaX = b.x - oldX;
            double deltaY = b.y - oldY;
            PCamera mainCamera = this.mainCanvas.getCamera();
            double scaleFactor = oldHeight / b.getHeight();
            PBounds oldGlobalBounds = mainCamera.getViewBounds();
            mainCamera.translateView(oldGlobalBounds.getX(), oldGlobalBounds.getY());
            mainCamera.scaleView(scaleFactor);
            mainCamera.translateView(-oldGlobalBounds.getX(), -oldGlobalBounds.getY());
            double scale = this.radarCanvas.getCamera().getViewScale();
            mainCamera.translateView(-deltaX / scale, -deltaY / scale);
            this.radarDialog.listenToMainCamera = false;
            n.setPathTo(b);
        }

        public void endHandleDrag(Point2D aLocalPoint, PInputEvent aEvent) {
            super.endHandleDrag(aLocalPoint, aEvent);
            PCamera mainCamera = this.mainCanvas.getCamera();
            int newZoomLevel = DamaskCanvas.getNearestZoomLevel(mainCamera.getViewScale());
            this.mainCanvas.setZoomLevel(newZoomLevel);
        }
    }

    private class WindowHandler
    extends WindowAdapter {
        WindowHandler() {
        }

        public void windowGainedFocus(WindowEvent e) {
            logger.info(DamaskRadarDialog.this.mainFrame + ": Radar view gained focus");
        }

        public void windowLostFocus(WindowEvent e) {
            logger.info(DamaskRadarDialog.this.mainFrame + ": Radar view lost focus");
        }
    }
}

