/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.view;

import edu.berkeley.guir.damask.DamaskUtils;
import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.InteractionElement;
import edu.berkeley.guir.damask.InteractionGraph;
import edu.berkeley.guir.damask.command.AddDialogCommand;
import edu.berkeley.guir.damask.command.ModifyGraphMacroCommand;
import edu.berkeley.guir.damask.component.ComponentGroup;
import edu.berkeley.guir.damask.component.Content;
import edu.berkeley.guir.damask.component.Control;
import edu.berkeley.guir.damask.dialog.Dialog;
import edu.berkeley.guir.damask.dialog.Page;
import edu.berkeley.guir.damask.dialog.PageRegion;
import edu.berkeley.guir.damask.view.DamaskAppExceptionHandler;
import edu.berkeley.guir.damask.view.DamaskAppUtils;
import edu.berkeley.guir.damask.view.DamaskCanvas;
import edu.berkeley.guir.damask.view.DamaskLayer;
import edu.berkeley.guir.damask.view.visual.component.ControlView;
import edu.berkeley.guir.damask.view.visual.component.Label;
import edu.berkeley.guir.damask.view.visual.component.Panel;
import edu.berkeley.guir.damask.view.visual.dialog.PageView;
import edu.berkeley.guir.damask.view.voice.component.Prompt;
import edu.berkeley.guir.damask.view.voice.component.Response;
import edu.berkeley.guir.damask.view.voice.dialog.Form;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PAffineTransform;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PPaintContext;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.TransferHandler;

public class DamaskObjectSelection
extends TransferHandler
implements Transferable {
    private static final int PASTE_OFFSET = 20;
    private static final Logger logger;
    private final Map copiedObjectsToOrigParents = new LinkedHashMap();
    private PNode copiedObjectsPureCopy = null;
    private String copiedText = "";
    public static final DataFlavor DAMASK_OBJECTS_FLAVOR;
    private static final DataFlavor[] flavors;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.damask.view.DamaskObjectSelection");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getName());
        DAMASK_OBJECTS_FLAVOR = new DataFlavor("application/x-java-jvm-local-objectref;class=java.util.Map", "Collection of Damask objects");
        flavors = new DataFlavor[]{DAMASK_OBJECTS_FLAVOR, DataFlavor.imageFlavor, DataFlavor.stringFlavor};
    }

    public int getSourceActions(JComponent comp) {
        if (comp instanceof DamaskCanvas) {
            return 3;
        }
        return 0;
    }

    public boolean canImport(JComponent comp, DataFlavor[] compFlavors) {
        if (comp instanceof DamaskCanvas) {
            int i = 0;
            int n = compFlavors.length;
            while (i < n) {
                if (this.isDataFlavorSupported(compFlavors[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public Transferable createTransferable(JComponent comp) {
        Object selectedObject;
        if (!(comp instanceof DamaskCanvas)) {
            return null;
        }
        this.copiedObjectsToOrigParents.clear();
        DamaskCanvas canvas = (DamaskCanvas)comp;
        Collection selectedObjects = canvas.getObjectsToCopy();
        HashMap<Control, Control> controlClones = new HashMap<Control, Control>();
        HashSet<PageRegion> voiceControlRegions = new HashSet<PageRegion>();
        HashSet<Control> voiceControls = new HashSet<Control>();
        Iterator i = selectedObjects.iterator();
        while (i.hasNext()) {
            Object selectedView = i.next();
            if (selectedView instanceof PageView) {
                Dialog selectedDialog = ((Page)((PageView)selectedView).getModel()).getDialog();
                this.copiedObjectsToOrigParents.put(selectedDialog.clone(), selectedDialog.getInteractionGraph());
                continue;
            }
            if (selectedView instanceof Form) {
                Form form = (Form)selectedView;
                Dialog selectedDialog = (Dialog)form.getModel();
                this.copiedObjectsToOrigParents.put(selectedDialog.clone(), selectedDialog.getInteractionGraph());
                continue;
            }
            if (!(selectedView instanceof ControlView) && !(selectedView instanceof Prompt) && !(selectedView instanceof Response.TextGroup)) continue;
            Control selectedControl = selectedView instanceof ControlView ? (Control)((ControlView)selectedView).getModel() : (selectedView instanceof Prompt ? (Control)((Prompt)selectedView).getModel() : (Control)((Response.TextGroup)selectedView).getResponse().getModel());
            if (selectedControl.isVisibleToDeviceType(DeviceType.VOICE)) {
                voiceControls.add(selectedControl);
                voiceControlRegions.add(selectedControl.getPageRegion(DeviceType.VOICE));
                continue;
            }
            Control selectedControlClone = (Control)selectedControl.clone();
            this.copiedObjectsToOrigParents.put(selectedControlClone, selectedControl.getPageRegion(canvas.getDeviceType()));
            controlClones.put(selectedControl, selectedControlClone);
        }
        i = voiceControlRegions.iterator();
        while (i.hasNext()) {
            PageRegion region = (PageRegion)i.next();
            Iterator j = region.getControls().iterator();
            while (j.hasNext()) {
                Control control = (Control)j.next();
                if (!voiceControls.contains(control)) continue;
                Control selectedControlClone = (Control)control.clone();
                this.copiedObjectsToOrigParents.put(selectedControlClone, control.getPageRegion(canvas.getDeviceType()));
                controlClones.put(control, selectedControlClone);
            }
        }
        this.copiedObjectsPureCopy = new PNode();
        i = selectedObjects.iterator();
        while (i.hasNext()) {
            PNode node = (PNode)i.next();
            PNode nodeCopy = DamaskAppUtils.getPureCopy(node);
            nodeCopy.setTransform(node.getLocalToGlobalTransform(null));
            this.copiedObjectsPureCopy.addChild(nodeCopy);
        }
        if (selectedObjects.size() == 1 && (selectedObject = selectedObjects.iterator().next()) instanceof Label) {
            this.copiedText = ((Content)((Label)selectedObject).getModel()).getText();
        }
        return this;
    }

    public boolean importData(JComponent comp, Transferable t) {
        boolean result = false;
        try {
            if (comp instanceof DamaskCanvas) {
                DamaskCanvas canvas = (DamaskCanvas)comp;
                DeviceType canvasDeviceType = canvas.getDeviceType();
                PageRegion targetRegion = canvas.getPasteTargetPageRegion();
                DeviceType deviceTypeForNewElement = ((DamaskLayer)canvas.getLayer()).getDeviceTypeForNewElement();
                if (t.isDataFlavorSupported(DAMASK_OBJECTS_FLAVOR)) {
                    ModifyGraphMacroCommand cmd = new ModifyGraphMacroCommand();
                    DamaskObjectSelection clipboardData = (DamaskObjectSelection)t.getTransferData(DAMASK_OBJECTS_FLAVOR);
                    Collection newObjects = clipboardData.getCopiedObjects();
                    Panel targetPanel = DamaskAppUtils.findRootPanel(canvas.getSelectedObjects());
                    ComponentGroup targetGroup = targetPanel == null ? null : (ComponentGroup)targetPanel.getModel();
                    ArrayList<Control> controlsWithNoBounds = new ArrayList<Control>();
                    Iterator i = newObjects.iterator();
                    while (i.hasNext()) {
                        InteractionElement element = (InteractionElement)i.next();
                        System.out.println(element);
                        if (element instanceof Dialog) {
                            Dialog newDialog = new Dialog((Dialog)element, deviceTypeForNewElement);
                            InteractionGraph parent = (InteractionGraph)clipboardData.getParent(element);
                            cmd.addCommand(new AddDialogCommand(parent, newDialog));
                            continue;
                        }
                        if (element instanceof Control) {
                            AffineTransform newControlTransform;
                            Point2D newControlLocation;
                            Point2D origControlLocation;
                            Control control = (Control)element;
                            Control newControl = (Control)control.createCopy(deviceTypeForNewElement);
                            if (newControl.getBounds(canvasDeviceType) == null) {
                                controlsWithNoBounds.add(newControl);
                            }
                            DamaskUtils.addCommandsForAddingComponentToMacroCommand(cmd, newControl, targetRegion, targetGroup, false, false);
                            Control origControl = (Control)control.getCloneSourceIfAlive();
                            if (origControl == null || origControl.getPageRegion(canvasDeviceType) != targetRegion || !(origControlLocation = origControl.getTransform(canvasDeviceType).transform(origControl.getLocation(canvasDeviceType), null)).equals(newControlLocation = (newControlTransform = newControl.getTransform(canvasDeviceType)).transform(newControl.getLocation(canvasDeviceType), null))) continue;
                            newControlTransform.preConcatenate(AffineTransform.getTranslateInstance(20.0, 20.0));
                            newControl.setTransform(canvasDeviceType, newControlTransform);
                            continue;
                        }
                        System.out.println("Pasting " + element + " not supported");
                    }
                    if (!cmd.isEmpty()) {
                        canvas.getDocument().getCommandQueue().doCommand(canvas, cmd);
                        result = true;
                        double newControlY = 0.0;
                        Iterator j = controlsWithNoBounds.iterator();
                        while (j.hasNext()) {
                            Control controlWithNoBounds = (Control)j.next();
                            controlWithNoBounds.setTransform(canvasDeviceType, AffineTransform.getTranslateInstance(0.0, newControlY));
                            newControlY += controlWithNoBounds.getBounds(canvasDeviceType).getHeight();
                        }
                    }
                } else if (t.isDataFlavorSupported(DataFlavor.imageFlavor)) {
                    BufferedImage newImage = (BufferedImage)t.getTransferData(DataFlavor.imageFlavor);
                    Content newContent = new Content(deviceTypeForNewElement, newImage);
                    newContent.setBounds(DeviceType.ALL, new Rectangle2D.Double(0.0, 0.0, newImage.getWidth(), newImage.getHeight()));
                    ModifyGraphMacroCommand cmd = new ModifyGraphMacroCommand();
                    DamaskUtils.addCommandsForAddingComponentToMacroCommand(cmd, newContent, targetRegion);
                    canvas.getDocument().getCommandQueue().doCommand(canvas, cmd);
                    result = true;
                } else if (t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    String newText = (String)t.getTransferData(DataFlavor.stringFlavor);
                    Content newContent = new Content(deviceTypeForNewElement, newText);
                    ModifyGraphMacroCommand cmd = new ModifyGraphMacroCommand();
                    DamaskUtils.addCommandsForAddingComponentToMacroCommand(cmd, newContent, targetRegion);
                    canvas.getDocument().getCommandQueue().doCommand(canvas, cmd);
                    result = true;
                }
                canvas.getSelectionEventHandler().unselectAll(canvas);
            }
        }
        catch (UnsupportedFlavorException ignored) {
            logger.info("Cannot paste");
            DamaskAppExceptionHandler.log(ignored);
        }
        catch (IOException ignored) {
            logger.info("Cannot paste");
            DamaskAppExceptionHandler.log(ignored);
        }
        return result;
    }

    public Collection getCopiedObjects() {
        return this.copiedObjectsToOrigParents.keySet();
    }

    public Object getParent(InteractionElement element) {
        return this.copiedObjectsToOrigParents.get(element);
    }

    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
        if (DAMASK_OBJECTS_FLAVOR.match(flavor)) {
            return this;
        }
        if (DataFlavor.imageFlavor.match(flavor)) {
            if (this.copiedObjectsPureCopy == null) {
                return null;
            }
            PBounds imageBounds = this.copiedObjectsPureCopy.getFullBounds();
            int imageWidth = (int)((RectangularShape)imageBounds).getWidth();
            int imageHeight = (int)((RectangularShape)imageBounds).getHeight();
            BufferedImage selectedViewsImage = new BufferedImage(imageWidth, imageHeight, 2);
            Graphics2D g = selectedViewsImage.createGraphics();
            g.setColor(Color.WHITE);
            g.fillRect(0, 0, imageWidth, imageHeight);
            PAffineTransform origTransform = this.copiedObjectsPureCopy.getTransform();
            this.copiedObjectsPureCopy.setTransform(AffineTransform.getTranslateInstance(-((RectangularShape)imageBounds).getX(), -((RectangularShape)imageBounds).getY()));
            PPaintContext paintContext = new PPaintContext(g);
            this.copiedObjectsPureCopy.fullPaint(paintContext);
            this.copiedObjectsPureCopy.setTransform(origTransform);
            g.dispose();
            return selectedViewsImage;
        }
        if (DataFlavor.stringFlavor.match(flavor)) {
            return this.copiedText;
        }
        throw new UnsupportedFlavorException(flavor);
    }

    public DataFlavor[] getTransferDataFlavors() {
        return flavors;
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        int i = 0;
        int n = flavors.length;
        while (i < n) {
            if (flavors[i].match(flavor)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

