/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.view;

import edu.berkeley.guir.damask.DamaskUtils;
import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.InteractionElement;
import edu.berkeley.guir.damask.InteractionGraph;
import edu.berkeley.guir.damask.connection.Connection;
import edu.berkeley.guir.damask.dialog.Dialog;
import edu.berkeley.guir.damask.event.ElementContainerEvent;
import edu.berkeley.guir.damask.event.ElementContainerListener;
import edu.berkeley.guir.damask.event.InteractionGraphEvent;
import edu.berkeley.guir.damask.event.InteractionGraphListener;
import edu.berkeley.guir.damask.pattern.PatternInstance;
import edu.berkeley.guir.damask.view.DamaskAppUtils;
import edu.berkeley.guir.damask.view.DamaskCanvas;
import edu.berkeley.guir.damask.view.DamaskDocument;
import edu.berkeley.guir.damask.view.InteractionElementView;
import edu.berkeley.guir.damask.view.TemplatePane;
import edu.berkeley.guir.damask.view.appevent.LayerEventSource;
import edu.berkeley.guir.damask.view.appevent.LayerListener;
import edu.berkeley.guir.damask.view.visual.VisualLayer;
import edu.berkeley.guir.damask.view.voice.VoiceLayer;
import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PComponent;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.PNode;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.ButtonModel;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class DamaskLayer
extends PLayer {
    public static final int THIS_LAYER_ALPHA = 255;
    public static final int OTHER_LAYER_ALPHA = 80;
    private static Logger logger;
    private final DamaskDocument doc;
    private final DeviceType deviceType;
    private final double pageTitleScale;
    private DeviceTypeLayer deviceTypeLayer;
    private final JToggleButton.ToggleButtonModel allDevicesButtonModel = new JToggleButton.ToggleButtonModel();
    private final JToggleButton.ToggleButtonModel thisDeviceButtonModel = new JToggleButton.ToggleButtonModel();
    private TemplatePane templatePane;
    protected final Map views = new HashMap();
    private final LayerEventSource eventSource = new LayerEventSource();
    protected final List trackedViews = new ArrayList();
    protected boolean trackViews = false;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.damask.view.DamaskLayer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("edu.berkeley.guir.damask.view.DamaskLayer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz2.getName());
    }

    public DamaskLayer(DamaskDocument doc, DeviceType deviceType) {
        this(doc, deviceType, 1.0);
    }

    public DamaskLayer(DamaskDocument doc, DeviceType deviceType, double pageTitleScale) {
        deviceType.verifyTypeIsNotAll();
        this.doc = doc;
        this.deviceType = deviceType;
        this.pageTitleScale = pageTitleScale;
        InteractionGraph graph = doc.getGraph();
        GraphHandler graphHandler = new GraphHandler();
        graph.addElementContainerListener(graphHandler);
        graph.addInteractionGraphListener(graphHandler);
        this.templatePane = new TemplatePane();
        this.addChild(0, this.templatePane);
        this.initBeforeAddingViews();
        Iterator i = graph.getDialogs(deviceType).iterator();
        while (i.hasNext()) {
            Dialog dialog = (Dialog)i.next();
            this.addViewForElement(dialog);
        }
        i = graph.getConnections(deviceType).iterator();
        while (i.hasNext()) {
            Connection connection = (Connection)i.next();
            this.addViewForElement(connection);
        }
        i = graph.getPatternInstances().iterator();
        while (i.hasNext()) {
            PatternInstance pi = (PatternInstance)i.next();
            this.addViewForElement(pi);
        }
        this.allDevicesButtonModel.addChangeListener(new LayerButtonModelHandler());
        this.thisDeviceButtonModel.addChangeListener(new LayerButtonModelHandler());
        this.setDeviceTypeLayer(DeviceTypeLayer.ALL);
        this.addPropertyChangeListener("cameras", new CamerasHandler());
        this.updateHomePage();
    }

    protected void initBeforeAddingViews() {
    }

    public static DamaskLayer create(DamaskDocument doc, DeviceType deviceType) {
        return DamaskLayer.create(doc, deviceType, 1.0);
    }

    public static DamaskLayer create(DamaskDocument doc, DeviceType deviceType, double pageTitleScale) {
        if (deviceType.isVisual()) {
            return new VisualLayer(doc, deviceType, pageTitleScale);
        }
        return new VoiceLayer(doc, deviceType, pageTitleScale);
    }

    public synchronized void addLayerListener(LayerListener listener) {
        this.eventSource.addLayerListener(listener);
    }

    public synchronized void removeLayerListener(LayerListener listener) {
        this.eventSource.removeLayerListener(listener);
    }

    protected void fireDeviceTypeLayerChanged() {
        this.eventSource.fireDeviceTypeLayerChanged(this);
    }

    public double getPageTitleScale() {
        return this.pageTitleScale;
    }

    public TemplatePane getTemplatePane() {
        return this.templatePane;
    }

    public DamaskDocument getDocument() {
        return this.doc;
    }

    public DeviceType getDeviceType() {
        return this.deviceType;
    }

    public DeviceTypeLayer getDeviceTypeLayer() {
        return this.deviceTypeLayer;
    }

    public DeviceType getDeviceTypeForNewElement() {
        if (this.deviceTypeLayer == DeviceTypeLayer.ALL) {
            return DeviceType.ALL;
        }
        return this.deviceType;
    }

    protected ButtonModel getAllDevicesButtonModel() {
        return this.allDevicesButtonModel;
    }

    protected ButtonModel getThisDeviceButtonModel() {
        return this.thisDeviceButtonModel;
    }

    public void setDeviceTypeLayer(DeviceTypeLayer deviceTypeLayer) {
        if (deviceTypeLayer == DeviceTypeLayer.ALL) {
            this.allDevicesButtonModel.setSelected(true);
        } else {
            this.thisDeviceButtonModel.setSelected(true);
        }
    }

    protected void internalSetDeviceTypeLayer(DeviceTypeLayer deviceTypeLayer) {
        this.deviceTypeLayer = deviceTypeLayer;
        logger.info(this + ": Device type layer changed to " + deviceTypeLayer);
        this.fireDeviceTypeLayerChanged();
    }

    protected void layerButtonModelStateChanged(ChangeEvent e) {
        if (e.getSource() == this.allDevicesButtonModel) {
            if (this.allDevicesButtonModel.isSelected()) {
                this.internalSetDeviceTypeLayer(DeviceTypeLayer.ALL);
            }
        } else if (e.getSource() == this.thisDeviceButtonModel) {
            if (this.thisDeviceButtonModel.isSelected()) {
                this.internalSetDeviceTypeLayer(DeviceTypeLayer.DEVICE);
            }
        } else if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public InteractionElementView getView(InteractionElement model) {
        return DamaskAppUtils.getView(this, model);
    }

    public List getViews(InteractionElement model) {
        return DamaskAppUtils.getViews(this, model);
    }

    protected Collection getDamaskCanvases() {
        HashSet<PComponent> canvases = new HashSet<PComponent>();
        Iterator i = this.getCamerasReference().iterator();
        while (i.hasNext()) {
            PCamera camera = (PCamera)i.next();
            PComponent component = camera.getComponent();
            if (!(component instanceof DamaskCanvas)) continue;
            canvases.add(component);
        }
        return canvases;
    }

    public void addSelectableParent(PNode node) {
        Iterator i = this.getDamaskCanvases().iterator();
        while (i.hasNext()) {
            DamaskCanvas canvas = (DamaskCanvas)i.next();
            canvas.getSelectionEventHandler().addSelectableParent(node);
        }
    }

    public void removeSelectableParent(PNode node) {
        Iterator i = this.getDamaskCanvases().iterator();
        while (i.hasNext()) {
            DamaskCanvas canvas = (DamaskCanvas)i.next();
            canvas.getSelectionEventHandler().removeSelectableParent(node);
        }
    }

    public void clearSelectableParents() {
        Iterator i = this.getDamaskCanvases().iterator();
        while (i.hasNext()) {
            DamaskCanvas canvas = (DamaskCanvas)i.next();
            canvas.getSelectionEventHandler().setSelectableParents(Collections.EMPTY_LIST);
        }
    }

    protected abstract void addViewForElement(InteractionElement var1);

    protected abstract void removeViewForElement(InteractionElement var1);

    public void startTrackingNewAdditions() {
        this.trackViews = true;
    }

    public void stopTrackingNewAdditions() {
        this.trackViews = false;
    }

    public void clearTrackedNewAdditions() {
        this.trackedViews.clear();
    }

    public List getTrackedNewAdditions() {
        return this.trackedViews;
    }

    public void trackAddition(InteractionElementView view) {
        if (this.trackViews) {
            this.trackedViews.add(new WeakReference<InteractionElementView>(view));
        }
    }

    public abstract void updateHomePage();

    public String toString() {
        return String.valueOf(DamaskUtils.toShortString(this)) + " (" + this.getDocument() + " - " + this.getDeviceType() + ")";
    }

    public static class DeviceTypeLayer {
        private String name;
        public static final DeviceTypeLayer ALL = new DeviceTypeLayer("all");
        public static final DeviceTypeLayer DEVICE = new DeviceTypeLayer("device");

        private DeviceTypeLayer(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    private class LayerButtonModelHandler
    implements ChangeListener {
        LayerButtonModelHandler() {
        }

        public void stateChanged(ChangeEvent e) {
            DamaskLayer.this.layerButtonModelStateChanged(e);
        }
    }

    private class GraphHandler
    implements ElementContainerListener,
    InteractionGraphListener {
        static final /* synthetic */ boolean $assertionsDisabled;
        static /* synthetic */ Class class$0;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("edu.berkeley.guir.damask.view.DamaskLayer$GraphHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        GraphHandler() {
        }

        public void elementAdded(ElementContainerEvent e) {
            Object container = e.getSource();
            if (!$assertionsDisabled && !DamaskLayer.this.doc.getGraph().equals(container)) {
                throw new AssertionError((Object)("ERROR: event source " + container + " is not " + DamaskLayer.this.doc.getGraph()));
            }
            InteractionElement element = e.getElement();
            DamaskLayer.this.addViewForElement(element);
        }

        public void elementRemoved(ElementContainerEvent e) {
            Object container = e.getSource();
            if (!$assertionsDisabled && !DamaskLayer.this.doc.getGraph().equals(container)) {
                throw new AssertionError((Object)("ERROR: event source " + container + " is not " + DamaskLayer.this.doc.getGraph()));
            }
            InteractionElement element = e.getElement();
            DamaskLayer.this.removeViewForElement(element);
        }

        public void homePageChanged(InteractionGraphEvent e) {
            InteractionGraph graph = e.getGraph();
            if (!$assertionsDisabled && !DamaskLayer.this.getDocument().getGraph().equals(graph)) {
                throw new AssertionError((Object)("ERROR: event source " + graph + " is not " + DamaskLayer.this.getDocument().getGraph()));
            }
            DamaskLayer.this.updateHomePage();
        }
    }

    private class CamerasHandler
    implements PropertyChangeListener {
        CamerasHandler() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            DamaskLayer.this.clearSelectableParents();
        }
    }
}

