/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.view;

import edu.berkeley.guir.damask.Damask;
import edu.berkeley.guir.damask.DamaskUtils;
import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.component.Content;
import edu.berkeley.guir.damask.view.DamaskApp;
import edu.berkeley.guir.damask.view.DamaskAppExceptionHandler;
import edu.berkeley.guir.damask.view.DamaskAppUtils;
import edu.berkeley.guir.damask.view.DamaskCamera;
import edu.berkeley.guir.damask.view.DamaskCanvas;
import edu.berkeley.guir.damask.view.DamaskDocument;
import edu.berkeley.guir.damask.view.DamaskLayer;
import edu.berkeley.guir.damask.view.DamaskRadarDialog;
import edu.berkeley.guir.damask.view.DamaskToolbar;
import edu.berkeley.guir.damask.view.TemplatePane;
import edu.berkeley.guir.damask.view.Toolbox;
import edu.berkeley.guir.damask.view.ZoomSlider;
import edu.berkeley.guir.damask.view.appdialogs.FileDialogUtils;
import edu.berkeley.guir.damask.view.appevent.CommandEvent;
import edu.berkeley.guir.damask.view.appevent.CommandListener;
import edu.berkeley.guir.damask.view.appevent.DocumentEvent;
import edu.berkeley.guir.damask.view.appevent.DocumentListener;
import edu.berkeley.guir.damask.view.pattern.PatternBrowser;
import edu.berkeley.guir.damask.view.visual.VisualCanvas;
import edu.berkeley.guir.lib.satin.command.CommandQueue;
import edu.umd.cs.piccolo.PLayer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.MouseInputAdapter;
import javax.xml.bind.JAXBException;

public class DamaskFrame
extends JFrame {
    private static final String PROPERTY_SLIDER = "slider";
    private static final String PROPERTY_CANVAS = "canvas";
    private static final Logger logger;
    private static final int NEW_WINDOW_OFFSET = 20;
    private final int FIRST_OPEN_WINDOW_POS;
    private static final SortedSet allFrames;
    private final DamaskDocument.DamaskCanvasGroup canvasGroup;
    private DamaskCanvas currentCanvas = null;
    private final JTabbedPane tabPane = new JTabbedPane();
    private final Toolbox toolbox = new Toolbox();
    private final DamaskToolbar toolbar = new DamaskToolbar();
    private final Set canvasWithVisibleTemplates = new HashSet();
    private final DocumentListener docListener = new DocumentHandler();
    private final WindowHandler winHandler = new WindowHandler();
    private final ChangeListener tabListener = new TabbedPaneListener();
    private final CommandListener commandListener = new CommandHandler();
    private final Action newAction = new NewAction();
    private final Action openAction = new OpenAction();
    private final Action saveAction = new SaveAction();
    private final Action undoAction = new UndoAction();
    private final Action redoAction = new RedoAction();
    private final JMenuItem fileExportAsVoiceXMLItem;
    private final JMenuItem editCutItem;
    private final JMenuItem editCopyItem;
    private final JMenuItem editPasteItem;
    private final JMenuItem editDeleteItem;
    private final JCheckBoxMenuItem viewTemplatesItem;
    private final JCheckBoxMenuItem viewRadarItem;
    private final JCheckBoxMenuItem viewPatternItem;
    private final JMenu pageMenu;
    private final JMenuItem pageCutItem;
    private final JMenuItem pageCopyItem;
    private final JMenuItem pagePasteItem;
    private final JMenuItem pageDeleteItem;
    private final JMenuItem pageSetHomeItem;
    private final JMenu contentMenu;
    private final JRadioButtonMenuItem contentInkItem;
    private final JRadioButtonMenuItem contentTextItem;
    private final JRadioButtonMenuItem contentPictureItem;
    private final JRadioButtonMenuItem contentMixedItem;
    private final JMenuItem contentChangePictureItem;
    private final JMenu runMenu;
    private final JMenuItem runFromHomeItem;
    private final JMenuItem runFromSelectedPageItem;
    private final JMenu windowMenu;
    private DamaskRadarDialog radarView;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.damask.view.DamaskFrame");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getName());
        allFrames = new TreeSet(new FrameNameComparator());
    }

    public DamaskFrame(DamaskDocument.DamaskCanvasGroup canvasGroup) {
        this.canvasGroup = canvasGroup;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension frameSize = toolkit.getScreenSize();
        Insets insets = toolkit.getScreenInsets(this.getGraphicsConfiguration());
        frameSize.width -= insets.left + insets.right;
        frameSize.height -= insets.top + insets.bottom;
        if (frameSize.width > frameSize.height) {
            frameSize.width = (int)((double)frameSize.width * 0.7);
        } else {
            frameSize.height = (int)((double)frameSize.height * 0.7);
        }
        this.setSize(frameSize);
        this.setLocation(insets.left, insets.top);
        Iterator i = DamaskApp.getDocuments().iterator();
        while (i.hasNext()) {
            DamaskDocument doc = (DamaskDocument)i.next();
            doc.addDocumentListener(this.docListener);
        }
        Container content = this.getContentPane();
        Iterator i2 = Damask.getSupportedDeviceTypes().iterator();
        while (i2.hasNext()) {
            DeviceType deviceType = (DeviceType)i2.next();
            JPanel tabPaneContent = new JPanel();
            DamaskCanvas canvas = canvasGroup.getCanvas(deviceType);
            DamaskLayer layer = (DamaskLayer)canvas.getLayer();
            canvas.setZoomLevel(3);
            tabPaneContent.setLayout(new BorderLayout());
            JPanel leftBar = new JPanel();
            leftBar.setLayout(new BoxLayout(leftBar, 1));
            JPanel layerButtonsPanel = new JPanel();
            layerButtonsPanel.setLayout(new GridLayout(0, 1));
            layerButtonsPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
            JLabel layersLabel = new JLabel("Layers:");
            layerButtonsPanel.add(layersLabel);
            ButtonGroup layersButtonGroup = new ButtonGroup();
            JRadioButton allDevicesButton = new JRadioButton("All Devices");
            allDevicesButton.setMnemonic('A');
            allDevicesButton.setModel(layer.getAllDevicesButtonModel());
            layersButtonGroup.add(allDevicesButton);
            layerButtonsPanel.add(allDevicesButton);
            JRadioButton thisDeviceButton = new JRadioButton("This Device");
            thisDeviceButton.setMnemonic('T');
            thisDeviceButton.setModel(layer.getThisDeviceButtonModel());
            layersButtonGroup.add(thisDeviceButton);
            layerButtonsPanel.add(thisDeviceButton);
            leftBar.add(layerButtonsPanel);
            leftBar.add(new JSeparator());
            ZoomSlider zoomSlider = new ZoomSlider(canvas.getSliderModel());
            zoomSlider.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
            leftBar.add(zoomSlider);
            tabPaneContent.add((Component)leftBar, "West");
            JPanel mainPanel = new JPanel();
            mainPanel.setLayout(new BorderLayout());
            JButton topButton = new JButton(DamaskRadarDialog.getRadarIcon("top.gif"));
            JButton bottomButton = new JButton(DamaskRadarDialog.getRadarIcon("bottom.gif"));
            JButton leftButton = new JButton(DamaskRadarDialog.getRadarIcon("left.gif"));
            JButton rightButton = new JButton(DamaskRadarDialog.getRadarIcon("right.gif"));
            leftButton.setMargin(new Insets(0, 3, 0, 3));
            rightButton.setMargin(new Insets(0, 3, 0, 3));
            DamaskCamera camera = (DamaskCamera)canvas.getCamera();
            topButton.addMouseListener(new PanButtonMouseHandler(camera, 0.0, 1.0));
            bottomButton.addMouseListener(new PanButtonMouseHandler(camera, 0.0, -1.0));
            rightButton.addMouseListener(new PanButtonMouseHandler(camera, -1.0, 0.0));
            leftButton.addMouseListener(new PanButtonMouseHandler(camera, 1.0, 0.0));
            mainPanel.add((Component)topButton, "North");
            mainPanel.add((Component)bottomButton, "South");
            mainPanel.add((Component)rightButton, "East");
            mainPanel.add((Component)leftButton, "West");
            mainPanel.add((Component)canvas, "Center");
            tabPaneContent.add(mainPanel);
            this.tabPane.addTab(deviceType.toString(), tabPaneContent);
            tabPaneContent.putClientProperty(PROPERTY_SLIDER, zoomSlider);
            tabPaneContent.putClientProperty(PROPERTY_CANVAS, canvas);
        }
        content.setLayout(new BorderLayout());
        content.add((Component)this.tabPane, "Center");
        this.addCanvasChangeListener(this.tabListener);
        content.add((Component)this.toolbox, "West");
        this.updateTitleBar();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this.winHandler);
        this.addWindowFocusListener(this.winHandler);
        this.setGlassPane(new EventSwallowerGlassPane());
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic('F');
        JMenuItem fileNewItem = new JMenuItem(this.newAction);
        fileMenu.add(fileNewItem);
        JMenuItem fileOpenItem = new JMenuItem(this.openAction);
        fileMenu.add(fileOpenItem);
        JMenuItem fileCloseItem = new JMenuItem(new FileCloseAction());
        fileMenu.add(fileCloseItem);
        fileMenu.add(new JSeparator());
        JMenuItem fileSaveItem = new JMenuItem(this.saveAction);
        fileMenu.add(fileSaveItem);
        JMenuItem saveAsItem = new JMenuItem(new SaveAsAction());
        fileMenu.add(saveAsItem);
        fileMenu.add(new JSeparator());
        JMenuItem fileExportAsImageItem = new JMenuItem(new ExportAsImageAction());
        fileMenu.add(fileExportAsImageItem);
        this.fileExportAsVoiceXMLItem = new JMenuItem(new ExportAsVoiceXMLAction());
        fileMenu.add(this.fileExportAsVoiceXMLItem);
        if (!DamaskAppUtils.isMac()) {
            fileMenu.add(new JSeparator());
            JMenuItem editRedoItem = new JMenuItem(new ExitAction());
            fileMenu.add(editRedoItem);
        }
        menuBar.add(fileMenu);
        JMenu editMenu = new JMenu("Edit");
        editMenu.setMnemonic('E');
        JMenuItem editUndoItem = new JMenuItem(this.undoAction);
        this.undoAction.setEnabled(false);
        editMenu.add(editUndoItem);
        JMenuItem editRedoItem = new JMenuItem(this.redoAction);
        this.redoAction.setEnabled(false);
        editMenu.add(editRedoItem);
        editMenu.add(new JSeparator());
        this.editCutItem = new JMenuItem();
        editMenu.add(this.editCutItem);
        this.editCopyItem = new JMenuItem();
        editMenu.add(this.editCopyItem);
        this.editPasteItem = new JMenuItem();
        editMenu.add(this.editPasteItem);
        this.editDeleteItem = new JMenuItem();
        editMenu.add(this.editDeleteItem);
        menuBar.add(editMenu);
        JMenu viewMenu = new JMenu("View");
        viewMenu.setMnemonic('V');
        this.viewTemplatesItem = new JCheckBoxMenuItem(new TemplatePaneAction());
        viewMenu.add(this.viewTemplatesItem);
        viewMenu.add(new JSeparator());
        this.viewRadarItem = new JCheckBoxMenuItem(new ViewRadarAction());
        viewMenu.add(this.viewRadarItem);
        this.viewPatternItem = new JCheckBoxMenuItem(new ViewPatternAction());
        PatternBrowser browser = DamaskApp.getPatternBrowserReference();
        if (browser != null) {
            this.viewPatternItem.setState(browser.isVisible());
        }
        viewMenu.add(this.viewPatternItem);
        menuBar.add(viewMenu);
        this.pageMenu = new JMenu("Page");
        this.pageMenu.setMnemonic('P');
        this.pageCutItem = new JMenuItem();
        this.pageMenu.add(this.pageCutItem);
        this.pageCopyItem = new JMenuItem();
        this.pageMenu.add(this.pageCopyItem);
        this.pagePasteItem = new JMenuItem();
        this.pageMenu.add(this.pagePasteItem);
        this.pageDeleteItem = new JMenuItem();
        this.pageMenu.add(this.pageDeleteItem);
        this.pageMenu.add(new JSeparator());
        this.pageSetHomeItem = new JMenuItem();
        this.pageMenu.add(this.pageSetHomeItem);
        menuBar.add(this.pageMenu);
        this.contentMenu = new JMenu("Content");
        this.contentMenu.setMnemonic('C');
        ButtonGroup displayModeGroup = new ButtonGroup();
        this.contentInkItem = new JRadioButtonMenuItem();
        displayModeGroup.add(this.contentInkItem);
        this.contentMenu.add(this.contentInkItem);
        this.contentTextItem = new JRadioButtonMenuItem();
        displayModeGroup.add(this.contentTextItem);
        this.contentMenu.add(this.contentTextItem);
        this.contentPictureItem = new JRadioButtonMenuItem();
        displayModeGroup.add(this.contentPictureItem);
        this.contentMenu.add(this.contentPictureItem);
        this.contentMixedItem = new JRadioButtonMenuItem();
        displayModeGroup.add(this.contentMixedItem);
        this.contentMenu.addMenuListener(new MenuListener(){

            public void menuSelected(MenuEvent e) {
                VisualCanvas visualCanvas = (VisualCanvas)DamaskFrame.this.currentCanvas;
                Collection selectedLabels = visualCanvas.getSelectedLabels();
                if (selectedLabels.isEmpty()) {
                    DamaskFrame.this.contentMixedItem.setSelected(true);
                } else {
                    Content.DisplayMode selectedDisplayMode = visualCanvas.getSelectedLabelsMode();
                    if (selectedDisplayMode == Content.INK) {
                        DamaskFrame.this.contentInkItem.setSelected(true);
                    } else if (selectedDisplayMode == Content.TEXT) {
                        DamaskFrame.this.contentTextItem.setSelected(true);
                    } else if (selectedDisplayMode == Content.IMAGE) {
                        DamaskFrame.this.contentPictureItem.setSelected(true);
                    } else {
                        DamaskFrame.this.contentMixedItem.setSelected(true);
                    }
                }
            }

            public void menuCanceled(MenuEvent e) {
            }

            public void menuDeselected(MenuEvent e) {
            }
        });
        this.contentMenu.add(new JSeparator());
        this.contentChangePictureItem = new JMenuItem();
        this.contentMenu.add(this.contentChangePictureItem);
        menuBar.add(this.contentMenu);
        this.runMenu = new JMenu("Run");
        this.runMenu.setMnemonic('R');
        this.runFromHomeItem = new JMenuItem();
        this.runMenu.add(this.runFromHomeItem);
        this.runFromSelectedPageItem = new JMenuItem();
        this.runMenu.add(this.runFromSelectedPageItem);
        menuBar.add(this.runMenu);
        this.windowMenu = new JMenu("Window");
        this.windowMenu.setMnemonic('W');
        if (!DamaskAppUtils.isMac()) {
            this.windowMenu.add(new JMenuItem(new NewWindowAction()));
            this.windowMenu.add(new JMenuItem(new CloseWindowAction()));
        } else {
            this.windowMenu.add(new JMenuItem(new CloseWindowAction()));
            this.windowMenu.add(new JMenuItem(new NewWindowAction()));
        }
        this.windowMenu.add(new JSeparator());
        this.FIRST_OPEN_WINDOW_POS = 3;
        this.updateTitleBar();
        menuBar.add(this.windowMenu);
        DamaskDocument.VerboseCommandQueue q = canvasGroup.getDocument().getCommandQueue();
        q.addCommandListener(this.commandListener);
        this.undoAction.setEnabled(q.canUndo());
        this.redoAction.setEnabled(q.canRedo());
        content.add((Component)this.toolbar, "North");
        this.updateCurrentCanvas();
        allFrames.add(this);
        DamaskFrame.updateAllWindowMenus();
        this.radarView = new DamaskRadarDialog(this);
        this.radarView.setLocation(this.getX() + this.getWidth() - this.radarView.getWidth(), this.getY() + this.getHeight() - this.radarView.getHeight());
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("edu.berkeley.guir.damask.view.DamaskApp");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.radarView.setVisible(Preferences.userNodeForPackage(clazz).getBoolean("Radar view visible", true));
        logger.info(this + " created");
    }

    public void initialize() {
        this.toolbar.initialize();
        this.toolbox.initialize();
    }

    public void dispose() {
        logger.info(this + " closed");
        allFrames.remove(this);
        Iterator i = DamaskApp.getDocuments().iterator();
        while (i.hasNext()) {
            DamaskDocument doc = (DamaskDocument)i.next();
            doc.removeDocumentListener(this.docListener);
        }
        this.tabPane.removeChangeListener(this.tabListener);
        this.getDocument().removeCanvasGroup(this.canvasGroup);
        i = this.getDocument().getWindows().iterator();
        while (i.hasNext()) {
            DamaskFrame frame = (DamaskFrame)i.next();
            frame.updateTitleBar();
        }
        DamaskFrame.updateAllWindowMenus();
        super.dispose();
    }

    public static Set getAllDamaskFrames() {
        return Collections.unmodifiableSet(allFrames);
    }

    public DamaskDocument.DamaskCanvasGroup getCanvasGroup() {
        return this.canvasGroup;
    }

    public DamaskCanvas getCurrentCanvas() {
        DamaskCanvas realCurrentCanvas = (DamaskCanvas)((JComponent)this.tabPane.getSelectedComponent()).getClientProperty(PROPERTY_CANVAS);
        if (realCurrentCanvas != this.currentCanvas) {
            this.updateCurrentCanvas();
        }
        return this.currentCanvas;
    }

    public void addCanvasChangeListener(ChangeListener listener) {
        this.tabPane.addChangeListener(listener);
    }

    public void removeCanvasChangeListener(ChangeListener listener) {
        this.tabPane.removeChangeListener(listener);
    }

    private void updateCurrentCanvas() {
        DamaskCanvas realCurrentCanvas = (DamaskCanvas)((JComponent)this.tabPane.getSelectedComponent()).getClientProperty(PROPERTY_CANVAS);
        if (this.currentCanvas == realCurrentCanvas) {
            return;
        }
        this.currentCanvas = realCurrentCanvas;
        this.editCutItem.setAction(this.currentCanvas.getCutAction());
        this.editCopyItem.setAction(this.currentCanvas.getCopyAction());
        this.editPasteItem.setAction(this.currentCanvas.getPasteAction());
        this.editDeleteItem.setAction(this.currentCanvas.getDeleteAction());
        this.runFromHomeItem.setAction(this.currentCanvas.getRunFromHomeAction());
        this.runFromSelectedPageItem.setAction(this.currentCanvas.getRunFromSelectedPageAction());
        this.pageCutItem.setAction(this.currentCanvas.getCutPageAction());
        this.pageCopyItem.setAction(this.currentCanvas.getCopyPageAction());
        this.pagePasteItem.setAction(this.currentCanvas.getPastePageAction());
        this.pageDeleteItem.setAction(this.currentCanvas.getDeletePageAction());
        this.pageSetHomeItem.setAction(this.currentCanvas.getSetHomePageAction());
        if (this.currentCanvas instanceof VisualCanvas) {
            VisualCanvas visualCanvas = (VisualCanvas)this.currentCanvas;
            this.pageMenu.setText("Page");
            this.pageMenu.setMnemonic(80);
            this.contentMenu.setVisible(true);
            this.contentInkItem.setAction(visualCanvas.getChangeContentDisplayModeAction(Content.INK));
            this.contentTextItem.setAction(visualCanvas.getChangeContentDisplayModeAction(Content.TEXT));
            this.contentPictureItem.setAction(visualCanvas.getChangeContentDisplayModeAction(Content.IMAGE));
            this.contentChangePictureItem.setAction(visualCanvas.getChangeContentPictureAction());
        } else {
            this.pageMenu.setText("Form");
            this.pageMenu.setMnemonic(79);
            this.contentMenu.setVisible(false);
        }
        this.viewTemplatesItem.setSelected(this.canvasWithVisibleTemplates.contains(this.currentCanvas));
        logger.info(this + ": Current canvas is now " + this.currentCanvas.getDeviceType());
    }

    public DamaskDocument getDocument() {
        return this.canvasGroup.getDocument();
    }

    protected String getFileNameInTitleBar() {
        StringBuffer sb = new StringBuffer(this.getDocument().getDisplayedFileName());
        if (this.getDocument().getCanvasGroups().size() > 1) {
            int windowNumber = this.getDocument().getCanvasGroupIndex(this.canvasGroup);
            sb.append(":");
            sb.append(windowNumber + 1);
        }
        if (DamaskAppUtils.isMac()) {
            this.getRootPane().putClientProperty("windowModified", this.getDocument().isModified());
        } else if (this.getDocument().isModified()) {
            sb.append("*");
        }
        return sb.toString();
    }

    private void updateTitleBar() {
        StringBuffer sb = new StringBuffer(this.getFileNameInTitleBar());
        if (!DamaskAppUtils.isMac()) {
            sb.append(" - Damask");
        }
        final String titleBarString = sb.toString();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DamaskFrame.this.setTitle(titleBarString);
            }
        });
    }

    private static void updateAllWindowMenus() {
        Iterator i = allFrames.iterator();
        while (i.hasNext()) {
            DamaskFrame frame = (DamaskFrame)i.next();
            frame.updateWindowMenu();
        }
    }

    private void updateWindowMenu() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                int i = DamaskFrame.this.windowMenu.getItemCount() - 1;
                while (i >= DamaskFrame.this.FIRST_OPEN_WINDOW_POS) {
                    DamaskFrame.this.windowMenu.remove(i);
                    --i;
                }
                int count = 1;
                Iterator i2 = allFrames.iterator();
                while (i2.hasNext()) {
                    DamaskFrame frameInMenu = (DamaskFrame)i2.next();
                    JRadioButtonMenuItem rbMenuItem = new JRadioButtonMenuItem(new SwitchWindowAction(count, frameInMenu, frameInMenu.getFileNameInTitleBar()));
                    DamaskFrame.this.windowMenu.add(rbMenuItem);
                    if (frameInMenu == DamaskFrame.this) {
                        rbMenuItem.setSelected(true);
                    }
                    ++count;
                }
            }
        });
    }

    public boolean tryClose() {
        if (this.getDocument().getCanvasGroups().size() == 1) {
            return this.getDocument().tryClose(this);
        }
        this.setVisible(false);
        this.dispose();
        return true;
    }

    public void setCloseButtonEnabled(boolean flag) {
        if (flag) {
            this.addWindowListener(this.winHandler);
        } else {
            this.removeWindowListener(this.winHandler);
        }
    }

    public void setContentsEnabled(boolean flag) {
        this.getGlassPane().setVisible(!flag);
    }

    public String toString() {
        return String.valueOf(DamaskUtils.toShortString(this)) + " (" + this.getFileNameInTitleBar() + ")";
    }

    public DamaskRadarDialog getRadarDialog() {
        return this.radarView;
    }

    public void onRadarDialogVisibleChanged(final boolean flag) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DamaskFrame.this.viewRadarItem.setSelected(flag);
            }
        });
    }

    public void onPatternBrowserVisibleChanged(final boolean flag) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DamaskFrame.this.viewPatternItem.setState(flag);
            }
        });
    }

    public Action getNewAction() {
        return this.newAction;
    }

    public Action getOpenAction() {
        return this.openAction;
    }

    public Action getSaveAction() {
        return this.saveAction;
    }

    public Action getUndoAction() {
        return this.undoAction;
    }

    public Action getRedoAction() {
        return this.redoAction;
    }

    private class NewAction
    extends AbstractAction {
        public NewAction() {
            super("New");
            this.putValue("ShortDescription", "Creates a new document");
            this.putValue("MnemonicKey", new Integer(78));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(78, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            this.putValue("SmallIcon", DamaskToolbar.getToolbarIcon("new.png"));
            this.putValue("Disabled icon", DamaskToolbar.getToolbarDisabledIcon("new.png"));
        }

        public void actionPerformed(ActionEvent e) {
            DamaskFrame newFrame = DamaskApp.createNewDocument();
            newFrame.setBounds(DamaskFrame.this.getX() + 20, DamaskFrame.this.getY(), DamaskFrame.this.getWidth(), DamaskFrame.this.getHeight());
            newFrame.radarView.setLocation(newFrame.getX() + newFrame.getWidth() - DamaskFrame.this.radarView.getWidth(), newFrame.getY() + newFrame.getHeight() - DamaskFrame.this.radarView.getHeight());
            newFrame.radarView.setVisible(DamaskFrame.this.radarView.isVisible());
        }
    }

    private class OpenAction
    extends AbstractAction {
        public OpenAction() {
            super("Open...");
            this.putValue("ShortDescription", "Opens this document");
            this.putValue("MnemonicKey", new Integer(79));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(79, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            this.putValue("SmallIcon", DamaskToolbar.getToolbarIcon("open.png"));
            this.putValue("Disabled icon", DamaskToolbar.getToolbarDisabledIcon("open.png"));
        }

        public void actionPerformed(ActionEvent e) {
            File newFile = FileDialogUtils.showDamaskOpenDialog(DamaskFrame.this);
            if (newFile != null) {
                Iterator i = allFrames.iterator();
                while (i.hasNext()) {
                    DamaskFrame aFrame = (DamaskFrame)i.next();
                    if (!newFile.equals(aFrame.getDocument().getFile())) continue;
                    aFrame.toFront();
                    return;
                }
                try {
                    DamaskFrame newFrame = DamaskApp.openDocument(newFile);
                    boolean emptyDocument = !DamaskFrame.this.getDocument().isModified() && DamaskFrame.this.getDocument().getFile() == null;
                    int newWindowOffset = emptyDocument ? 0 : 20;
                    newFrame.setBounds(DamaskFrame.this.getX() + newWindowOffset, DamaskFrame.this.getY(), DamaskFrame.this.getWidth(), DamaskFrame.this.getHeight());
                    newFrame.radarView.setLocation(newFrame.getX() + newFrame.getWidth() - DamaskFrame.this.radarView.getWidth(), newFrame.getY() + newFrame.getHeight() - DamaskFrame.this.radarView.getHeight());
                    newFrame.radarView.setVisible(DamaskFrame.this.radarView.isVisible());
                    if (emptyDocument) {
                        DamaskFrame.this.tryClose();
                    }
                }
                catch (JAXBException e1) {
                    JOptionPane.showMessageDialog(DamaskFrame.this, "There is a problem opening " + newFile + ".\n\n" + e1.getMessage(), "Damask", 0);
                    DamaskAppExceptionHandler.log(e1);
                }
            }
        }
    }

    private class FileCloseAction
    extends AbstractAction {
        public FileCloseAction() {
            super("Close");
            this.putValue("ShortDescription", "Closes this document");
            this.putValue("MnemonicKey", new Integer(67));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(87, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        }

        public void actionPerformed(ActionEvent e) {
            DamaskFrame.this.getDocument().tryClose(DamaskFrame.this);
        }
    }

    private class SaveAction
    extends AbstractAction {
        public SaveAction() {
            super("Save");
            this.putValue("ShortDescription", "Saves this document");
            this.putValue("MnemonicKey", new Integer(83));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            this.putValue("SmallIcon", DamaskToolbar.getToolbarIcon("save.png"));
            this.putValue("Disabled icon", DamaskToolbar.getToolbarDisabledIcon("save.png"));
        }

        public void actionPerformed(ActionEvent e) {
            DamaskFrame.this.getDocument().trySave(DamaskFrame.this);
        }
    }

    private class SaveAsAction
    extends AbstractAction {
        public SaveAsAction() {
            super("Save As...");
            this.putValue("ShortDescription", "Saves this document with a new name");
            this.putValue("MnemonicKey", new Integer(65));
            if (DamaskAppUtils.isMac()) {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, 1 | Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            }
        }

        public void actionPerformed(ActionEvent e) {
            DamaskFrame.this.getDocument().trySaveAs(DamaskFrame.this);
        }
    }

    private class ExportAsVoiceXMLAction
    extends AbstractAction {
        public ExportAsVoiceXMLAction() {
            super("Export as VoiceXML...");
            this.putValue("ShortDescription", "Exports the voice portion of this document as a VoiceXML document");
            this.putValue("MnemonicKey", new Integer(86));
        }

        public void actionPerformed(ActionEvent e) {
            DamaskFrame.this.getDocument().tryExportAsVoiceXML(DamaskFrame.this);
        }
    }

    private class ExportAsImageAction
    extends AbstractAction {
        public ExportAsImageAction() {
            super("Export as Image...");
            this.putValue("ShortDescription", "Exports the current tab as an image");
            this.putValue("MnemonicKey", new Integer(69));
        }

        public void actionPerformed(ActionEvent e) {
            DamaskFrame.this.getCurrentCanvas().tryExportAsImage(DamaskFrame.this);
        }
    }

    private class ExitAction
    extends AbstractAction {
        public ExitAction() {
            super("Exit");
            this.putValue("ShortDescription", "Exits Damask");
            this.putValue("MnemonicKey", new Integer(88));
        }

        public void actionPerformed(ActionEvent e) {
            DamaskApp.tryExit();
        }
    }

    private class UndoAction
    extends AbstractAction {
        public UndoAction() {
            super("Undo");
            this.putValue("ShortDescription", "Undoes the last action");
            this.putValue("MnemonicKey", new Integer(85));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            this.putValue("SmallIcon", DamaskToolbar.getToolbarIcon("undo.png"));
            this.putValue("Disabled icon", DamaskToolbar.getToolbarDisabledIcon("undo.png"));
        }

        public void actionPerformed(ActionEvent e) {
            DamaskFrame.this.canvasGroup.getDocument().getCommandQueue().undo();
        }
    }

    private class RedoAction
    extends AbstractAction {
        public RedoAction() {
            super("Redo");
            this.putValue("ShortDescription", "Redoes the last action");
            this.putValue("MnemonicKey", new Integer(82));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(89, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            this.putValue("SmallIcon", DamaskToolbar.getToolbarIcon("redo.png"));
            this.putValue("Disabled icon", DamaskToolbar.getToolbarDisabledIcon("redo.png"));
        }

        public void actionPerformed(ActionEvent e) {
            DamaskFrame.this.canvasGroup.getDocument().getCommandQueue().redo();
        }
    }

    private class ViewRadarAction
    extends AbstractAction {
        public ViewRadarAction() {
            super("Thumbnail");
            this.putValue("ShortDescription", "Displays a thumbnail view of your design");
            this.putValue("MnemonicKey", new Integer(72));
        }

        public void actionPerformed(ActionEvent e) {
            DamaskFrame.this.radarView.setVisible(!DamaskFrame.this.radarView.isVisible());
        }
    }

    private class ViewPatternAction
    extends AbstractAction {
        public ViewPatternAction() {
            super("Pattern Browser");
            this.putValue("ShortDescription", "Displays the pattern browser");
            this.putValue("MnemonicKey", new Integer(80));
        }

        public void actionPerformed(ActionEvent e) {
            Cursor oldCursor = DamaskFrame.this.getCursor();
            DamaskFrame.this.setCursor(Cursor.getPredefinedCursor(3));
            PatternBrowser patternBrowser = DamaskApp.getPatternBrowser();
            patternBrowser.setVisible(!patternBrowser.isVisible());
            DamaskFrame.this.setCursor(oldCursor);
        }
    }

    private class NewWindowAction
    extends AbstractAction {
        public NewWindowAction() {
            super("New Window");
            this.putValue("ShortDescription", "Creates a new window for this document");
            this.putValue("MnemonicKey", new Integer(78));
        }

        public void actionPerformed(ActionEvent e) {
            DamaskFrame newFrame = new DamaskFrame(DamaskFrame.this.getDocument().createCanvasGroup());
            newFrame.initialize();
            newFrame.setBounds(DamaskFrame.this.getX() + 20, DamaskFrame.this.getY(), DamaskFrame.this.getWidth(), DamaskFrame.this.getHeight());
            newFrame.setVisible(true);
            newFrame.radarView.setLocation(newFrame.getX() + newFrame.getWidth() - DamaskFrame.this.radarView.getWidth(), newFrame.getY() + newFrame.getHeight() - DamaskFrame.this.radarView.getHeight());
            newFrame.radarView.setVisible(DamaskFrame.this.radarView.isVisible());
            DamaskFrame.this.updateTitleBar();
        }
    }

    private class CloseWindowAction
    extends AbstractAction {
        public CloseWindowAction() {
            super("Close");
            this.putValue("ShortDescription", "Closes this window");
            this.putValue("MnemonicKey", new Integer(67));
        }

        public void actionPerformed(ActionEvent e) {
            DamaskFrame.this.tryClose();
        }
    }

    private class SwitchWindowAction
    extends AbstractAction {
        private Window window;

        public SwitchWindowAction(int index, Window window, String windowName) {
            if (index < 10) {
                this.putValue("Name", String.valueOf(Integer.toString(index)) + " " + windowName);
            } else {
                this.putValue("Name", windowName);
            }
            this.putValue("ShortDescription", "Switches to this window");
            if (index >= 1 && index <= 9) {
                this.putValue("MnemonicKey", new Integer(index + 48));
            }
            this.window = window;
        }

        public void actionPerformed(ActionEvent e) {
            this.window.toFront();
            if (e.getSource() instanceof JRadioButtonMenuItem) {
                if (this.window != DamaskFrame.this) {
                    ((JRadioButtonMenuItem)e.getSource()).setSelected(false);
                } else {
                    ((JRadioButtonMenuItem)e.getSource()).setSelected(true);
                }
            }
        }
    }

    private class TemplatePaneAction
    extends AbstractAction {
        public TemplatePaneAction() {
            super("Templates");
            this.putValue("MnemonicKey", new Integer(84));
        }

        public void actionPerformed(ActionEvent e) {
            DamaskLayer layer = (DamaskLayer)DamaskFrame.this.currentCanvas.getLayer();
            TemplatePane templatePane = layer.getTemplatePane();
            templatePane.setExpanded(DamaskFrame.this.currentCanvas.getCamera(), !templatePane.isExpanded(), true);
            if (templatePane.isExpanded()) {
                DamaskFrame.this.canvasWithVisibleTemplates.add(DamaskFrame.this.currentCanvas);
                templatePane.setVisibleToCamera(DamaskFrame.this.currentCanvas.getCamera());
                logger.info(DamaskFrame.this + ": Template pane visible");
            } else {
                DamaskFrame.this.canvasWithVisibleTemplates.remove(DamaskFrame.this.currentCanvas);
                logger.info(DamaskFrame.this + ": Template pane not visible");
            }
        }
    }

    private class WindowHandler
    extends WindowAdapter {
        WindowHandler() {
        }

        public void windowClosing(WindowEvent e) {
            DamaskFrame.this.tryClose();
        }

        public void windowGainedFocus(WindowEvent e) {
            DamaskApp.setCurrentFrame(DamaskFrame.this);
            DamaskCamera camera = (DamaskCamera)DamaskFrame.this.currentCanvas.getCamera();
            PLayer layer = DamaskFrame.this.currentCanvas.getLayer();
            if (layer instanceof DamaskLayer) {
                TemplatePane templatePane = ((DamaskLayer)layer).getTemplatePane();
                templatePane.setVisibleToCamera(camera);
                templatePane.setExpanded(camera, DamaskFrame.this.canvasWithVisibleTemplates.contains(DamaskFrame.this.currentCanvas), false);
            }
            logger.info(DamaskFrame.this + " gained focus");
        }

        public void windowLostFocus(WindowEvent e) {
            PLayer layer = DamaskFrame.this.currentCanvas.getLayer();
            if (layer instanceof DamaskLayer) {
                ((DamaskLayer)layer).getTemplatePane().setVisibleToCamera(null);
            }
            logger.info(DamaskFrame.this + " lost focus");
        }
    }

    private class CommandHandler
    implements CommandListener {
        CommandHandler() {
        }

        private void updateActionsEnabledState(CommandEvent e) {
            CommandQueue q = e.getCommandQueue();
            DamaskFrame.this.undoAction.setEnabled(q.canUndo());
            DamaskFrame.this.redoAction.setEnabled(q.canRedo());
            if (DamaskFrame.this.isFocused()) {
                int i = 0;
                int n = DamaskFrame.this.tabPane.getComponentCount();
                while (i < n) {
                    DamaskCanvas canvas = (DamaskCanvas)((JComponent)DamaskFrame.this.tabPane.getComponentAt(i)).getClientProperty(DamaskFrame.PROPERTY_CANVAS);
                    if (canvas.getDeviceType() == ((DamaskCanvas)e.getCanvas()).getDeviceType()) {
                        DamaskFrame.this.tabPane.setSelectedIndex(i);
                        return;
                    }
                    ++i;
                }
            }
        }

        public void commandExecuted(CommandEvent e) {
            this.updateActionsEnabledState(e);
        }

        public void commandUndone(CommandEvent e) {
            this.updateActionsEnabledState(e);
        }

        public void commandRedone(CommandEvent e) {
            this.updateActionsEnabledState(e);
        }
    }

    private class TabbedPaneListener
    implements ChangeListener {
        static final /* synthetic */ boolean $assertionsDisabled;
        static /* synthetic */ Class class$0;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("edu.berkeley.guir.damask.view.DamaskFrame$TabbedPaneListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        TabbedPaneListener() {
        }

        public void stateChanged(ChangeEvent e) {
            if (!$assertionsDisabled && e.getSource() != DamaskFrame.this.tabPane) {
                throw new AssertionError((Object)("Receiving events from " + e.getSource() + " instead of " + DamaskFrame.this.tabPane));
            }
            DamaskFrame.this.updateCurrentCanvas();
        }
    }

    private class DocumentHandler
    implements DocumentListener {
        DocumentHandler() {
        }

        public void documentModified(DocumentEvent e) {
            if (e.getDocument() == DamaskFrame.this.getDocument()) {
                DamaskFrame.this.updateTitleBar();
            }
            DamaskFrame.updateAllWindowMenus();
        }

        public void documentCleaned(DocumentEvent e) {
            if (e.getDocument() == DamaskFrame.this.getDocument()) {
                DamaskFrame.this.updateTitleBar();
            }
            DamaskFrame.updateAllWindowMenus();
        }

        public void documentRenamed(DocumentEvent e) {
            if (e.getDocument() == DamaskFrame.this.getDocument()) {
                DamaskFrame.this.updateTitleBar();
            }
            DamaskFrame.updateAllWindowMenus();
        }

        public void documentClosed(DocumentEvent e) {
            e.getDocument().removeDocumentListener(DamaskFrame.this.docListener);
        }

        public void documentBusyStarted(DocumentEvent e) {
            if (e.getDocument() == DamaskFrame.this.getDocument()) {
                DamaskFrame.this.setCloseButtonEnabled(false);
                DamaskFrame.this.setContentsEnabled(false);
                DamaskFrame.this.setCursor(Cursor.getPredefinedCursor(3));
            }
        }

        public void documentBusyStopped(DocumentEvent e) {
            if (e.getDocument() == DamaskFrame.this.getDocument()) {
                DamaskFrame.this.setContentsEnabled(true);
                DamaskFrame.this.setCloseButtonEnabled(true);
                DamaskFrame.this.setCursor(Cursor.getDefaultCursor());
            }
        }

        public void canvasGroupAdded(DocumentEvent e) {
        }

        public void canvasGroupRemoved(DocumentEvent e) {
        }
    }

    private class EventSwallowerGlassPane
    extends JComponent {
        public EventSwallowerGlassPane() {
            MouseInputAdapter emptyAdapter = new MouseInputAdapter(this){
                final /* synthetic */ EventSwallowerGlassPane this$1;
                {
                    this.this$1 = eventSwallowerGlassPane;
                }
            };
            this.addMouseListener(emptyAdapter);
            this.addMouseMotionListener(emptyAdapter);
        }
    }

    private static class FrameNameComparator
    implements Comparator {
        FrameNameComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (!(o1 instanceof DamaskFrame)) {
                throw new ClassCastException("o1 must be of type DamaskFrame, not " + (o1 == null ? null : o1.getClass()));
            }
            if (!(o2 instanceof DamaskFrame)) {
                throw new ClassCastException("o2 must be of type DamaskFrame, not " + (o2 == null ? null : o2.getClass()));
            }
            DamaskFrame f1 = (DamaskFrame)o1;
            DamaskFrame f2 = (DamaskFrame)o2;
            return f1.getFileNameInTitleBar().compareTo(f2.getFileNameInTitleBar());
        }
    }

    private class PanButtonMouseHandler
    implements MouseListener {
        private DamaskCamera camera;
        private double dx;
        private double dy;

        public PanButtonMouseHandler(DamaskCamera camera, double x, double y) {
            this.camera = camera;
            this.dx = x;
            this.dy = y;
        }

        public void mouseClicked(MouseEvent event) {
        }

        public void mouseEntered(MouseEvent event) {
        }

        public void mouseExited(MouseEvent event) {
        }

        public void mousePressed(MouseEvent event) {
            this.camera.getPanActivity().setDirection(this.dx, this.dy);
            this.camera.setPanning(true);
        }

        public void mouseReleased(MouseEvent event) {
            this.camera.setPanning(false);
        }
    }
}

