/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.view;

import edu.berkeley.guir.damask.Damask;
import edu.berkeley.guir.damask.DamaskUtils;
import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.InteractionGraph;
import edu.berkeley.guir.damask.command.ModifyGraphCommand;
import edu.berkeley.guir.damask.io.DamaskReader;
import edu.berkeley.guir.damask.io.DamaskWriter;
import edu.berkeley.guir.damask.io.VoiceXMLWriter;
import edu.berkeley.guir.damask.view.DamaskAppExceptionHandler;
import edu.berkeley.guir.damask.view.DamaskAppUtils;
import edu.berkeley.guir.damask.view.DamaskCanvas;
import edu.berkeley.guir.damask.view.DamaskFrame;
import edu.berkeley.guir.damask.view.appdialogs.FileDialogUtils;
import edu.berkeley.guir.damask.view.appevent.CommandEvent;
import edu.berkeley.guir.damask.view.appevent.CommandEventSource;
import edu.berkeley.guir.damask.view.appevent.CommandListener;
import edu.berkeley.guir.damask.view.appevent.DocumentEventSource;
import edu.berkeley.guir.damask.view.appevent.DocumentListener;
import edu.berkeley.guir.lib.io.FileLib;
import edu.berkeley.guir.lib.satin.command.Command;
import edu.berkeley.guir.lib.satin.command.LinearCommandQueue;
import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.util.PAffineTransform;
import java.awt.Window;
import java.awt.geom.AffineTransform;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.xml.bind.JAXBException;

public class DamaskDocument {
    private static final Logger logger;
    private final InteractionGraph graph;
    private final List canvasGroups = new ArrayList();
    private final VerboseCommandQueue cmdQueue = new VerboseCommandQueue();
    private final DocumentEventSource eventSource = new DocumentEventSource();
    private final int newDocNum;
    private File file = null;
    private int numModifications = 0;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.damask.view.DamaskDocument");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getName());
    }

    public DamaskDocument(InteractionGraph graph, int newDocNum) {
        this.graph = graph;
        this.file = null;
        this.newDocNum = newDocNum;
        this.init();
    }

    public DamaskDocument(File file) throws JAXBException {
        this.graph = DamaskReader.open(file);
        this.file = file;
        this.newDocNum = -1;
        this.init();
    }

    private void init() {
        this.cmdQueue.addCommandListener(new CommandHandler());
        logger.info(this + " created");
    }

    public InteractionGraph getGraph() {
        return this.graph;
    }

    public synchronized void addDocumentListener(DocumentListener listener) {
        this.eventSource.addDocumentListener(listener);
    }

    public synchronized void removeDocumentListener(DocumentListener listener) {
        this.eventSource.removeDocumentListener(listener);
    }

    protected void fireCanvasGroupAdded() {
        this.eventSource.fireCanvasGroupAdded(this);
    }

    protected void fireCanvasGroupRemoved() {
        this.eventSource.fireCanvasGroupRemoved(this);
    }

    protected void fireDocumentRenamed() {
        this.eventSource.fireDocumentRenamed(this);
    }

    protected void fireDocumentBusyStarted() {
        this.eventSource.fireDocumentBusyStarted(this);
    }

    protected void fireDocumentBusyStopped() {
        this.eventSource.fireDocumentBusyStopped(this);
    }

    protected void fireDocumentClosed() {
        this.eventSource.fireDocumentClosed(this);
    }

    protected void fireDocumentModified() {
        this.eventSource.fireDocumentModified(this);
    }

    protected void fireDocumentCleaned() {
        this.eventSource.fireDocumentCleaned(this);
    }

    public DamaskCanvasGroup createCanvasGroup() {
        DamaskCanvasGroup newGroup = new DamaskCanvasGroup();
        this.canvasGroups.add(newGroup);
        this.fireCanvasGroupAdded();
        return newGroup;
    }

    public boolean removeCanvasGroup(DamaskCanvasGroup group) {
        boolean result = this.canvasGroups.remove(group);
        this.fireCanvasGroupRemoved();
        return result;
    }

    public List getCanvasGroups() {
        return Collections.unmodifiableList(this.canvasGroups);
    }

    public int getCanvasGroupIndex(DamaskCanvasGroup canvasGroup) {
        return this.canvasGroups.indexOf(canvasGroup);
    }

    public Collection getWindows() {
        HashSet<Window> windows = new HashSet<Window>();
        Iterator i = this.canvasGroups.iterator();
        while (i.hasNext()) {
            DamaskCanvasGroup group = (DamaskCanvasGroup)i.next();
            Iterator j = group.getCanvases().iterator();
            while (j.hasNext()) {
                DamaskCanvas canvas = (DamaskCanvas)j.next();
                windows.add(SwingUtilities.windowForComponent(canvas));
            }
        }
        return windows;
    }

    public String getDisplayedFileName() {
        if (this.file == null) {
            StringBuffer sb = new StringBuffer();
            if (DamaskAppUtils.isMac()) {
                sb.append("untitled");
                if (this.newDocNum > 1) {
                    sb.append(" ");
                    sb.append(this.newDocNum);
                }
            } else {
                sb.append("Document" + this.newDocNum);
            }
            return sb.toString();
        }
        return this.file.getName();
    }

    private void save(File newFile, Window parentWindow) {
        try {
            String newFilePath = newFile.getAbsolutePath();
            File tempFile = new File(String.valueOf(newFilePath) + ".part");
            FileWriter writer = new FileWriter(tempFile);
            DamaskWriter.save(this.getGraph(), (DamaskFrame)parentWindow, writer);
            writer.close();
            this.clearModified();
            if (newFile.exists()) {
                long newFileModified = newFile.lastModified();
                String dateStr = DamaskUtils.dateToISO(newFileModified).replace(':', '-');
                String bakFileNameMain = FileLib.removeFileNameExtension(newFile.getAbsolutePath());
                String bakFileNameExt = FileLib.getFileNameExtension(newFile.getAbsolutePath());
                newFile.renameTo(new File(String.valueOf(bakFileNameMain) + "-" + dateStr + "." + bakFileNameExt));
            }
            tempFile.renameTo(new File(newFilePath));
            logger.info(this + " saved");
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(parentWindow, "There is a problem writing " + newFile + ".\n\n" + e.getMessage(), "Damask", 0);
            DamaskAppExceptionHandler.log(e);
        }
        this.fireDocumentBusyStopped();
    }

    private void exportVoiceXML(File newFile, Window parentWindow) {
        try {
            String newFilePath = newFile.getAbsolutePath();
            File tempFile = new File(String.valueOf(newFilePath) + ".part");
            FileWriter writer = new FileWriter(tempFile);
            VoiceXMLWriter.save(this.getGraph(), writer);
            writer.close();
            this.clearModified();
            if (newFile.exists()) {
                long newFileModified = newFile.lastModified();
                String dateStr = DamaskUtils.dateToISO(newFileModified).replace(':', '-');
                String bakFileNameMain = FileLib.removeFileNameExtension(newFile.getAbsolutePath());
                String bakFileNameExt = FileLib.getFileNameExtension(newFile.getAbsolutePath());
                newFile.renameTo(new File(String.valueOf(bakFileNameMain) + "-" + dateStr + "." + bakFileNameExt));
            }
            tempFile.renameTo(new File(newFilePath));
            logger.info(this + " saved");
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(parentWindow, "There is a problem writing " + newFile + ".\n\n" + e.getMessage(), "Damask", 0);
            DamaskAppExceptionHandler.log(e);
        }
        this.fireDocumentBusyStopped();
    }

    public boolean trySave(Window parentWindow) {
        if (this.file == null) {
            return this.trySaveAs(parentWindow);
        }
        this.save(this.file, parentWindow);
        return true;
    }

    public boolean trySaveAs(Window parentWindow) {
        File newFile = FileDialogUtils.showDamaskSaveDialog(parentWindow);
        if (newFile != null) {
            this.save(newFile, parentWindow);
            this.setFile(newFile);
            logger.info(this + ": new name");
            return true;
        }
        return false;
    }

    public boolean tryExportAsVoiceXML(Window parentWindow) {
        File newFile = FileDialogUtils.showExportVoiceXMLDialog(parentWindow);
        if (newFile != null) {
            this.exportVoiceXML(newFile, parentWindow);
            logger.info(this + ": export as VoiceXML");
            return true;
        }
        return false;
    }

    public boolean tryClose(Window parentWindow) {
        boolean isClosing;
        if (this.isModified()) {
            int result;
            if (parentWindow == null) {
                DamaskCanvas firstCanvas = ((DamaskCanvasGroup)this.canvasGroups.get(0)).getCanvas(DeviceType.DESKTOP);
                parentWindow = SwingUtilities.windowForComponent(firstCanvas);
            }
            isClosing = (result = FileDialogUtils.promptToSave(parentWindow, this.getDisplayedFileName())) == 0 ? this.trySave(parentWindow) : result == 1;
        } else {
            isClosing = true;
        }
        if (isClosing) {
            logger.info(this + " closed");
            this.fireDocumentClosed();
            return true;
        }
        return false;
    }

    public boolean isModified() {
        return this.numModifications != 0;
    }

    private void fireDocumentModifiedOrCleaned(int oldNumModifications, int newNumModifications) {
        if (oldNumModifications == 0) {
            this.fireDocumentModified();
        } else if (oldNumModifications != 0 && newNumModifications == 0) {
            this.fireDocumentCleaned();
        }
    }

    protected void incrModified() {
        int oldNumModifications = this.numModifications++;
        this.fireDocumentModifiedOrCleaned(oldNumModifications, this.numModifications);
    }

    protected void decrModified() {
        int oldNumModifications = this.numModifications--;
        this.fireDocumentModifiedOrCleaned(oldNumModifications, this.numModifications);
    }

    protected void clearModified() {
        this.numModifications = 0;
        this.fireDocumentCleaned();
    }

    public File getFile() {
        return this.file;
    }

    protected void setFile(File file) {
        this.file = file;
        this.fireDocumentRenamed();
    }

    public String toString() {
        return String.valueOf(DamaskUtils.toShortString(this)) + " (" + this.getDisplayedFileName() + ")";
    }

    public VerboseCommandQueue getCommandQueue() {
        return this.cmdQueue;
    }

    public static class VerboseCommandQueue
    extends LinearCommandQueue {
        private CommandEventSource commandEventSource = new CommandEventSource();
        private Map canvasForCommand = new HashMap();
        private Map cameraTransformForCommand = new HashMap();
        private static Logger logger;
        static /* synthetic */ Class class$0;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("edu.berkeley.guir.damask.view.DamaskDocument$VerboseCommandQueue");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            logger = Logger.getLogger(clazz.getName());
        }

        public void addCommandListener(CommandListener listener) {
            this.commandEventSource.addCommandListener(listener);
        }

        public void removeCommandListener(CommandListener listener) {
            this.commandEventSource.removeCommandListener(listener);
        }

        public synchronized void doCommand(PCanvas canvas, Command cmd) {
            super.doCommand(cmd);
            logger.info("Command done: " + cmd.getPresentationName());
            PAffineTransform canvasTransform = canvas == null ? null : canvas.getCamera().getViewTransform();
            this.canvasForCommand.put(cmd, canvas);
            this.cameraTransformForCommand.put(cmd, canvasTransform);
            this.commandEventSource.fireCommandExecuted(this, cmd, canvas, canvasTransform);
        }

        public synchronized void doCommand(Command cmd) {
            this.doCommand(null, cmd);
        }

        public synchronized void undo() throws CannotUndoException {
            Command edit = (Command)this.editToBeUndone();
            super.undo();
            logger.info("Command undone: " + edit.getPresentationName());
            this.commandEventSource.fireCommandUndone(this, edit, (PCanvas)this.canvasForCommand.get(edit), (AffineTransform)this.cameraTransformForCommand.get(edit));
        }

        public synchronized void redo() throws CannotRedoException {
            Command edit = (Command)this.editToBeRedone();
            super.redo();
            logger.info("Command redone: " + edit.getPresentationName());
            this.commandEventSource.fireCommandRedone(this, edit, (PCanvas)this.canvasForCommand.get(edit), (AffineTransform)this.cameraTransformForCommand.get(edit));
        }
    }

    private class CommandHandler
    implements CommandListener {
        CommandHandler() {
        }

        private void update(CommandEvent e, int deltaModified) {
            if (e.getCommand() instanceof ModifyGraphCommand) {
                if (deltaModified == 1) {
                    DamaskDocument.this.incrModified();
                } else if (deltaModified == -1) {
                    DamaskDocument.this.decrModified();
                }
            }
        }

        public void commandExecuted(CommandEvent e) {
            this.update(e, 1);
        }

        public void commandUndone(CommandEvent e) {
            this.update(e, -1);
        }

        public void commandRedone(CommandEvent e) {
            this.update(e, 1);
        }
    }

    public class DamaskCanvasGroup {
        private Map canvases = new HashMap();

        private DamaskCanvasGroup() {
            Iterator i = Damask.getSupportedDeviceTypes().iterator();
            while (i.hasNext()) {
                DeviceType deviceType = (DeviceType)i.next();
                this.canvases.put(deviceType, DamaskCanvas.create(this, deviceType));
            }
        }

        public DamaskCanvas getCanvas(DeviceType deviceType) {
            return (DamaskCanvas)this.canvases.get(deviceType);
        }

        public Collection getCanvases() {
            return this.canvases.values();
        }

        public DamaskDocument getDocument() {
            return DamaskDocument.this;
        }
    }
}

