/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.view;

import edu.berkeley.guir.damask.DamaskUtils;
import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.InteractionElement;
import edu.berkeley.guir.damask.command.AddPatternInstanceCommand;
import edu.berkeley.guir.damask.command.ModifyGraphMacroCommand;
import edu.berkeley.guir.damask.command.RemoveControlCommand;
import edu.berkeley.guir.damask.command.ReplaceComponentWithDeviceAllVersionCommand;
import edu.berkeley.guir.damask.command.SetBoundsCommand;
import edu.berkeley.guir.damask.command.SetTransformCommand;
import edu.berkeley.guir.damask.command.SplitComponentIntoDeviceSpecificVersionsCommand;
import edu.berkeley.guir.damask.component.Component;
import edu.berkeley.guir.damask.component.Control;
import edu.berkeley.guir.damask.component.SelectMany;
import edu.berkeley.guir.damask.component.SelectOne;
import edu.berkeley.guir.damask.component.TextInput;
import edu.berkeley.guir.damask.component.Trigger;
import edu.berkeley.guir.damask.dialog.Dialog;
import edu.berkeley.guir.damask.dialog.Page;
import edu.berkeley.guir.damask.dialog.PageRegion;
import edu.berkeley.guir.damask.pattern.PatternSolution;
import edu.berkeley.guir.damask.view.DamaskAppExceptionHandler;
import edu.berkeley.guir.damask.view.DamaskAppMode;
import edu.berkeley.guir.damask.view.DamaskAppUtils;
import edu.berkeley.guir.damask.view.DamaskCamera;
import edu.berkeley.guir.damask.view.DamaskDocument;
import edu.berkeley.guir.damask.view.DamaskLayer;
import edu.berkeley.guir.damask.view.DamaskObjectSelection;
import edu.berkeley.guir.damask.view.DamaskToolbar;
import edu.berkeley.guir.damask.view.InteractionElementView;
import edu.berkeley.guir.damask.view.TemplatePane;
import edu.berkeley.guir.damask.view.appdialogs.FileDialogUtils;
import edu.berkeley.guir.damask.view.appevent.CanvasEvent;
import edu.berkeley.guir.damask.view.appevent.CanvasEventSource;
import edu.berkeley.guir.damask.view.appevent.CanvasListener;
import edu.berkeley.guir.damask.view.appevent.CommandEvent;
import edu.berkeley.guir.damask.view.appevent.CommandListener;
import edu.berkeley.guir.damask.view.appevent.LayerEvent;
import edu.berkeley.guir.damask.view.appevent.LayerListener;
import edu.berkeley.guir.damask.view.event.PanningHandEventHandler;
import edu.berkeley.guir.damask.view.event.PopupMenuEventHandler;
import edu.berkeley.guir.damask.view.event.PullToAllDeviceTypesEventHandler;
import edu.berkeley.guir.damask.view.event.PushToSingleDeviceTypeEventHandler;
import edu.berkeley.guir.damask.view.event.SelectionEventHandler;
import edu.berkeley.guir.damask.view.nodes.DamaskWindow;
import edu.berkeley.guir.damask.view.nodes.DragBar;
import edu.berkeley.guir.damask.view.nodes.NonResizableHandle;
import edu.berkeley.guir.damask.view.nodes.SizeGrip;
import edu.berkeley.guir.damask.view.pattern.PatternBrowser;
import edu.berkeley.guir.damask.view.pattern.PatternInstanceView;
import edu.berkeley.guir.damask.view.visual.VisualCanvas;
import edu.berkeley.guir.damask.view.visual.component.ComponentView;
import edu.berkeley.guir.damask.view.visual.component.RadioButton;
import edu.berkeley.guir.damask.view.voice.VoiceCanvas;
import edu.berkeley.guir.damask.view.voice.component.Prompt;
import edu.berkeley.guir.damask.view.voice.component.Response;
import edu.berkeley.guir.damask.view.voice.component.VoiceComponent;
import edu.berkeley.guir.lib.collection.Map2D;
import edu.berkeley.guir.lib.io.FileLib;
import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.PRoot;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.event.PInputEventFilter;
import edu.umd.cs.piccolo.event.PInputEventListener;
import edu.umd.cs.piccolo.util.PAffineTransform;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolox.handles.PBoundsHandle;
import edu.umd.cs.piccolox.util.PBoundsLocator;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class DamaskCanvas
extends PCanvas {
    private static final Point POINT00 = new Point(0, 0);
    public static final String SELECTION_MODE = "Select/Move";
    public static final String HAND_MODE = "Pan";
    public static final String TO_ALL_DEVICES_MODE = "Change to All Device Types";
    public static final String TO_SINGLE_DEVICE_MODE = "Change to This Device Type";
    private static final Logger logger;
    public static final Map2D BACKGROUND_PAINTS;
    private static final int ACCEPTABLE_DROP_ACTIONS = 3;
    private final DropTarget dropTarget;
    private final DamaskDocument.DamaskCanvasGroup group;
    private DamaskAppMode appMode = null;
    private PInputEventListener appModeHandler = null;
    private PNode insideNode = null;
    private final SelectionEventHandler selectionEventHandler;
    private final Map modes = new HashMap();
    private Collection objectsToCopy = null;
    public static final int SITEMAP = 1;
    public static final int STORYBOARD = 3;
    public static final int BETWEEN_STORYBOARD_PAGE = 5;
    public static final int PAGE = 7;
    public static final int BETWEEN_PAGE_DETAIL = 9;
    public static final int DETAIL = 11;
    public static final int BELOW_DETAIL = 13;
    private final BoundedRangeModel sliderModel = new DefaultBoundedRangeModel(7, 0, 1, 13);
    private boolean zoomCenteredAtUpperLeft = false;
    private final CanvasEventSource eventSource = new CanvasEventSource();
    private final MouseWheelHandler mouseWheelHandler = new MouseWheelHandler();
    private Point2D zoomCenterMousePosition = null;
    private final Action cutAction = new CutAction();
    private final Action copyAction = new CopyAction();
    private final Action pasteAction = new PasteAction();
    private final Action deleteAction = new DeleteAction();
    private final Action changeLayerOfObjectAction = new ChangeLayerOfObjectAction();
    private boolean textEditing = false;
    private final JPopupMenu plainPopupMenu = new JPopupMenu();
    private final PopupMenuEventHandler popupMenuEventHandler;
    private DamaskWindow currentWindow = null;
    private boolean windowIsManipulated = false;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.damask.view.DamaskCanvas");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getName());
        BACKGROUND_PAINTS = new Map2D();
        Color desktopColor = new Color(250, 240, 220);
        Color smartphoneColor = new Color(220, 250, 240);
        Color voiceColor = new Color(220, 220, 250);
        BACKGROUND_PAINTS.put(DeviceType.DESKTOP, DamaskLayer.DeviceTypeLayer.DEVICE, desktopColor);
        BACKGROUND_PAINTS.put(DeviceType.SMARTPHONE, DamaskLayer.DeviceTypeLayer.DEVICE, smartphoneColor);
        BACKGROUND_PAINTS.put(DeviceType.VOICE, DamaskLayer.DeviceTypeLayer.DEVICE, voiceColor);
        BACKGROUND_PAINTS.put(DeviceType.DESKTOP, DamaskLayer.DeviceTypeLayer.ALL, new GradientPaint(0.0f, 0.0f, desktopColor, 50.0f, 50.0f, DamaskAppUtils.createDarkerColor(desktopColor, 0.85), true));
        BACKGROUND_PAINTS.put(DeviceType.SMARTPHONE, DamaskLayer.DeviceTypeLayer.ALL, new GradientPaint(0.0f, 0.0f, smartphoneColor, 50.0f, 50.0f, DamaskAppUtils.createDarkerColor(smartphoneColor, 0.85), true));
        BACKGROUND_PAINTS.put(DeviceType.VOICE, DamaskLayer.DeviceTypeLayer.ALL, new GradientPaint(0.0f, 0.0f, voiceColor, 50.0f, 50.0f, DamaskAppUtils.createDarkerColor(voiceColor, 0.85), true));
    }

    public DamaskCanvas(DamaskDocument.DamaskCanvasGroup group, DeviceType deviceType) {
        this(group, deviceType, 1.0);
    }

    public DamaskCanvas(DamaskDocument.DamaskCanvasGroup group, DeviceType deviceType, double pageTitleScale) {
        this.group = group;
        PRoot root = this.getRoot();
        PLayer oldLayer = this.getLayer();
        PCamera oldCamera = this.getCamera();
        root.removeChild(oldLayer);
        root.removeChild(oldCamera);
        oldCamera.removeLayer(oldLayer);
        DamaskCamera camera = new DamaskCamera();
        DamaskLayer damaskLayer = DamaskLayer.create(group.getDocument(), deviceType, pageTitleScale);
        this.setCamera(camera);
        root.addChild(camera);
        root.addChild(damaskLayer);
        this.selectionEventHandler = new SelectionEventHandler((PNode)damaskLayer, new ArrayList());
        this.selectionEventHandler.setEventFilter(new PInputEventFilter(16));
        camera.addLayer(damaskLayer);
        damaskLayer.addLayerListener(new LayerHandler());
        this.updateBackgroundColor();
        this.sliderModel.addChangeListener(new SliderModelHandler());
        this.addCanvasListener(new SelectionChangeHandler());
        this.removeInputEventListener(this.getPanEventHandler());
        this.addInputEventListener(this.mouseWheelHandler);
        this.modes.put(SELECTION_MODE, this.getSelectionAppMode());
        this.modes.put(HAND_MODE, new DamaskAppMode(HAND_MODE, new PanningHandEventHandler(), DamaskAppUtils.createCursor("hand.gif", new Point(8, 0), "Hand")));
        this.modes.put(TO_ALL_DEVICES_MODE, new DamaskAppMode(TO_ALL_DEVICES_MODE, new PullToAllDeviceTypesEventHandler(), null));
        this.modes.put(TO_SINGLE_DEVICE_MODE, new DamaskAppMode(TO_SINGLE_DEVICE_MODE, new PushToSingleDeviceTypeEventHandler(), null));
        this.setTransferHandler(new DamaskObjectSelection());
        this.dropTarget = new DropTarget(this, 3, new DropTargetHandler(), true);
        this.getDocument().getCommandQueue().addCommandListener(new CommandHandler());
        this.setLayout(null);
        this.cutAction.setEnabled(false);
        this.copyAction.setEnabled(false);
        this.deleteAction.setEnabled(false);
        this.changeLayerOfObjectAction.setEnabled(false);
        this.plainPopupMenu.add(new JMenuItem(this.cutAction));
        this.plainPopupMenu.add(new JMenuItem(this.copyAction));
        this.plainPopupMenu.add(new JMenuItem(this.pasteAction));
        this.plainPopupMenu.add(new JMenuItem(this.deleteAction));
        this.popupMenuEventHandler = new PopupMenuEventHandler(this);
        this.addInputEventListener(this.popupMenuEventHandler);
    }

    public DamaskAppMode getSelectionAppMode() {
        return new DamaskAppMode(SELECTION_MODE, this.selectionEventHandler, null);
    }

    public static DamaskCanvas create(DamaskDocument.DamaskCanvasGroup group, DeviceType deviceType) {
        return DamaskCanvas.create(group, deviceType, 1.0);
    }

    public static DamaskCanvas create(DamaskDocument.DamaskCanvasGroup group, DeviceType deviceType, double pageTitleScale) {
        if (deviceType.isVisual()) {
            return new VisualCanvas(group, deviceType, pageTitleScale);
        }
        return new VoiceCanvas(group, deviceType, pageTitleScale);
    }

    public DeviceType getDeviceType() {
        return ((DamaskLayer)this.getLayer()).getDeviceType();
    }

    public DamaskDocument getDocument() {
        return this.group.getDocument();
    }

    public String toString() {
        return String.valueOf(DamaskUtils.toShortString(this)) + " (" + SwingUtilities.windowForComponent(this) + " - " + this.getDeviceType() + ")";
    }

    public SelectionEventHandler getSelectionEventHandler() {
        return this.selectionEventHandler;
    }

    protected void addMode(DamaskAppMode newMode) {
        this.modes.put(newMode.getName(), newMode);
    }

    public DamaskAppMode getMode() {
        return this.appMode;
    }

    protected void beforeSetModeByName() {
    }

    protected void afterSetModeByName() {
    }

    public void setModeByName(String newModeName) {
        this.stopTextEditing();
        if (this.appMode != null) {
            this.beforeSetModeByName();
            this.setModeEventHandlerEnabled(false);
        }
        this.selectionEventHandler.unselectAll(this);
        this.appMode = (DamaskAppMode)this.modes.get(newModeName);
        if (this.appMode != null) {
            this.afterSetModeByName();
            this.setModeEventHandlerEnabled(true);
        }
    }

    protected void setModeEventHandlerEnabled(boolean flag) {
        if (flag) {
            Cursor cursorToUse;
            this.appModeHandler = this.appMode.getDefaultHandler();
            if (this.insideNode instanceof PBoundsHandle && !(this.insideNode instanceof NonResizableHandle)) {
                PBoundsHandle handle = (PBoundsHandle)this.insideNode;
                cursorToUse = handle.getCursorFor(((PBoundsLocator)handle.getLocator()).getSide());
            } else {
                cursorToUse = this.appMode.getDefaultCursor();
            }
            this.addInputEventListener(this.appModeHandler);
            this.setCursor(cursorToUse);
        } else {
            this.removeInputEventListener(this.appModeHandler);
            this.setCursor(null);
        }
    }

    public void setProperCursor() {
        this.setCursor(this.appMode.getDefaultCursor());
    }

    public void setTextEditing(boolean flag) {
        this.textEditing = flag;
    }

    public boolean isTextEditing() {
        return this.textEditing;
    }

    public abstract void stopTextEditing();

    public synchronized void addCanvasListener(CanvasListener listener) {
        this.eventSource.addCanvasListener(listener);
    }

    public synchronized void removeCanvasListener(CanvasListener listener) {
        this.eventSource.removeCanvasListener(listener);
    }

    public void fireSelectionChanged() {
        this.eventSource.fireSelectionChanged(this);
    }

    public void fireSelectedPageChanged() {
        this.eventSource.fireSelectedPageChanged(this);
    }

    public boolean tryExportAsImage(Window parentWindow) {
        boolean result;
        File newFile = FileDialogUtils.showImageSaveDialog(parentWindow);
        if (newFile != null) {
            DamaskLayer damaskLayer = (DamaskLayer)this.getLayer();
            TemplatePane templatePane = damaskLayer.getTemplatePane();
            boolean isTemplatePaneVisible = templatePane.getVisible();
            templatePane.setVisible(false);
            PBounds b = this.getLayer().getFullBoundsReference();
            BufferedImage image = (BufferedImage)this.getLayer().toImage((int)Math.ceil(b.getWidth()), (int)Math.ceil(b.getHeight()), this.getCamera().getPaint());
            try {
                ImageIO.write((RenderedImage)image, FileLib.getFileNameExtension(newFile.getAbsolutePath()), newFile);
                logger.info(this + ": exported image as " + newFile);
                result = true;
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(parentWindow, "There is a problem writing " + newFile + ".\n\n" + e.getMessage(), "Damask", 0);
                DamaskAppExceptionHandler.log(e);
                result = false;
            }
            templatePane.setVisible(isTemplatePaneVisible);
        } else {
            result = false;
        }
        return result;
    }

    private void updateBackgroundColor() {
        DamaskLayer.DeviceTypeLayer deviceTypeLayer = ((DamaskLayer)this.getLayer()).getDeviceTypeLayer();
        this.getCamera().setPaint((Paint)BACKGROUND_PAINTS.get(this.getDeviceType(), deviceTypeLayer));
        if (deviceTypeLayer == DamaskLayer.DeviceTypeLayer.ALL) {
            this.changeLayerOfObjectAction.putValue("Name", "Move Objects to \"This Device\" Layer");
        } else {
            this.changeLayerOfObjectAction.putValue("Name", "Move Objects to \"All Devices\" Layer");
        }
    }

    public BoundedRangeModel getSliderModel() {
        return this.sliderModel;
    }

    public static double scaleFactor(int zoomLevel) {
        return 0.15 * (double)zoomLevel - 0.05;
    }

    public static int getNearestZoomLevel(double scaleFactor) {
        return (int)Math.round((scaleFactor + 0.05) / 0.15);
    }

    public void setZoomLevel(int zoomLevel) {
        this.sliderModel.setValue(zoomLevel);
    }

    protected Point2D getZoomCenterMousePosition() {
        return this.zoomCenterMousePosition;
    }

    public boolean isZoomCenteredAtUpperLeft() {
        return this.zoomCenteredAtUpperLeft;
    }

    public void setZoomCenteredAtUpperLeft(boolean flag) {
        this.zoomCenteredAtUpperLeft = flag;
    }

    protected void sliderModelStateChanged(ChangeEvent e) {
        PCamera camera = this.getCamera();
        Point2D zoomCenter = this.zoomCenteredAtUpperLeft ? POINT00 : (this.zoomCenterMousePosition == null ? camera.getViewBounds().getCenter2D() : this.zoomCenterMousePosition);
        camera.scaleViewAboutPoint(DamaskCanvas.scaleFactor(this.sliderModel.getValue()) / camera.getViewScale(), zoomCenter.getX(), zoomCenter.getY());
        logger.info(this + ": Zoom level changed to " + this.sliderModel.getValue());
    }

    protected abstract Page getDropTarget(Point2D var1);

    public PNode getInsideNode() {
        return this.insideNode;
    }

    public void setInsideNode(PNode node) {
        if (node == this.insideNode) {
            return;
        }
        this.setModeEventHandlerEnabled(false);
        this.insideNode = node;
        this.setModeEventHandlerEnabled(true);
    }

    protected DamaskWindow getCurrentWindow() {
        return this.currentWindow;
    }

    public void setWindowBoundsChanging(boolean flag) {
        this.windowIsManipulated = flag;
        if (!flag) {
            Rectangle2D currentWindowBounds = this.currentWindow.getPathReference().getBounds2D();
            PAffineTransform currentWindowTransform = this.currentWindow.getTransform();
            InteractionElement currentWindowModel = this.currentWindow.getModel();
            DeviceType deviceType = this.getDeviceType();
            ModifyGraphMacroCommand command = new ModifyGraphMacroCommand();
            if (!currentWindowModel.getBounds(deviceType).equals(currentWindowBounds)) {
                command.addCommand(new SetBoundsCommand(currentWindowModel, deviceType, currentWindowBounds));
            }
            if (!currentWindowModel.getTransform(deviceType).equals(currentWindowTransform)) {
                command.addCommand(new SetTransformCommand(currentWindowModel, deviceType, (AffineTransform)currentWindowTransform));
            }
            if (!command.isEmpty()) {
                this.getDocument().getCommandQueue().doCommand(this, command);
            }
        }
        if (flag) {
            this.stopTextEditing();
        }
    }

    public boolean isWindowBoundsChanging() {
        return this.windowIsManipulated;
    }

    public void attachHandles(DamaskWindow window, PCamera camera) {
        if (window == this.currentWindow) {
            return;
        }
        if (this.currentWindow != null) {
            SizeGrip.removeFrom(this.currentWindow);
            DragBar.removeFrom(this.currentWindow);
        }
        this.currentWindow = window;
        this.fireSelectedPageChanged();
        if (this.currentWindow != null) {
            SizeGrip.addTo(this.currentWindow, camera);
            DragBar.addTo(this.currentWindow, camera);
        }
    }

    public Collection getSelectedObjects() {
        return this.selectionEventHandler.getSelection();
    }

    public Collection getObjectsToCopy() {
        return this.objectsToCopy;
    }

    protected void setObjectsToCopy(Collection objectsToCopy) {
        this.objectsToCopy = objectsToCopy;
    }

    public abstract PageRegion getPasteTargetPageRegion();

    public abstract Page getSelectedPage();

    protected PopupMenuEventHandler getPopupMenuEventHandler() {
        return this.popupMenuEventHandler;
    }

    public JPopupMenu getPopupMenu(PNode pickedNode, boolean isPickedNodeSelectable) {
        return this.plainPopupMenu;
    }

    public Action getCopyAction() {
        return this.copyAction;
    }

    public Action getCutAction() {
        return this.cutAction;
    }

    public Action getDeleteAction() {
        return this.deleteAction;
    }

    public Action getPasteAction() {
        return this.pasteAction;
    }

    public Action getChangeLayerOfObjectAction() {
        return this.changeLayerOfObjectAction;
    }

    public abstract Action getRunFromHomeAction();

    public abstract Action getRunFromSelectedPageAction();

    public abstract Action getCopyPageAction();

    public abstract Action getCutPageAction();

    public abstract Action getDeletePageAction();

    public abstract Action getPastePageAction();

    public abstract Action getSetHomePageAction();

    private class LayerHandler
    implements LayerListener {
        static final /* synthetic */ boolean $assertionsDisabled;
        static /* synthetic */ Class class$0;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("edu.berkeley.guir.damask.view.DamaskCanvas$LayerHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        LayerHandler() {
        }

        public void deviceTypeLayerChanged(LayerEvent e) {
            if (!$assertionsDisabled && e.getLayer() != DamaskCanvas.this.getLayer()) {
                throw new AssertionError((Object)("should be receiving events from " + DamaskCanvas.this.getLayer() + ", not " + e.getLayer()));
            }
            DamaskCanvas.this.updateBackgroundColor();
        }
    }

    private class SliderModelHandler
    implements ChangeListener {
        SliderModelHandler() {
        }

        public void stateChanged(ChangeEvent e) {
            DamaskCanvas.this.sliderModelStateChanged(e);
        }
    }

    private class MouseWheelHandler
    extends PBasicInputEventHandler {
        MouseWheelHandler() {
        }

        public void mouseWheelRotated(PInputEvent event) {
            DamaskCanvas.this.zoomCenterMousePosition = event.getPosition();
            DamaskCanvas.this.sliderModel.setValue(DamaskCanvas.this.sliderModel.getValue() - event.getWheelRotation());
            DamaskCanvas.this.zoomCenterMousePosition = null;
        }
    }

    private class DropTargetHandler
    implements DropTargetListener {
        private DataFlavor[] flavors = new DataFlavor[]{PatternBrowser.PATTERN_SOLUTION_FLAVOR};

        DropTargetHandler() {
        }

        public void dragEnter(DropTargetDragEvent dtde) {
        }

        public void dragOver(DropTargetDragEvent dtde) {
        }

        public void dragExit(DropTargetEvent dte) {
        }

        public void dropActionChanged(DropTargetDragEvent dtde) {
        }

        public void drop(DropTargetDropEvent dtde) {
            DataFlavor flavor = null;
            if (!dtde.isLocalTransfer()) {
                dtde.rejectDrop();
                return;
            }
            int i = 0;
            int n = this.flavors.length;
            while (i < n) {
                if (dtde.isDataFlavorSupported(this.flavors[i])) {
                    flavor = this.flavors[i];
                    break;
                }
                ++i;
            }
            if (flavor == null) {
                dtde.rejectDrop();
                return;
            }
            if ((dtde.getSourceActions() & 3) == 0) {
                dtde.rejectDrop();
                return;
            }
            Object data = null;
            try {
                dtde.acceptDrop(3);
                data = dtde.getTransferable().getTransferData(flavor);
                if (data == null) {
                    throw new NullPointerException();
                }
                PatternSolution solution = (PatternSolution)data;
                Point2D.Double layerDropPt = new Point2D.Double(dtde.getLocation().getX(), dtde.getLocation().getY());
                DamaskCanvas.this.getCamera().localToView(layerDropPt);
                Page dropPage = DamaskCanvas.this.getDropTarget(layerDropPt);
                Page dragPage = ((Dialog)solution.getDialogs().get(0)).getFirstPage(DamaskCanvas.this.getDeviceType());
                AddPatternInstanceCommand newCommand = dropPage == null ? new AddPatternInstanceCommand(DamaskCanvas.this.getDocument().getGraph(), solution.getPattern(), dragPage, layerDropPt) : new AddPatternInstanceCommand(DamaskCanvas.this.getDocument().getGraph(), solution.getPattern(), dragPage, dropPage);
                PatternInstanceView.setAutoReshape(false);
                DamaskCanvas.this.getDocument().getCommandQueue().doCommand(DamaskCanvas.this, newCommand);
                PatternInstanceView.reshapeAll();
                PatternInstanceView.setAutoReshape(true);
            }
            catch (Throwable t) {
                DamaskAppExceptionHandler.log(t);
                dtde.dropComplete(false);
            }
        }
    }

    private class CommandHandler
    implements CommandListener {
        CommandHandler() {
        }

        private void update(CommandEvent e) {
            AffineTransform canvasTransform;
            DamaskCanvas.this.getRunFromHomeAction().setEnabled(!DamaskCanvas.this.getDocument().getGraph().getDialogs(DamaskCanvas.this.getDeviceType()).isEmpty());
            if (SwingUtilities.getWindowAncestor(DamaskCanvas.this).isFocused() && ((DamaskCanvas)e.getCanvas()).getDeviceType() == DamaskCanvas.this.getDeviceType() && !(canvasTransform = e.getCanvasTransform()).equals(DamaskCanvas.this.getCamera().getViewTransform())) {
                DamaskCanvas.this.setZoomLevel(DamaskCanvas.getNearestZoomLevel(canvasTransform.getScaleX()));
                DamaskCanvas.this.getCamera().setViewTransform(canvasTransform);
            }
        }

        public void commandExecuted(CommandEvent e) {
            this.update(e);
        }

        public void commandUndone(CommandEvent e) {
            this.update(e);
        }

        public void commandRedone(CommandEvent e) {
            this.update(e);
        }
    }

    private class SelectionChangeHandler
    implements CanvasListener {
        static final /* synthetic */ boolean $assertionsDisabled;
        static /* synthetic */ Class class$0;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("edu.berkeley.guir.damask.view.DamaskCanvas$SelectionChangeHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        SelectionChangeHandler() {
        }

        public void selectionChanged(CanvasEvent e) {
            if (!$assertionsDisabled && e.getCanvas() != DamaskCanvas.this) {
                throw new AssertionError((Object)("should be receiving events from " + DamaskCanvas.this + ", not " + e.getCanvas()));
            }
            Collection selectedObjects = DamaskCanvas.this.getSelectedObjects();
            boolean hasSelected = !selectedObjects.isEmpty();
            DamaskCanvas.this.cutAction.setEnabled(hasSelected);
            DamaskCanvas.this.copyAction.setEnabled(hasSelected);
            DamaskCanvas.this.deleteAction.setEnabled(hasSelected);
            DamaskCanvas.this.changeLayerOfObjectAction.setEnabled(hasSelected);
        }

        public void selectedPageChanged(CanvasEvent e) {
            if (!$assertionsDisabled && e.getCanvas() != DamaskCanvas.this) {
                throw new AssertionError((Object)("should be receiving events from " + DamaskCanvas.this + ", not " + e.getCanvas()));
            }
        }
    }

    private class CutAction
    extends AbstractAction {
        public CutAction() {
            super("Cut");
            this.putValue("ShortDescription", "Cuts the selected object into the clipboard");
            this.putValue("MnemonicKey", new Integer(84));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(88, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            this.putValue("SmallIcon", DamaskToolbar.getToolbarIcon("cut.png"));
            this.putValue("Disabled icon", DamaskToolbar.getToolbarDisabledIcon("cut.png"));
        }

        public void actionPerformed(ActionEvent e) {
            logger.info("Begin cut");
            DamaskCanvas.this.copyAction.actionPerformed(e);
            DamaskCanvas.this.deleteAction.actionPerformed(e);
            logger.info("End cut");
        }
    }

    private class CopyAction
    extends AbstractAction {
        public CopyAction() {
            super("Copy");
            this.putValue("ShortDescription", "Copies the selected object into the clipboard");
            this.putValue("MnemonicKey", new Integer(67));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            this.putValue("SmallIcon", DamaskToolbar.getToolbarIcon("copy.png"));
            this.putValue("Disabled icon", DamaskToolbar.getToolbarDisabledIcon("copy.png"));
        }

        public void actionPerformed(ActionEvent e) {
            logger.info("Begin copy");
            DamaskCanvas.this.objectsToCopy = DamaskCanvas.this.getSelectedObjects();
            TransferHandler handler = DamaskCanvas.this.getTransferHandler();
            handler.exportToClipboard(DamaskCanvas.this, Toolkit.getDefaultToolkit().getSystemClipboard(), 1);
            DamaskCanvas.this.pasteAction.setEnabled(true);
            logger.info("End copy");
        }
    }

    private class PasteAction
    extends AbstractAction {
        public PasteAction() {
            super("Paste");
            this.putValue("ShortDescription", "Pastes the contents of the clipboard");
            this.putValue("MnemonicKey", new Integer(80));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            this.putValue("SmallIcon", DamaskToolbar.getToolbarIcon("paste.png"));
            this.putValue("Disabled icon", DamaskToolbar.getToolbarDisabledIcon("paste.png"));
        }

        public void actionPerformed(ActionEvent e) {
            TransferHandler handler;
            logger.info("Begin paste");
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable clipData = clipboard.getContents(this);
            if (clipData != null && (handler = DamaskCanvas.this.getTransferHandler()).canImport(DamaskCanvas.this, clipData.getTransferDataFlavors())) {
                DamaskLayer layer = (DamaskLayer)DamaskCanvas.this.getLayer();
                layer.clearTrackedNewAdditions();
                layer.startTrackingNewAdditions();
                handler.importData(DamaskCanvas.this, clipData);
                layer.stopTrackingNewAdditions();
                DamaskCanvas.this.selectionEventHandler.unselectAll(DamaskCanvas.this);
                Iterator i = layer.getTrackedNewAdditions().iterator();
                while (i.hasNext()) {
                    WeakReference viewRef = (WeakReference)i.next();
                    InteractionElementView view = (InteractionElementView)viewRef.get();
                    if (!view.isSelectable() || !(view instanceof ComponentView)) continue;
                    DamaskCanvas.this.selectionEventHandler.select((PNode)view, DamaskCanvas.this);
                }
            }
            logger.info("End paste");
        }
    }

    private class DeleteAction
    extends AbstractAction {
        public DeleteAction() {
            super("Delete");
            this.putValue("ShortDescription", "Deletes the selected object");
            this.putValue("MnemonicKey", new Integer(68));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(127, 0));
            this.putValue("SmallIcon", DamaskToolbar.getToolbarIcon("delete.png"));
            this.putValue("Disabled icon", DamaskToolbar.getToolbarDisabledIcon("delete.png"));
        }

        public void actionPerformed(ActionEvent e) {
            DamaskCanvas.this.getDocument().getCommandQueue().doCommand(DamaskCanvas.this, DamaskAppUtils.createDeleteObjectsCommand(DamaskCanvas.this, DamaskCanvas.this.getSelectedObjects()));
        }
    }

    private class ChangeLayerOfObjectAction
    extends AbstractAction {
        public ChangeLayerOfObjectAction() {
            super("Move Objects to \"This Device\" Layer");
            this.putValue("ShortDescription", "Changes the layer of the selected objects");
            this.putValue("MnemonicKey", new Integer(76));
        }

        public void actionPerformed(ActionEvent e) {
            HashSet pickedNodes = new HashSet(DamaskCanvas.this.getSelectedObjects());
            HashSet<PNode> nodesToAdd = new HashSet<PNode>();
            HashSet<PNode> nodesToRemove = new HashSet<PNode>();
            Iterator i = pickedNodes.iterator();
            while (i.hasNext()) {
                PNode node = (PNode)i.next();
                if (node instanceof RadioButton) {
                    nodesToAdd.add(node.getParent());
                    nodesToRemove.add(node);
                    continue;
                }
                if (node instanceof Prompt) {
                    nodesToAdd.add(((Prompt)node).getParent());
                    continue;
                }
                if (!(node instanceof Response.TextGroup)) continue;
                nodesToAdd.add(((Response.TextGroup)node).getResponse().getParent());
            }
            pickedNodes.addAll(nodesToAdd);
            pickedNodes.removeAll(nodesToRemove);
            DamaskLayer.DeviceTypeLayer deviceTypeLayer = ((DamaskLayer)DamaskCanvas.this.getLayer()).getDeviceTypeLayer();
            ModifyGraphMacroCommand cmd = new ModifyGraphMacroCommand();
            Iterator i2 = pickedNodes.iterator();
            while (i2.hasNext()) {
                Control nextControl;
                PNode node = (PNode)i2.next();
                if (!(node instanceof ComponentView) && !(node instanceof VoiceComponent)) continue;
                Component component = (Component)((InteractionElementView)node).getModel();
                if ((component instanceof SelectOne || component instanceof SelectMany.Item || component instanceof TextInput) && component.isVisibleToDeviceType(DeviceType.VOICE) && (nextControl = DamaskUtils.getNextLowLevelControl(((Control)component).getPageRegion(DeviceType.VOICE), (Control)component)) instanceof Trigger && !nextControl.isForAllDeviceTypes() && DamaskCanvas.this.getDeviceType() != DeviceType.VOICE) {
                    cmd.addCommand(new RemoveControlCommand(nextControl));
                }
                if (deviceTypeLayer == DamaskLayer.DeviceTypeLayer.ALL) {
                    cmd.addCommand(new SplitComponentIntoDeviceSpecificVersionsCommand(component, DamaskCanvas.this.getDeviceType()));
                    continue;
                }
                if (component.getDialog().getDeviceType() != DeviceType.ALL) continue;
                cmd.addCommand(new ReplaceComponentWithDeviceAllVersionCommand(component));
            }
            if (!cmd.isEmpty()) {
                DamaskCanvas.this.getDocument().getCommandQueue().doCommand(DamaskCanvas.this, cmd);
            }
            this.setEnabled(!DamaskCanvas.this.getSelectedObjects().isEmpty());
        }
    }
}

