/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.view;

import edu.berkeley.guir.damask.view.DamaskLayer;
import edu.berkeley.guir.damask.view.TemplatePane;
import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PRoot;
import edu.umd.cs.piccolo.activities.PActivity;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class DamaskCamera
extends PCamera {
    private final int PAN_JUMP = 25;
    private final PanActivity panActivity = new PanActivity(-1L);
    private boolean panActive = false;

    public DamaskCamera() {
        CameraBoundsTransformListener boundsTransformListener = new CameraBoundsTransformListener();
        this.addPropertyChangeListener("bounds", boundsTransformListener);
        this.addPropertyChangeListener("viewTransform", boundsTransformListener);
    }

    public PanActivity getPanActivity() {
        return this.panActivity;
    }

    public void panView(double dx, double dy) {
        this.translateView(dx / this.getViewScale(), dy / this.getViewScale());
    }

    public void setPanning(boolean flag) {
        this.panActive = flag;
        if (this.panActive) {
            PRoot root = this.getRoot();
            this.panView(this.panActivity.getDx() * 25.0, this.panActivity.getDy() * 25.0);
            this.panActivity.setStartTime(root.getGlobalTime() + 500L);
            root.addActivity(this.panActivity);
        } else {
            this.panActivity.terminate();
        }
    }

    public boolean isPanning() {
        return this.panActive;
    }

    public class PanActivity
    extends PActivity {
        private double dx;
        private double dy;

        private PanActivity(long aDuration) {
            super(aDuration);
        }

        private PanActivity(long aDuration, long aStepRate) {
            super(aDuration, aStepRate);
        }

        private PanActivity(long aDuration, long aStepRate, long aStartTime) {
            super(aDuration, aStepRate, aStartTime);
        }

        protected void activityStep(long elapsedTime) {
            super.activityStep(elapsedTime);
            DamaskCamera.this.panView(this.dx * 25.0, this.dy * 25.0);
        }

        public double getDx() {
            return this.dx;
        }

        public double getDy() {
            return this.dy;
        }

        public void setDirection(double dx, double dy) {
            this.dx = dx;
            this.dy = dy;
        }
    }

    private class CameraBoundsTransformListener
    implements PropertyChangeListener {
        CameraBoundsTransformListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (DamaskCamera.this.getLayer(0) instanceof DamaskLayer) {
                TemplatePane templatePane = ((DamaskLayer)DamaskCamera.this.getLayer(0)).getTemplatePane();
                templatePane.reposition(DamaskCamera.this, false);
            }
        }
    }
}

