/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.view;

import edu.berkeley.guir.damask.DamaskUtils;
import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.InteractionElement;
import edu.berkeley.guir.damask.command.AddItemCommand;
import edu.berkeley.guir.damask.command.EditContentCommand;
import edu.berkeley.guir.damask.command.ModifyGraphMacroCommand;
import edu.berkeley.guir.damask.command.RemoveComponentFromGroupCommand;
import edu.berkeley.guir.damask.command.RemoveConnectionCommand;
import edu.berkeley.guir.damask.command.RemoveControlCommand;
import edu.berkeley.guir.damask.command.RemoveGroupCommand;
import edu.berkeley.guir.damask.command.RemoveItemCommand;
import edu.berkeley.guir.damask.command.SetContentDisplayModeCommand;
import edu.berkeley.guir.damask.command.SetVoicePromptTextCommand;
import edu.berkeley.guir.damask.component.ComponentGroup;
import edu.berkeley.guir.damask.component.Content;
import edu.berkeley.guir.damask.component.Control;
import edu.berkeley.guir.damask.component.Select;
import edu.berkeley.guir.damask.component.SelectMany;
import edu.berkeley.guir.damask.component.SelectOne;
import edu.berkeley.guir.damask.component.TextInput;
import edu.berkeley.guir.damask.connection.Connection;
import edu.berkeley.guir.damask.view.DamaskAppExceptionHandler;
import edu.berkeley.guir.damask.view.DamaskCanvas;
import edu.berkeley.guir.damask.view.DamaskLayer;
import edu.berkeley.guir.damask.view.InteractionElementView;
import edu.berkeley.guir.damask.view.nodes.DamaskPPath;
import edu.berkeley.guir.damask.view.nodes.StickyTransformManager;
import edu.berkeley.guir.damask.view.visual.Arrow;
import edu.berkeley.guir.damask.view.visual.component.CheckBox;
import edu.berkeley.guir.damask.view.visual.component.ComponentView;
import edu.berkeley.guir.damask.view.visual.component.ControlView;
import edu.berkeley.guir.damask.view.visual.component.Label;
import edu.berkeley.guir.damask.view.visual.component.Panel;
import edu.berkeley.guir.damask.view.visual.component.RadioButton;
import edu.berkeley.guir.damask.view.voice.component.Prompt;
import edu.berkeley.guir.damask.view.voice.component.Response;
import edu.berkeley.guir.lib.awt.geom.GeomLib;
import edu.berkeley.guir.lib.awt.geom.Polygon2D;
import edu.berkeley.guir.lib.satin.command.MacroCommand;
import edu.berkeley.guir.lib.util.ClassLib;
import edu.berkeley.guir.lib.util.StringLib;
import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PAffineTransform;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PNodeFilter;
import edu.umd.cs.piccolo.util.PPaintContext;
import edu.umd.cs.piccolox.handles.PBoundsHandle;
import edu.umd.cs.piccolox.handles.PHandle;
import edu.umd.cs.piccolox.nodes.PStyledText;
import edu.umd.cs.piccolox.util.PBoundsLocator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class DamaskAppUtils {
    public static final Color NO_COLOR;
    public static final String PROPERTY_RESIZE_ANCHOR = "Resize anchor";
    public static final String PROPERTY_RESIZE_CHILDREN_ANCHOR = "Resize children anchor";
    public static final String PROPERTY_DISABLED_ICON = "Disabled icon";
    private static final int SQUIGGLE_WIGGLE_WIDTH = 4;
    private static final int SQUIGGLE_GAP_WIDTH = 6;
    private static final int SQUIGGLE_HEIGHT = 6;
    private static final AffineTransform TEMP_TRANSFORM;
    private static final PText pText;
    private static final Map origPaints;
    private static final Map origStrokePaints;
    private static final Icon backIcon;
    private static final Icon forwardIcon;
    private static final Icon backDisabledIcon;
    private static final Icon forwardDisabledIcon;
    private static final Icon backRolloverIcon;
    private static final Icon forwardRolloverIcon;
    private static final double ARROWHEAD_ANGLE = 0.7853981633974483;
    private static final double ARROWHEAD_LENGTH = 8.0;
    private static final AffineTransform IDENTITY_TRANSFORM;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        URL forwardRolloverURL;
        URL backRolloverURL;
        URL forwardDisabledURL;
        URL backDisabledURL;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("edu.berkeley.guir.damask.view.DamaskAppUtils");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        NO_COLOR = new Color(0, 0, 0, 0);
        TEMP_TRANSFORM = new AffineTransform();
        pText = new PText();
        origPaints = new HashMap();
        origStrokePaints = new HashMap();
        String platformName = DamaskAppUtils.isUsingSystemLookAndFeel() ? (DamaskAppUtils.isMac() ? "mac" : (DamaskAppUtils.isWindows() ? (DamaskAppUtils.isWindowsXP() ? "win_xp" : "win") : "java")) : "java";
        Toolkit tk = Toolkit.getDefaultToolkit();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("edu.berkeley.guir.damask.view.DamaskApp");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        backIcon = new ImageIcon(tk.getImage(clazz2.getResource("images/run/" + platformName + "/normal/back.png")));
        Class<?> clazz3 = class$0;
        if (clazz3 == null) {
            try {
                clazz3 = class$0 = Class.forName("edu.berkeley.guir.damask.view.DamaskApp");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        forwardIcon = new ImageIcon(tk.getImage(clazz3.getResource("images/run/" + platformName + "/normal/forward.png")));
        Class<?> clazz4 = class$0;
        if (clazz4 == null) {
            try {
                clazz4 = class$0 = Class.forName("edu.berkeley.guir.damask.view.DamaskApp");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        backDisabledIcon = (backDisabledURL = clazz4.getResource("images/run/" + platformName + "/disabled/back.png")) == null ? null : new ImageIcon(tk.getImage(backDisabledURL));
        Class<?> clazz5 = class$0;
        if (clazz5 == null) {
            try {
                clazz5 = class$0 = Class.forName("edu.berkeley.guir.damask.view.DamaskApp");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        forwardDisabledIcon = (forwardDisabledURL = clazz5.getResource("images/run/" + platformName + "/disabled/forward.png")) == null ? null : new ImageIcon(tk.getImage(forwardDisabledURL));
        Class<?> clazz6 = class$0;
        if (clazz6 == null) {
            try {
                clazz6 = class$0 = Class.forName("edu.berkeley.guir.damask.view.DamaskApp");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        backRolloverIcon = (backRolloverURL = clazz6.getResource("images/run/" + platformName + "/rollover/back.png")) == null ? null : new ImageIcon(tk.getImage(backRolloverURL));
        Class<?> clazz7 = class$0;
        if (clazz7 == null) {
            try {
                clazz7 = class$0 = Class.forName("edu.berkeley.guir.damask.view.DamaskApp");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        forwardRolloverIcon = (forwardRolloverURL = clazz7.getResource("images/run/" + platformName + "/rollover/forward.png")) == null ? null : new ImageIcon(tk.getImage(forwardRolloverURL));
        IDENTITY_TRANSFORM = new AffineTransform();
    }

    private DamaskAppUtils() {
    }

    public static PNode getAncestor(PNode node, Class aClass) {
        PNode ancestor = node;
        while (ancestor != null && !aClass.isInstance(ancestor)) {
            ancestor = ancestor.getParent();
        }
        return ancestor;
    }

    public static InteractionElementView getView(PNode node, InteractionElement model) {
        InteractionElementView view = null;
        LinkedList<PNode> queue = new LinkedList<PNode>();
        queue.add(node);
        while (!queue.isEmpty()) {
            InteractionElementView currentView;
            PNode aNode = (PNode)queue.remove(0);
            if (aNode instanceof InteractionElementView && (currentView = (InteractionElementView)aNode).getModel() == model) {
                view = currentView;
                break;
            }
            Iterator i = aNode.getChildrenIterator();
            while (i.hasNext()) {
                PNode child = (PNode)i.next();
                queue.add(child);
            }
        }
        queue.clear();
        return view;
    }

    public static List getViews(PNode node, InteractionElement model) {
        ArrayList<InteractionElementView> views = new ArrayList<InteractionElementView>();
        LinkedList<PNode> queue = new LinkedList<PNode>();
        queue.add(node);
        while (!queue.isEmpty()) {
            InteractionElementView currentView;
            boolean foundView = false;
            PNode aNode = (PNode)queue.remove(0);
            if (aNode instanceof InteractionElementView && (currentView = (InteractionElementView)aNode).getModel() == model) {
                views.add(currentView);
                foundView = true;
            }
            if (foundView) continue;
            Iterator i = aNode.getChildrenIterator();
            while (i.hasNext()) {
                PNode child = (PNode)i.next();
                queue.add(child);
            }
        }
        queue.clear();
        return views;
    }

    private static void addDescendants(ComponentGroup group, Set groups, Set controls) {
        Iterator i = group.getChildren().iterator();
        while (i.hasNext()) {
            edu.berkeley.guir.damask.component.Component child = (edu.berkeley.guir.damask.component.Component)i.next();
            if (child instanceof Control) {
                controls.add(child);
                continue;
            }
            if (!(child instanceof ComponentGroup)) continue;
            groups.add(child);
            DamaskAppUtils.addDescendants((ComponentGroup)child, groups, controls);
        }
    }

    private static void removeDescendantGroupsAndAddDescendantControls(Set groupsToRemove, Set controlsToRemove) {
        HashSet redundantGroups = new HashSet();
        Iterator i = groupsToRemove.iterator();
        while (i.hasNext()) {
            ComponentGroup group = (ComponentGroup)i.next();
            DamaskAppUtils.addDescendants(group, redundantGroups, controlsToRemove);
        }
        groupsToRemove.removeAll(redundantGroups);
    }

    private static void addDeleteDescendantGroupsToCommand(ComponentGroup group, MacroCommand cmd) {
        Iterator i = group.getChildren().iterator();
        while (i.hasNext()) {
            edu.berkeley.guir.damask.component.Component child = (edu.berkeley.guir.damask.component.Component)i.next();
            if (!(child instanceof ComponentGroup)) continue;
            DamaskAppUtils.addDeleteDescendantGroupsToCommand((ComponentGroup)child, cmd);
        }
        if (group.getGroup() != null) {
            cmd.addCommand(new RemoveComponentFromGroupCommand(group.getGroup(), group));
        }
        cmd.addCommand(new RemoveGroupCommand(group));
    }

    public static MacroCommand createDeleteObjectsCommand(DamaskCanvas canvas, Collection objsToDel) {
        ModifyGraphMacroCommand cmd = new ModifyGraphMacroCommand();
        HashMap<Select, HashSet<Select.Item>> selectItemsToRemove = new HashMap<Select, HashSet<Select.Item>>();
        HashSet<InteractionElement> groupsToRemove = new HashSet<InteractionElement>();
        HashSet<InteractionElement> controlsToRemove = new HashSet<InteractionElement>();
        Iterator<Object> i = objsToDel.iterator();
        while (i.hasNext()) {
            PNode node = (PNode)i.next();
            InteractionElementView view = null;
            if (node instanceof InteractionElementView) {
                view = (InteractionElementView)node;
            } else if (node.getParent() instanceof Response) {
                view = (Response)node.getParent();
            }
            if (view == null) continue;
            if (canvas.getSelectedObjects().contains(view)) {
                canvas.getSelectionEventHandler().unselect(view, canvas);
            }
            if (view instanceof RadioButton || view instanceof CheckBox) {
                Select.Item item = (Select.Item)view.getModel();
                Select select = item.getParent();
                HashSet<Select.Item> itemsToRemoveFromSelect = (HashSet<Select.Item>)selectItemsToRemove.get(select);
                if (itemsToRemoveFromSelect == null) {
                    itemsToRemoveFromSelect = new HashSet<Select.Item>();
                    selectItemsToRemove.put(select, itemsToRemoveFromSelect);
                }
                itemsToRemoveFromSelect.add(item);
                continue;
            }
            if (view instanceof ControlView) {
                controlsToRemove.add(view.getModel());
                continue;
            }
            if (view instanceof Panel) {
                groupsToRemove.add(view.getModel());
                continue;
            }
            if (view instanceof Prompt) {
                controlsToRemove.add(view.getModel());
                continue;
            }
            if (view instanceof Response) {
                Control control = (Control)view.getModel();
                controlsToRemove.add(control);
                Control prevControl = DamaskUtils.getPreviousLowLevelControl(control.getPageRegion(DeviceType.VOICE), control);
                if (prevControl instanceof Select || prevControl instanceof TextInput) {
                    controlsToRemove.add(prevControl);
                    continue;
                }
                if (!(prevControl instanceof Select.Item)) continue;
                controlsToRemove.add(((Select.Item)prevControl).getParent());
                continue;
            }
            if (!(view instanceof Arrow)) continue;
            cmd.addCommand(new RemoveConnectionCommand((Connection)view.getModel(), true));
        }
        i = selectItemsToRemove.keySet().iterator();
        while (i.hasNext()) {
            Select select = (Select)i.next();
            Set removedItemsForSelect = (Set)selectItemsToRemove.get(select);
            if (removedItemsForSelect.size() == select.getItems().size()) {
                controlsToRemove.add(select);
                continue;
            }
            Iterator j = removedItemsForSelect.iterator();
            while (j.hasNext()) {
                Select.Item item = (Select.Item)j.next();
                cmd.addCommand(new RemoveItemCommand(select, item));
            }
        }
        DamaskAppUtils.removeDescendantGroupsAndAddDescendantControls(groupsToRemove, controlsToRemove);
        i = controlsToRemove.iterator();
        while (i.hasNext()) {
            Control control = (Control)i.next();
            if (control.getGroup() != null) {
                cmd.addCommand(new RemoveComponentFromGroupCommand(control.getGroup(), control));
            }
            cmd.addCommand(new RemoveControlCommand(control));
        }
        i = groupsToRemove.iterator();
        while (i.hasNext()) {
            ComponentGroup group = (ComponentGroup)i.next();
            DamaskAppUtils.addDeleteDescendantGroupsToCommand(group, cmd);
        }
        return cmd;
    }

    public static PNode getSelectablePickedNode(PInputEvent pie, Collection selectableParents) {
        PNode pickedNode = pie.getPath().getPickedNode();
        if (pickedNode instanceof PCamera) {
            pickedNode = null;
        } else {
            PNode newPickedNode = pickedNode;
            while (newPickedNode != null && !selectableParents.contains(newPickedNode.getParent())) {
                newPickedNode = newPickedNode.getParent();
            }
            pickedNode = newPickedNode;
        }
        return pickedNode;
    }

    public static Panel findRootPanel(Collection nodes) {
        edu.berkeley.guir.damask.component.Component survivor;
        HashMap<edu.berkeley.guir.damask.component.Component, ComponentView> views = new HashMap<edu.berkeley.guir.damask.component.Component, ComponentView>();
        HashSet<edu.berkeley.guir.damask.component.Component> components = new HashSet<edu.berkeley.guir.damask.component.Component>();
        HashSet descendantGroups = new HashSet();
        HashSet descendantControls = new HashSet();
        Iterator i = nodes.iterator();
        while (i.hasNext()) {
            PNode node = (PNode)i.next();
            if (node instanceof ComponentView) {
                ComponentView componentView = (ComponentView)node;
                edu.berkeley.guir.damask.component.Component component = (edu.berkeley.guir.damask.component.Component)componentView.getModel();
                components.add(component);
                views.put(component, componentView);
                continue;
            }
            return null;
        }
        i = components.iterator();
        while (i.hasNext()) {
            edu.berkeley.guir.damask.component.Component component = (edu.berkeley.guir.damask.component.Component)i.next();
            if (!(component instanceof ComponentGroup)) continue;
            DamaskAppUtils.addDescendants((ComponentGroup)component, descendantGroups, descendantControls);
        }
        components.removeAll(descendantGroups);
        components.removeAll(descendantControls);
        if (components.size() == 1 && (survivor = (edu.berkeley.guir.damask.component.Component)components.iterator().next()) instanceof ComponentGroup) {
            return (Panel)views.get(survivor);
        }
        return null;
    }

    public static void printTree(PNode node) {
        DamaskAppUtils.printTree(node, 0);
    }

    private static void printTree(PNode node, int indent) {
        System.out.print(String.valueOf(StringLib.spaces(indent * 2)) + ClassLib.getShortClassName(node));
        if (node instanceof InteractionElementView) {
            System.out.print(" - " + ((InteractionElementView)node).getModel().getDeviceTypesVisibleTo());
        }
        System.out.println();
        System.out.println(String.valueOf(StringLib.spaces(indent * 2)) + "* " + node.getTransform());
        PBounds globalBounds = node.getBounds();
        node.localToGlobal(globalBounds);
        Iterator i = node.getChildrenIterator();
        while (i.hasNext()) {
            PNode child = (PNode)i.next();
            DamaskAppUtils.printTree(child, indent + 1);
        }
    }

    public static void printAncestors(PNode node) {
        PNode n = node;
        System.out.println(n);
        System.out.println("   * " + n.getTransform());
        n = n.getParent();
        while (n != null) {
            System.out.println("- " + n);
            System.out.println("   * " + n.getTransform());
            n = n.getParent();
        }
    }

    public static Rectangle2D localToCanvas(PNode node, PCanvas canvas, Rectangle2D rect) {
        node.localToGlobal(rect);
        PCamera camera = canvas.getCamera();
        PNode n = node;
        boolean haveSeenCanvasCamera = false;
        while (n != null) {
            haveSeenCanvasCamera |= n == camera;
            n = n.getParent();
        }
        if (!haveSeenCanvasCamera) {
            camera.viewToLocal(rect);
        }
        return rect;
    }

    public static Rectangle2D canvasToLocal(PNode node, PCanvas canvas, Rectangle2D rect) {
        PCamera camera = canvas.getCamera();
        PNode n = node;
        boolean haveSeenCanvasCamera = false;
        while (n != null) {
            haveSeenCanvasCamera |= n == camera;
            n = n.getParent();
        }
        if (!haveSeenCanvasCamera) {
            camera.localToView(rect);
        }
        node.globalToLocal(rect);
        return rect;
    }

    private static boolean isInvisibleOrWhite(Paint paint) {
        return paint == null || paint.equals(NO_COLOR) || paint.equals(Color.WHITE);
    }

    public static void setInternalColor(PNode node, Color color) {
        if (node instanceof Label) {
            ((Label)node).setLabelColor(color);
        } else {
            PNode path;
            if (node instanceof PPath && !DamaskAppUtils.isInvisibleOrWhite(((PPath)(path = (PPath)node)).getStrokePaint())) {
                ((PPath)path).setStrokePaint(color);
            }
            if (node instanceof DamaskPPath && !DamaskAppUtils.isInvisibleOrWhite(((DamaskPPath)(path = (DamaskPPath)node)).getStrokePaint())) {
                ((DamaskPPath)path).setStrokePaint(color);
            }
            if (!DamaskAppUtils.isInvisibleOrWhite(node.getPaint())) {
                node.setPaint(color);
            }
            Iterator i = node.getChildrenIterator();
            while (i.hasNext()) {
                PNode child = (PNode)i.next();
                DamaskAppUtils.setInternalColor(child, color);
            }
        }
    }

    public static void setInternalColorAlpha(PNode node, int alpha) {
        if (node instanceof Label) {
            Label label = (Label)node;
            label.setLabelColor(DamaskAppUtils.createTransparentColor(label.getLabelColor(), alpha));
        } else {
            PNode path;
            if (node instanceof PPath && !DamaskAppUtils.isInvisibleOrWhite(((PPath)(path = (PPath)node)).getStrokePaint())) {
                ((PPath)path).setStrokePaint(DamaskAppUtils.createTransparentPaint(((PPath)path).getStrokePaint(), alpha));
            }
            if (node instanceof DamaskPPath && !DamaskAppUtils.isInvisibleOrWhite(((DamaskPPath)(path = (DamaskPPath)node)).getStrokePaint())) {
                ((DamaskPPath)path).setStrokePaint(DamaskAppUtils.createTransparentPaint(((DamaskPPath)path).getStrokePaint(), alpha));
            }
            if (!DamaskAppUtils.isInvisibleOrWhite(node.getPaint())) {
                node.setPaint(DamaskAppUtils.createTransparentPaint(node.getPaint(), alpha));
            }
            Iterator i = node.getChildrenIterator();
            while (i.hasNext()) {
                PNode child = (PNode)i.next();
                DamaskAppUtils.setInternalColorAlpha(child, alpha);
            }
        }
    }

    public static void pushInternalColor(PNode node, Color color) {
        if (node instanceof Label) {
            Label label = (Label)node;
            origPaints.put(label, label.getLabelColor());
            label.setLabelColor(color);
        } else if (!(node instanceof PHandle) && !(node instanceof Response.HotSpot)) {
            PNode path;
            if (node instanceof PPath && !DamaskAppUtils.isInvisibleOrWhite(((PPath)(path = (PPath)node)).getStrokePaint())) {
                origStrokePaints.put(path, ((PPath)path).getStrokePaint());
                ((PPath)path).setStrokePaint(color);
            }
            if (node instanceof DamaskPPath && !DamaskAppUtils.isInvisibleOrWhite(((DamaskPPath)(path = (DamaskPPath)node)).getStrokePaint())) {
                origStrokePaints.put(path, ((DamaskPPath)path).getStrokePaint());
                ((DamaskPPath)path).setStrokePaint(color);
            }
            if (!DamaskAppUtils.isInvisibleOrWhite(node.getPaint())) {
                origPaints.put(node, node.getPaint());
                node.setPaint(color);
            }
            Iterator i = node.getChildrenIterator();
            while (i.hasNext()) {
                PNode child = (PNode)i.next();
                DamaskAppUtils.pushInternalColor(child, color);
            }
        }
    }

    public static void popInternalColor(PNode node) {
        if (node instanceof Label) {
            Label label = (Label)node;
            Color origColor = (Color)origPaints.get(label);
            if (origColor != null) {
                label.setLabelColor(origColor);
                origPaints.remove(label);
            }
        } else {
            Color origColor;
            Color origColor2;
            PNode path;
            if (node instanceof PPath && !DamaskAppUtils.isInvisibleOrWhite(((PPath)(path = (PPath)node)).getStrokePaint()) && (origColor2 = (Color)origStrokePaints.get(path)) != null) {
                ((PPath)path).setStrokePaint(origColor2);
                origStrokePaints.remove(path);
            }
            if (node instanceof DamaskPPath && !DamaskAppUtils.isInvisibleOrWhite(((DamaskPPath)(path = (DamaskPPath)node)).getStrokePaint()) && (origColor2 = (Color)origStrokePaints.get(path)) != null) {
                ((DamaskPPath)path).setStrokePaint(origColor2);
                origStrokePaints.remove(path);
            }
            if (!DamaskAppUtils.isInvisibleOrWhite(node.getPaint()) && (origColor = (Color)origPaints.get(node)) != null) {
                node.setPaint(origColor);
                origPaints.remove(origColor);
            }
            Iterator i = node.getChildrenIterator();
            while (i.hasNext()) {
                PNode child = (PNode)i.next();
                DamaskAppUtils.popInternalColor(child);
            }
        }
    }

    public static Color createTransparentColor(Color color, int alpha) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
    }

    public static Paint createTransparentPaint(Paint paint, int alpha) {
        if (paint instanceof Color) {
            Color color = (Color)paint;
            return new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
        }
        return paint;
    }

    public static Color createDarkerColor(Color color, double factor) {
        return new Color(Math.max((int)((double)color.getRed() * factor), 0), Math.max((int)((double)color.getGreen() * factor), 0), Math.max((int)((double)color.getBlue() * factor), 0));
    }

    public static void setInternalStroke(PNode node, Stroke stroke) {
        PNode path;
        if (node instanceof PPath) {
            path = (PPath)node;
            ((PPath)path).setStroke(stroke);
        } else if (node instanceof DamaskPPath) {
            path = (DamaskPPath)node;
            ((DamaskPPath)path).setStroke(stroke);
        }
        Iterator i = node.getChildrenIterator();
        while (i.hasNext()) {
            PNode child = (PNode)i.next();
            DamaskAppUtils.setInternalStroke(child, stroke);
        }
    }

    public static void resizeGeneralPath(GeneralPath path, Rectangle2D newBounds) {
        Rectangle2D pathBounds = path.getBounds2D();
        double x = newBounds.getX();
        double y = newBounds.getY();
        double width = newBounds.getWidth();
        double height = newBounds.getHeight();
        if (width <= 0.0 || height <= 0.0) {
            width = Math.max(width, 0.0);
            height = Math.max(height, 0.0);
            if (width == 0.0 && height == 0.0) {
                path.reset();
                path.moveTo((float)x, (float)y);
                path.lineTo((float)x, (float)y);
                path.closePath();
            } else {
                path.reset();
                path.moveTo((float)x, (float)y);
                path.lineTo((float)(x + width), (float)(y + height));
                path.closePath();
            }
        } else if (pathBounds.getWidth() == 0.0 || pathBounds.getHeight() == 0.0) {
            path.reset();
            path.append(new Rectangle2D.Double(x, y, x + width, y + height), false);
        } else {
            TEMP_TRANSFORM.setToIdentity();
            TEMP_TRANSFORM.translate(x, y);
            TEMP_TRANSFORM.scale(width / pathBounds.getWidth(), height / pathBounds.getHeight());
            TEMP_TRANSFORM.translate(-pathBounds.getX(), -pathBounds.getY());
            path.transform(TEMP_TRANSFORM);
        }
    }

    public static boolean containsRect(Rectangle2D rect1, Rectangle2D rect2) {
        if (rect1.getHeight() >= 0.0 && rect1.getHeight() >= 0.0 && rect2.getHeight() == 0.0 || rect2.getWidth() == 0.0) {
            return rect1.getX() <= rect2.getX() && rect2.getMaxX() <= rect1.getMaxX() && rect1.getY() <= rect2.getY() && rect2.getMaxY() <= rect1.getMaxY();
        }
        return rect1.contains(rect2);
    }

    public static void localToGlobal(PNode node, Rectangle2D rect) {
        if (rect.getWidth() == 0.0 || rect.getHeight() == 0.0) {
            PAffineTransform regionTransform = node.getLocalToGlobalTransform(null);
            Point2D.Double p1 = new Point2D.Double(rect.getX(), rect.getY());
            Point2D.Double p2 = new Point2D.Double(rect.getMaxX(), rect.getMaxY());
            regionTransform.transform(p1, p1);
            regionTransform.transform(p2, p2);
            rect.setRect(((Point2D)p1).getX(), ((Point2D)p1).getY(), ((Point2D)p2).getX() - ((Point2D)p1).getX(), ((Point2D)p2).getY() - ((Point2D)p1).getY());
        } else {
            node.localToGlobal(rect);
        }
    }

    public static void globalToLocal(PNode node, Rectangle2D rect) {
        if (rect.getWidth() == 0.0 || rect.getHeight() == 0.0) {
            PAffineTransform regionTransform = node.getGlobalToLocalTransform(null);
            Point2D.Double p1 = new Point2D.Double(rect.getX(), rect.getY());
            Point2D.Double p2 = new Point2D.Double(rect.getMaxX(), rect.getMaxY());
            regionTransform.transform(p1, p1);
            regionTransform.transform(p2, p2);
            rect.setRect(((Point2D)p1).getX(), ((Point2D)p1).getY(), ((Point2D)p2).getX() - ((Point2D)p1).getX(), ((Point2D)p2).getY() - ((Point2D)p1).getY());
        } else {
            node.globalToLocal(rect);
        }
    }

    public static void addStickyZBoundsHandlesTo(PNode aNode, PCamera camera) {
        PBoundsHandle[] handles = new PBoundsHandle[]{new PBoundsHandle(PBoundsLocator.createEastLocator(aNode)), new PBoundsHandle(PBoundsLocator.createWestLocator(aNode)), new PBoundsHandle(PBoundsLocator.createNorthLocator(aNode)), new PBoundsHandle(PBoundsLocator.createSouthLocator(aNode)), new PBoundsHandle(PBoundsLocator.createNorthEastLocator(aNode)), new PBoundsHandle(PBoundsLocator.createNorthWestLocator(aNode)), new PBoundsHandle(PBoundsLocator.createSouthEastLocator(aNode)), new PBoundsHandle(PBoundsLocator.createSouthWestLocator(aNode))};
        int i = 0;
        int n = handles.length;
        while (i < n) {
            PBoundsHandle handle = handles[i];
            aNode.addChild(handle);
            StickyTransformManager.setupStickyZ(handle, camera, new Point2D.Double(0.5, 0.5));
            handle.relocateHandle();
            ++i;
        }
    }

    public static void removeStickyBoundsHandlesFrom(PNode aNode, PCamera camera) {
        HashSet<PBoundsHandle> handlesToRemove = new HashSet<PBoundsHandle>();
        Iterator i = camera.getChildrenIterator();
        while (i.hasNext()) {
            PBoundsHandle handle;
            PBoundsLocator l;
            PNode n;
            PNode child = (PNode)i.next();
            if (!(child instanceof PBoundsHandle) || (n = (l = (PBoundsLocator)(handle = (PBoundsHandle)child).getLocator()).getNode()) != aNode) continue;
            handlesToRemove.add(handle);
        }
        camera.removeChildren(handlesToRemove);
    }

    public static Rectangle2D getUnionBounds(Collection strokes) {
        if (strokes.isEmpty()) {
            return new Rectangle2D.Double();
        }
        Iterator i = strokes.iterator();
        GeneralPath firstPath = (GeneralPath)i.next();
        Rectangle2D strokesBounds = firstPath.getBounds2D();
        while (i.hasNext()) {
            GeneralPath path = (GeneralPath)i.next();
            Rectangle2D.union(strokesBounds, path.getBounds2D(), strokesBounds);
        }
        return strokesBounds;
    }

    public static GeneralPath createHalfRoundRectangle(Rectangle2D rect, float arcw, float arch) {
        return DamaskAppUtils.createHalfRoundRectangle((float)rect.getX(), (float)rect.getY(), (float)rect.getWidth(), (float)rect.getHeight(), arcw, arch);
    }

    public static GeneralPath createHalfRoundRectangle(float x, float y, float w, float h, float arcw, float arch) {
        GeneralPath path = new GeneralPath();
        path.moveTo(x, y + h);
        path.lineTo(x, y + arch);
        path.quadTo(x, y, x + arcw, y);
        path.lineTo(x + w - arcw, y);
        path.quadTo(x + w, y, x + w, y + arch);
        path.lineTo(x + w, y + h);
        path.closePath();
        return path;
    }

    public static RoundRectangle2D createRoundRectangle(Rectangle2D rect, float arcw, float arch) {
        return new RoundRectangle2D.Double(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight(), arcw, arch);
    }

    public static GeneralPath createVoiceBalloon(Rectangle2D rect, float arcw, float arch, float pointX1, float pointX2, float pointY2, float pointX3) {
        return DamaskAppUtils.createVoiceBalloon((float)rect.getX(), (float)rect.getY(), (float)rect.getWidth(), (float)rect.getHeight(), arcw, arch, pointX1, pointX2, pointY2, pointX3);
    }

    public static GeneralPath createVoiceBalloon(float x, float y, float w, float h, float arcw, float arch, float pointX1, float pointX2, float pointY2, float pointX3) {
        GeneralPath path = new GeneralPath();
        if (arcw > w / 3.0f) {
            arcw = w / 3.0f;
        }
        if (arch > h / 3.0f) {
            arch = h / 3.0f;
        }
        float dx = pointX2 - pointX1;
        if (pointX3 < arcw || pointX3 > w - arcw) {
            pointX3 = w - arcw + 1.0f;
        }
        if (pointX1 < arcw || pointX1 > pointX3) {
            pointX1 = arcw - 1.0f;
        }
        if (Math.signum(dx) != Math.signum(pointX2 - pointX1)) {
            pointX2 = pointX1 + dx;
        }
        path.moveTo(x, y + h - arch);
        path.lineTo(x, y + arch);
        path.quadTo(x, y, x + arcw, y);
        path.lineTo(x + w - arcw, y);
        path.quadTo(x + w, y, x + w, y + arch);
        path.lineTo(x + w, y + h - arch);
        path.quadTo(x + w, y + h, x + w - arcw, y + h);
        path.lineTo(x + pointX3, y + h);
        path.lineTo(x + pointX2, y + h + pointY2);
        path.lineTo(x + pointX1, y + h);
        path.lineTo(x + arcw, y + h);
        path.quadTo(x, y + h, x, y + h - arch);
        path.closePath();
        return path;
    }

    public static GeneralPath createDiamond(Rectangle2D bounds) {
        GeneralPath path = new GeneralPath();
        path.moveTo((float)bounds.getCenterX(), (float)bounds.getY());
        path.lineTo((float)bounds.getX(), (float)bounds.getCenterY());
        path.lineTo((float)bounds.getCenterX(), (float)bounds.getMaxY());
        path.lineTo((float)bounds.getMaxX(), (float)bounds.getCenterY());
        path.closePath();
        return path;
    }

    public static PPath createSquiggle() {
        return DamaskAppUtils.createSquiggle(13);
    }

    public static PPath createSquiggle(int numWiggles) {
        return DamaskAppUtils.createSquiggleStroke(numWiggles);
    }

    private static PPath createSquiggleStroke(int numWiggles) {
        PPath squiggle = new PPath();
        squiggle.moveTo(0.0f, 6.0f);
        int x = 1;
        int y = 0;
        while (x <= numWiggles) {
            squiggle.lineTo(x * 4, y);
            y = y == 0 ? 6 : 0;
            ++x;
        }
        return squiggle;
    }

    public static PNode createSquiggles(int[] lengths) {
        int totalWidth = 0;
        int i = 0;
        while (i < lengths.length) {
            totalWidth += lengths[i] * 4 + 6;
            ++i;
        }
        PNode squiggles = new PNode();
        squiggles.setBounds(0.0, 0.0, totalWidth, 6.0);
        int x = 0;
        int i2 = 0;
        int n = lengths.length;
        while (i2 < n) {
            PPath squiggle = DamaskAppUtils.createSquiggleStroke(lengths[i2]);
            squiggles.addChild(squiggle);
            squiggle.setOffset(x, 0.0);
            x += 4 * lengths[i2] + 6;
            ++i2;
        }
        return squiggles;
    }

    public static PNode getPureCopy(PNode node) {
        PNode clone;
        if (node instanceof PPath) {
            clone = new PPath((GeneralPath)((PPath)node).getPathReference().clone());
            ((PPath)clone).setStrokePaint(((PPath)node).getStrokePaint());
        } else if (node instanceof DamaskPPath) {
            clone = new DamaskPPath((GeneralPath)((DamaskPPath)node).getPathReference().clone());
            ((DamaskPPath)clone).setStrokePaint(((DamaskPPath)node).getStrokePaint());
        } else if (node instanceof PImage) {
            clone = new PImage();
            Image nodeImage = ((PImage)node).getImage();
            if (nodeImage != null) {
                ((PImage)clone).setImage(nodeImage);
                ((PImage)clone).setAccelerated(((PImage)node).getAccelerated());
            }
        } else if (node instanceof PText) {
            clone = new PText();
            ((PText)clone).setText(((PText)node).getText());
            ((PText)clone).setFont(((PText)node).getFont());
        } else {
            clone = new PNode();
        }
        clone.setPaint(node.getPaint());
        clone.setBounds(node.getBounds());
        clone.setTransform(node.getTransform());
        clone.setVisible(node.getVisible());
        Iterator i = node.getChildrenIterator();
        while (i.hasNext()) {
            PNode child = (PNode)i.next();
            if (child instanceof PHandle || child instanceof Response.HotSpot) continue;
            clone.addChild(DamaskAppUtils.getPureCopy(child));
        }
        return clone;
    }

    public static Rectangle2D getRenderedTextBounds(String text, int size) {
        pText.setText(text);
        DamaskAppUtils.setFontSize(pText, size);
        return pText.getBounds();
    }

    public static Font getDefaultFont() {
        return PText.DEFAULT_FONT;
    }

    public static void setFontSize(PText text, int size) {
        text.setFont(text.getFont().deriveFont((float)size));
    }

    public static int getFontSize(PStyledText text, int pos) {
        Document document = text.getDocument();
        if (document instanceof StyledDocument) {
            StyledDocument styledDoc = (StyledDocument)document;
            Element charElement = styledDoc.getCharacterElement(pos);
            Font font = styledDoc.getFont(charElement.getAttributes());
            return font.getSize();
        }
        return -1;
    }

    public static void setFontSize(PStyledText text, int size) {
        Document document = text.getDocument();
        if (document instanceof StyledDocument) {
            SimpleAttributeSet as = new SimpleAttributeSet();
            StyleConstants.setFontSize(as, size);
            ((StyledDocument)document).setParagraphAttributes(0, document.getLength(), as, false);
            text.syncWithDocument();
        }
    }

    public static void setFont(PStyledText text, Font font) {
        Document document = text.getDocument();
        if (document instanceof StyledDocument) {
            SimpleAttributeSet as = new SimpleAttributeSet();
            StyleConstants.setFontFamily(as, font.getFamily());
            StyleConstants.setFontSize(as, font.getSize());
            ((StyledDocument)document).setParagraphAttributes(0, document.getLength(), as, false);
            text.syncWithDocument();
        }
    }

    public static void setText(PStyledText text, String string) {
        try {
            Document document = text.getDocument();
            document.remove(0, document.getLength());
            document.insertString(0, string, null);
            text.syncWithDocument();
        }
        catch (BadLocationException e) {
            DamaskAppExceptionHandler.log(e);
        }
    }

    public static boolean isUsingSystemLookAndFeel() {
        return UIManager.getSystemLookAndFeelClassName().equals(UIManager.getLookAndFeel().getClass().getName());
    }

    public static boolean isMac() {
        return System.getProperty("mrj.version") != null;
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").startsWith("Windows");
    }

    public static boolean isWindowsXP() {
        if (DamaskAppUtils.isWindows()) {
            String versionStr = System.getProperty("os.version");
            String[] versionArray = versionStr.split("\\.");
            if (versionArray.length >= 2) {
                try {
                    int majorVersion = Integer.parseInt(versionArray[0]);
                    int minorVersion = Integer.parseInt(versionArray[1]);
                    return majorVersion >= 5 && minorVersion >= 1;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
            return false;
        }
        return false;
    }

    public static File getUserDirectory() {
        String fileName = System.getProperty("user.home");
        fileName = DamaskAppUtils.isWindows() ? String.valueOf(fileName) + File.separator + "Application Data" + File.separator + "Damask" + File.separator : String.valueOf(fileName) + File.separator + ".damask" + File.separator;
        File path = new File(fileName);
        if (!path.isDirectory()) {
            path.mkdirs();
        }
        return path;
    }

    public static Cursor createCursor(String fileName, Point hotSpot, String name) {
        try {
            BufferedImage cursorImage;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("edu.berkeley.guir.damask.view.DamaskApp");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            BufferedImage image = ImageIO.read(clazz.getResource("images/cursors/" + fileName));
            Toolkit tk = Toolkit.getDefaultToolkit();
            Dimension cursorSize = tk.getBestCursorSize(image.getWidth(), image.getHeight());
            int cursorWidth = cursorSize.width;
            int cursorHeight = cursorSize.height;
            if (cursorWidth == 0 && cursorHeight == 0) {
                return Cursor.getDefaultCursor();
            }
            if (cursorWidth > image.getWidth() || cursorHeight > image.getHeight()) {
                cursorImage = new BufferedImage(cursorWidth, cursorHeight, 2);
                Graphics2D g = cursorImage.createGraphics();
                g.drawImage((Image)image, 0, 0, null);
                g.dispose();
            } else {
                cursorImage = image;
            }
            return tk.createCustomCursor(cursorImage, hotSpot, name);
        }
        catch (IOException e) {
            return Cursor.getDefaultCursor();
        }
    }

    public static JButton createBackButton(Action action) {
        JButton backButton = new JButton(action);
        backButton.setIcon(backIcon);
        if (backRolloverIcon != null) {
            backButton.setRolloverIcon(backRolloverIcon);
        }
        if (backDisabledIcon != null) {
            backButton.setDisabledIcon(backDisabledIcon);
        }
        if (!DamaskAppUtils.isWindows()) {
            backButton.setVerticalTextPosition(3);
            backButton.setHorizontalTextPosition(0);
        }
        return backButton;
    }

    public static JButton createForwardButton(Action action) {
        JButton forwardButton = new JButton(action);
        forwardButton.setIcon(forwardIcon);
        if (forwardRolloverIcon != null) {
            forwardButton.setRolloverIcon(forwardRolloverIcon);
        }
        if (forwardDisabledIcon != null) {
            forwardButton.setDisabledIcon(forwardDisabledIcon);
        }
        if (!DamaskAppUtils.isWindows()) {
            forwardButton.setVerticalTextPosition(3);
            forwardButton.setHorizontalTextPosition(0);
        }
        return forwardButton;
    }

    public static List getPickedNodes(DamaskCanvas canvas, Point2D pt) {
        ArrayList pickedNodes = new ArrayList();
        Collection selectableParents = canvas.getSelectionEventHandler().getSelectableParents();
        PickableAndSelectableFilter filter = new PickableAndSelectableFilter(selectableParents, pt);
        Iterator parentsIt = selectableParents.iterator();
        while (parentsIt.hasNext()) {
            PNode parent = (PNode)parentsIt.next();
            if (parent instanceof PCamera) {
                int i = 0;
                while (i < ((PCamera)parent).getLayerCount()) {
                    ((PCamera)parent).getLayer(i).getAllNodes(filter, pickedNodes);
                    ++i;
                }
                continue;
            }
            parent.getAllNodes(filter, pickedNodes);
        }
        return pickedNodes;
    }

    public static Point2D getFirstPoint(Shape s) {
        return DamaskAppUtils.getEndPoints(s)[0];
    }

    public static Point2D getLastPoint(Shape s) {
        return DamaskAppUtils.getEndPoints(s)[1];
    }

    public static Point2D[] getEndPoints(Shape s) {
        Polygon2D poly = GeomLib.pathIteratorToPolygon2D(s.getPathIterator(IDENTITY_TRANSFORM));
        Point2D.Float startPoint = new Point2D.Float(poly.xpoints[0], poly.ypoints[0]);
        Point2D endPoint = poly.isClosed() ? (Point2D)startPoint.clone() : new Point2D.Float(poly.xpoints[poly.npoints - 1], poly.ypoints[poly.npoints - 1]);
        return new Point2D[]{startPoint, endPoint};
    }

    private static Polygon computeArrowheadParams(Polygon2D polygon, double scaleFactor) {
        Point last = new Point();
        Point penult = new Point();
        last.x = (int)polygon.xpoints[polygon.npoints - 1];
        last.y = (int)polygon.ypoints[polygon.npoints - 1];
        if (polygon.npoints < 9) {
            penult.x = (int)polygon.xpoints[polygon.npoints - 2];
            penult.y = (int)polygon.ypoints[polygon.npoints - 2];
        } else {
            penult.x = (int)polygon.xpoints[polygon.npoints - 8];
            penult.y = (int)polygon.ypoints[polygon.npoints - 8];
        }
        double th = Math.atan((double)(last.y - penult.y) / (double)(last.x - penult.x));
        if (last.x > penult.x) {
            th += Math.PI;
        }
        if (last.x == penult.x) {
            th = last.y > penult.y ? -1.5707963267948966 : 1.5707963267948966;
        }
        int x1Offset = (int)(8.0 * scaleFactor * Math.cos(th + 0.7853981633974483));
        int x2Offset = (int)(8.0 * scaleFactor * Math.cos(th - 0.7853981633974483));
        int x1 = last.x + x1Offset;
        int x2 = last.x + x2Offset;
        double m1 = Math.tan(th + 0.7853981633974483);
        double m2 = Math.tan(th - 0.7853981633974483);
        double b1 = (double)last.y - m1 * (double)last.x;
        double b2 = (double)last.y - m2 * (double)last.x;
        int y1 = (int)(m1 * (double)x1 + b1);
        int y2 = (int)(m2 * (double)x2 + b2);
        if (x1 == last.x && y1 == last.y || m1 > 1000000.0 || m1 < -1000000.0) {
            y1 = last.y > penult.y ? (int)((double)last.y - 8.0 * scaleFactor) : (int)((double)last.y + 8.0 * scaleFactor);
        }
        if (x2 == last.x && y2 == last.y || m2 > 1000000.0 || m2 < -1000000.0) {
            y2 = last.y > penult.y ? (int)((double)last.y - 8.0 * scaleFactor) : (int)((double)last.y + 8.0 * scaleFactor);
        }
        Polygon result = new Polygon();
        result.addPoint(last.x, last.y);
        result.addPoint(x1, y1);
        result.addPoint(x2, y2);
        return result;
    }

    public static void drawArrowheads(DamaskPPath damaskPPath, PPaintContext paintContext) {
        DamaskAppUtils.drawArrowheads(damaskPPath, paintContext, damaskPPath.getStrokePaint(), damaskPPath.getStrokePaint(), damaskPPath.getStrokePaint(), damaskPPath.getStrokePaint());
    }

    public static void drawArrowheads(DamaskPPath damaskPPath, PPaintContext paintContext, Paint fillStartPaint, Paint borderStartPaint, Paint fillEndPaint, Paint borderEndPaint) {
        Graphics2D g2 = paintContext.getGraphics();
        PCamera paintCamera = paintContext.getCamera();
        GeneralPath path = damaskPPath.getPathReference();
        Stroke stroke = damaskPPath.getStroke();
        if (stroke != null) {
            g2.setStroke(stroke);
        }
        double scale = paintCamera == null ? 1.0 : 1.0 / paintContext.getCamera().getViewScale();
        Polygon2D polygon = GeomLib.pathIteratorToPolygon2D(path.getPathIterator(IDENTITY_TRANSFORM));
        if (!$assertionsDisabled && polygon.npoints < 2) {
            throw new AssertionError((Object)"An arrow needs at least two points.");
        }
        int startCircleRadius = (int)(8.0 * scale);
        if (fillStartPaint != null) {
            g2.setPaint(fillStartPaint);
            g2.fillOval((int)polygon.xpoints[0] - startCircleRadius / 2, (int)polygon.ypoints[0] - startCircleRadius / 2, startCircleRadius, startCircleRadius);
        }
        if (borderStartPaint != null) {
            g2.setPaint(borderStartPaint);
            g2.drawOval((int)polygon.xpoints[0] - startCircleRadius / 2, (int)polygon.ypoints[0] - startCircleRadius / 2, startCircleRadius, startCircleRadius);
        }
        Polygon arrowhead = DamaskAppUtils.computeArrowheadParams(polygon, scale);
        if (fillEndPaint != null) {
            g2.setPaint(fillEndPaint);
            g2.fillPolygon(arrowhead);
        }
        if (borderEndPaint != null) {
            g2.setPaint(borderEndPaint);
            g2.drawPolygon(arrowhead);
        }
    }

    public static boolean askToChangeLayers(DamaskLayer layer, Component parentComponent) {
        String otherLayerString;
        String currentLayerString;
        DamaskLayer.DeviceTypeLayer deviceTypeLayer = layer.getDeviceTypeLayer();
        if (deviceTypeLayer == DamaskLayer.DeviceTypeLayer.ALL) {
            currentLayerString = "All Devices";
            otherLayerString = "This Device";
        } else {
            currentLayerString = "This Device";
            otherLayerString = "All Devices";
        }
        int result = JOptionPane.showConfirmDialog(parentComponent, "The object you tried to select is in the \"" + otherLayerString + "\" layer, but \"" + currentLayerString + "\" is the active layer.\nDo you want to change the active layer to \"" + otherLayerString + "\"?", "Damask", 0);
        if (result == 0) {
            if (deviceTypeLayer == DamaskLayer.DeviceTypeLayer.DEVICE) {
                layer.setDeviceTypeLayer(DamaskLayer.DeviceTypeLayer.ALL);
            } else {
                layer.setDeviceTypeLayer(DamaskLayer.DeviceTypeLayer.DEVICE);
            }
        }
        return result == 0;
    }

    public static void addCommandsToModifySelectItemsToMacroCommand(Select select, DamaskCanvas canvas, String[] newItems, MacroCommand command, boolean modifyVoiceText) {
        Select.Item item;
        Iterator it = select.getItems().iterator();
        int i = 0;
        int n = newItems.length;
        while (i < n && it.hasNext()) {
            System.out.println(i);
            item = (Select.Item)it.next();
            if (modifyVoiceText && select.getItems().size() == n) {
                System.out.println("prompt");
                command.addCommand(new SetVoicePromptTextCommand(item.getContent(), newItems[i]));
            } else {
                System.out.println("content");
                command.addCommand(new EditContentCommand(item.getContent(), newItems[i]));
            }
            command.addCommand(new SetContentDisplayModeCommand(item.getContent(), canvas.getDeviceType(), Content.TEXT));
            ++i;
        }
        if (i == n) {
            while (it.hasNext()) {
                item = (Select.Item)it.next();
                command.addCommand(new RemoveItemCommand(select, item));
            }
        } else {
            HashMap<DeviceType, AffineTransform> transforms = new HashMap<DeviceType, AffineTransform>();
            if (i > 0) {
                Select.Item lastSelectItem = (Select.Item)select.getItems().get(i - 1);
                Iterator deviceIt = select.getDeviceTypesVisibleTo().iterator();
                while (deviceIt.hasNext()) {
                    DeviceType deviceType = (DeviceType)deviceIt.next();
                    AffineTransform transform = lastSelectItem.getTransform(deviceType);
                    if (lastSelectItem.getBounds(deviceType) != null) {
                        transform.translate(0.0, lastSelectItem.getBounds(deviceType).getHeight());
                    }
                    transforms.put(deviceType, transform);
                }
            } else {
                Iterator deviceIt = select.getDeviceTypesVisibleTo().iterator();
                while (deviceIt.hasNext()) {
                    DeviceType deviceType = (DeviceType)deviceIt.next();
                    transforms.put(deviceType, new AffineTransform());
                }
            }
            while (i < n) {
                DeviceType deviceType;
                Content newContent = new Content(((DamaskLayer)canvas.getLayer()).getDeviceTypeForNewElement(), newItems[i]);
                Select.Item newItem = select instanceof SelectOne ? new SelectOne.Item(newContent) : new SelectMany.Item(newContent);
                Rectangle2D newItemTextBounds = DamaskAppUtils.getRenderedTextBounds(newItems[i], DamaskAppUtils.getDefaultFont().getSize());
                Rectangle2D newItemBounds = (Rectangle2D)newItemTextBounds.clone();
                newContent.setBounds(select.getDeviceType(), newItemBounds);
                newItem.setBounds(select.getDeviceType(), newItemBounds);
                Iterator deviceIt = select.getDeviceTypesVisibleTo().iterator();
                while (deviceIt.hasNext()) {
                    deviceType = (DeviceType)deviceIt.next();
                    if (select.getStyle(deviceType) != Select.FULL) continue;
                    PNode defaultView = select instanceof SelectOne ? RadioButton.createTempView() : CheckBox.createTempView();
                    PBounds bounds = defaultView.getBounds();
                    PPath captionPath = (PPath)defaultView.getChild(1);
                    Rectangle2D captionPathBounds = captionPath.getPathReference().getBounds2D();
                    PAffineTransform captionPathTransform = captionPath.getTransform();
                    Rectangle2D captionPathBoundsInItemCoords = GeomLib.transformRectangle(captionPathTransform, captionPathBounds);
                    newItem.getContent().setTransform(deviceType, captionPathTransform);
                    double topInset = captionPathBoundsInItemCoords.getY() - ((RectangularShape)bounds).getY();
                    double leftInset = captionPathBoundsInItemCoords.getX() - ((RectangularShape)bounds).getX();
                    double bottomInset = bounds.getMaxY() - captionPathBoundsInItemCoords.getMaxY();
                    double rightInset = bounds.getMaxX() - captionPathBoundsInItemCoords.getMaxX();
                    newItem.setContentInsets(deviceType, topInset, leftInset, bottomInset, rightInset);
                }
                deviceIt = select.getDeviceTypesVisibleTo().iterator();
                while (deviceIt.hasNext()) {
                    deviceType = (DeviceType)deviceIt.next();
                    AffineTransform newTransform = (AffineTransform)transforms.get(deviceType);
                    newItem.setTransform(deviceType, new AffineTransform(newTransform));
                    newTransform.translate(0.0, newItemBounds.getHeight());
                }
                command.addCommand(new AddItemCommand(select, newItem));
                ++i;
            }
        }
    }

    public static class PickableAndSelectableFilter
    implements PNodeFilter {
        private final Collection selectableParents;
        private final Point2D globalPt;

        public PickableAndSelectableFilter(Collection selectableParents, Point2D globalPt) {
            this.selectableParents = selectableParents;
            this.globalPt = globalPt;
        }

        public boolean accept(PNode node) {
            Point2D.Double localPt = new Point2D.Double(this.globalPt.getX(), this.globalPt.getY());
            node.globalToLocal(localPt);
            boolean result = true;
            if (node instanceof InteractionElementView) {
                result = ((InteractionElementView)node).isSelectable();
            }
            return result && node.getPickable() && node.getBounds().contains(localPt) && !(node instanceof PHandle) && !(node instanceof Response.HotSpot) && !this.selectableParents.contains(node) && !this.isCameraLayer(node);
        }

        public boolean acceptChildrenOf(PNode node) {
            return this.selectableParents.contains(node) || this.isCameraLayer(node);
        }

        public boolean isCameraLayer(PNode node) {
            if (node instanceof PLayer) {
                Iterator i = this.selectableParents.iterator();
                while (i.hasNext()) {
                    PNode parent = (PNode)i.next();
                    if (!(parent instanceof PCamera) || ((PCamera)parent).indexOfLayer((PLayer)node) == -1) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

