/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.view;

import edu.berkeley.guir.damask.DamaskUtils;
import edu.berkeley.guir.damask.InteractionGraph;
import edu.berkeley.guir.damask.view.DamaskAppExceptionHandler;
import edu.berkeley.guir.damask.view.DamaskAppUtils;
import edu.berkeley.guir.damask.view.DamaskDocument;
import edu.berkeley.guir.damask.view.DamaskFrame;
import edu.berkeley.guir.damask.view.DamaskRadarDialog;
import edu.berkeley.guir.damask.view.appevent.AppEventSource;
import edu.berkeley.guir.damask.view.appevent.AppListener;
import edu.berkeley.guir.damask.view.appevent.DocumentEvent;
import edu.berkeley.guir.damask.view.appevent.DocumentListener;
import edu.berkeley.guir.damask.view.pattern.PatternBrowser;
import java.awt.EventQueue;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.UIManager;
import javax.xml.bind.JAXBException;

public class DamaskApp {
    private static final List documents = new ArrayList();
    private static final DamaskApp instance = new DamaskApp();
    private static int numNewDocs = 0;
    private static final DocumentListener docListener = new DocumentHandler();
    private static final AppEventSource appEventSource = new AppEventSource();
    private static DamaskFrame currentFrame = null;
    private static final String INITIAL_COLLECTION_ID = "DesignOfSites";
    private static final String INITIAL_PATTERN_ID = "PersonalECommerce";
    private static PatternBrowser patternBrowser = null;
    protected static final String PROP_WINDOW_X = "Window x";
    protected static final String PROP_WINDOW_Y = "Window y";
    protected static final String PROP_WINDOW_WIDTH = "Window width";
    protected static final String PROP_WINDOW_HEIGHT = "Window height";
    protected static final String PROP_RADAR_X = "Radar x";
    protected static final String PROP_RADAR_Y = "Radar y";
    protected static final String PROP_RADAR_WIDTH = "Radar width";
    protected static final String PROP_RADAR_HEIGHT = "Radar height";
    protected static final String PROP_RADAR_ZOOM = "Radar zoom";
    protected static final String PROP_RADAR_VISIBLE = "Radar view visible";
    private static final Logger logger;
    private static Handler logHandler;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.damask.view.DamaskApp");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getName());
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            String dateStr = DamaskUtils.dateToISO(System.currentTimeMillis()).replace(':', '-');
            logHandler = new FileHandler(String.valueOf(DamaskAppUtils.getUserDirectory().getPath()) + "/damask-" + dateStr + ".log");
            Logger.getLogger("").addHandler(logHandler);
        }
        catch (SecurityException dateStr) {
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        logger.info("Damask started");
        System.setProperty("sun.java2d.noddraw", "true");
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("edu.berkeley.guir.damask.view.DamaskAppExceptionHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        System.setProperty("sun.awt.exception.handler", clazz.getName());
        DamaskFrame firstFrame = DamaskApp.createNewDocument();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("edu.berkeley.guir.damask.view.DamaskApp");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Preferences prefs = Preferences.userNodeForPackage(clazz2);
        int newX = prefs.getInt(PROP_WINDOW_X, firstFrame.getX());
        int newY = prefs.getInt(PROP_WINDOW_Y, firstFrame.getY());
        int newWidth = prefs.getInt(PROP_WINDOW_WIDTH, firstFrame.getWidth());
        int newHeight = prefs.getInt(PROP_WINDOW_HEIGHT, firstFrame.getHeight());
        firstFrame.setLocation(newX, newY);
        firstFrame.setSize(newWidth, newHeight);
        firstFrame.validate();
        DamaskApp.setCurrentFrame(firstFrame);
        DamaskRadarDialog radarDialog = firstFrame.getRadarDialog();
        int newRadarX = prefs.getInt(PROP_RADAR_X, radarDialog.getX());
        int newRadarY = prefs.getInt(PROP_RADAR_Y, radarDialog.getY());
        int newRadarWidth = prefs.getInt(PROP_RADAR_WIDTH, radarDialog.getWidth());
        int newRadarHeight = prefs.getInt(PROP_RADAR_HEIGHT, radarDialog.getHeight());
        radarDialog.setLocation(newRadarX, newRadarY);
        radarDialog.setSize(newRadarWidth, newRadarHeight);
        radarDialog.validate();
    }

    public static DamaskFrame createNewDocument() {
        return DamaskApp.createDocument(new DamaskDocument(new InteractionGraph(), ++numNewDocs));
    }

    public static DamaskFrame openDocument(File f) throws JAXBException {
        return DamaskApp.createDocument(new DamaskDocument(f));
    }

    protected static DamaskFrame createDocument(DamaskDocument doc) {
        documents.add(doc);
        doc.addDocumentListener(docListener);
        DamaskFrame frame = new DamaskFrame(doc.createCanvasGroup());
        frame.initialize();
        FrameDisplayer runner = new FrameDisplayer(frame);
        EventQueue.invokeLater(runner);
        return frame;
    }

    public static void tryExit() {
        ArrayList docs = new ArrayList(documents);
        Iterator it = docs.iterator();
        while (it.hasNext()) {
            DamaskDocument doc = (DamaskDocument)it.next();
            if (!doc.tryClose(null)) break;
        }
    }

    private static void exit() {
        logger.info("Damask exited");
        logHandler.close();
        System.exit(0);
    }

    public static List getDocuments() {
        return Collections.unmodifiableList(documents);
    }

    private static void saveFrameInfo(DamaskFrame frame) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.damask.view.DamaskApp");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Preferences prefs = Preferences.userNodeForPackage(clazz);
        prefs.putInt(PROP_WINDOW_X, frame.getX());
        prefs.putInt(PROP_WINDOW_Y, frame.getY());
        prefs.putInt(PROP_WINDOW_WIDTH, frame.getWidth());
        prefs.putInt(PROP_WINDOW_HEIGHT, frame.getHeight());
        DamaskRadarDialog radarDialog = frame.getRadarDialog();
        prefs.putInt(PROP_RADAR_X, radarDialog.getX());
        prefs.putInt(PROP_RADAR_Y, radarDialog.getY());
        prefs.putInt(PROP_RADAR_WIDTH, radarDialog.getWidth());
        prefs.putInt(PROP_RADAR_HEIGHT, radarDialog.getHeight());
        prefs.putBoolean(PROP_RADAR_VISIBLE, radarDialog.isVisible());
        try {
            prefs.sync();
        }
        catch (BackingStoreException e) {
            DamaskAppExceptionHandler.log(e);
        }
    }

    public static void addAppListener(AppListener listener) {
        appEventSource.addAppListener(listener);
    }

    public static void removeAppListener(AppListener listener) {
        appEventSource.removeAppListener(listener);
    }

    public static void fireCurrentFrameChanged() {
        appEventSource.fireCurrentFrameChanged(instance);
    }

    public static DamaskFrame getCurrentFrame() {
        return currentFrame;
    }

    protected static void setCurrentFrame(DamaskFrame currentFrame) {
        DamaskApp.currentFrame = currentFrame;
        DamaskApp.fireCurrentFrameChanged();
    }

    public static PatternBrowser getPatternBrowser() {
        if (patternBrowser == null) {
            patternBrowser = new PatternBrowser(INITIAL_COLLECTION_ID, INITIAL_PATTERN_ID);
            patternBrowser.setVisible(false);
        }
        return patternBrowser;
    }

    static PatternBrowser getPatternBrowserReference() {
        return patternBrowser;
    }

    private static class FrameDisplayer
    implements Runnable {
        final Frame frame;

        public FrameDisplayer(Frame frame) {
            this.frame = frame;
        }

        public void run() {
            this.frame.show();
        }
    }

    private static class DocumentHandler
    implements DocumentListener {
        DocumentHandler() {
        }

        public void documentModified(DocumentEvent e) {
        }

        public void documentCleaned(DocumentEvent e) {
        }

        public void documentRenamed(DocumentEvent e) {
        }

        public void documentClosed(DocumentEvent e) {
            DamaskDocument doc = e.getDocument();
            Collection framesForDoc = doc.getWindows();
            documents.remove(doc);
            doc.removeDocumentListener(docListener);
            Iterator i = framesForDoc.iterator();
            while (i.hasNext()) {
                DamaskFrame frame = (DamaskFrame)i.next();
                if (documents.isEmpty()) {
                    DamaskApp.saveFrameInfo(frame);
                }
                frame.setVisible(false);
                frame.dispose();
            }
            doc.getGraph().dispose();
            if (documents.isEmpty()) {
                DamaskApp.exit();
            }
        }

        public void documentBusyStarted(DocumentEvent e) {
        }

        public void documentBusyStopped(DocumentEvent e) {
        }

        public void canvasGroupAdded(DocumentEvent e) {
        }

        public void canvasGroupRemoved(DocumentEvent e) {
        }
    }
}

