/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.pattern;

import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.InteractionGraph;
import edu.berkeley.guir.damask.InteractionSubgraph;
import edu.berkeley.guir.damask.component.Component;
import edu.berkeley.guir.damask.component.ComponentGroup;
import edu.berkeley.guir.damask.component.Control;
import edu.berkeley.guir.damask.connection.Connection;
import edu.berkeley.guir.damask.dialog.Dialog;
import edu.berkeley.guir.damask.dialog.Page;
import edu.berkeley.guir.damask.dialog.PageRegion;
import edu.berkeley.guir.damask.pattern.Pattern;
import edu.berkeley.guir.damask.pattern.PatternInstance;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class PatternSolution
extends InteractionGraph {
    private final Pattern pattern;
    private Set backgroundMembers;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.damask.pattern.PatternSolution");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    PatternSolution(Pattern pattern) {
        this.pattern = pattern;
        this.backgroundMembers = new HashSet();
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    InteractionSubgraph createPatternInstance(InteractionGraph graph) {
        PatternSolution clone = (PatternSolution)this.clone();
        clone.add(clone.getMainPatternInstance());
        Iterator i = clone.backgroundMembers.iterator();
        while (i.hasNext()) {
            Component backgroundMember = (Component)i.next();
            if (backgroundMember instanceof ComponentGroup) {
                ComponentGroup backgroundGroup = (ComponentGroup)backgroundMember;
                backgroundGroup.getDialog().removeGroup(backgroundGroup);
                continue;
            }
            Control backgroundControl = (Control)backgroundMember;
            backgroundControl.getDialog().removeControl(backgroundControl);
        }
        InteractionSubgraph subgraph = new InteractionSubgraph(clone);
        graph.merge(clone);
        Iterator i2 = subgraph.getDialogs().iterator();
        while (i2.hasNext()) {
            Dialog dialog = (Dialog)i2.next();
            Iterator j = dialog.getDeviceTypesVisibleTo().iterator();
            while (j.hasNext()) {
                DeviceType aDeviceType = (DeviceType)j.next();
                Iterator k = dialog.getPages(aDeviceType).iterator();
                while (k.hasNext()) {
                    Page aPage = (Page)k.next();
                    Iterator m = new ArrayList(aPage.getTemplates()).iterator();
                    while (m.hasNext()) {
                        Page templatePage = (Page)m.next();
                        aPage.removeTemplate(templatePage);
                    }
                }
            }
        }
        return subgraph;
    }

    protected PatternInstance getMainPatternInstance() {
        PatternInstance mainPatternInstance = new PatternInstance(this.pattern);
        Iterator i = this.getDialogs().iterator();
        while (i.hasNext()) {
            Dialog dialog = (Dialog)i.next();
            Iterator j = dialog.getDeviceTypesVisibleTo().iterator();
            while (j.hasNext()) {
                DeviceType deviceType = (DeviceType)j.next();
                Iterator k = dialog.getPages(deviceType).iterator();
                while (k.hasNext()) {
                    Page page = (Page)k.next();
                    Iterator m = page.getRegions().iterator();
                    while (m.hasNext()) {
                        PageRegion region = (PageRegion)m.next();
                        Iterator n = region.getControls().iterator();
                        while (n.hasNext()) {
                            Control control = (Control)n.next();
                            mainPatternInstance.add(control);
                        }
                    }
                }
            }
        }
        i = this.getConnections().iterator();
        while (i.hasNext()) {
            Connection connection = (Connection)i.next();
            mainPatternInstance.add(connection);
        }
        return mainPatternInstance;
    }

    public Collection getBackgroundMembers() {
        return Collections.unmodifiableCollection(this.backgroundMembers);
    }

    public Object clone() {
        PatternSolution clone = (PatternSolution)super.clone();
        clone.backgroundMembers = new HashSet();
        Iterator i = this.backgroundMembers.iterator();
        while (i.hasNext()) {
            Component backgroundMember = (Component)i.next();
            Component backgroundMemberClone = (Component)backgroundMember.getMostRecentCloneIfAlive();
            if (!$assertionsDisabled && backgroundMemberClone == null) {
                throw new AssertionError((Object)"clone of background member should still be alive");
            }
            clone.backgroundMembers.add(backgroundMember.getMostRecentCloneIfAlive());
        }
        return clone;
    }
}

