/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.pattern;

import edu.berkeley.guir.damask.pattern.Pattern;
import edu.berkeley.guir.damask.view.DamaskAppExceptionHandler;
import edu.berkeley.guir.damask.view.pattern.PatternParser;
import edu.berkeley.guir.lib.collection.Map2D;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;

public class PatternLibrary {
    private static final Map2D library = new Map2D();
    static /* synthetic */ Class class$0;

    static {
        try {
            String patternline;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("edu.berkeley.guir.damask.pattern.Pattern");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            URL patternsListURL = clazz.getResource("PatternList.txt");
            BufferedReader indexReader = new BufferedReader(new InputStreamReader(patternsListURL.openStream()));
            while ((patternline = indexReader.readLine()) != null) {
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = Class.forName("edu.berkeley.guir.damask.pattern.Pattern");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                PatternLibrary.addPattern(clazz2.getResource(patternline));
            }
        }
        catch (IOException e) {
            DamaskAppExceptionHandler.log(e);
        }
    }

    private PatternLibrary() {
    }

    public static void addPattern(Pattern pattern) {
        library.put(pattern.getCollectionID(), pattern.getID(), pattern);
    }

    public static void addPattern(URL patternURL) {
        String[] ids = PatternParser.getPatternIDs(patternURL);
        library.put(ids[0], ids[1], patternURL);
    }

    public static void removePattern(Pattern pattern) {
        library.put(pattern.getCollectionID(), pattern.getID(), null);
    }

    public static Pattern getPattern(String collectionID, String patternID) {
        Object result = library.get(collectionID, patternID);
        if (result instanceof URL) {
            Pattern pattern = new Pattern(collectionID, patternID, (URL)result);
            PatternLibrary.addPattern(pattern);
            return pattern;
        }
        return (Pattern)result;
    }
}

