/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.pattern;

import edu.berkeley.guir.damask.AbstractInteractionElement;
import edu.berkeley.guir.damask.Damask;
import edu.berkeley.guir.damask.DamaskUtils;
import edu.berkeley.guir.damask.DeviceType;
import edu.berkeley.guir.damask.InteractionElement;
import edu.berkeley.guir.damask.InteractionGraph;
import edu.berkeley.guir.damask.event.ElementContainerListener;
import edu.berkeley.guir.damask.event.ElementContainerSource;
import edu.berkeley.guir.damask.pattern.Pattern;
import edu.berkeley.guir.damask.pattern.PatternInstanceMember;
import edu.berkeley.guir.lib.util.StringLib;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class PatternInstance
extends AbstractInteractionElement {
    private final Pattern pattern;
    private InteractionGraph graph;
    private Set members = new HashSet();
    private ElementContainerSource containerEventSource = new ElementContainerSource();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.damask.pattern.PatternInstance");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public PatternInstance(Pattern pattern) {
        this.pattern = pattern;
    }

    public void dispose() {
        this.setInteractionGraph(null);
    }

    public InteractionGraph getInteractionGraph() {
        return this.graph;
    }

    public void setInteractionGraph(InteractionGraph graph) {
        this.graph = graph;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public Collection getMembers() {
        return Collections.unmodifiableCollection(this.members);
    }

    public Collection getMembers(DeviceType deviceType) {
        HashSet<PatternInstanceMember> deviceMembers = new HashSet<PatternInstanceMember>();
        Iterator i = this.getMembers().iterator();
        while (i.hasNext()) {
            PatternInstanceMember member = (PatternInstanceMember)i.next();
            if (!member.isVisibleToDeviceType(deviceType)) continue;
            deviceMembers.add(member);
        }
        return deviceMembers;
    }

    public void add(PatternInstanceMember element) {
        this.members.add(element);
        element.addToPatternInstance(this);
        this.fireElementAdded(-1, element);
    }

    public boolean remove(PatternInstanceMember element) {
        boolean wasRemoved = this.members.remove(element);
        element.removeFromPatternInstance(this);
        if (wasRemoved) {
            this.fireElementRemoved(-1, element);
        }
        return wasRemoved;
    }

    public Set getDeviceTypesVisibleTo() {
        HashSet deviceTypes = new HashSet();
        Iterator i = this.getMembers().iterator();
        while (i.hasNext()) {
            PatternInstanceMember member = (PatternInstanceMember)i.next();
            deviceTypes.addAll(member.getDeviceTypesVisibleTo());
        }
        return deviceTypes;
    }

    public Rectangle2D getBounds(DeviceType deviceType) {
        deviceType.verifyTypeIsNotAll();
        Rectangle2D bounds = super.getBounds(deviceType);
        if (this.isVisibleToDeviceType(deviceType) && bounds == null) {
            bounds = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
            super.setBounds(deviceType, bounds);
        }
        return bounds;
    }

    private String membersToString(int indentLevel, DeviceType deviceType) {
        StringBuffer sb = new StringBuffer();
        Iterator i = this.getMembers(deviceType).iterator();
        while (i.hasNext()) {
            PatternInstanceMember element = (PatternInstanceMember)i.next();
            sb.append(StringLib.spaces(indentLevel * DamaskUtils.INDENT_SPACES));
            sb.append("  - " + element.toString());
            if (!i.hasNext()) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    public String toLongString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.toString());
        sb.append("\n");
        Iterator i = Damask.getSupportedDeviceTypes().iterator();
        while (i.hasNext()) {
            DeviceType deviceType = (DeviceType)i.next();
            sb.append("* " + deviceType + "\n");
            sb.append(this.membersToString(0, deviceType));
        }
        return sb.toString();
    }

    public String toLongString(int indentLevel, DeviceType deviceType) {
        if (!$assertionsDisabled && deviceType == DeviceType.ALL) {
            throw new AssertionError((Object)"Device cannot be ALL");
        }
        StringBuffer sb = new StringBuffer();
        sb.append(StringLib.spaces(indentLevel * DamaskUtils.INDENT_SPACES));
        sb.append(this.toString());
        sb.append(this.membersToString(indentLevel, deviceType));
        return sb.toString();
    }

    public void addElementContainerListener(ElementContainerListener listener) {
        this.containerEventSource.addElementContainerListener(listener);
    }

    public void removeElementContainerListener(ElementContainerListener listener) {
        this.containerEventSource.removeElementContainerListener(listener);
    }

    private void fireElementAdded(int i, InteractionElement e) {
        this.containerEventSource.fireElementAdded(this, null, i, e);
    }

    private void fireElementRemoved(int i, InteractionElement e) {
        this.containerEventSource.fireElementRemoved(this, null, i, e);
    }

    public Object clone() {
        PatternInstance clone = (PatternInstance)super.clone();
        clone.members = new HashSet(this.members);
        clone.containerEventSource = new ElementContainerSource();
        return clone;
    }
}

