/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.damask.pattern;

import edu.berkeley.guir.damask.InteractionGraph;
import edu.berkeley.guir.damask.InteractionSubgraph;
import edu.berkeley.guir.damask.pattern.PatternSolution;
import edu.berkeley.guir.damask.view.pattern.PatternParser;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;

public class Pattern {
    final java.util.regex.Pattern PATTERN_LETTER_NUMBER_PAIR = java.util.regex.Pattern.compile(".*\\((\\p{Alpha}*)(\\p{Digit}*)\\).*");
    private String ID = "";
    private String collectionID = "";
    private String name = "";
    private URL illustrationURL = null;
    private String illustrationText = "";
    private String background = "";
    private String problem = "";
    private String forces = "";
    private Set examples = new HashSet();
    private String solutionText = "";
    private PatternSolution solution = new PatternSolution(this);
    private URL solutionImageURL = null;
    private String solutionImageText;
    private Set inRefs = new HashSet();
    private Set outRefs = new HashSet();
    private String relatedPatternsText;
    private String credits;
    private String group;
    private int indexInGroup;
    private URL patternURL = null;

    public Pattern() {
    }

    public Pattern(String collectionID, String patternID, URL patternURL) {
        this();
        this.ID = patternID;
        this.collectionID = collectionID;
        this.patternURL = patternURL;
        this.name = PatternParser.getPatternName(patternURL);
        this.setGroupAndIndex();
    }

    private void openFromFileIfNecessary() {
        if (this.patternURL != null) {
            URL url = this.patternURL;
            this.patternURL = null;
            PatternParser.parseInto(url, this);
        }
    }

    public String getID() {
        return this.ID;
    }

    public void setID(String string) {
        this.openFromFileIfNecessary();
        this.ID = string;
    }

    public String getCollectionID() {
        return this.collectionID;
    }

    public void setCollectionID(String string) {
        this.openFromFileIfNecessary();
        this.collectionID = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.openFromFileIfNecessary();
        this.name = name;
        this.setGroupAndIndex();
    }

    private void setGroupAndIndex() {
        Matcher matcher = this.PATTERN_LETTER_NUMBER_PAIR.matcher(this.name);
        if (matcher.matches()) {
            this.group = matcher.group(1);
            try {
                this.indexInGroup = Integer.parseInt(matcher.group(2));
            }
            catch (NumberFormatException ex) {
                this.indexInGroup = -1;
            }
        } else {
            this.group = null;
            this.indexInGroup = -1;
        }
    }

    public String getGroup() {
        return this.group;
    }

    public int getIndexInGroup() {
        return this.indexInGroup;
    }

    public URL getIllustrationURL() {
        this.openFromFileIfNecessary();
        return this.illustrationURL;
    }

    public void setIllustrationURL(URL url) {
        this.openFromFileIfNecessary();
        this.illustrationURL = url;
    }

    public String getIllustrationText() {
        this.openFromFileIfNecessary();
        return this.illustrationText;
    }

    public void setIllustrationText(String text) {
        this.openFromFileIfNecessary();
        this.illustrationText = text;
    }

    public String getBackground() {
        this.openFromFileIfNecessary();
        return this.background;
    }

    public void setBackground(String background) {
        this.openFromFileIfNecessary();
        this.background = background;
    }

    public String getProblem() {
        this.openFromFileIfNecessary();
        return this.problem;
    }

    public void setProblem(String problem) {
        this.openFromFileIfNecessary();
        this.problem = problem;
    }

    public String getForces() {
        this.openFromFileIfNecessary();
        return this.forces;
    }

    public void setForces(String forces) {
        this.openFromFileIfNecessary();
        this.forces = forces;
    }

    public Collection getExamples() {
        this.openFromFileIfNecessary();
        return Collections.unmodifiableCollection(this.examples);
    }

    public InteractionSubgraph createPatternInstance(InteractionGraph graph) {
        this.openFromFileIfNecessary();
        InteractionSubgraph subgraph = this.solution.createPatternInstance(graph);
        this.examples.add(subgraph);
        return subgraph;
    }

    public PatternSolution getSolution() {
        this.openFromFileIfNecessary();
        return this.solution;
    }

    public void setSolution(PatternSolution solution) {
        this.openFromFileIfNecessary();
        this.solution = solution;
    }

    public String getSolutionText() {
        this.openFromFileIfNecessary();
        return this.solutionText;
    }

    public void setSolutionText(String solutionText) {
        this.openFromFileIfNecessary();
        this.solutionText = solutionText;
    }

    public URL getSolutionImageURL() {
        this.openFromFileIfNecessary();
        return this.solutionImageURL;
    }

    public void setSolutionImageURL(URL url) {
        this.openFromFileIfNecessary();
        this.solutionImageURL = url;
    }

    public String getSolutionImageText() {
        this.openFromFileIfNecessary();
        return this.solutionImageText;
    }

    public void setSolutionImageText(String text) {
        this.openFromFileIfNecessary();
        this.solutionImageText = text;
    }

    public Collection getInRefs() {
        this.openFromFileIfNecessary();
        return Collections.unmodifiableCollection(this.inRefs);
    }

    public void addInRef(Pattern pattern) {
        this.openFromFileIfNecessary();
        this.inRefs.add(pattern);
    }

    public boolean removeInRef(Pattern pattern) {
        this.openFromFileIfNecessary();
        return this.inRefs.remove(pattern);
    }

    public Collection getOutRefs() {
        this.openFromFileIfNecessary();
        return Collections.unmodifiableCollection(this.outRefs);
    }

    public void addOutRef(Pattern pattern) {
        this.openFromFileIfNecessary();
        this.outRefs.add(pattern);
    }

    public boolean removeOutRef(Pattern pattern) {
        this.openFromFileIfNecessary();
        return this.outRefs.remove(pattern);
    }

    public String getRelatedPatternsText() {
        this.openFromFileIfNecessary();
        return this.relatedPatternsText;
    }

    public void setRelatedPatternsText(String text) {
        this.openFromFileIfNecessary();
        this.relatedPatternsText = text;
    }

    public String getCredits() {
        this.openFromFileIfNecessary();
        return this.credits;
    }

    public void setCredits(String credits) {
        this.openFromFileIfNecessary();
        this.credits = credits;
    }

    public String toString() {
        return String.valueOf(this.collectionID) + ":" + this.ID;
    }
}

